/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.lifecycle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.lifecycle.LifecycleError;
import com.ibm.ws.messaging.lifecycle.Singleton;
import com.ibm.ws.messaging.lifecycle.SingletonsReady;
import com.ibm.wsspi.logging.Introspector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.messaging.lifecycle.singletons"}, property={"osgi.command.scope=sib", "osgi.command.function=singletons", "service.vendor=IBM"})
public class SingletonMonitor
implements Introspector {
    public static final TraceComponent tc = Tr.register(SingletonMonitor.class);
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final int version = counter.incrementAndGet();
    private final ConfigurationAdmin configAdmin;
    private volatile Set<String> declaredSingletons;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> realizedSingletons = new ArrayList<String>();
    private final List<String> pendingSingletons = new ArrayList<String>();
    private int singletonsReadyBindCount;
    private int singletonsReadyUnbindCount;

    @Activate
    public SingletonMonitor(@Reference(name="configAdmin") ConfigurationAdmin configAdmin) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        this.configAdmin = configAdmin;
        this.declaredSingletons = Collections.unmodifiableSet(this.findDeclaredSingletons());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    private Set<String> findDeclaredSingletons() {
        Object[] configs;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"findDeclaredSingletons", (Object[])new Object[0]);
        }
        try {
            configs = this.configAdmin.listConfigurations("(service.factoryPid=com.ibm.ws.messaging.lifecycle.SingletonAgent)");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Singleton configs: ", (Object[])new Object[]{Arrays.toString(configs)});
            }
        }
        catch (IOException | InvalidSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.messaging.lifecycle.SingletonMonitor.findDeclaredSingletons", (String)"list configs");
            throw new LifecycleError("Could not list declared singletons", e);
        }
        Set<String> result = Stream.of(configs).map(this::retrieveId).filter(Objects::nonNull).collect(TreeSet::new, Set::add, Set::addAll);
        result = Collections.unmodifiableSet(result);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"findDeclaredSingletons", result);
        }
        return result;
    }

    private String retrieveId(Configuration config) {
        String result;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"retrieveId", (Object[])new Object[]{config});
            }
            result = null;
            try {
                Dictionary dict = config.getProperties();
                Object definition = dict.get("id");
                result = (String)definition;
            }
            catch (Exception e) {
                this.errors.add("" + e);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"retrieveId", (Object[])new Object[]{e});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"retrieveId", (Object)result);
        }
        return result;
    }

    @Modified
    public synchronized void modified() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"modified", (Object[])new Object[0]);
        }
        Set<String> oldSet = this.declaredSingletons;
        Set<String> newSet = this.findDeclaredSingletons();
        if (newSet.equals(oldSet)) {
            return;
        }
        this.declaredSingletons = newSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            TreeSet<String> removed = new TreeSet<String>(oldSet);
            TreeSet<String> added = new TreeSet<String>(newSet);
            TreeSet<String> unmodified = new TreeSet<String>(oldSet);
            removed.removeAll(newSet);
            added.removeAll(oldSet);
            unmodified.removeAll(removed);
            if (unmodified.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Singleton declarations unmodified:", (Object[])new Object[]{unmodified});
            }
            if (removed.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Singleton declarations removed:", (Object[])new Object[]{removed});
            }
            if (added.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Singleton declarations added:", (Object[])new Object[]{added});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"modified");
        }
    }

    @Deactivate
    public void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[0]);
            Tr.exit((Object)this, (TraceComponent)tc, (String)"deactivate");
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addPendingSingleton(ServiceReference<Singleton> ref) {
        String type = (String)ref.getProperty("type");
        this.pendingSingletons.add(type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Pending Singleton added: %s", type), (Object[])new Object[0]);
        }
    }

    synchronized void removePendingSingleton(ServiceReference<Singleton> ref) {
        String type = (String)ref.getProperty("type");
        this.pendingSingletons.remove(type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Pending Singleton removed: %s", type), (Object[])new Object[0]);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addRealizedSingleton(Singleton singleton, Map<String, Object> properties) {
        String type = (String)properties.get("type");
        this.realizedSingletons.add(type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Realized Singleton added: %s", type), (Object[])new Object[0]);
        }
    }

    synchronized void removeRealizedSingleton(Singleton singleton, Map<String, Object> properties) {
        String type = (String)properties.get("type");
        this.realizedSingletons.remove(type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Realized Singleton removed: %s", type), (Object[])new Object[0]);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addSingletonsReady(SingletonsReady ready) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"addSingletonsReady", (Object[])new Object[]{ready});
        }
        this.modified();
        ++this.singletonsReadyBindCount;
        TreeSet<String> pending = new TreeSet<String>(this.pendingSingletons);
        TreeSet<String> realized = new TreeSet<String>(this.realizedSingletons);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Declared singletons: " + this.declaredSingletons), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Pending singletons:  " + pending), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Realized singletons: " + realized), (Object[])new Object[0]);
        }
        if (this.declaredSingletons.equals(realized)) {
            return;
        }
        TreeSet<String> missing = new TreeSet<String>(this.declaredSingletons);
        TreeSet<String> blocked = pending;
        TreeSet<String> extra = realized;
        blocked.removeAll(realized);
        missing.removeAll(realized);
        extra.removeAll(this.declaredSingletons);
        IllegalStateException e = new IllegalStateException("Singleton mismatch detected:\n\tmissing: " + missing + "\n\tblocked: " + blocked + "\n\textra:   " + extra);
        FFDCFilter.processException((Throwable)e, (String)SingletonMonitor.class.getName(), (String)"addSingletonsReady");
        if (this.singletonsReadyBindCount > this.singletonsReadyUnbindCount + 1) {
            this.errors.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"addSingletonsReady");
        }
    }

    synchronized void removeSingletonsReady(SingletonsReady ready) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"removeSingletonsReady", (Object[])new Object[]{ready});
        }
        ++this.singletonsReadyUnbindCount;
        if (this.singletonsReadyBindCount > this.singletonsReadyUnbindCount) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"removeSingletonsReady (out of order)");
            }
            return;
        }
        this.errors.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"removeSingletonsReady (in order)");
        }
    }

    public String toString() {
        return SingletonMonitor.class.getName() + "#" + this.version;
    }

    public String getIntrospectorName() {
        return "Messaging" + this.getClass().getSimpleName();
    }

    public String getIntrospectorDescription() {
        return this.getIntrospectorName().replaceAll(".", "=") + "\nList the declared (D), pending (P), and realized (R) messaging singletons.\nMessaging cannot start until all the declared singletons become available (i.e. are realized).";
    }

    public synchronized void introspect(PrintWriter out) throws Exception {
        out.println();
        out.println("=Detected Singletons=");
        ((Stream)Stream.concat(Stream.concat(this.declaredSingletons.stream(), this.realizedSingletons.stream()), this.pendingSingletons.stream()).sorted().distinct().sequential()).peek(s -> out.print('[')).peek(s -> out.print(this.declaredSingletons.contains(s) ? (char)'D' : (char)' ')).peek(s -> out.print((char)(this.realizedSingletons.contains(s) ? 82 : (this.pendingSingletons.contains(s) ? 80 : 32)))).peek(s -> out.print("] ")).forEach(out::println);
        out.println();
        out.println("=SingletonsReady tracking=");
        out.println("Bind calls:   " + this.singletonsReadyBindCount);
        out.println("Unbind calls: " + this.singletonsReadyUnbindCount);
        out.println();
        out.println("=Errors=");
        this.errors.forEach(out::println);
        if (this.errors.isEmpty()) {
            out.println("No errors recorded.");
        }
    }

    public void singletons() throws Exception {
        System.out.println(this.getIntrospectorName());
        System.out.println(this.getIntrospectorDescription());
        try (PrintWriter pw = new PrintWriter(System.out);){
            this.introspect(pw);
        }
    }
}

