/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TruncatableThrowable;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.PasswordNullifier;
import com.ibm.ws.http.channel.outstream.HttpOutputStreamConnectWeb;
import com.ibm.ws.http.channel.outstream.HttpOutputStreamObserver;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.ws.webcontainer.osgi.response.IResponseImpl;
import com.ibm.ws.webcontainer.osgi.response.WCOutputStream;
import com.ibm.ws.webcontainer.servlet.IServletWrapperInternal;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTOutputStream;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IOutputMethodListener;
import com.ibm.wsspi.webcontainer.servlet.IServletResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.BufferedWriter;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.IResponseOutput;
import com.ibm.wsspi.webcontainer.util.WrappingEnumeration;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SRTServletResponse
implements HttpServletResponse,
IResponseOutput,
IExtendedResponse,
IServletResponse,
Response,
IOutputStreamObserver,
HttpOutputStreamObserver {
    private static boolean skipInputStreamRead = false;
    private boolean isCharEncodingExplicit;
    private static final String REASON_OK = "OK";
    private static final String CONTENT_LANGUAGE_HEADER = "Content-Language";
    private static final byte[] CONTENT_LANGUAGE_HEADER_BYTES = "Content-Language".getBytes();
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final byte[] HEADER_CONTENT_TYPE_BYTES = "Content-Type".getBytes();
    protected static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final boolean keepContentLength = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("keepcontentlength"));
    private static final boolean skipHeaderFlush = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.skipheaderflush"));
    private static final String contentTypeCompatibility = WCCustomProperties.CONTENT_TYPE_COMPATIBILITY;
    private static final boolean getSessionCompatibility = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.getsession2_4compatibility"));
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTServletResponse";
    protected static final TraceNLS nls = TraceNLS.getTraceNLS(SRTServletResponse.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final Locale _defaultLocale = Locale.getDefault();
    public static final String _defaultEncoding = "ISO-8859-1";
    private static final ConcurrentHashMap<Locale, String> localeStrings = new ConcurrentHashMap();
    protected IResponse _response = null;
    protected boolean writerClosed = false;
    protected SRTOutputStream _rawOut = new SRTOutputStream();
    protected ServletOutputStream _bufferedOut;
    protected BufferedWriter _bufferedWriter = new BufferedWriter(0);
    protected PrintWriter _pwriter;
    protected boolean _firstWrite = false;
    protected boolean _firstWriteToCurrentBuffer = false;
    protected int _bufferSize = 0;
    protected boolean _gotWriter = false;
    protected boolean _firstWriterRetrieval = true;
    protected boolean _gotOutputStream = false;
    protected boolean _firstOutputStreamRetrieval = true;
    protected OutputStreamWriter _outWriter = null;
    protected String _outWriterEncoding;
    protected boolean writerException = false;
    protected boolean _ignoreStateErrors;
    protected boolean _headersWritten = false;
    protected Locale _locale;
    protected String _encoding;
    protected long _contentLength = -1L;
    protected int _statusCode = 200;
    private SRTConnectionContext _connContext;
    private IOutputMethodListener outputMethodListener = null;
    protected String _contentType;
    private static final boolean localeDependentDateFormatter = WCCustomProperties.LOCALE_DEPENDENT_DATE_FORMATTER;
    private static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal();
    private static String formatStr = "EEE, dd MMM yyyy HH:mm:ss z";
    private static TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    protected boolean isCharEncodingExplicitViaSetLocale = false;

    public SRTServletResponse() {
        this._bufferedWriter.setObserver(this);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "SRTServletResponse", "outputstream is of type --> " + this._bufferedOut);
        }
    }

    public SRTServletResponse(SRTConnectionContext context) {
        this();
        this._connContext = context;
    }

    @Override
    public void alertClose() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertClose", " _outWriter: --> " + this._outWriter);
        }
        this.writerClosed = true;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertClose", "exit");
        }
    }

    @Override
    public void alertFirstWrite() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertFirstWrite", "entry");
        }
        this._firstWrite = true;
        this._firstWriteToCurrentBuffer = true;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertFirstWrite", "exit");
        }
    }

    @Override
    public void alertFirstFlush() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertFirstFlush", "entry");
        }
        if (!this.isCommitted()) {
            this.commit();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertFirstFlush", "exit");
        }
    }

    @Override
    public void alertException() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertException", "entry  _outWriter: --> " + this._outWriter);
        }
        this.writerException = true;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertException", "exit");
        }
    }

    @Override
    public boolean writerObtained() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "writerObtained", " " + String.valueOf(this._gotWriter), "[" + this + "]");
        }
        return this._gotWriter;
    }

    @Override
    public boolean outputStreamObtained() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "outputStreamObtained", " " + String.valueOf(this._gotOutputStream), "[" + this + "]");
        }
        return this._gotOutputStream;
    }

    @Override
    public void finish() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "finish", "[" + this + "]");
        }
        if (!this.isCommitted()) {
            this.commit();
        }
        try {
            this.flushBuffer(false);
            this._rawOut.close();
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "finish", "Servlet.Exception:.Error.while.finishing.response", e);
            }
        }
        finally {
            this._rawOut.reset();
            this.cleanupFromFinish();
            this._bufferedWriter.reset();
        }
        this.resetState();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "finish");
        }
    }

    protected void cleanupFromFinish() {
        this._response = null;
        this._bufferSize = 0;
        this._encoding = null;
        this._gotOutputStream = false;
        this._gotWriter = false;
        this._pwriter = null;
    }

    protected void resetState() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "resetState", "entry");
        }
        this._headersWritten = false;
        this._firstWrite = false;
        this._firstWriteToCurrentBuffer = false;
        this._ignoreStateErrors = false;
        this._contentLength = -1L;
        this._contentType = null;
        this._locale = _defaultLocale;
        this.writerClosed = false;
        this._firstWriterRetrieval = true;
        this._firstOutputStreamRetrieval = true;
        this.isCharEncodingExplicit = false;
        this.isCharEncodingExplicitViaSetLocale = false;
        if (com.ibm.ws.webcontainer.osgi.WebContainer.getServletContainerSpecLevel() >= 31) {
            this._gotOutputStream = false;
            this._gotWriter = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "resetState", "exit");
        }
    }

    public void addField(String key, String value) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addField", "key --> " + key + " value --> " + value);
        }
        this._response.addHeader(key, value);
    }

    public void addDateField(String key, long value) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addDateField", "key --> " + key + " value --> " + value);
        }
        this._response.addDateHeader(key, value);
    }

    public void addIntField(String key, int value) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addIntField", "key --> " + key + " value --> " + value);
        }
        this._response.addIntHeader(key, value);
    }

    public String getHeader(String key) {
        String header = this._response.getHeader(key);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeader", " name --> " + key + " response --> " + header, "[" + this + "]");
        }
        return header;
    }

    @Override
    public IResponse getIResponse() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getIResponse", " response --> " + this._response, "[" + this + "]");
        }
        return this._response;
    }

    protected String getHeader(byte[] key) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeader", " name --> " + (key != null ? new String(key) : "") + " response --> " + this._response.getHeader(key), "[" + this + "]");
        }
        return this._response.getHeader(key);
    }

    public boolean containsHeader(String name) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "containsHeader", " name --> " + name + " response --> " + String.valueOf(this._response.containsHeader(name)));
        }
        return this._response.containsHeader(name);
    }

    private boolean containsHeader(HttpHeaderKeys headerKey) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "containsHeader", " headerKey --> " + headerKey.getName() + " response --> " + String.valueOf(this._response.containsHeader(headerKey.getName())));
        }
        return this._response instanceof IResponseImpl ? ((IResponseImpl)this._response).containsHeader(headerKey) : this._response.containsHeader(headerKey.getName());
    }

    public boolean containsHeader(byte[] name) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "containsHeader", " name --> " + (name != null ? new String(name) : "") + " response --> " + String.valueOf(this._response.containsHeader(name)));
        }
        return this._response.containsHeader(name);
    }

    protected void removeHeader(String key) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeHeader", " name --> " + key);
        }
        this._response.removeHeader(key);
    }

    protected void removeHeader(byte[] key) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeHeader", " name --> " + (key != null ? new String(key) : ""));
        }
        this._response.removeHeader(key);
    }

    public void resetBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "resetBuffer", "[" + this + "]");
        }
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        if (this._gotOutputStream) {
            this._response.resetBuffer();
        }
        if (this._bufferedWriter != null) {
            this._bufferedWriter.clearBuffer();
        }
        this._firstWriteToCurrentBuffer = false;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "resetBuffer");
        }
    }

    public void closeResponseOutput() {
        this.closeResponseOutput(false);
    }

    @Override
    public void closeResponseOutput(boolean releaseChannel) {
        WebContainerRequestState reqState;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "closeResponseOutput", "[" + this + "]");
            logger.logp(Level.FINE, CLASS_NAME, "closeResponseOutput", "releaseChannel->" + releaseChannel + ", writerClosed->" + this.writerClosed);
        }
        if (!this.writerClosed) {
            boolean isArdEnabled = false;
            if (WebContainer.getWebContainer().getWebContainerConfig().isArdEnabled() && ((WebAppDispatcherContext)this._connContext.getRequest().getWebAppDispatcherContext()).getWebApp().getWebAppConfig().isArdEnabled()) {
                isArdEnabled = true;
                WebContainerRequestState reqState2 = WebContainerRequestState.getInstance(true);
                reqState2.setAttribute("com.ibm.ws.webcontainer.appIsArdEnabled", true);
            }
            if (!isArdEnabled) {
                block24: {
                    this._response.setFlushMode(false);
                    this._response.setIsClosing(true);
                    try {
                        if (this._gotOutputStream) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "closeResponseOutput", "flush output stream");
                            }
                            if (!(this._bufferedOut instanceof WCOutputStream) || !((WCOutputStream)this._bufferedOut).isClosed()) {
                                this._bufferedOut.flush();
                            }
                        } else if (this._gotWriter) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "closeResponseOutput", "flush writer");
                            }
                            this._pwriter.flush();
                        }
                    }
                    catch (Throwable th) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.SEVERE)) break block24;
                        logger.logp(Level.SEVERE, CLASS_NAME, "closeResponseOutput", "Error.while.flushing.last.response");
                    }
                }
                this._response.setFlushMode(true);
            }
            try {
                if (this._gotOutputStream) {
                    if (!isArdEnabled && WCCustomProperties.COMPLETE_DATA_RESPONSE && !WCCustomProperties.FINISH_RESPONSE_ON_CLOSE) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "closeResponseOutput", "setLastBuffer to true ");
                        }
                        this._response.setLastBuffer(true);
                    }
                    this._bufferedOut.close();
                    this._rawOut.close();
                } else if (this._gotWriter) {
                    if (!isArdEnabled && WCCustomProperties.COMPLETE_DATA_RESPONSE && !WCCustomProperties.FINISH_RESPONSE_ON_CLOSE) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "closeResponseOutput", "setLastBuffer to true ");
                        }
                        this._response.setLastBuffer(true);
                    }
                    this._pwriter.close();
                    this._rawOut.close();
                }
                if (releaseChannel) {
                    this._response.releaseChannel();
                    WebContainerRequestState.getInstance(true).setCompleted(true);
                }
            }
            catch (Throwable th) {
                logger.logp(Level.SEVERE, CLASS_NAME, "closeResponseOutput", "Error.while.closing.response.output", th);
            }
        }
        if (releaseChannel && !(reqState = WebContainerRequestState.getInstance(true)).isCompleted()) {
            this._response.releaseChannel();
            WebContainerRequestState.getInstance(true).setCompleted(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "closeResponseOutput");
        }
    }

    public void setIgnoreStateErrors(boolean b) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setIgnoreStateErrors", " " + String.valueOf(b), "[" + this + "]");
        }
        this._ignoreStateErrors = b;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBufferSize(int size) {
        block7: {
            block6: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.entering(CLASS_NAME, "setBufferSize ", String.valueOf(size) + " [" + this + "]");
                }
                this._bufferSize = size;
                if (!this._gotOutputStream && !this._gotWriter) break block6;
                if (!this._firstWrite) {
                    this._response.setBufferSize(size);
                    if (this._gotWriter) {
                        this._bufferedWriter.setBufferSize(size);
                    }
                    break block7;
                } else {
                    logger.logp(Level.SEVERE, CLASS_NAME, "setBufferSize", "setbuffer.size.called.after.write");
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.exiting(CLASS_NAME, "setBufferSize", "throw IllegalStateException");
                    }
                    throw new IllegalStateException("setBufferSize() called after first write to Output Stream/Writer");
                }
            }
            this._response.setBufferSize(size);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setBufferSize");
        }
    }

    public int getBufferSize() {
        if (!this._gotOutputStream) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getBufferSize", "size --> " + this._bufferSize, "[" + this + "]");
            }
            return this._bufferSize;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getBufferSize", "getBufferSize --> " + this._response.getBufferSize(), "[" + this + "]");
        }
        return this._response.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.flushBuffer(true);
    }

    @Override
    public void flushBuffer(boolean flushToWire) throws IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "flushBuffer", "flushToWire=" + String.valueOf(flushToWire) + " [" + this + "]");
        }
        if (!flushToWire) {
            this._response.setFlushMode(false);
        }
        try {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "flushBuffer", "_firstWriteToCurrentBuffer->" + this._firstWriteToCurrentBuffer + ", skipHeaderFlush->" + skipHeaderFlush);
            }
            if (this._firstWriteToCurrentBuffer || skipHeaderFlush || flushToWire) {
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "flushBuffer", "we've written output so flush");
                }
                if (this._pwriter != null && !this.writerClosed) {
                    if (isTraceOn && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "flushBuffer", "flush the printWriter");
                    }
                    this._pwriter.flush();
                }
                if (!(!this._gotOutputStream || this._bufferedOut instanceof WCOutputStream && ((WCOutputStream)this._bufferedOut).isClosed())) {
                    if (isTraceOn && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "flushBuffer", "flush the outputStream, isCommitted =" + this._response.isCommitted());
                    }
                    this._bufferedOut.flush();
                }
            }
            if (!this.isCommitted()) {
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "flushBuffer", "Not committed, so write headers");
                }
                this.commit();
                if (this._firstWriteToCurrentBuffer || skipHeaderFlush || flushToWire) {
                    this._response.writeHeaders();
                }
            }
        }
        finally {
            if (!flushToWire) {
                this._response.setFlushMode(true);
            }
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "flushBuffer");
            }
        }
    }

    @Override
    public boolean isCommitted() {
        if (this._headersWritten) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "isCommitted", "headersWritten=true", "[" + this + "]");
            }
            return true;
        }
        if (this._gotOutputStream) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "isCommitted", "responseBuffer isCommitted=" + this._response.isCommitted(), "[" + this + "]");
            }
            return this._response.isCommitted();
        }
        if (this._gotWriter && this._bufferedWriter != null) {
            return this._bufferedWriter.isCommitted();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isCommitted", "false", "[" + this + "]");
        }
        return false;
    }

    public IExtendedRequest getRequest() {
        if (this._connContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getRequest", "null", "[" + this + "]");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequest", "request=" + this._connContext.getRequest(), "[" + this + "]");
        }
        return this._connContext.getRequest();
    }

    public ServletOutputStream getOutputStream() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getOutputStream", "gotWriter=" + String.valueOf(this._gotWriter) + " [" + this + "]");
        }
        if (!this._ignoreStateErrors && this._gotWriter) {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "getOutputStream", "throw IllegalStateException");
            }
            throw new IllegalStateException(nls.getString("Writer.already.obtained", "Writer already obtained"));
        }
        if (!WCCustomProperties.FINISH_RESPONSE_ON_CLOSE || !this._gotOutputStream) {
            this._gotOutputStream = true;
        }
        this.fireOutputStreamRetrievedEvent(this._bufferedOut);
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getOutputStream");
        }
        return this._bufferedOut;
    }

    public PrintWriter getWriter() throws IOException, UnsupportedEncodingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getWriter", "gotOutputStream=" + String.valueOf(this._gotOutputStream) + " [" + this + "]");
        }
        if (!this._ignoreStateErrors && this._gotOutputStream) {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "getWriter", "throw IllegalStateException");
            }
            throw new IllegalStateException(nls.getString("OutputStream.already.obtained", "OutputStream already obtained"));
        }
        if (!this._gotWriter) {
            String contentType;
            String charEncoding = this.getCharacterEncoding();
            if ((contentTypeCompatibility == null || !contentTypeCompatibility.equalsIgnoreCase("V4") && !contentTypeCompatibility.equalsIgnoreCase("V5")) && (contentType = this.getContentType()) != null && contentType.indexOf("charset") == -1 && contentType.startsWith("text")) {
                if (contentType.endsWith(";")) {
                    this.setContentType(contentType + "charset=" + charEncoding);
                } else {
                    this.setContentType(contentType + ";charset=" + charEncoding);
                }
            }
            if (this._outWriter == null || this.writerException || !charEncoding.equals(this._outWriterEncoding)) {
                if (isTraceOn && logger.isLoggable(Level.FINE) && this.writerException) {
                    logger.logp(Level.FINE, CLASS_NAME, "getWriter", "writerException --> " + this.writerException + "--> creating new OutputStreamWriter");
                }
                this._outWriter = new OutputStreamWriter((OutputStream)((Object)this._rawOut), EncodingUtils.getJvmConverter(charEncoding));
                this._outWriterEncoding = charEncoding;
                this.writerException = false;
            } else if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getWriter", "reusing _outWriter: --> " + this._outWriter);
            }
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getWriter", "created writer with encoding: " + this._outWriter.getEncoding());
            }
            this._bufferedWriter.init(this._outWriter, this.getBufferSize());
            this._bufferedWriter.setLimitLong(this._contentLength);
            this._bufferedWriter.setResponse(this._response);
            this._pwriter = new PrintWriter((Writer)this._bufferedWriter, false);
            this._gotWriter = true;
            this.writerClosed = false;
        }
        this.fireWriterRetrievedEvent(this._pwriter);
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getWriter");
        }
        return this._pwriter;
    }

    @Override
    public void start() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "start", "[" + this + "]");
        }
        this.setDefaultResponseEncoding();
    }

    protected SRTConnectionContext getConnectionContext() {
        return this._connContext;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", "[" + this + "]");
        }
        return super.clone();
    }

    public void addCookie(Cookie cookie) {
        WebAppDispatcherContext dispatchContext;
        String cookieName = cookie.getName();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addCookie", "Adding cookie --> " + cookieName, "[" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addCookie", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addCookie cookie --> " + cookieName);
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            IServletWrapper wrapper = dispatchContext.getCurrentServletReference();
            if (this.logWarningActionNow(wrapper)) {
                this.logAlreadyCommittedWarning(new Throwable(), "addCookie");
            } else {
                logger.logp(Level.FINE, CLASS_NAME, "addCookie", "Cannot set header.  Response already committed.");
            }
        } else {
            this._response.addCookie(cookie);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addCookie");
        }
    }

    protected synchronized void commit() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "commit", "[" + this + "] ,_headersWritten -->" + this._headersWritten);
        }
        if (!this._headersWritten && !this.isCommitted()) {
            this.addLocaleHeader();
            if (this.containsHeader(HttpHeaderKeys.HDR_CONTENT_ENCODING) && this.containsHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH)) {
                if (keepContentLength) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "commit", "WebContainer custom property set to keep Content-Length header w/presence of Content-Encoding header");
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "commit", "Content-Length header disallowed w/presence of Content-Encoding header");
                    }
                    this.removeHeader(HEADER_CONTENT_LENGTH);
                }
            }
            WebContainer.notifyHttpServletResponseListenersPreHeaderCommit(this._connContext.getRequest(), this);
            String scheme = this.getRequest().getScheme();
            if (scheme != null && scheme.equalsIgnoreCase("https")) {
                this.addSTSHeader();
            }
            this._response.prepareHeadersForWrite();
            this._headersWritten = true;
            if (this._bufferedOut != null && this._bufferedOut instanceof WCOutputStream) {
                HttpOutputStreamConnectWeb output = ((WCOutputStream)this._bufferedOut).getOutput();
                output.setWebC_headersWritten(true);
                String remoteUser = this._connContext.getRequest().getRemoteUser();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "commit", "Setting remote user : " + remoteUser);
                }
                output.setWC_remoteUser(remoteUser);
                ((WCOutputStream)this._bufferedOut).getOutput().setWebC_headersWritten(true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "commit");
        }
    }

    private void addLocaleHeader() {
        String locale = localeStrings.get(this._locale);
        if (locale == null) {
            locale = this._locale.toString().replace('_', '-');
            localeStrings.put(this._locale, locale);
        }
        this._response.setContentLanguage(locale);
    }

    private void addSTSHeader() {
        String value = this.getRequest().getWebAppDispatcherContext().getWebApp().getConfiguration().getSTSHeaderValue();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addSTSHeader", " value -->" + value);
        }
        if (value.equalsIgnoreCase("NoValue")) {
            return;
        }
        if (this.getHeader("Strict-Transport-Security") == null) {
            this.setHeader("Strict-Transport-Security", value);
        }
    }

    public String encodeRedirectUrl(String URL2) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "encodeRedirectUrl", "[" + this + "]");
        }
        return this.encodeURL(URL2);
    }

    public String encodeRedirectURL(String url) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "encodeRedirectURL", "[" + this + "]");
        }
        return this.encodeURL(url);
    }

    public String encodeUrl(String URL2) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "encodeUrl", "[" + this + "]");
        }
        return this.encodeURL(URL2);
    }

    public String encodeURL(String url) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "encodeURL", " url --> " + PasswordNullifier.nullifyParams((String)url), "[" + this + "]");
        }
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext();
        return dispatchContext.encodeURL(url);
    }

    protected void setDefaultResponseEncoding() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setDefaultResponseEncoding", "[" + this + "]");
        }
        IExtendedRequest extReq = this.getRequest();
        WebApp webApp = null;
        boolean useAuto = false;
        if (extReq != null) {
            webApp = ((WebAppDispatcherContext)extReq.getWebAppDispatcherContext()).getWebApp();
        }
        if (webApp != null && webApp.getConfiguration().isAutoResponseEncoding()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setDefaultResponseEncoding", "auto response encoding is true");
            }
            useAuto = true;
            this._locale = this.getRequest().getLocale();
            if (this._locale == null) {
                this._locale = _defaultLocale;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setDefaultResponseEncoding", "_locale is null: default to " + this._locale.toString());
                }
            }
            this._encoding = this.getRequest().getCharacterEncoding();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setDefaultResponseEncoding", "Encoding from request: " + this._encoding);
            }
            if (this._encoding != null && !EncodingUtils.isCharsetSupported(this._encoding)) {
                this._encoding = null;
            }
            if (this._encoding == null) {
                this._encoding = webApp.getConfiguration().getLocaleEncoding(this._locale);
                if (this._encoding == null) {
                    this._encoding = EncodingUtils.getEncodingFromLocale(this._locale);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "setDefaultResponseEncoding", "Encoding from locale: " + this._encoding);
                    }
                    if (this._encoding == null) {
                        this._encoding = _defaultEncoding;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "setDefaultResponseEncoding", "_encoding is null: default to " + this._encoding);
                        }
                    }
                }
            }
            if (EncodingUtils.setContentTypeBySetHeader) {
                this.setHeader(HEADER_CONTENT_TYPE, "text/html; charset=" + this._encoding);
            } else {
                this.setContentType("text/html; charset=" + this._encoding);
            }
        }
        if (!useAuto) {
            this._locale = _defaultLocale;
            this._encoding = this.getSpecLevelEncoding(_defaultEncoding, webApp);
            if (contentTypeCompatibility != null) {
                if (contentTypeCompatibility.equalsIgnoreCase("V4")) {
                    this.setHeader(HEADER_CONTENT_TYPE, "text/html");
                    if (EncodingUtils.setContentTypeBySetHeader) {
                        this.setHeader(HEADER_CONTENT_TYPE, "text/html");
                    } else {
                        this.setContentType("text/html");
                    }
                } else if (contentTypeCompatibility.equalsIgnoreCase("V5")) {
                    if (EncodingUtils.setContentTypeBySetHeader) {
                        this.setHeader(HEADER_CONTENT_TYPE, "text/html; charset=" + this._encoding);
                    } else {
                        this.setContentType("text/html; charset=" + this._encoding);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setDefaultResponseEncoding", "_locale: " + this._locale.toString() + ", _encoding: " + this._encoding);
        }
    }

    protected String getSpecLevelEncoding(String encoding, WebApp webApp) {
        return encoding;
    }

    @Override
    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "reset", "[" + this + "]");
        }
        this._response.setReason(REASON_OK);
        this._response.setStatusCode(200);
        if (this._bufferedWriter != null) {
            this._bufferedWriter.clearBuffer();
        }
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this._response.resetBuffer();
        this._response.clearHeaders();
        this.resetState();
        this.setDefaultResponseEncoding();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "reset");
        }
    }

    public String getCharacterEncoding() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getCharacterEncoding", "[" + this + "]");
        }
        if (this._encoding == null) {
            this.setDefaultResponseEncoding();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getCharacterEncoding", " encoding --> " + this._encoding);
        }
        return this._encoding;
    }

    public String getContentType() {
        String contentTypeHeader;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getContentType", "[" + this + "]");
        }
        if (this._contentType == null && (contentTypeHeader = this.getHeader(HEADER_CONTENT_TYPE)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getContentType", " content-type header is null, skip setContentType [" + this + "]");
            }
            this.setContentType(contentTypeHeader);
        }
        return this._contentType;
    }

    public void setCharacterEncoding(String encoding) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setCharacterEncoding", " encoding --> " + encoding + " [" + this + "]");
        }
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext();
        if (this.getRequest() != null && dispatchContext.isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setCharacterEncoding", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"));
            }
            return;
        }
        if (this._gotWriter || this._headersWritten) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setCharacterEncoding", "_gotWriter=" + String.valueOf(this._gotWriter) + ", _headersWritten=" + String.valueOf(this._headersWritten));
            }
            return;
        }
        if (encoding != null) {
            String apos = "'";
            String qoute = "\"";
            if (encoding.startsWith(apos) || encoding.startsWith(qoute)) {
                encoding = encoding.substring(1);
            }
            if (encoding.endsWith(apos) || encoding.endsWith(qoute)) {
                encoding = encoding.substring(0, encoding.length() - 1);
            }
            this._encoding = encoding;
            this.isCharEncodingExplicit = true;
        }
        if (this._contentType != null) {
            int index = this._contentType.indexOf("charset=");
            this._contentType = index != -1 ? this._contentType.substring(0, index) + "charset=" + this._encoding : this._contentType + "; charset=" + this._encoding;
            if (this._response != null) {
                this._response.setContentType(this._contentType);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setCharacterEncoding", "encoding: " + this._encoding + " ,contentType: " + this._contentType);
        }
    }

    public Cookie[] getCookies() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCookies", "[" + this + "]");
        }
        return this._response.getCookies();
    }

    public void sendError(int status) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sendError", "error --> " + String.valueOf(status), "[" + this + "]");
        }
        Object[] args = new Object[]{new Integer(status)};
        this.sendError(status, MessageFormat.format(nls.getString("Error.reported.{0}", "Error reported: {0}"), args));
    }

    public void sendError(int status, String msg) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "sendError", "status --> " + status + " " + msg + " [" + this + "]");
        }
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext();
        if (!WCCustomProperties.ALLOW_INCLUDE_SEND_ERROR && dispatchContext.isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendError", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "sendError --> " + status + " with message --> " + msg);
            }
        } else {
            dispatchContext.sendError(status, msg);
            this.closeResponseOutput();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "sendError");
        }
    }

    public void setReason(String msg) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setReason", " message --> " + msg, "[" + this + "]");
        }
        this._response.setReason(msg);
    }

    public void sendRedirect(String location) throws IOException {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "sendRedirect", "location --> " + PasswordNullifier.nullifyParams((String)location) + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "sendRedirect location --> " + PasswordNullifier.nullifyParams((String)location));
            }
        } else {
            dispatchContext.sendRedirect(location);
        }
        this.closeResponseOutput();
        if (!this.isCommitted() && !dispatchContext.isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", " : Not committed, so write headers");
            }
            this.commit();
            this._response.setLastBuffer(true);
            this._response.writeHeaders();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "sendRedirect");
        }
    }

    @Override
    public void sendRedirect303(String location) throws IOException {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "sendRedirect303", "location --> " + location + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect303", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "sendRedirect303 location -->" + location);
            }
        } else {
            dispatchContext.sendRedirect303(location);
        }
        this.closeResponseOutput();
        if (!this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", " : Not committed, so write headers");
            }
            this.commit();
            this._response.setLastBuffer(true);
            this._response.writeHeaders();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "sendRedirect303");
        }
    }

    public void setContentLength(int len) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setContentLength", "length --> " + String.valueOf(len) + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setContentLength", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setContentLength length --> " + String.valueOf(len));
            }
        } else {
            if (this._response != null && !this._response.isCommitted()) {
                this._response.setContentLength(len);
            }
            this._contentLength = len;
            this._bufferedWriter.setLimitLong(this._contentLength);
            this.setIntHeader(HEADER_CONTENT_LENGTH, len);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setContentLength");
        }
    }

    public void setContentType(String type) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setContentType", " type --> " + type + " [" + this + "]");
        }
        if (type == null) {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setContentType", "not set - type is NULL");
            }
            return;
        }
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext();
        if (dispatchContext.isInclude()) {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setContentType", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"));
            }
            return;
        }
        if (this.isCommitted()) {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setContentType", "not set - response isCommitted");
            }
            return;
        }
        int equalsIndex = type.indexOf(61);
        boolean containsCharset = false;
        int beginCharsetStrIndex = equalsIndex - 7;
        int startCharsetValIndex = equalsIndex + 1;
        boolean isPreV7 = false;
        if (contentTypeCompatibility != null && (contentTypeCompatibility.equalsIgnoreCase("V4") || contentTypeCompatibility.equalsIgnoreCase("V5") || contentTypeCompatibility.equalsIgnoreCase("V6"))) {
            isPreV7 = true;
        }
        boolean addEncoding = false;
        if (beginCharsetStrIndex > -1) {
            containsCharset = type.regionMatches(true, beginCharsetStrIndex, "charset", 0, 7);
        }
        if (containsCharset) {
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setContentType", " isPreV7 --> " + isPreV7);
            }
            if (!this._gotWriter) {
                int endIndex = type.length() - 1;
                if (startCharsetValIndex <= endIndex) {
                    boolean endsWithQoute;
                    this.isCharEncodingExplicit = true;
                    boolean startsWithQoute = type.charAt(startCharsetValIndex) == '\"' || type.charAt(startCharsetValIndex) == '\'';
                    boolean bl = endsWithQoute = type.charAt(endIndex) == '\"' || type.charAt(endIndex) == '\'';
                    if (startsWithQoute && endsWithQoute) {
                        this._encoding = type.substring(startCharsetValIndex + 1, endIndex);
                        addEncoding = true;
                    } else {
                        this._encoding = type.substring(startCharsetValIndex);
                    }
                }
            } else if (isPreV7) {
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setContentType", " isPreV7, strip charset ");
                }
                type = type.substring(0, beginCharsetStrIndex).trim();
                type = type.substring(0, type.length() - 1);
            }
        }
        if (!isPreV7) {
            if (this._gotWriter) {
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setContentType", " add encoding because we retrieved a writer");
                }
                addEncoding = true;
            } else {
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setContentType", " did not get writer, check to see if charset already exists");
                }
                if (this.isCharEncodingExplicit && type.startsWith("text")) {
                    if (isTraceOn && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "setContentType", " add encoding because the content type already had a charset");
                    }
                    addEncoding = true;
                }
            }
        }
        if (addEncoding) {
            type = containsCharset ? type.substring(0, startCharsetValIndex) + this._encoding : type + ";" + "charset=" + this._encoding;
        }
        this._contentType = type;
        if (this._response != null) {
            this._response.setContentType(type);
        }
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setContentType", "type=" + this._contentType);
        }
    }

    public void setDateHeader(String name) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setDateHeader", "name --> " + name + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                IServletWrapper wrapper = dispatchContext.getCurrentServletReference();
                if (this.logWarningActionNow(wrapper)) {
                    this.logAlreadyCommittedWarning(new Throwable(), "setDateHeader");
                } else {
                    logger.logp(Level.FINE, CLASS_NAME, "setDateHeader", "Cannot set header.  Response already committed.");
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setDateHeader", "Response already committed");
                }
                return;
            }
            this.setHeader(name, this.createCompliantHttpDateString(System.currentTimeMillis()));
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setDateHeader");
        }
    }

    public void setDateHeader(String name, long t) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setDateHeader", " name --> " + name + " value --> " + String.valueOf(t) + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                IServletWrapper wrapper = dispatchContext.getCurrentServletReference();
                if (this.logWarningActionNow(wrapper)) {
                    this.logAlreadyCommittedWarning(new Throwable(), "setDateHeader");
                } else {
                    logger.logp(Level.FINE, CLASS_NAME, "setDateHeader", "Cannot set header.  Response already committed.");
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setDateHeader", "Response already committed");
                }
                return;
            }
            this._response.setDateHeader(name, t);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setDateHeader");
        }
    }

    public void setHeader(String name, String s) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setHeader", " name --> " + name + " value --> " + PasswordNullifier.nullifyParams((String)s), "[" + this + "]");
        }
        this.setHeader(name, s, true);
    }

    @Override
    public void setHeader(String name, String s, boolean checkInclude) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setHeader", " name --> " + name + " value --> " + PasswordNullifier.nullifyParams((String)s) + " checkInclude --> " + checkInclude + " [" + this + "]");
        }
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext();
        if (checkInclude && dispatchContext.isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setHeader name --> " + name + " value --> " + PasswordNullifier.nullifyParams((String)s) + " checkInclude --> " + checkInclude);
            }
        } else {
            if (name == null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setHeader", "name is null");
                }
                return;
            }
            if (!this._ignoreStateErrors && this.isCommitted()) {
                IServletWrapper wrapper = dispatchContext.getCurrentServletReference();
                if (this.logWarningActionNow(wrapper)) {
                    Throwable t = new Throwable();
                    this.logAlreadyCommittedWarning(t, "setHeader");
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setHeader", "Response already committed");
                }
                return;
            }
            if (s == null) {
                this.removeHeader(name);
            } else if (!name.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                this._response.setHeader(name, s);
            } else {
                int index = s.indexOf("charset=");
                if (index != -1) {
                    this._encoding = s.substring(index + 8);
                } else {
                    String value = s.toLowerCase();
                    index = value.indexOf("charset=");
                    if (index != -1) {
                        this._encoding = s.substring(index + 8);
                        s = s.substring(0, index) + "charset=" + this._encoding;
                    } else if (dispatchContext.isAutoRequestEncoding()) {
                        s = s.endsWith(";") ? s + "charset=" + this.getCharacterEncoding() : s + ";charset=" + this.getCharacterEncoding();
                    }
                }
                this._contentType = s;
                if (this._response instanceof IResponseImpl) {
                    ((IResponseImpl)this._response).setHeader(HttpHeaderKeys.HDR_CONTENT_TYPE, s);
                } else {
                    this._response.setHeader(name, s);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setHeader", " name --> " + name + " value --> " + PasswordNullifier.nullifyParams((String)s));
        }
    }

    protected boolean logWarningActionNow(IServletWrapper w) {
        if (w instanceof IServletWrapperInternal) {
            boolean firstTime = ((IServletWrapperInternal)w).hitWarningStatus();
            return firstTime;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "logWarningActionNow", "Not dealing with internal wrapper");
        }
        return true;
    }

    protected void logAlreadyCommittedWarning(Throwable t, String methodName) {
        String userStackTrace = null;
        TruncatableThrowable tt = new TruncatableThrowable(t);
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = tt.getStackTrace();
        for (int i = 0; i < elements.length && i < 64; ++i) {
            sb.append("\n        at ").append(elements[i].toString());
        }
        sb.append("\n");
        userStackTrace = sb.toString();
        logger.logp(Level.WARNING, CLASS_NAME, methodName, "Cannot.set.header.Response.already.committed", new Object[]{userStackTrace});
    }

    @Override
    public void setInternalHeader(String name, String s) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setInternalHeader", " name --> " + name + " value --> " + s, "[" + this + "]");
        }
        this.setHeader(name, s, false);
    }

    protected void setHeader(byte[] name, String s) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setHeader", " name --> " + name + " value --> " + s + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setHeader name --> " + name + " value --> " + s);
            }
        } else {
            if (name == null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setHeader", "name is null");
                }
                return;
            }
            if (!this._ignoreStateErrors && this.isCommitted()) {
                IServletWrapper wrapper = dispatchContext.getCurrentServletReference();
                if (this.logWarningActionNow(wrapper)) {
                    this.logAlreadyCommittedWarning(new Throwable(), "setHeader");
                } else {
                    logger.logp(Level.FINE, CLASS_NAME, "setHeader", "Cannot set header.  Response already committed.");
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setHeader", "Response already committed");
                }
                return;
            }
            if (s == null) {
                this.removeHeader(name);
            } else {
                if (Arrays.equals(name, HEADER_CONTENT_TYPE_BYTES)) {
                    String value = s.toLowerCase();
                    int index = value.indexOf("charset=");
                    if (index != -1) {
                        this._encoding = s.substring(index + 8);
                        s = s.substring(0, index) + "charset=" + this._encoding;
                    } else if (dispatchContext.isAutoRequestEncoding()) {
                        s = value.endsWith(";") ? s + "charset=" + this.getCharacterEncoding() : s + ";charset=" + this.getCharacterEncoding();
                    }
                    this._contentType = s;
                }
                this._response.setHeader(name, s.getBytes());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setHeader");
        }
    }

    public void setIntHeader(String name, int i) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setIntHeader", " name --> " + name + " value --> " + String.valueOf(i) + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setIntHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setIntHeader name --> " + name + " value --> " + String.valueOf(i));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                IServletWrapper wrapper = dispatchContext.getCurrentServletReference();
                if (this.logWarningActionNow(wrapper)) {
                    this.logAlreadyCommittedWarning(new Throwable(), "setIntHeader");
                } else {
                    logger.logp(Level.FINE, CLASS_NAME, "setIntHeader", "Cannot set header.  Response already committed.");
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "setIntHeader : Response already committed.");
                }
                return;
            }
            this._response.setIntHeader(name, i);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setIntHeader");
        }
    }

    public void setStatus(int status) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setStatus", " status --> " + String.valueOf(status) + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setStatus", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setStatus status --> " + String.valueOf(status));
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            logger.logp(Level.WARNING, CLASS_NAME, "setStatus", "Cannot.set.status.Response.already.committed");
        } else {
            if (WCCustomProperties.RESET_BUFFER_ON_SET_STATUS) {
                this.resetBuffer();
            }
            this._response.setStatusCode(status);
            this._statusCode = status;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setStatus");
        }
    }

    public void setStatus(int status, String reason) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setStatus", " status --> " + String.valueOf(status) + " reason --> " + reason + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setStatus", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setStatus status --> " + String.valueOf(status) + " reason --> " + reason);
            }
        } else if (!this._ignoreStateErrors && this.isCommitted()) {
            logger.logp(Level.WARNING, CLASS_NAME, "setStatus", "Cannot.set.status.Response.already.committed");
        } else {
            if (WCCustomProperties.RESET_BUFFER_ON_SET_STATUS) {
                this.resetBuffer();
            }
            this._response.setStatusCode(status);
            this._response.setReason(reason);
            this._statusCode = status;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setStatus");
        }
    }

    @Override
    public int getStatusCode() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getStatusCode", "statusCode = " + this._statusCode, "[" + this + "]");
        }
        return this._statusCode;
    }

    public void setLocale(Locale loc) {
        String contentType;
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setLocale", " locale --> " + (loc != null ? loc.toString() : "") + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setLocale", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"));
            }
            return;
        }
        this._locale = loc;
        if (this.isCharEncodingSet() || this._gotWriter || this._headersWritten) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "setLocale", "_gotWriter=" + String.valueOf(this._gotWriter) + ", _headersWritten=" + String.valueOf(this._headersWritten));
            }
            return;
        }
        this.isCharEncodingExplicitViaSetLocale = true;
        this.isCharEncodingExplicit = false;
        this._encoding = dispatchContext.getWebApp().getConfiguration().getLocaleEncoding(this._locale);
        if (this._encoding == null) {
            this._encoding = EncodingUtils.getEncodingFromLocale(this._locale);
            if (this._encoding == null) {
                this._encoding = _defaultEncoding;
            }
        }
        if ((contentType = this.getHeader(HEADER_CONTENT_TYPE)) != null) {
            int index = contentType.indexOf("charset=");
            contentType = index != -1 ? contentType.substring(0, index) + "charset=" + this._encoding : contentType + "; charset=" + this._encoding;
            this._response.setContentType(contentType);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setLocale", "contentType = " + this._contentType);
        }
    }

    protected boolean isCharEncodingSet() {
        int index;
        String contentType;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isCharEncodingSet", "_locale = " + this._locale + " [" + this + "]");
        }
        if ((contentType = this.getHeader(HEADER_CONTENT_TYPE)) != null && (index = contentType.indexOf("charset=")) != -1) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "isCharEncodingSet", String.valueOf(this.isCharEncodingExplicit));
            }
            return this.isCharEncodingExplicit;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isCharEncodingSet", " [" + this.isCharEncodingExplicit + "]");
        }
        return this.isCharEncodingExplicit;
    }

    public Locale getLocale() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocale", "_locale = " + this._locale + " [" + this + "]");
        }
        if (this._locale == null) {
            this.setDefaultResponseEncoding();
        }
        return this._locale;
    }

    public void addDateHeader(String name, long date) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "addDateHeader", "name --> " + name + " date --> " + date + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addDateHeader name --> " + name + " value --> " + String.valueOf(date));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                IServletWrapper wrapper = dispatchContext.getCurrentServletReference();
                if (this.logWarningActionNow(wrapper)) {
                    this.logAlreadyCommittedWarning(new Throwable(), "addDateHeader");
                } else {
                    logger.logp(Level.FINE, CLASS_NAME, "addDateHeader", "Cannot set header.  Response already committed.");
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addDateHeader", "Response already committed");
                }
                return;
            }
            if (name.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addDateHeader", "throw IllegalArgumentException");
                }
                throw new IllegalArgumentException("Cannot Set Content-Type to a Date value");
            }
            this.setHeader(name, this.createCompliantHttpDateString(date));
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addDateHeader");
        }
    }

    public void addHeader(String name, String value) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "addHeader", "name --> " + name + " with value --> " + value + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addHeader --> " + name + " with value --> " + value);
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                IServletWrapper wrapper = dispatchContext.getCurrentServletReference();
                if (this.logWarningActionNow(wrapper)) {
                    this.logAlreadyCommittedWarning(new Throwable(), "addHeader");
                } else {
                    logger.logp(Level.FINE, CLASS_NAME, "addHeader", "Cannot set header.  Response already committed.");
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addHeader", "Response already committed");
                }
                return;
            }
            if (name.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                this._response.setContentType(value);
            } else {
                this.addField(name, value);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addHeader");
        }
    }

    @Override
    public void addHeader(byte[] name, byte[] value) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "addHeader", "name(byte) --> " + (name != null ? new String(name) : "") + " with value --> " + (value != null ? new String(value) : "") + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addHeader(byte) --> " + (name != null ? new String(name) : "") + " with value --> " + (value != null ? new String(value) : ""));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                IServletWrapper wrapper = dispatchContext.getCurrentServletReference();
                if (this.logWarningActionNow(wrapper)) {
                    this.logAlreadyCommittedWarning(new Throwable(), "addHeader");
                } else {
                    logger.logp(Level.FINE, CLASS_NAME, "addHeader", "Cannot set header.  Response already committed.");
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addHeader", "Response already committed");
                }
                return;
            }
            this._response.addHeader(name, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addHeader");
        }
    }

    public void addIntHeader(String name, int value) {
        WebAppDispatcherContext dispatchContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "addIntHeader", " name --> " + name + " value --> " + String.valueOf(value) + " [" + this + "]");
        }
        if ((dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext()).isInclude()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addIntHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addIntHeader name --> " + name + " value --> " + String.valueOf(value));
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                IServletWrapper wrapper = dispatchContext.getCurrentServletReference();
                if (this.logWarningActionNow(wrapper)) {
                    this.logAlreadyCommittedWarning(new Throwable(), "addIntHeader");
                } else {
                    logger.logp(Level.FINE, CLASS_NAME, "addIntHeader", "Cannot set header.  Response already committed.");
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addIntHeader", "Response already committed");
                }
                return;
            }
            if (name.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addIntHeader", "throw IllegalArgumentException");
                }
                throw new IllegalArgumentException("Cannot Set Content-Type to an Int value");
            }
            this.addIntField(name, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addIntHeader");
        }
    }

    @Override
    public void addSessionCookie(Cookie cookie) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "addSessionCookie", "cookie --> " + cookie.getName() + " [" + this + "]");
        }
        if (this.isCommitted()) {
            WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this.getRequest().getWebAppDispatcherContext();
            if (!getSessionCompatibility && dispatchContext.isInclude() && dispatchContext.getWebApp().getVersionID() >= 25) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "addSessionCookie", "throw IllegalArgumentException");
                }
                throw new IllegalStateException();
            }
            logger.logp(Level.WARNING, CLASS_NAME, "addSessionCookie", "Cannot.set.session.cookie.Response.already.committed");
        } else {
            this._response.addCookie(cookie);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addSessionCookie");
        }
    }

    @Override
    public void initForNextResponse(IResponse resp) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "initForNextResponse", "resp = " + resp + " [" + this + "]");
        }
        if (resp == null) {
            this._rawOut.init(null);
            this._bufferedWriter.clean();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "initForNextResponse");
            }
            return;
        }
        this.resetState();
        resp.setStatusCode(200);
        resp.setReason(REASON_OK);
        this._statusCode = 200;
        this._response = resp;
        this.setCommonHeaders();
        try {
            this._rawOut.init((OutputStream)this._response.getOutputStream());
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, CLASS_NAME, "initForNextResponse", "error.initializing.output.stream", e);
        }
        this._bufferedWriter.reset();
        this._bufferSize = 4096;
        this._bufferedOut = this.createOutputStream(4096);
        if (this._bufferedOut instanceof WCOutputStream) {
            ((WCOutputStream)this._bufferedOut).getOutput().setObserver((HttpOutputStreamObserver)this);
        }
        this._encoding = null;
        this._gotOutputStream = false;
        this._gotWriter = false;
        this._pwriter = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "initForNextResponse");
        }
    }

    private void setCommonHeaders() {
        String methodName = "setCommonHeaders";
        String xPoweredByValue = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, "DISABLE_X_POWERED_BY [ " + WCCustomProperties.DISABLE_X_POWERED_BY + " ]");
        }
        if (!WCCustomProperties.DISABLE_X_POWERED_BY && (xPoweredByValue = WCCustomProperties.X_POWERED_BY == null ? this.getXPoweredbyHeader() : WCCustomProperties.X_POWERED_BY) != null) {
            this.setHeader("X-Powered-By", xPoweredByValue);
        }
    }

    protected String getXPoweredbyHeader() {
        return "Servlet/3.0";
    }

    @Override
    public Vector[] getHeaderTable() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeaderTable", "[" + this + "]");
        }
        return this._response.getHeaderTable();
    }

    @Override
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", "[" + this + "]");
        }
        this._connContext = null;
        this._rawOut = null;
        this._bufferedOut = null;
        this._bufferedWriter = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " exit");
        }
    }

    protected ServletOutputStream createOutputStream(int size) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "createOutputStream", "size : " + size + " [" + this + "]");
        }
        try {
            return this._response.getOutputStream();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".createOutputStream"), (String)"2261");
            return null;
        }
    }

    protected String createCompliantHttpDateString(long timestamp) {
        SimpleDateFormat tmpDateFmt = dateFormat.get();
        if (tmpDateFmt == null) {
            if (!localeDependentDateFormatter) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "createCompliantHttpDateString", "use english date formatter");
                }
                Locale locale1 = new Locale("en", "US");
                tmpDateFmt = new SimpleDateFormat(formatStr, locale1);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "createCompliantHttpDateString", "use localeDependentDateFormatter, JVM locale-> " + Locale.getDefault().toString());
                }
                tmpDateFmt = new SimpleDateFormat(formatStr);
            }
            tmpDateFmt.setTimeZone(gmtTimeZone);
            dateFormat.set(tmpDateFmt);
        }
        Date myDate = new Date(timestamp);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "createCompliantHttpDateString", "createCompliantHttpDateString result->" + tmpDateFmt.format(myDate));
        }
        return tmpDateFmt.format(myDate);
    }

    public static void main(String[] args) {
        SRTServletResponse srtRes = new SRTServletResponse();
        srtRes.setContentType("text/html;charset='ISO-8859-1'");
        srtRes._gotWriter = true;
        srtRes._headersWritten = true;
        srtRes.setContentType("text/xml;charset=ISO-8859-7");
        System.out.println(srtRes.getContentType());
        srtRes = new SRTServletResponse();
        srtRes.setCharacterEncoding(_defaultEncoding);
        System.out.println(srtRes.getContentType());
        srtRes = new SRTServletResponse();
        srtRes.setCharacterEncoding("UTF-8");
        srtRes.setContentType("text/html");
        try {
            srtRes.getWriter();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        srtRes._gotWriter = true;
        srtRes._headersWritten = true;
        srtRes.setContentType("text/xml");
        System.out.println(srtRes.getContentType());
        srtRes = new SRTServletResponse();
        try {
            srtRes.getWriter();
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        srtRes._gotWriter = true;
        srtRes._headersWritten = true;
        srtRes.setContentType("text/xml;charset=UTF-8");
        System.out.println(srtRes.getContentType());
        srtRes = new SRTServletResponse();
        srtRes.setContentType("text/html");
        srtRes.setCharacterEncoding("UTF-8");
        System.out.println(srtRes.getContentType());
        srtRes = new SRTServletResponse();
        try {
            srtRes.getWriter();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println(srtRes.getContentType());
    }

    @Override
    public void fireOutputStreamRetrievedEvent(ServletOutputStream sos) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "fireOutputStreamRetrievedEvent", "_firstOutputStreamRetrieval:" + String.valueOf(this._firstOutputStreamRetrieval) + " ,outputMethodListener:" + this.outputMethodListener, "[" + this + "]");
        }
        if (this.outputMethodListener != null && this._firstOutputStreamRetrieval) {
            this._firstOutputStreamRetrieval = false;
            this.outputMethodListener.notifyOutputStreamRetrieved(sos);
        }
    }

    @Override
    public void fireWriterRetrievedEvent(PrintWriter pw) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "fireWriterRetrievedEvent", "__firstWriterRetrieval:" + String.valueOf(this._firstWriterRetrieval) + " ,outputMethodListener:" + this.outputMethodListener, "[" + this + "]");
        }
        if (this.outputMethodListener != null && this._firstWriterRetrieval) {
            this._firstWriterRetrieval = false;
            this.outputMethodListener.notifyWriterRetrieved(pw);
        }
    }

    @Override
    public void registerOutputMethodListener(IOutputMethodListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "registerOutputMethodListener", "listener = " + listener, "[" + this + "]");
        }
        this.outputMethodListener = listener;
    }

    public static void setSkipInputStreamRead(boolean b) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setSkipInputStreamRead", "b = " + String.valueOf(b));
        }
        skipInputStreamRead = b;
    }

    public static boolean isSkipInputStreamRead() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isSkipInputStreamRead", "skipInputStreamRead = " + String.valueOf(skipInputStreamRead));
        }
        return skipInputStreamRead;
    }

    @Override
    public boolean isOutputWritten() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isOutputWritten", "_firstWrite = " + String.valueOf(this._firstWrite), "[" + this + "]");
        }
        return this._firstWrite;
    }

    public Collection<String> getHeaderNames() {
        return ((WrappingEnumeration)this._response.getHeaderNames()).getTargetCollection();
    }

    public Collection<String> getHeaders(String name) {
        return ((WrappingEnumeration)this._response.getHeaders(name)).getTargetCollection();
    }

    public int getStatus() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getStatus", "statusCode = " + this._statusCode, "[" + this + "]");
        }
        return this._statusCode;
    }

    @Override
    public void removeCookie(String cookieName) {
        if (this.isCommitted()) {
            throw new IllegalStateException("cannot remove cookie if the response is committed");
        }
        this._response.removeCookie(cookieName);
    }

    public void alertOSFirstFlush() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertOSFirstFlush", "entry");
        }
        if (!this.isCommitted()) {
            this.commit();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertOSFirstFlush", "exit");
        }
    }
}

