/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.context;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextDeserializationInfo;
import io.openliberty.concurrent.internal.context.ThirdPartyContext;
import io.openliberty.concurrent.internal.processor.ContextServiceResourceFactoryBuilder;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="io.openliberty.thirdparty.context.provider", configurationPolicy=ConfigurationPolicy.IGNORE)
public class ThirdPartyContextCoordinator
implements ApplicationStateListener,
com.ibm.wsspi.threadcontext.ThreadContextProvider {
    private static final TraceComponent tc = Tr.register(ThirdPartyContextCoordinator.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.resources.CWWKCMessages");
    private static final HashSet<String> BUILT_IN_CONTEXT = new HashSet();
    private static final String NO_CONTEXT_CLASSLOADER = "NO_CONTEXT_CLASSLOADER";
    static final SecureAction priv;
    private final ConcurrentHashMap<Object, Map.Entry<String, ArrayList<ThreadContextProvider>>> providersPerClassLoader = new ConcurrentHashMap();
    static final long serialVersionUID = 6245409677708225882L;

    @Trivial
    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    @Trivial
    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getName();
        Iterator<Map.Entry<Object, Map.Entry<String, ArrayList<ThreadContextProvider>>>> it = this.providersPerClassLoader.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ArrayList<ThreadContextProvider>> entry;
            Map.Entry<Object, Map.Entry<String, ArrayList<ThreadContextProvider>>> providerInfo = it.next();
            if (NO_CONTEXT_CLASSLOADER.equals(providerInfo.getKey()) || !appName.equals((entry = providerInfo.getValue()).getKey())) continue;
            it.remove();
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)"removed providers", (Object[])new Object[]{entry.getValue()});
        }
    }

    @Trivial
    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public ThreadContext captureThreadContext(Map<String, String> execProps, Map<String, ?> threadContextConfig) {
        return new ThirdPartyContext(this, execProps, threadContextConfig);
    }

    public ThreadContext createDefaultThreadContext(Map<String, String> execProps) {
        return new ThirdPartyContext(this, execProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadContext deserializeThreadContext(ThreadContextDeserializationInfo info, byte[] bytes) throws ClassNotFoundException, IOException {
        ThirdPartyContext context;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            context = (ThirdPartyContext)in.readObject();
        }
        context.initPostDeserialize(this, ((ThreadContextDescriptor)info).getExecutionProperties());
        return context;
    }

    private Object findConflictingProvider(ThreadContextProvider provider, ClassLoader classloader) {
        String conflictingType = provider.getThreadContextType();
        if (BUILT_IN_CONTEXT.contains(conflictingType)) {
            return "built-in";
        }
        for (ThreadContextProvider p : ServiceLoader.load(ThreadContextProvider.class, classloader)) {
            if (!conflictingType.equals(p.getThreadContextType()) || provider.equals(p)) continue;
            return p;
        }
        throw new IllegalStateException(conflictingType);
    }

    @Trivial
    public List<com.ibm.wsspi.threadcontext.ThreadContextProvider> getPrerequisites() {
        return null;
    }

    ArrayList<ThreadContextProvider> getProviders() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ClassLoader classLoader = priv.getContextClassLoader();
        Object key = classLoader == null ? NO_CONTEXT_CLASSLOADER : classLoader;
        AbstractMap.SimpleEntry providerInfo = this.providersPerClassLoader.get(key);
        if (providerInfo == null) {
            HashSet<String> available = new HashSet<String>(BUILT_IN_CONTEXT);
            ArrayList<ThreadContextProvider> providersNew = new ArrayList<ThreadContextProvider>();
            for (ThreadContextProvider provider : ServiceLoader.load(ThreadContextProvider.class, classLoader)) {
                String type = provider.getThreadContextType();
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("context type " + type + " provided by " + provider), (Object[])new Object[0]);
                }
                if (available.add(type)) {
                    providersNew.add(provider);
                    continue;
                }
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1203.duplicate.context", (Object[])new Object[]{type, provider, this.findConflictingProvider(provider, classLoader)}));
            }
            ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            String appName = cData == null ? "" : cData.getJ2EEName().getApplication();
            AbstractMap.SimpleEntry providerInfoNew = new AbstractMap.SimpleEntry(appName, providersNew);
            providerInfo = this.providersPerClassLoader.putIfAbsent(key, providerInfoNew);
            if (providerInfo == null) {
                providerInfo = providerInfoNew;
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"providers for", (Object[])new Object[]{appName, classLoader, providerInfo});
            }
        }
        return providerInfo.getValue();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        BUILT_IN_CONTEXT.addAll(ContextServiceResourceFactoryBuilder.BUILT_IN_CONTEXT_PIDS.keySet());
        BUILT_IN_CONTEXT.add("Remaining");
        BUILT_IN_CONTEXT.add("EmptyHandleList");
        BUILT_IN_CONTEXT.add("Transaction");
        priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    }
}

