/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.yoko.io.AlignmentBoundary;
import org.apache.yoko.io.Buffer;
import org.apache.yoko.io.WriteBuffer;
import org.apache.yoko.util.Hex;
import org.apache.yoko.util.HexConverter;

public final class ReadBuffer
extends Buffer<ReadBuffer> {
    ReadBuffer(Buffer.Core core) {
        super(core);
    }

    public byte peekByte() {
        return this.core.data[this.position];
    }

    public byte readByte() {
        return this.core.data[this.position++];
    }

    public char readByteAsChar() {
        return (char)this.core.data[this.position++];
    }

    public byte[] readBytes(byte[] buffer) {
        return this.readBytes(buffer, 0, buffer.length);
    }

    public byte[] readBytes(byte[] buffer, int offset, int length) {
        if (this.available() < length) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.core.data, this.position, buffer, offset, length);
        this.position += length;
        return buffer;
    }

    public WriteBuffer readBytes(WriteBuffer buffer) {
        return buffer.writeBytes(this.core.data, this.position, this.available());
    }

    public byte[] copyRemainingBytes() {
        return ReadBuffer.copyOf(this.core.data, this.available());
    }

    public char peekChar() {
        return (char)(this.core.data[this.position] << 8 | this.core.data[this.position + 1] & 0xFF);
    }

    public char readChar() {
        return (char)(this.core.data[this.position++] << 8 | this.core.data[this.position++] & 0xFF);
    }

    private char readChar_LE() {
        return (char)(this.core.data[this.position++] & 0xFF | this.core.data[this.position++] << 8);
    }

    public char readChar(boolean littleEndian) {
        return littleEndian ? this.readChar_LE() : this.readChar();
    }

    public short readShort() {
        return (short)(this.core.data[this.position++] << 8 | this.core.data[this.position++] & 0xFF);
    }

    private short readShort_LE() {
        return (short)(this.core.data[this.position++] & 0xFF | this.core.data[this.position++] << 8);
    }

    public short readShort(boolean littleEndian) {
        return littleEndian ? this.readShort_LE() : this.readShort();
    }

    public int readInt() {
        return this.core.data[this.position++] << 24 | this.core.data[this.position++] << 16 & 0xFF0000 | this.core.data[this.position++] << 8 & 0xFF00 | this.core.data[this.position++] & 0xFF;
    }

    public int readInt_LE() {
        return this.core.data[this.position++] & 0xFF | this.core.data[this.position++] << 8 & 0xFF00 | this.core.data[this.position++] << 16 & 0xFF0000 | this.core.data[this.position++] << 24;
    }

    public int readInt(boolean littleEndian) {
        return littleEndian ? this.readInt_LE() : this.readInt();
    }

    public String remainingBytesToAscii() {
        return HexConverter.octetsToAscii(this.core.data, this.available());
    }

    public String dumpRemainingData() {
        StringBuilder dump = new StringBuilder();
        dump.append(String.format("Read pos=0x%x Core len=0x%x Remaining core data=%n%n", this.position, this.core.length));
        return Hex.formatHexPara(this.core.data, this.position, this.available(), dump).toString();
    }

    public String dumpAllDataWithPosition() {
        return this.dumpAllDataWithPosition(new StringBuilder(), "pos").toString();
    }

    public StringBuilder dumpAllDataWithPosition(StringBuilder sb, String label) {
        Hex.formatHexPara(this.core.data, 0, this.position, sb);
        sb.append(String.format("%n       >>>>>>>> %4s: 0x%08X  <<<<<<<<%n", label, this.position));
        Hex.formatHexPara(this.core.data, this.position, this.available(), sb);
        return sb;
    }

    public void dumpSomeData(StringBuilder sb, String indent, int len) {
        Hex.formatHexPara(indent, this.core.data, this.position, len, sb);
    }

    public ReadBuffer writeTo(OutputStream out) throws IOException {
        try {
            out.write(this.core.data, this.position, this.available());
            out.flush();
            this.position = this.core.length;
            return this;
        }
        catch (InterruptedIOException ex) {
            this.position += ex.bytesTransferred;
            throw ex;
        }
    }

    public ReadBuffer rewindToStart() {
        this.position = 0;
        return this;
    }

    public ReadBuffer align(AlignmentBoundary boundary) {
        this.position = boundary.newIndex(this.position);
        return this;
    }

    public ReadBuffer skipBytes(int n) {
        int newPos = this.position + n;
        if (newPos < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (newPos > this.core.length) {
            throw new IndexOutOfBoundsException();
        }
        this.position = newPos;
        return this;
    }

    @Override
    public ReadBuffer newReadBuffer() {
        return (ReadBuffer)this.clone();
    }
}

