/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal;

import com.ibm.websphere.application.ApplicationMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.app.manager.AppMessageHelper;
import com.ibm.ws.app.manager.ApplicationManager;
import com.ibm.ws.app.manager.ApplicationStateCoordinator;
import com.ibm.ws.app.manager.CacheUtils;
import com.ibm.ws.app.manager.internal.ApplicationConfig;
import com.ibm.ws.app.manager.internal.ApplicationDependency;
import com.ibm.ws.app.manager.internal.FutureCollectionCompletionListener;
import com.ibm.ws.app.manager.internal.lifecycle.ServiceReg;
import com.ibm.ws.app.manager.internal.monitor.AppMonitorConfigurator;
import com.ibm.ws.app.manager.internal.statemachine.ApplicationStateMachine;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.application.Application;
import com.ibm.wsspi.application.ApplicationState;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.application.handler.ApplicationTypeSupported;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.logging.Introspector;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.AttributeChangeNotification;
import javax.management.DynamicMBean;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.StandardEmitterMBean;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ManagedServiceFactory.class, Introspector.class, RuntimeUpdateListener.class, ApplicationRecycleCoordinator.class, CheckpointHook.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.pid=com.ibm.ws.app.manager"})
public class ApplicationConfigurator
implements ManagedServiceFactory,
Introspector,
RuntimeUpdateListener,
ApplicationRecycleCoordinator,
CheckpointHook {
    private static final TraceComponent _tc = Tr.register(ApplicationConfigurator.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator");
    private final Map<String, NamedApplication> _appFromName = new HashMap<String, NamedApplication>();
    private final Map<String, NamedApplication> _appFromPid = new HashMap<String, NamedApplication>();
    private volatile Set<NamedApplication> _appsToShutdown;
    private final Map<String, ApplicationConfig> _blockedConfigFromPid = new HashMap<String, ApplicationConfig>();
    private final Map<String, List<String>> _blockedPidsFromName = new HashMap<String, List<String>>();
    private final Map<String, List<ApplicationDependency>> _startAfterDependencies = new HashMap<String, List<ApplicationDependency>>();
    private final Set<String> reportedCycles = new HashSet<String>();
    private final Map<String, ApplicationTypeSupport> _appTypeSupport = new HashMap<String, ApplicationTypeSupport>();
    private volatile BundleContext _ctx;
    private volatile ApplicationDependency _appManagerRARSupportDependency;
    private volatile ApplicationDependency _appManagerReadyDependency;
    private UpdateEpisodeState _currentEpisode;
    private final Map<ApplicationRecycleContext, ApplicationRecycleContextState> _appRecycleMap = new HashMap<ApplicationRecycleContext, ApplicationRecycleContextState>();
    private volatile ConfigurationAdmin _configAdmin;
    private volatile WsLocationAdmin _locAdmin;
    private volatile FutureMonitor _futureMonitor;
    private volatile RuntimeUpdateManager _runtimeUpdateManager;
    private volatile ArtifactContainerFactory _artifactFactory;
    private volatile AdaptableModuleFactory _moduleFactory;
    private volatile ExecutorService _executor;
    private volatile ScheduledExecutorService _scheduledExecutor;
    private volatile AppMonitorConfigurator _appMonitorConfigurator;
    private volatile ApplicationManager _applicationManager;
    private final CheckpointPhase _checkpointPhase = CheckpointPhase.getPhase();
    private final List<Runnable> _restoreMessages = new CopyOnWriteArrayList<Runnable>();
    private static final Collection<String> SIMPLE_INITIAL_UPDATE_NOTIFICATIONS = Arrays.asList("FeatureUpdatesCompleted", "ConfigUpdatesDelivered", "ORBStarting");
    static final long serialVersionUID = 5490850289746020923L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext ctx) {
        this._appManagerRARSupportDependency = this.createDependency("resolves when either support for type=rar applications is registered or we are ready for apps to start");
        if (this._appTypeSupport.get("rar") != null) {
            this._appManagerRARSupportDependency.setResult(true);
        }
        this._appManagerReadyDependency = this.createDependency("resolves when we are ready for apps to start");
        ApplicationConfigurator applicationConfigurator = this;
        synchronized (applicationConfigurator) {
            if (FrameworkState.isStopping()) {
                return;
            }
            final UpdateEpisodeState episode = this.joinEpisode();
            if (episode == null) {
                return;
            }
            for (String initialNotificationName : SIMPLE_INITIAL_UPDATE_NOTIFICATIONS) {
                RuntimeUpdateNotification notification = this._runtimeUpdateManager.getNotification(initialNotificationName);
                if (notification == null) continue;
                this.joinEpisode().createSimpleDependency(notification.getFuture());
            }
            this._appManagerReadyDependency.onCompletion(new CompletionListener<Boolean>(){
                static final long serialVersionUID = 1411059772787189606L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    episode.dropReference();
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    episode.dropReference();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$1");
                }
            });
        }
        ApplicationStateCoordinator.setApplicationConfigurator(this);
        this._ctx = ctx.getBundleContext();
    }

    @Modified
    protected void modified(ComponentContext ctx) {
        this._ctx = ctx.getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        HashSet<NamedApplication> appsToStop;
        this._ctx = null;
        this._appManagerReadyDependency = null;
        this._appManagerRARSupportDependency = null;
        Object object = this;
        synchronized (object) {
            appsToStop = new HashSet<NamedApplication>(this._appFromName.values());
            this._appFromName.clear();
            this._appFromPid.clear();
            this._blockedConfigFromPid.clear();
            this._blockedPidsFromName.clear();
            this._appTypeSupport.clear();
        }
        for (NamedApplication app : appsToStop) {
            this.uninstallApp(app);
        }
        object = this;
        synchronized (object) {
            UpdateEpisodeState episode = this._currentEpisode;
            if (episode != null) {
                episode.deactivate();
                this.leaveEpisode();
            }
        }
        ApplicationStateCoordinator.setApplicationConfigurator(null);
    }

    @Reference
    protected void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this._configAdmin = configurationAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this._configAdmin = null;
    }

    @Reference(name="locationService", service=WsLocationAdmin.class)
    protected void setLocationService(WsLocationAdmin locationService) {
        this._locAdmin = locationService;
    }

    protected void unsetLocationService(WsLocationAdmin locationService) {
        this._locAdmin = null;
    }

    @Reference(service=FutureMonitor.class)
    protected void setFutureMonitor(FutureMonitor futureMonitor) {
        this._futureMonitor = futureMonitor;
    }

    protected void unsetFutureMonitor(FutureMonitor futureMonitor) {
        this._futureMonitor = null;
    }

    @Reference(service=RuntimeUpdateManager.class)
    protected void setRuntimeUpdateManager(RuntimeUpdateManager runtimeUpdateManager) {
        this._runtimeUpdateManager = runtimeUpdateManager;
    }

    protected void unsetRuntimeUpdateManager(RuntimeUpdateManager runtimeUpdateManager) {
        this._runtimeUpdateManager = null;
    }

    @Reference(name="containerFactory", service=ArtifactContainerFactory.class)
    protected void setContainerFactory(ArtifactContainerFactory containerFactory) {
        this._artifactFactory = containerFactory;
    }

    protected void unsetContainerFactory(ArtifactContainerFactory containerFactory) {
        this._artifactFactory = null;
    }

    @Reference(service=AdaptableModuleFactory.class)
    protected void setAdaptableModuleFactory(AdaptableModuleFactory adaptableModuleFactory) {
        this._moduleFactory = adaptableModuleFactory;
    }

    protected void unsetAdaptableModuleFactory(AdaptableModuleFactory adaptableModuleFactory) {
        this._moduleFactory = null;
    }

    @Reference(name="executorService", service=ExecutorService.class)
    protected void setExecutorService(ExecutorService executorService) {
        this._executor = executorService;
    }

    protected void unsetExecutorService(ExecutorService executorService) {
        this._executor = null;
    }

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class)
    protected void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this._scheduledExecutor = scheduledExecutorService;
    }

    protected void unsetScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this._scheduledExecutor = null;
    }

    @Reference(service=AppMonitorConfigurator.class)
    protected void setApplicationMonitorConfigurator(AppMonitorConfigurator appMonitorConfigurator) {
        this._appMonitorConfigurator = appMonitorConfigurator;
    }

    protected void unsetApplicationMonitorConfigurator(AppMonitorConfigurator appMonitorConfigurator) {
        this._appMonitorConfigurator = null;
    }

    @Reference(name="appTypeSupported", service=ApplicationTypeSupported.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setAppTypeSupported(ApplicationTypeSupported appTypeSupported, Map<String, ?> serviceProps) {
        Object o = serviceProps.get("type");
        if (o != null) {
            if (o instanceof String) {
                String appType = (String)o;
                this.registerAppType(appType);
            } else if (o instanceof String[]) {
                for (String appType : (String[])o) {
                    this.registerAppType(appType);
                }
            }
        }
    }

    protected void unsetAppTypeSupported(ApplicationTypeSupported appTypeSupported, Map<String, ?> serviceProps) {
        Object o = serviceProps.get("type");
        if (o != null) {
            if (o instanceof String) {
                String appType = (String)o;
                this.unregisterAppType(appType);
            } else if (o instanceof String[]) {
                for (String appType : (String[])o) {
                    this.unregisterAppType(appType);
                }
            }
        }
    }

    @Reference(name="appHandler", service=ApplicationHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setAppHandler(ApplicationHandler<?> appHandler, Map<String, ?> serviceProps) {
        Object o = serviceProps.get("type");
        if (o != null) {
            if (o instanceof String) {
                String appType = (String)o;
                this.registerAppHandler(appType, appHandler);
            } else if (o instanceof String[]) {
                for (String appType : (String[])o) {
                    this.registerAppHandler(appType, appHandler);
                }
            }
        }
    }

    protected void unsetAppHandler(ApplicationHandler<?> appHandler, Map<String, ?> serviceProps) {
        if (FrameworkState.isStopping()) {
            return;
        }
        Object o = serviceProps.get("type");
        if (o != null) {
            if (o instanceof String) {
                String appType = (String)o;
                this.unregisterAppHandler(appType, appHandler);
            } else if (o instanceof String[]) {
                for (String appType : (String[])o) {
                    this.unregisterAppHandler(appType, appHandler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="appRecycleContext", service=ApplicationRecycleContext.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setAppRecycleContext(ApplicationRecycleContext appRecycleContext) {
        try {
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)("setAppRecycleContext: context " + appRecycleContext), (Object[])new Object[0]);
            }
            String appName = appRecycleContext.getAppName();
            ApplicationConfigurator applicationConfigurator = this;
            synchronized (applicationConfigurator) {
                ApplicationRecycleContextState contextState;
                NamedApplication app;
                NamedApplication namedApplication = app = appName != null ? this._appFromName.get(appName) : null;
                if (app != null) {
                    app.setRecycleContext(appRecycleContext);
                }
                if ((contextState = this._appRecycleMap.get(appRecycleContext)) == null) {
                    contextState = new ApplicationRecycleContextState();
                    this._appRecycleMap.put(appRecycleContext, contextState);
                }
                contextState.context = appRecycleContext;
            }
        }
        finally {
            this.dumpApplications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetAppRecycleContext(ApplicationRecycleContext appRecycleContext) {
        try {
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)("unsetAppRecycleContext: context " + appRecycleContext), (Object[])new Object[0]);
            }
            if (FrameworkState.isStopping()) {
                return;
            }
            ApplicationConfigurator applicationConfigurator = this;
            synchronized (applicationConfigurator) {
                UpdateEpisodeState episode;
                block15: {
                    episode = this.joinEpisode();
                    if (episode != null) break block15;
                    return;
                }
                episode.recycleAppContext(appRecycleContext);
                ApplicationRecycleContextState state = this._appRecycleMap.get(appRecycleContext);
                if (state != null) {
                    state.context = null;
                    if (state.isEmpty()) {
                        this._appRecycleMap.remove(appRecycleContext);
                        episode.dropContextReference(appRecycleContext);
                    }
                } else if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"unsetAppRecycleContext: context was not previously set", (Object[])new Object[0]);
                }
            }
        }
        finally {
            this.dumpApplications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="appRecycleComponent", service=ApplicationRecycleComponent.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setAppRecycleComponent(ApplicationRecycleComponent appRecycleComponent) {
        block8: {
            try {
                ApplicationRecycleContext context;
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)("setAppRecycleComponent: component " + appRecycleComponent + ", context " + appRecycleComponent.getContext()), (Object[])new Object[0]);
                }
                if ((context = appRecycleComponent.getContext()) == null) break block8;
                ApplicationConfigurator applicationConfigurator = this;
                synchronized (applicationConfigurator) {
                    ApplicationRecycleContextState contextState = this._appRecycleMap.get(context);
                    if (contextState == null) {
                        contextState = new ApplicationRecycleContextState();
                        this._appRecycleMap.put(context, contextState);
                    }
                    contextState.components.add(appRecycleComponent);
                }
            }
            finally {
                this.dumpApplications();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetAppRecycleComponent(ApplicationRecycleComponent appRecycleComponent) {
        try {
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)("unsetAppRecycleComponent: component " + appRecycleComponent + ", context " + appRecycleComponent.getContext()), (Object[])new Object[0]);
            }
            if (FrameworkState.isStopping()) {
                return;
            }
            ApplicationRecycleContext context = appRecycleComponent.getContext();
            Set dependentApplications = appRecycleComponent.getDependentApplications();
            ApplicationConfigurator applicationConfigurator = this;
            synchronized (applicationConfigurator) {
                UpdateEpisodeState episode;
                block21: {
                    block19: {
                        block20: {
                            block17: {
                                episode = this.joinEpisode();
                                if (episode != null) break block17;
                                return;
                            }
                            if (context == null) break block19;
                            ApplicationRecycleContextState state = this._appRecycleMap.get(context);
                            if (state == null) break block20;
                            state.components.remove(appRecycleComponent);
                            if (state.isEmpty()) {
                                this._appRecycleMap.remove(context);
                                episode.dropContextReference(context);
                            }
                            break block21;
                        }
                        if (!_tc.isEventEnabled()) break block21;
                        Tr.event((TraceComponent)_tc, (String)"unsetAppRecycleComponent: component context was not previously set", (Object[])new Object[0]);
                        break block21;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"unsetAppRecycleComponent: no context for component.", (Object[])new Object[0]);
                    }
                    Iterator<Map.Entry<ApplicationRecycleContext, ApplicationRecycleContextState>> iter = this._appRecycleMap.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<ApplicationRecycleContext, ApplicationRecycleContextState> entry = iter.next();
                        ApplicationRecycleContextState state = entry.getValue();
                        if (!state.components.remove(appRecycleComponent)) continue;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("Removing component " + appRecycleComponent + " from appState map for context " + entry.getKey()), (Object[])new Object[0]);
                        }
                        if (!state.isEmpty()) continue;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("No components left for context " + entry.getKey() + ", removing from app recycle map."), (Object[])new Object[0]);
                        }
                        iter.remove();
                        episode.dropContextReference(entry.getKey());
                    }
                }
                Collection<NamedApplication> apps = this.getNamedApps(dependentApplications);
                if (apps != null && !apps.isEmpty()) {
                    episode.recycleApps(apps);
                }
                episode.dropReference();
            }
        }
        finally {
            this.dumpApplications();
        }
    }

    @Reference
    protected void setApplicationManager(ApplicationManager mgr) {
        this._applicationManager = mgr;
    }

    protected void unsetApplicationManager(ApplicationManager mgr) {
        this._applicationManager = null;
    }

    public String getName() {
        return "ApplicationConfigurator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        if (this._ctx == null || this._appsToShutdown != null) {
            return;
        }
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Error while updating application configuration with pid: " + pid + ", no properties were provided"), (Object[])new Object[0]);
            }
            return;
        }
        try {
            ApplicationConfigurator applicationConfigurator = this;
            synchronized (applicationConfigurator) {
                ApplicationConfig appConfig = new ApplicationConfig(pid, properties, this._applicationManager);
                if (appConfig.getLocation() == null) {
                    if (appConfig.getName() == null) {
                        Tr.audit((TraceComponent)_tc, (String)"APPLICATION_NO_LOCATION_NO_NAME", (Object[])new Object[0]);
                    } else {
                        Tr.audit((TraceComponent)_tc, (String)"APPLICATION_NO_LOCATION", (Object[])new Object[]{appConfig.getName()});
                    }
                } else if (appConfig.getType() == null) {
                    Tr.audit((TraceComponent)_tc, (String)"APPLICATION_NO_TYPE", (Object[])new Object[]{appConfig.getName(), appConfig.getLocation()});
                }
                this.processUpdate(pid, appConfig);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator", (String)"870", (Object)this, (Object[])new Object[]{pid, properties});
            if (_tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)_tc, (String)("Error while updating application configuration with pid: " + pid + ", Exception: " + e), (Object[])new Object[0]);
            }
        }
        finally {
            this.dumpApplications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void deleted(String pid) {
        if (this._ctx == null) {
            return;
        }
        try {
            ApplicationConfigurator applicationConfigurator = this;
            synchronized (applicationConfigurator) {
                this.processDeletion(pid);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator", (String)"888", (Object)this, (Object[])new Object[]{pid});
            if (_tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)_tc, (String)("Error while deleting application configuration with pid: " + pid + ", Exception: " + e), (Object[])new Object[0]);
            }
        }
        finally {
            this.dumpApplications();
        }
    }

    public String getIntrospectorName() {
        return "ApplicationConfigurator";
    }

    public String getIntrospectorDescription() {
        return "ApplicationConfigurator";
    }

    public void introspect(PrintWriter out) throws Exception {
        this.writeHeader("Applications", out);
        StringBuilder sb = new StringBuilder();
        for (NamedApplication app : this.getNamedApps()) {
            sb.append("  ");
            app.describe(sb);
            sb.append("\n\n");
        }
        out.print(sb.toString());
    }

    private void writeHeader(String header, PrintWriter writer) {
        writer.print("\n");
        writer.println(header);
        for (int i = header.length(); i > 0; --i) {
            writer.print("-");
        }
        writer.print("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notificationCreated(RuntimeUpdateManager updateManager, RuntimeUpdateNotification notification) {
        UpdateEpisodeState episode;
        ApplicationConfigurator applicationConfigurator;
        if (this._ctx == null || this._appsToShutdown != null) {
            return;
        }
        if ("AppForceRestart".equals(notification.getName())) {
            applicationConfigurator = this;
            synchronized (applicationConfigurator) {
                episode = this.joinEpisode();
                if (episode != null) {
                    episode.createAppForceRestartDependency(notification.getFuture(), updateManager.getNotification("FeatureUpdatesCompleted"));
                }
            }
        }
        if (SIMPLE_INITIAL_UPDATE_NOTIFICATIONS.contains(notification.getName())) {
            applicationConfigurator = this;
            synchronized (applicationConfigurator) {
                episode = this.joinEpisode();
                if (episode != null) {
                    episode.createSimpleDependency(notification.getFuture());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycleApplications(Set<String> dependentApplications) {
        try {
            if (FrameworkState.isStopping()) {
                return;
            }
            ApplicationConfigurator applicationConfigurator = this;
            synchronized (applicationConfigurator) {
                UpdateEpisodeState episode;
                Collection<NamedApplication> apps = dependentApplications == null ? new HashSet<NamedApplication>(this._appFromName.values()) : this.getNamedApps(dependentApplications);
                if (apps != null && !apps.isEmpty() && (episode = this.joinEpisode()) != null) {
                    episode.recycleApps(apps);
                    episode.dropReference();
                }
            }
        }
        finally {
            this.dumpApplications();
        }
    }

    private synchronized void registerAppType(String appType) {
        ApplicationDependency current;
        ApplicationTypeSupport typeSupport = this._appTypeSupport.get(appType);
        if (typeSupport == null) {
            typeSupport = new ApplicationTypeSupport(true);
            this._appTypeSupport.put(appType, typeSupport);
        } else {
            typeSupport.setSupported(true);
        }
        if ("rar".equals(appType) && (current = this._appManagerRARSupportDependency) != null) {
            current.setResult(true);
        }
    }

    private synchronized void unregisterAppType(String appType) {
        if (FrameworkState.isStopping()) {
            return;
        }
        ApplicationTypeSupport typeSupport = this._appTypeSupport.get(appType);
        if (typeSupport != null) {
            typeSupport.setSupported(false);
        }
    }

    private synchronized void registerAppHandler(String appType, ApplicationHandler<?> appHandler) {
        ApplicationTypeSupport typeSupport = this._appTypeSupport.get(appType);
        if (typeSupport == null) {
            typeSupport = new ApplicationTypeSupport(false);
            this._appTypeSupport.put(appType, typeSupport);
        }
        typeSupport.setHandler(appHandler);
    }

    private synchronized void unregisterAppHandler(String appType, ApplicationHandler<?> appHandler) {
        UpdateEpisodeState episode;
        if (FrameworkState.isStopping()) {
            return;
        }
        ApplicationTypeSupport typeSupport = this._appTypeSupport.get(appType);
        if (typeSupport == null) {
            throw new RuntimeException("unregisterAppHandler: appType=" + appType + ": appTypeSupport == null");
        }
        typeSupport.setHandler(null);
        HashSet<NamedApplication> appsUsingHandler = new HashSet<NamedApplication>();
        for (NamedApplication app : this._appFromName.values()) {
            if (app.getTypeSupport() != typeSupport) continue;
            appsUsingHandler.add(app);
            typeSupport.addWaitingApp(app);
        }
        if (!appsUsingHandler.isEmpty() && (episode = this.joinEpisode()) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"app type: ", (Object[])new Object[]{appType});
            }
            if (appType.equals("rar")) {
                episode.removeRarsStartedDependency();
            }
            episode.unsetAppHandler(appsUsingHandler);
            episode.dropReference();
        }
    }

    @Trivial
    private ApplicationStateMachine createStateMachine(NamedApplication app) {
        ApplicationStateMachine asm = ApplicationStateMachine.newInstance(this._ctx, this._locAdmin, this._futureMonitor, this._artifactFactory, this._moduleFactory, this._executor, this._scheduledExecutor, app, this._appMonitorConfigurator.getMonitor(), this);
        app.setStateMachine(asm);
        return asm;
    }

    private void processUpdate(String newPid, ApplicationConfig newAppConfig) {
        UpdateEpisodeState episode;
        ApplicationStateMachine asm;
        NamedApplication app;
        this.dumpApplications();
        ApplicationStateCoordinator.updateConfiguredAppStatus(newPid);
        String newAppName = newAppConfig.getName();
        NamedApplication oldAppFromNewPid = this._appFromPid.get(newPid);
        NamedApplication oldAppFromNewName = this._appFromName.get(newAppName);
        if (oldAppFromNewPid != null) {
            if (oldAppFromNewName == null) {
                this.processUpdateWithNameChange(newPid, newAppConfig, oldAppFromNewPid);
                return;
            }
            if (oldAppFromNewName != oldAppFromNewPid) {
                this.processUpdateWithNameConflict(newPid, newAppConfig, oldAppFromNewPid, oldAppFromNewName);
                return;
            }
            app = oldAppFromNewPid;
            app.setConfig(newAppConfig);
            if (app.getStateMachine() != null) {
                asm = app.getStateMachine();
                this.recycleDependentApps(app.getRecycleContext());
            } else {
                asm = this.createStateMachine(app);
            }
        } else {
            if (oldAppFromNewName != null) {
                this.processAddWithNameConflict(newPid, newAppConfig, oldAppFromNewName);
                return;
            }
            app = new NamedApplication(newAppName, newAppConfig, this._ctx, this._executor);
            asm = this.createStateMachine(app);
            this._appFromPid.put(newPid, app);
            this._appFromName.put(newAppName, app);
        }
        String appType = newAppConfig.getType();
        ApplicationTypeSupport typeSupport = this._appTypeSupport.get(appType);
        if (typeSupport == null) {
            typeSupport = new ApplicationTypeSupport(false);
            this._appTypeSupport.put(appType, typeSupport);
        }
        app.setTypeSupport(typeSupport);
        ApplicationHandler<?> appHandler = typeSupport.getHandler();
        asm.setAppHandler(appHandler);
        if (appHandler == null) {
            typeSupport.addWaitingApp(app);
        }
        if ((episode = this.joinEpisode()) != null) {
            episode.configureApp(app);
            episode.dropReference();
        }
    }

    private boolean cleanCache(File appsRoot, Set<String> excludedCacheIds) {
        if (appsRoot == null || !appsRoot.isDirectory()) {
            return false;
        }
        File[] appRoots = appsRoot.listFiles();
        if (appRoots == null || appRoots.length == 0) {
            return true;
        }
        boolean result = true;
        for (File appRoot : appRoots) {
            if (excludedCacheIds.contains(appRoot.getName()) || this.recursivelyDelete(appRoot)) continue;
            result = false;
        }
        return result;
    }

    private boolean recursivelyDelete(File f) {
        File[] children;
        boolean result = true;
        if (f.isDirectory() && (children = f.listFiles()) != null) {
            for (File child : children) {
                if (this.recursivelyDelete(child)) continue;
                result = false;
            }
        }
        if (!f.delete()) {
            return false;
        }
        return result;
    }

    private void processDeletion(String pid) {
        NamedApplication appFromPid = this._appFromPid.get(pid);
        if (appFromPid == null) {
            ApplicationConfig blockedConfig = this._blockedConfigFromPid.remove(pid);
            if (blockedConfig != null) {
                String blockedName = blockedConfig.getName();
                List<String> blockedPids = this._blockedPidsFromName.get(blockedName);
                if (blockedPids != null && !blockedPids.isEmpty()) {
                    blockedPids.remove(pid);
                }
                return;
            }
            return;
        }
        NamedApplication appFromName = this._appFromName.get(appFromPid.getAppName());
        if (appFromPid != appFromName) {
            throw new IllegalStateException("processDeletion: appFromPid=" + appFromPid + ", appFromName=" + appFromName);
        }
        this.uninstallApp(appFromPid, true);
    }

    private File getCacheDir() {
        return this._locAdmin.getBundleFile((Object)this, "cache");
    }

    private File getCacheAdaptDir() {
        return this._locAdmin.getBundleFile((Object)this, "cacheAdapt");
    }

    private File getCacheOverlayDir() {
        return this._locAdmin.getBundleFile((Object)this, "cacheOverlay");
    }

    private void processUpdateWithNameChange(final String pid, final ApplicationConfig newAppConfig, NamedApplication appFromPid) {
        UpdateEpisodeState episode;
        String oldAppName = appFromPid.getAppName();
        ApplicationConfig oldAppConfig = appFromPid.getConfig();
        if (oldAppConfig == null) {
            throw new RuntimeException("processUpdateWithNameChange: pid=" + pid + ", oldAppName=" + oldAppName + ": unable to find old app config");
        }
        String oldPid = oldAppConfig.getConfigPid();
        if (!oldPid.equals(pid)) {
            throw new RuntimeException("processUpdateWithNameChange: name=" + oldAppName + ", oldPid=" + oldPid + ", newPid=" + pid);
        }
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)("processUpdateWithNameChange: pid=" + pid + ", oldAppName=" + oldAppName + ", newAppName=" + newAppConfig.getName()), (Object[])new Object[0]);
        }
        if ((episode = this.joinEpisode()) != null) {
            ApplicationDependency appRemoved = this.uninstallApp(appFromPid);
            appRemoved.onCompletion(new CompletionListener<Boolean>(){
                static final long serialVersionUID = -77177340519097615L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    ApplicationConfigurator applicationConfigurator = ApplicationConfigurator.this;
                    synchronized (applicationConfigurator) {
                        ApplicationConfigurator.this.processUpdate(pid, newAppConfig);
                        episode.dropReference();
                    }
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    episode.dropReference();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$2");
                }
            });
        }
    }

    private void processAddWithNameConflict(String pid, ApplicationConfig newAppConfig, NamedApplication appFromName) {
        String newAppName = newAppConfig.getName();
        ApplicationTypeSupport typeSupport = this._appTypeSupport.get(newAppConfig.getType());
        ApplicationHandler<?> handler = typeSupport != null ? typeSupport.getHandler() : null;
        AppMessageHelper.get(handler).error("DUPLICATE_APPLICATION_NAME", newAppName);
        this.blockApplication(pid, newAppConfig, newAppName);
        ApplicationStateCoordinator.updateStartingAppStatus(pid, ApplicationStateCoordinator.AppStatus.DUP_APP_NAME);
    }

    private void processUpdateWithNameConflict(String pid, ApplicationConfig newAppConfig, NamedApplication appFromPid, NamedApplication appFromName) {
        UpdateEpisodeState episode;
        String newAppName = newAppConfig.getName();
        String oldAppName = appFromPid.getAppName();
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)("processUpdateWithNameConflict: pid=" + pid + ", oldAppName=" + oldAppName + ", newAppName=" + newAppName), (Object[])new Object[0]);
        }
        if ((episode = this.joinEpisode()) != null) {
            ApplicationDependency appRemoved = this.uninstallApp(appFromPid);
            ApplicationTypeSupport typeSupport = this._appTypeSupport.get(newAppConfig.getType());
            AppMessageHelper.get(typeSupport != null ? typeSupport.getHandler() : null).audit("DUPLICATE_APPLICATION_NAME", newAppName);
            this.blockApplication(pid, newAppConfig, newAppName);
            ApplicationStateCoordinator.updateStartingAppStatus(pid, ApplicationStateCoordinator.AppStatus.DUP_APP_NAME);
            appRemoved.onCompletion(new CompletionListener<Boolean>(){
                static final long serialVersionUID = 8596622614134412452L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    ApplicationConfigurator applicationConfigurator = ApplicationConfigurator.this;
                    synchronized (applicationConfigurator) {
                        episode.dropReference();
                    }
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    episode.dropReference();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$3");
                }
            });
        }
    }

    private void recycleDependentApps(ApplicationRecycleContext recycleContext) {
        if (recycleContext != null) {
            ApplicationRecycleContextState recycleContextState = this._appRecycleMap.get(recycleContext);
            if (recycleContextState != null) {
                HashSet<String> currentDependentApps = new HashSet<String>();
                for (ApplicationRecycleComponent recycleComponent : recycleContextState.components) {
                    Set dependentApps = recycleComponent.getDependentApplications();
                    if (dependentApps == null || dependentApps.isEmpty()) continue;
                    currentDependentApps.addAll(dependentApps);
                }
                Collection<NamedApplication> apps = this.getNamedApps(currentDependentApps);
                if (apps != null && !apps.isEmpty()) {
                    UpdateEpisodeState episode = this._currentEpisode.addReference();
                    episode.recycleApps(apps);
                    episode.dropReference();
                }
            } else if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"recycleDependentApps: config context was not previously set", (Object[])new Object[0]);
            }
        }
    }

    private Collection<NamedApplication> getNamedApps(Set<String> appNames) {
        HashSet<NamedApplication> apps = null;
        if (appNames != null) {
            for (String appName : appNames) {
                NamedApplication app = this._appFromName.get(appName);
                if (app == null) continue;
                if (apps == null) {
                    apps = new HashSet<NamedApplication>();
                }
                apps.add(app);
            }
        }
        return apps;
    }

    private void addStartDependency(String pid, ApplicationDependency dependency) {
        List<ApplicationDependency> deps = this._startAfterDependencies.get(pid);
        if (deps == null) {
            deps = new LinkedList<ApplicationDependency>();
            this._startAfterDependencies.put(pid, deps);
        }
        deps.add(dependency);
    }

    private void blockApplication(String pid, ApplicationConfig newAppConfig, String newAppName) {
        this._blockedConfigFromPid.put(pid, newAppConfig);
        List<String> blockedPids = this._blockedPidsFromName.get(newAppName);
        if (blockedPids == null) {
            blockedPids = new LinkedList<String>();
            this._blockedPidsFromName.put(newAppName, blockedPids);
        }
        blockedPids.add(pid);
    }

    @Trivial
    ApplicationDependency createDependency(String desc) {
        ApplicationDependency appDep = new ApplicationDependency(this._futureMonitor, desc);
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)("createDependency: created " + appDep), (Object[])new Object[0]);
        }
        return appDep;
    }

    @Trivial
    private synchronized NamedApplication[] getNamedApps() {
        Collection<NamedApplication> apps = this._appFromName.values();
        return apps.toArray(new NamedApplication[apps.size()]);
    }

    @Trivial
    void dumpApplications() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            String prefix = " ";
            for (NamedApplication app : this.getNamedApps()) {
                sb.append(prefix);
                app.describe(sb);
                prefix = ", ";
            }
            String desc = sb.toString();
            if (desc.length() > 0) {
                Tr.debug((TraceComponent)_tc, (String)("applications:" + desc), (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private UpdateEpisodeState joinEpisode() {
        if (this._currentEpisode == null) {
            try {
                this._currentEpisode = new UpdateEpisodeState();
            }
            catch (IllegalStateException ex) {
                return null;
            }
        }
        return this._currentEpisode.addReference();
    }

    private void leaveEpisode() {
        UpdateEpisodeState episode = this._currentEpisode;
        if (episode != null) {
            this._currentEpisode = null;
        }
    }

    public ConfigurationAdmin getConfigAdminService() {
        return this._configAdmin;
    }

    public void readyForAppsToStart() {
        this._appManagerRARSupportDependency.setResult(true);
        this._appManagerReadyDependency.setResult(true);
    }

    public synchronized void readyForAppsToStop() {
        HashSet<String> appPids = new HashSet<String>();
        HashSet<String> appCacheIds = new HashSet<String>();
        this._appsToShutdown = new HashSet<NamedApplication>();
        for (NamedApplication app : this._appFromName.values()) {
            if (app.getStateMachine() == null) continue;
            ApplicationConfig appConfig = app.getConfig();
            String appPid = appConfig.getConfigPid();
            String appId = (String)appConfig.getConfigProperty("id");
            String appCacheId = CacheUtils.getCacheId(appPid, appId);
            appPids.add(appPid);
            appCacheIds.add(appCacheId);
            this._appsToShutdown.add(app);
        }
        this._appFromName.clear();
        this._appFromPid.clear();
        this._blockedConfigFromPid.clear();
        this._blockedPidsFromName.clear();
        this.cleanCache(this.getCacheAdaptDir(), appCacheIds);
        this.cleanCache(this.getCacheOverlayDir(), appCacheIds);
        this.cleanCache(this.getCacheDir(), appCacheIds);
        ApplicationStateCoordinator.setStoppingAppPids(appPids);
        for (NamedApplication app : this._appsToShutdown) {
            this.uninstallApp(app);
        }
        this._appsToShutdown.clear();
    }

    private ApplicationDependency uninstallApp(NamedApplication appFromPid) {
        return this.uninstallApp(appFromPid, false);
    }

    private ApplicationDependency uninstallApp(final NamedApplication appFromPid, final boolean cleanCache) {
        final String oldAppName = appFromPid.getAppName();
        ApplicationDependency appRemoved = this.createDependency("resolves when app " + oldAppName + " is removed");
        ApplicationStateMachine asm = appFromPid.getStateMachine();
        appFromPid.setStateMachine(null);
        if (asm != null) {
            asm.uninstall(appRemoved);
        } else {
            appRemoved.setResult(true);
        }
        appRemoved.onCompletion(new CompletionListener<Boolean>(){
            static final long serialVersionUID = 7002765324801101909L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void successfulCompletion(Future<Boolean> future, Boolean result) {
                ApplicationConfigurator applicationConfigurator = ApplicationConfigurator.this;
                synchronized (applicationConfigurator) {
                    String removedAppPid = appFromPid.getConfigPid();
                    String removedAppId = (String)appFromPid.getConfig().getConfigProperty("id");
                    appFromPid.unregisterServices();
                    if (ApplicationConfigurator.this._appFromPid.containsKey(removedAppPid) && ((NamedApplication)ApplicationConfigurator.this._appFromPid.get(removedAppPid)).equals(appFromPid)) {
                        ApplicationConfigurator.this._appFromPid.remove(removedAppPid);
                    }
                    if (ApplicationConfigurator.this._appFromName.containsKey(oldAppName) && ((NamedApplication)ApplicationConfigurator.this._appFromName.get(oldAppName)).equals(appFromPid)) {
                        ApplicationConfigurator.this._appFromName.remove(oldAppName);
                    }
                    ApplicationStateCoordinator.updateStartingAppStatus(removedAppPid, ApplicationStateCoordinator.AppStatus.REMOVED);
                    ApplicationStateCoordinator.updateStoppingAppStatus(removedAppPid, ApplicationStateCoordinator.AppStatus.REMOVED);
                    List blockedPids = (List)ApplicationConfigurator.this._blockedPidsFromName.get(oldAppName);
                    if (blockedPids != null && !blockedPids.isEmpty()) {
                        String blockedPid = (String)blockedPids.remove(0);
                        ApplicationConfig blockedConfig = (ApplicationConfig)ApplicationConfigurator.this._blockedConfigFromPid.remove(blockedPid);
                        ApplicationConfigurator.this.processUpdate(blockedPid, blockedConfig);
                    }
                    if (cleanCache) {
                        String cacheId = CacheUtils.getCacheId(removedAppPid, removedAppId);
                        ApplicationConfigurator.this.recursivelyDelete(new File(ApplicationConfigurator.this.getCacheDir(), cacheId));
                        ApplicationConfigurator.this.recursivelyDelete(new File(ApplicationConfigurator.this.getCacheAdaptDir(), cacheId));
                        ApplicationConfigurator.this.recursivelyDelete(new File(ApplicationConfigurator.this.getCacheOverlayDir(), cacheId));
                    }
                }
            }

            public void failedCompletion(Future<Boolean> future, Throwable t) {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(4.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$4");
            }
        });
        return appRemoved;
    }

    public void unblockAppStartDependencies(String appPid) {
        List<ApplicationDependency> deps = this._startAfterDependencies.get(appPid);
        if (deps == null) {
            return;
        }
        for (ApplicationDependency dep : deps) {
            dep.setResult(true);
        }
    }

    @FFDCIgnore(value={CycleException.class})
    private boolean containsCycles(NamedApplication app) {
        LinkedList<NamedApplication> existing = new LinkedList<NamedApplication>();
        existing.add(app);
        try {
            this.checkForCycles(app, existing);
            return false;
        }
        catch (CycleException ex) {
            return true;
        }
    }

    private synchronized void checkForCycles() {
        for (Map.Entry<String, NamedApplication> entry : this._appFromPid.entrySet()) {
            if (!this.containsCycles(entry.getValue())) continue;
            ApplicationStateCoordinator.updateStartingAppStatus(entry.getKey(), ApplicationStateCoordinator.AppStatus.CYCLE);
        }
    }

    private void checkForCycles(NamedApplication app, LinkedList<NamedApplication> existing) throws CycleException {
        for (String pid : app.getConfig().getStartAfter()) {
            NamedApplication dependency = this._appFromPid.get(pid);
            if (dependency == null) continue;
            if (existing.contains(dependency)) {
                if (this.reportedCycles.add(app.getAppName())) {
                    String names = "";
                    for (int i = 0; i < existing.size(); ++i) {
                        names = names + existing.get(i).getAppName() + " ";
                        this.reportedCycles.add(existing.get(i).getAppName());
                    }
                    Tr.error((TraceComponent)_tc, (String)"error.startAfter.cycle", (Object[])new Object[]{names});
                }
                throw new CycleException();
            }
            existing.add(dependency);
            this.checkForCycles(dependency, existing);
            existing.removeLast();
        }
    }

    public void restoreMessage(Runnable message) {
        if (this._checkpointPhase != CheckpointPhase.INACTIVE) {
            this._restoreMessages.add(message);
        }
    }

    public synchronized void restore() {
        this._appFromName.values().forEach(a -> a.getStateMachine().resetStartTime());
        this._restoreMessages.forEach(Runnable::run);
        this._restoreMessages.clear();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class CycleException
    extends Exception {
        private static final long serialVersionUID = 3260293053577638179L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private CycleException() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CycleException.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$CycleException");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class CancelableCompletionListenerWrapper<T>
    implements CompletionListener<T> {
        private volatile CompletionListener<T> listener;
        static final long serialVersionUID = -3390723498402276818L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CancelableCompletionListenerWrapper(CompletionListener<T> listener) {
            this.listener = listener;
        }

        public void cancel() {
            this.listener = null;
        }

        public void successfulCompletion(Future<T> future, T result) {
            CompletionListener<T> l;
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)("CCLW: successfulCompletion: future " + future + ", result " + result), (Object[])new Object[0]);
            }
            if ((l = this.listener) != null) {
                l.successfulCompletion(future, result);
            }
        }

        public void failedCompletion(Future<T> future, Throwable t) {
            CompletionListener<T> l;
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)("CCLW: failedCompletion: future " + future + ", throwable " + t), (Object[])new Object[0]);
            }
            if ((l = this.listener) != null) {
                l.failedCompletion(future, t);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CancelableCompletionListenerWrapper.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$CancelableCompletionListenerWrapper");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class UpdateEpisodeState
    implements CompletionListener<Boolean> {
        private final RuntimeUpdateNotification appsStoppedNotification;
        private final RuntimeUpdateNotification appsStartingNotification;
        private final RuntimeUpdateNotification appsInstallCalledNotification;
        private final ApplicationDependency appsStopping;
        private final ApplicationDependency appsStopped;
        private final ApplicationDependency appsStarting;
        private final ApplicationDependency appsInstallCalled;
        private final ApplicationDependency rarsHaveStarted;
        private final List<ApplicationDependency> appsStoppedFutures = new ArrayList<ApplicationDependency>();
        private final Map<ApplicationDependency, ApplicationStateMachine> appsInstallCalledFutures = new HashMap<ApplicationDependency, ApplicationStateMachine>();
        private final List<ApplicationDependency> rarAppsStartedFutures = new ArrayList<ApplicationDependency>();
        private final Map<String, ApplicationDependency> appStoppedFutureMap = new HashMap<String, ApplicationDependency>();
        private Set<ApplicationRecycleContext> unregisteredContexts;
        private final AtomicInteger refCount = new AtomicInteger();
        private final AtomicReference<CancelableCompletionListenerWrapper<Boolean>> completionListener = new AtomicReference();
        static final long serialVersionUID = -3700344160384687003L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        UpdateEpisodeState() throws IllegalStateException {
            this.appsStoppedNotification = ApplicationConfigurator.this._runtimeUpdateManager.createNotification("ApplicationsStopped");
            this.appsStartingNotification = ApplicationConfigurator.this._runtimeUpdateManager.createNotification("ApplicationsStarting", true);
            this.appsInstallCalledNotification = ApplicationConfigurator.this._runtimeUpdateManager.createNotification("ApplicationsInstallCalled", true);
            if (this.appsStoppedNotification == null || this.appsStartingNotification == null || this.appsInstallCalledNotification == null) {
                throw new IllegalStateException();
            }
            this.appsStopping = ApplicationConfigurator.this.createDependency("resolves when applications are stopping");
            this.appsStopped = new ApplicationDependency(ApplicationConfigurator.this._futureMonitor, this.appsStoppedNotification.getFuture(), "resolves when applications have stopped");
            this.appsStarting = new ApplicationDependency(ApplicationConfigurator.this._futureMonitor, this.appsStartingNotification.getFuture(), "resolves when applications can start");
            this.appsInstallCalled = new ApplicationDependency(ApplicationConfigurator.this._futureMonitor, this.appsInstallCalledNotification.getFuture(), "resolves when install has been called for all applications");
            this.rarsHaveStarted = ApplicationConfigurator.this.createDependency("resolves when all resource adapters have started");
            this.appsStopping.onCompletion(new CompletionListener<Boolean>(){
                static final long serialVersionUID = -7556027969152759048L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    ArrayList<ApplicationDependency> stoppedApps;
                    ApplicationConfigurator applicationConfigurator = ApplicationConfigurator.this;
                    synchronized (applicationConfigurator) {
                        stoppedApps = new ArrayList<ApplicationDependency>(UpdateEpisodeState.this.appStoppedFutureMap.values());
                    }
                    FutureCollectionCompletionListener.newFutureCollectionCompletionListener(stoppedApps, UpdateEpisodeState.this.appsStopped);
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$UpdateEpisodeState$1");
                }
            });
            this.appsStarting.onCompletion(new CompletionListener<Boolean>(){
                static final long serialVersionUID = -7258615287673591670L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    Map appsInstallCalledCopy;
                    List<ApplicationDependency> rarAppsStarted;
                    if (result.booleanValue()) {
                        ApplicationConfigurator applicationConfigurator = ApplicationConfigurator.this;
                        synchronized (applicationConfigurator) {
                            rarAppsStarted = new ArrayList<ApplicationDependency>(UpdateEpisodeState.this.rarAppsStartedFutures);
                            UpdateEpisodeState.this.rarAppsStartedFutures.clear();
                        }
                    } else {
                        rarAppsStarted = Collections.emptyList();
                    }
                    if (result.booleanValue() && !rarAppsStarted.isEmpty()) {
                        FutureCollectionCompletionListener.newFutureCollectionCompletionListener(rarAppsStarted, UpdateEpisodeState.this.rarsHaveStarted);
                    } else {
                        UpdateEpisodeState.this.rarsHaveStarted.setResult(result);
                    }
                    if (result.booleanValue()) {
                        ApplicationConfigurator applicationConfigurator = ApplicationConfigurator.this;
                        synchronized (applicationConfigurator) {
                            appsInstallCalledCopy = new HashMap(UpdateEpisodeState.this.appsInstallCalledFutures);
                            UpdateEpisodeState.this.appsInstallCalledFutures.clear();
                        }
                    } else {
                        appsInstallCalledCopy = Collections.emptyMap();
                    }
                    if (result.booleanValue() && !appsInstallCalledCopy.isEmpty()) {
                        Iterator iAppsInstallCalled = appsInstallCalledCopy.entrySet().iterator();
                        while (iAppsInstallCalled.hasNext()) {
                            if (!((ApplicationStateMachine)iAppsInstallCalled.next().getValue()).isBlocked()) continue;
                            iAppsInstallCalled.remove();
                        }
                        if (appsInstallCalledCopy.isEmpty()) {
                            UpdateEpisodeState.this.appsInstallCalled.setResult(result);
                        } else {
                            FutureCollectionCompletionListener.newFutureCollectionCompletionListener(appsInstallCalledCopy.keySet(), UpdateEpisodeState.this.appsInstallCalled);
                        }
                    } else {
                        UpdateEpisodeState.this.appsInstallCalled.setResult(result);
                    }
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    UpdateEpisodeState.this.rarsHaveStarted.setResult(t);
                    UpdateEpisodeState.this.appsInstallCalled.setResult(t);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$UpdateEpisodeState$2");
                }
            });
        }

        public void removeRarsStartedDependency() {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Removing rar start deps", (Object[])new Object[0]);
            }
            this.rarsHaveStarted.setResult(true);
        }

        public void deactivate() {
            if (!this.appsStarting.isDone()) {
                this.appsStarting.setResult(true);
            }
        }

        public void createAppForceRestartDependency(Future<Boolean> appForceRestart, final RuntimeUpdateNotification runtimeUpdateNotification) {
            ApplicationConfigurator.this._futureMonitor.onCompletion(appForceRestart, (CompletionListener)new CompletionListener<Boolean>(){
                static final long serialVersionUID = -751577640233184959L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    if (result.booleanValue()) {
                        ApplicationConfigurator applicationConfigurator = ApplicationConfigurator.this;
                        synchronized (applicationConfigurator) {
                            UpdateEpisodeState.this.restartApps(ApplicationConfigurator.this._appFromName.values(), runtimeUpdateNotification);
                        }
                    } else {
                        UpdateEpisodeState.this.dropReference();
                    }
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    UpdateEpisodeState.this.dropReference();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$UpdateEpisodeState$3");
                }
            });
        }

        public void createSimpleDependency(Future<Boolean> future) {
            ApplicationConfigurator.this._futureMonitor.onCompletion(future, (CompletionListener)new CompletionListener<Boolean>(){
                static final long serialVersionUID = -4163899941078303709L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    UpdateEpisodeState.this.dropReference();
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    UpdateEpisodeState.this.dropReference();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$UpdateEpisodeState$4");
                }
            });
        }

        public String toString() {
            return super.toString() + "[refCount=" + this.refCount + ']';
        }

        void recycleAppContext(ApplicationRecycleContext context) {
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)("CCE: recycleAppContext: context " + context), (Object[])new Object[0]);
            }
            if (this.unregisteredContexts == null) {
                this.unregisteredContexts = new HashSet<ApplicationRecycleContext>();
            }
            this.unregisteredContexts.add(context);
            String contextApp = context.getAppName();
            Future appsStoppedFuture = context.getAppsStoppedFuture();
            if (appsStoppedFuture != null) {
                this.appsStoppedFutures.add(new ApplicationDependency(ApplicationConfigurator.this._futureMonitor, appsStoppedFuture, "resolves when the apps using resource adapter " + contextApp + " have stopped"));
            }
        }

        void dropContextReference(ApplicationRecycleContext context) {
            if (this.unregisteredContexts != null && this.unregisteredContexts.remove(context)) {
                this.dropReference();
            }
        }

        UpdateEpisodeState addReference() {
            CancelableCompletionListenerWrapper listener;
            boolean addingFirstRef;
            boolean bl = addingFirstRef = this.refCount.getAndIncrement() == 0;
            if (addingFirstRef && (listener = (CancelableCompletionListenerWrapper)this.completionListener.getAndSet(null)) != null) {
                listener.cancel();
            }
            return this;
        }

        UpdateEpisodeState dropReference() {
            boolean droppingLastRef;
            boolean bl = droppingLastRef = this.refCount.decrementAndGet() == 0;
            if (droppingLastRef) {
                ApplicationConfigurator.this.checkForCycles();
                CancelableCompletionListenerWrapper listener = this.completionListener.getAndSet(null);
                if (listener != null) {
                    listener.cancel();
                }
                this.startApplications();
            }
            return this;
        }

        void configureApp(NamedApplication app) {
            ApplicationConfig appConfig = app.getConfig();
            boolean isRARApp = "rar".equals(appConfig.getType());
            LinkedList<ApplicationDependency> appStartingFutures = new LinkedList<ApplicationDependency>();
            if (isRARApp) {
                appStartingFutures.add(ApplicationConfigurator.this._appManagerRARSupportDependency);
                appStartingFutures.add(this.appsStarting);
            } else {
                appStartingFutures.add(ApplicationConfigurator.this._appManagerReadyDependency);
                appStartingFutures.add(this.rarsHaveStarted);
            }
            LinkedList<ApplicationDependency> startAfterFutures = new LinkedList<ApplicationDependency>();
            for (String dependency : appConfig.getStartAfter()) {
                NamedApplication depApp = (NamedApplication)ApplicationConfigurator.this._appFromPid.get(dependency);
                if (depApp != null && depApp.appStateRef.get() == ApplicationState.STARTED) continue;
                ApplicationDependency startAfter = ApplicationConfigurator.this.createDependency("resolves when the app " + dependency + " has started");
                startAfterFutures.add(startAfter);
                ApplicationConfigurator.this.addStartDependency(dependency, startAfter);
            }
            String appPid = appConfig.getConfigPid();
            ApplicationDependency stoppedFuture = this.appStoppedFutureMap.get(appPid);
            if (stoppedFuture == null) {
                stoppedFuture = ApplicationConfigurator.this.createDependency("resolves when the " + appConfig.getLabel() + " has stopped");
                this.appStoppedFutureMap.put(appPid, stoppedFuture);
            }
            ApplicationDependency startingFuture = ApplicationConfigurator.this.createDependency("resolves when the " + appConfig.getLabel() + " begins starting");
            final ApplicationDependency installCalledFuture = ApplicationConfigurator.this.createDependency("resolves when the " + appConfig.getLabel() + " has called install");
            this.appsInstallCalledFutures.put(installCalledFuture, app.getStateMachine());
            final ApplicationDependency startedFuture = ApplicationConfigurator.this.createDependency("resolves when the " + appConfig.getLabel() + " has started");
            if (isRARApp) {
                this.rarAppsStartedFutures.add(startedFuture);
            }
            startingFuture.onCompletion(new CompletionListener<Boolean>(){
                static final long serialVersionUID = 8598037738903181042L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)("successfulCompletion: startingFuture, awaiting " + startedFuture), (Object[])new Object[0]);
                    }
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    startedFuture.setResult(t);
                    installCalledFuture.setResult(true);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(5.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$UpdateEpisodeState$5");
                }
            });
            installCalledFuture.onCompletion(new CompletionListener<Boolean>(){
                static final long serialVersionUID = 3215139512523450147L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)("successfulCompletion: installCalledFuture, awaiting " + startedFuture), (Object[])new Object[0]);
                    }
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    startedFuture.setResult(t);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(6.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$UpdateEpisodeState$6");
                }
            });
            app.getStateMachine().configure(appConfig, appStartingFutures, startAfterFutures, stoppedFuture, startingFuture, installCalledFuture, startedFuture);
        }

        void unsetAppHandler(Collection<NamedApplication> appsUsingHandler) {
            for (NamedApplication app : appsUsingHandler) {
                ApplicationStateMachine asm = app.getStateMachine();
                if (asm == null) continue;
                ApplicationConfig appConfig = app.getConfig();
                boolean isRARApp = "rar".equals(appConfig.getType());
                List<ApplicationDependency> appStartingFutures = isRARApp ? Arrays.asList(ApplicationConfigurator.this._appManagerRARSupportDependency, this.appsStarting) : Arrays.asList(ApplicationConfigurator.this._appManagerReadyDependency, this.rarsHaveStarted);
                String appPid = appConfig.getConfigPid();
                ApplicationDependency stoppedFuture = this.appStoppedFutureMap.get(appPid);
                if (stoppedFuture == null) {
                    stoppedFuture = ApplicationConfigurator.this.createDependency("resolves when the " + appConfig.getLabel() + " has stopped");
                    this.appStoppedFutureMap.put(appPid, stoppedFuture);
                }
                ApplicationDependency installCalledFuture = ApplicationConfigurator.this.createDependency("resolves when the " + appConfig.getLabel() + " has called install");
                this.appsInstallCalledFutures.put(installCalledFuture, app.getStateMachine());
                ApplicationDependency startedFuture = null;
                if (isRARApp) {
                    startedFuture = ApplicationConfigurator.this.createDependency("resolves when the RAR " + appConfig.getLabel() + " has started");
                    this.rarAppsStartedFutures.add(startedFuture);
                }
                asm.setAppHandler(null);
                asm.recycle(appStartingFutures, stoppedFuture, installCalledFuture, startedFuture);
            }
        }

        void restartApps(Collection<NamedApplication> apps, RuntimeUpdateNotification featureUpdatesComplete) {
            for (NamedApplication app : apps) {
                ApplicationStateMachine asm;
                if (!app.isConfigured() || (asm = app.getStateMachine()) == null) continue;
                ApplicationConfig appConfig = app.getConfig();
                boolean isRARApp = "rar".equals(appConfig.getType());
                LinkedList<ApplicationDependency> appStartingFutures = new LinkedList<ApplicationDependency>();
                ApplicationDependency featuresComplete = new ApplicationDependency(ApplicationConfigurator.this._futureMonitor, featureUpdatesComplete.getFuture(), "Resolves when feature updates are complete after AppForceRestart");
                appStartingFutures.add(featuresComplete);
                if (isRARApp) {
                    appStartingFutures.add(ApplicationConfigurator.this._appManagerRARSupportDependency);
                    appStartingFutures.add(this.appsStarting);
                } else {
                    appStartingFutures.add(ApplicationConfigurator.this._appManagerReadyDependency);
                    appStartingFutures.add(this.rarsHaveStarted);
                }
                String appPid = appConfig.getConfigPid();
                ApplicationDependency stoppedFuture = this.appStoppedFutureMap.get(appPid);
                if (stoppedFuture == null) {
                    stoppedFuture = ApplicationConfigurator.this.createDependency("resolves when the " + appConfig.getLabel() + " has stopped");
                    this.appStoppedFutureMap.put(appPid, stoppedFuture);
                }
                ApplicationDependency installCalledFuture = ApplicationConfigurator.this.createDependency("resolves when the " + appConfig.getLabel() + " has called install");
                this.appsInstallCalledFutures.put(installCalledFuture, app.getStateMachine());
                ApplicationDependency startedFuture = null;
                if (isRARApp) {
                    startedFuture = ApplicationConfigurator.this.createDependency("resolves when the RAR App" + appConfig.getLabel() + " has started");
                    this.rarAppsStartedFutures.add(startedFuture);
                }
                for (String dependency : appConfig.getStartAfter()) {
                    ApplicationDependency startAfter = ApplicationConfigurator.this.createDependency("resolves when the app " + dependency + " has started");
                    appStartingFutures.add(startAfter);
                    ApplicationConfigurator.this.addStartDependency(dependency, startAfter);
                }
                asm.recycle(appStartingFutures, stoppedFuture, installCalledFuture, startedFuture);
            }
            this.appsStopped.onCompletion(new CompletionListener<Boolean>(){
                static final long serialVersionUID = -555197544418795750L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    UpdateEpisodeState.this.dropReference();
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    UpdateEpisodeState.this.dropReference();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(7.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$UpdateEpisodeState$7");
                }
            });
            this.appsStopping.setResult(true);
        }

        void recycleApps(Collection<NamedApplication> apps) {
            for (NamedApplication app : apps) {
                ApplicationStateMachine asm;
                ApplicationConfig appConfig = app.getConfig();
                String appPid = appConfig.getConfigPid();
                ApplicationDependency stoppedFuture = this.appStoppedFutureMap.get(appPid);
                if (stoppedFuture != null || (asm = app.getStateMachine()) == null) continue;
                boolean isRARApp = "rar".equals(appConfig.getType());
                LinkedList<ApplicationDependency> appStartingFutures = new LinkedList<ApplicationDependency>();
                if (isRARApp) {
                    appStartingFutures.add(ApplicationConfigurator.this._appManagerRARSupportDependency);
                    appStartingFutures.add(this.appsStarting);
                } else {
                    appStartingFutures.add(ApplicationConfigurator.this._appManagerReadyDependency);
                    appStartingFutures.add(this.rarsHaveStarted);
                }
                stoppedFuture = ApplicationConfigurator.this.createDependency("resolves when the " + appConfig.getLabel() + " has stopped");
                this.appStoppedFutureMap.put(appPid, stoppedFuture);
                ApplicationDependency installCalledFuture = ApplicationConfigurator.this.createDependency("resolves when the " + appConfig.getLabel() + " has called install");
                this.appsInstallCalledFutures.put(installCalledFuture, app.getStateMachine());
                ApplicationDependency startedFuture = null;
                if (isRARApp) {
                    startedFuture = ApplicationConfigurator.this.createDependency("resolves when the RAR " + appConfig.getLabel() + " has started");
                    this.rarAppsStartedFutures.add(startedFuture);
                }
                for (String dependency : appConfig.getStartAfter()) {
                    ApplicationDependency startAfter = ApplicationConfigurator.this.createDependency("resolves when the app " + dependency + " has started");
                    appStartingFutures.add(startAfter);
                    ApplicationConfigurator.this.addStartDependency(dependency, startAfter);
                }
                asm.recycle(appStartingFutures, stoppedFuture, installCalledFuture, startedFuture);
            }
        }

        void startApplications() {
            CancelableCompletionListenerWrapper<Boolean> newListener = new CancelableCompletionListenerWrapper<Boolean>(this);
            CancelableCompletionListenerWrapper<Boolean> oldListener = this.completionListener.getAndSet(newListener);
            if (oldListener != null) {
                oldListener.cancel();
            }
            this.appsStopped.onCompletion(newListener);
            this.appsStopping.setResult(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void successfulCompletion(Future<Boolean> future, Boolean result) {
            if (ApplicationConfigurator.this._ctx == null) {
                return;
            }
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)("CCE: successfulCompletion: appStopped, result " + result), (Object[])new Object[0]);
            }
            ApplicationConfigurator applicationConfigurator = ApplicationConfigurator.this;
            synchronized (applicationConfigurator) {
                if (this.refCount.get() > 0) {
                    return;
                }
                CancelableCompletionListenerWrapper listener = this.completionListener.getAndSet(null);
                if (listener != null) {
                    listener.cancel();
                }
                for (ApplicationDependency appsStoppedFuture : this.appsStoppedFutures) {
                    appsStoppedFuture.setResult(true);
                }
                this.appsStoppedFutures.clear();
                this.appStoppedFutureMap.clear();
                RuntimeUpdateNotification featureUpdatesCompleted = ApplicationConfigurator.this._runtimeUpdateManager.getNotification("FeatureUpdatesCompleted");
                if (featureUpdatesCompleted != null) {
                    featureUpdatesCompleted.waitForCompletion();
                }
                ApplicationConfigurator.this.leaveEpisode();
                this.appsStarting.setResult(true);
            }
        }

        public void failedCompletion(Future<Boolean> future, Throwable t) {
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)("CCE: failedCompletion: appStopped, future " + future + ", throwable " + t), (Object[])new Object[0]);
            }
            if (t != null && t instanceof ExecutionException) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator.UpdateEpisodeState.failedCompletion", (String)"1385");
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(UpdateEpisodeState.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$UpdateEpisodeState");
        }
    }

    @Trivial
    private static class ApplicationRecycleContextState {
        ApplicationRecycleContext context;
        final Set<ApplicationRecycleComponent> components = new LinkedHashSet<ApplicationRecycleComponent>();

        private ApplicationRecycleContextState() {
        }

        public boolean isEmpty() {
            return this.context == null && this.components.isEmpty();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ApplicationTypeSupport {
        private volatile boolean supported;
        private volatile ApplicationHandler<?> appHandler;
        private Set<NamedApplication> waitingApps;
        static final long serialVersionUID = -3399332459233796417L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ApplicationTypeSupport(boolean supported) {
            this.supported = supported;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public void setSupported(boolean supported) {
            this.supported = supported;
            this.notifyWaitingApps();
        }

        public ApplicationHandler<?> getHandler() {
            return this.appHandler;
        }

        public void setHandler(ApplicationHandler<?> appHandler) {
            this.appHandler = appHandler;
            this.notifyWaitingApps();
        }

        private void notifyWaitingApps() {
            if (this.supported && this.appHandler != null && this.waitingApps != null) {
                Set<NamedApplication> apps = this.waitingApps;
                this.waitingApps = null;
                for (NamedApplication app : apps) {
                    ApplicationStateMachine asm;
                    if (app.getTypeSupport() != this || (asm = app.getStateMachine()) == null) continue;
                    asm.setAppHandler(this.appHandler);
                }
            }
        }

        public void addWaitingApp(NamedApplication app) {
            if (this.waitingApps == null) {
                this.waitingApps = new HashSet<NamedApplication>();
            }
            this.waitingApps.add(app);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ApplicationTypeSupport.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$ApplicationTypeSupport");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class NamedApplication
    implements ApplicationStateMachine.ASMHelper {
        private final String appName;
        private final String configPid;
        private final BundleContext bundleContext;
        private final NotificationBroadcasterSupport mbeanNotifier;
        private final AtomicLong sequence = new AtomicLong();
        private ApplicationConfig appConfig;
        private ApplicationStateMachine asm;
        private ApplicationTypeSupport appTypeSupport;
        private ApplicationRecycleContext appRecycleContext;
        private final AtomicReference<ApplicationState> appStateRef = new AtomicReference();
        private final ServiceReg<Application> appReg = new ServiceReg();
        private final ServiceReg<DynamicMBean> mbeanReg = new ServiceReg();
        private final AtomicReference<DynamicMBean> dynamicMBean = new AtomicReference();
        static final long serialVersionUID = -2429219244222002679L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        NamedApplication(String appName, ApplicationConfig appConfig, BundleContext bundleContext, ExecutorService executor) {
            this.appName = appName;
            this.configPid = appConfig.getConfigPid();
            this.appConfig = appConfig;
            this.bundleContext = bundleContext;
            MBeanNotificationInfo info = new MBeanNotificationInfo(new String[]{AttributeChangeNotification.class.getName()}, AttributeChangeNotification.class.getName(), "");
            MBeanNotificationInfo infoNotification = new MBeanNotificationInfo(new String[]{Notification.class.getName()}, Notification.class.getName(), "");
            this.mbeanNotifier = new NotificationBroadcasterSupport(executor, info, infoNotification);
            appConfig.setMBeanNotifier(this.mbeanNotifier);
        }

        public String getAppName() {
            return this.appName;
        }

        public String getConfigPid() {
            return this.configPid;
        }

        public ApplicationConfig getConfig() {
            return this.appConfig;
        }

        public ApplicationTypeSupport getTypeSupport() {
            return this.appTypeSupport;
        }

        public ApplicationRecycleContext getRecycleContext() {
            return this.appRecycleContext;
        }

        public ApplicationStateMachine getStateMachine() {
            return this.asm;
        }

        public boolean isConfigured() {
            return this.appStateRef.get() != null;
        }

        public void setConfig(ApplicationConfig appConfig) {
            this.appConfig = appConfig;
        }

        public void setTypeSupport(ApplicationTypeSupport appTypeSupport) {
            this.appTypeSupport = appTypeSupport;
        }

        public void setRecycleContext(ApplicationRecycleContext appRecycleContext) {
            this.appRecycleContext = appRecycleContext;
        }

        public void setStateMachine(ApplicationStateMachine asm) {
            this.asm = asm;
        }

        public void unregisterServices() {
            if (this.dynamicMBean.getAndSet(null) != null) {
                this.appReg.unregister();
                this.mbeanReg.unregister();
            }
        }

        public void describe(StringBuilder sb) {
            this.appConfig.describe(sb);
            ApplicationStateMachine asm = this.getStateMachine();
            if (asm != null) {
                asm.describe(sb);
            }
        }

        private void register(ApplicationConfig appConfig) {
            final String pid = appConfig.getConfigPid();
            final Application appService = new Application(){
                static final long serialVersionUID = 5885634736619198490L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Future<Boolean> start() {
                    return asm.start();
                }

                @Override
                public Future<Boolean> stop() {
                    return asm.stop();
                }

                @Override
                public void restart() {
                    asm.restart();
                }

                @Override
                public ApplicationState getState() {
                    return (ApplicationState)((Object)appStateRef.get());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$NamedApplication$1");
                }
            };
            Hashtable<String, Object> serviceProperties = appConfig.getServiceProperties();
            this.appReg.setProperties(serviceProperties);
            this.appReg.setProperty("application.state", (Object)this.appStateRef.get());
            this.appReg.register(this.bundleContext, Application.class, appService);
            ApplicationMBean appMBean = new ApplicationMBean(){
                static final long serialVersionUID = -8440793992168151614L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String getState() {
                    return appService.getState().toString();
                }

                @Override
                public String getPid() {
                    return pid;
                }

                @Override
                public void start() {
                    appService.start();
                }

                @Override
                public void stop() {
                    appService.stop();
                }

                @Override
                public void restart() {
                    appService.restart();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$NamedApplication$2");
                }
            };
            StandardEmitterMBean mbean = new StandardEmitterMBean(appMBean, ApplicationMBean.class, (NotificationEmitter)this.mbeanNotifier);
            this.mbeanReg.setProperties(serviceProperties);
            this.mbeanReg.setProperty("application.state", (Object)this.appStateRef.get());
            if (this.mbeanReg.setProperty("jmx.objectname", appConfig.getMBeanName())) {
                this.mbeanReg.unregister();
            }
            this.mbeanReg.register(this.bundleContext, DynamicMBean.class, mbean);
            this.dynamicMBean.set(mbean);
        }

        @Override
        public void switchApplicationState(ApplicationConfig appConfig, ApplicationState newAppState) {
            ApplicationState oldAppState;
            if (this.appStateRef.compareAndSet(null, ApplicationState.INSTALLED) && appConfig != null) {
                this.register(appConfig);
            }
            if ((oldAppState = this.appStateRef.getAndSet(newAppState)) != newAppState) {
                this.appReg.setProperty("application.state", (Object)newAppState);
                this.mbeanReg.setProperty("application.state", (Object)newAppState);
                String mbeanName = appConfig.getMBeanName();
                this.mbeanNotifier.sendNotification(new AttributeChangeNotification(mbeanName, this.sequence.incrementAndGet(), System.currentTimeMillis(), "", "State", "java.lang.String", oldAppState.toString(), newAppState.toString()));
                this.mbeanNotifier.sendNotification(new AttributeChangeNotification(mbeanName, this.sequence.incrementAndGet(), System.currentTimeMillis(), "", "state", "java.lang.String", oldAppState.toString(), newAppState.toString()));
            }
        }

        @Override
        public boolean appTypeSupported() {
            return this.appTypeSupport != null && this.appTypeSupport.isSupported();
        }

        @Override
        public void notifyAppStarted(String pid) {
            ApplicationStateCoordinator.updateStartingAppStatus(pid, ApplicationStateCoordinator.AppStatus.STARTED);
        }

        @Override
        public void notifyAppFailed(String pid) {
            ApplicationStateCoordinator.updateStartingAppStatus(pid, ApplicationStateCoordinator.AppStatus.FAILED);
            ApplicationStateCoordinator.updateStoppingAppStatus(pid, ApplicationStateCoordinator.AppStatus.FAILED);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NamedApplication.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.ApplicationConfigurator$NamedApplication");
        }
    }
}

