/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.custom.jdbc.impl;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLNonTransactionalDataSource;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRecoverableUnitImpl;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRecoverableUnitSectionImpl;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRetriableLog;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRetry;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.CustomLogProperties;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.HeartbeatLog;
import com.ibm.ws.recoverylog.spi.HeartbeatLogManager;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorCallback;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.MultiScopeLog;
import com.ibm.ws.recoverylog.spi.PeerLostLogOwnershipException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionExistsException;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.utils.RecoverableUnitIdTable;
import jakarta.resource.spi.ResourceAllocationException;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;

public class SQLMultiScopeRecoveryLog
implements LogCursorCallback,
MultiScopeLog,
HeartbeatLog,
SQLRetriableLog {
    private static final TraceComponent tc = Tr.register(SQLMultiScopeRecoveryLog.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private final RecoveryAgent _recoveryAgent;
    private final String _clientName;
    private final int _clientVersion;
    private final String _logName;
    private final int _logIdentifier;
    private final String _logIdentifierString;
    private final String _serverName;
    private final Properties _internalLogProperties;
    private volatile boolean _isOracle;
    private volatile boolean _isPostgreSQL;
    private volatile boolean _isDB2;
    private volatile boolean _isSQLServer;
    private volatile boolean _isDerby;
    private volatile boolean _isNonStandard;
    private boolean isolationFailureReported;
    private HashMap<Long, SQLRecoverableUnitImpl> _recoverableUnits;
    private int _closesRequired;
    private final CustomLogProperties _customLogProperties;
    private String _dsName;
    private boolean _failed;
    private RecoverableUnitIdTable _recUnitIdTable = new RecoverableUnitIdTable();
    private final String _traceId;
    private final boolean _bypassContainmentCheck;
    private static final String _recoveryTableName = "WAS_";
    private static final String _recoveryIndexName = "IXWS";
    private String _recoveryTableNameSuffix = "";
    final FailureScope _failureScope;
    private final boolean _isHomeServer;
    private volatile boolean _peerServerLostLogOwnership;
    private static final String genericTableCreatePreString = "CREATE TABLE ";
    private static final String genericTableDropPreString = "DROP TABLE ";
    private static final String genericTablePostString = "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID BIGINT, RUSECTION_ID BIGINT, RUSECTION_DATA_INDEX SMALLINT, DATA LONG VARCHAR FOR BIT DATA) ";
    private static final String db2TablePostString = "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID BIGINT, RUSECTION_ID BIGINT, RUSECTION_DATA_INDEX SMALLINT, DATA BLOB) ";
    private static final String oracleTablePostString = "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID NUMBER(19), RUSECTION_ID NUMBER(19), RUSECTION_DATA_INDEX SMALLINT, DATA BLOB) ";
    private static final String postgreSQLTablePostString = "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID BIGINT, RUSECTION_ID BIGINT, RUSECTION_DATA_INDEX SMALLINT, DATA BYTEA) ";
    private static final String sqlServerTablePostString = "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID BIGINT, RUSECTION_ID BIGINT, RUSECTION_DATA_INDEX SMALLINT, DATA VARBINARY(MAX)) ";
    private static final String indexPreString = "CREATE INDEX ";
    private static final String indexPostString = "( \"RU_ID\" ASC, \"SERVICE_ID\" ASC, \"SERVER_NAME\" ASC) ";
    private static final String postgreSQLIndexPostString = "( RU_ID ASC, SERVICE_ID ASC, SERVER_NAME ASC) ";
    private DataSource _theDS;
    private Connection _reservedConn;
    private static final Object _CreateTableLock = new Object();
    private static final Object _DBAccessIntentLock = new Object();
    private final ReentrantLock _throttleLock = new ReentrantLock(true);
    private final Condition _throttleCleared = this._throttleLock.newCondition();
    private int _throttleWaiters;
    private static final int _waiterThreshold;
    private boolean _throttleEnabled;
    private final List<ruForReplay> _cachedInsertsA = new ArrayList<ruForReplay>();
    private final List<ruForReplay> _cachedUpdatesA = new ArrayList<ruForReplay>();
    private final List<ruForReplay> _cachedRemovesA = new ArrayList<ruForReplay>();
    private final List<ruForReplay> _cachedInsertsB = new ArrayList<ruForReplay>();
    private final List<ruForReplay> _cachedUpdatesB = new ArrayList<ruForReplay>();
    private final List<ruForReplay> _cachedRemovesB = new ArrayList<ruForReplay>();
    private boolean _writeToCacheA = true;
    private boolean _sqlTransientErrorHandlingEnabled = true;
    private boolean _serverStopping;
    volatile SQLMultiScopeRecoveryLog _associatedLog;
    volatile boolean _failAssociatedLog;
    private final String _currentProcessServerName;
    private static volatile boolean _useNewLockingScheme;
    private static int _logGoneStaleTime;
    private int _peerLockTimeBetweenHeartbeats = 5;
    private static final long _reservedConnectionActiveSectionIDSet = 255L;
    private static final long _reservedConnectionActiveSectionIDUnset = 1L;

    public SQLMultiScopeRecoveryLog(CustomLogProperties logProperties, RecoveryAgent recoveryAgent, FailureScope fs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SQLMultiScopeRecoveryLog", (Object[])new Object[]{logProperties, recoveryAgent, fs, this});
        }
        this._customLogProperties = logProperties;
        this._recoveryAgent = recoveryAgent;
        this._logName = this._customLogProperties.logName();
        this._logIdentifier = this._customLogProperties.logIdentifier();
        this._logIdentifierString = this.logTypeFromInteger(this._logIdentifier);
        this._clientName = recoveryAgent.clientName();
        this._clientVersion = recoveryAgent.clientVersion();
        this._serverName = fs.serverName();
        this._failureScope = fs;
        this._isHomeServer = Configuration.localFailureScope().equals(this._failureScope);
        this._internalLogProperties = this._customLogProperties.properties();
        this._currentProcessServerName = Configuration.fqServerName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Recovery log belongs to server " + this._serverName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Recovery log belongs to home server " + this._isHomeServer), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Recovery log created by client service " + this._clientName + " at version " + this._clientVersion), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Recovery log name is " + this._logName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Recovery log identifier is " + this._logIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Recovery log internal properties are " + this._internalLogProperties), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"FIS 114950", (Object[])new Object[0]);
        }
        this._traceId = "SQLMultiScopeRecoveryLog:serverName=" + this._serverName + ":clientName=" + this._clientName + ":clientVersion=" + this._clientVersion + ":logName=" + this._logName + ":logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        boolean bl = this._bypassContainmentCheck = !Configuration.HAEnabled();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_bypassContainmentCheck = " + this._bypassContainmentCheck), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SQLMultiScopeRecoveryLog", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void openLog() throws LogCorruptedException, LogAllocationException, InternalLogException {
        Object object = _DBAccessIntentLock;
        synchronized (object) {
            SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
            synchronized (sQLMultiScopeRecoveryLog) {
                block76: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"openLog", (Object[])new Object[]{this});
                    }
                    if (this.failed()) {
                        if (this._peerServerLostLogOwnership) {
                            this._peerServerLostLogOwnership = false;
                            this._failed = false;
                        } else {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                            }
                            throw new InternalLogException(null);
                        }
                    }
                    if (this._serverStopping) {
                        InternalLogException ile = this.reportOperationAttemptWhenStopping("open");
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                        }
                        throw ile;
                    }
                    Connection conn = null;
                    if (this._closesRequired == 0) {
                        if (this._recoverableUnits != null) {
                            this._recoverableUnits.clear();
                        }
                        this._recoverableUnits = new HashMap();
                        this._cachedInsertsA.clear();
                        this._cachedInsertsB.clear();
                        this._cachedUpdatesA.clear();
                        this._cachedUpdatesB.clear();
                        this._cachedRemovesA.clear();
                        this._cachedRemovesB.clear();
                        this._reservedConn = null;
                        this._recUnitIdTable = new RecoverableUnitIdTable();
                        this._throttleWaiters = 0;
                        this._throttleEnabled = false;
                        Throwable nonTransientException = null;
                        try {
                            SQLException currentSqlEx;
                            boolean openSuccess;
                            int initialIsolation;
                            block78: {
                                block77: {
                                    block75: {
                                        initialIsolation = 4;
                                        openSuccess = false;
                                        currentSqlEx = null;
                                        if (this._dsName == null) {
                                            this.configureConnectionParameters();
                                            conn = this.getFirstConnection();
                                        } else {
                                            conn = this.getConnection();
                                        }
                                        if (conn == null) {
                                            if (tc.isEntryEnabled()) {
                                                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"Null connection InternalLogException");
                                            }
                                            throw new InternalLogException("Failed to get JDBC Connection", null);
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE and RR isolation on the connection", (Object[])new Object[0]);
                                        }
                                        initialIsolation = this.prepareConnectionForBatch(conn);
                                        this.assertDBTableExists(conn, initialIsolation);
                                        this.updateHADBLock(conn);
                                        this.recover(conn);
                                        conn.commit();
                                        openSuccess = true;
                                        if (!openSuccess) break block75;
                                        try {
                                            this.closeConnectionAfterBatch(conn, initialIsolation);
                                        }
                                        catch (Throwable exc) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)"Close Failed after initial success", (Object[])new Object[]{exc});
                                            }
                                            openSuccess = false;
                                        }
                                    }
                                    if (openSuccess) break block76;
                                    try {
                                        if (conn != null) {
                                            conn.rollback();
                                        }
                                    }
                                    catch (Throwable exc) {
                                        if (!tc.isDebugEnabled()) break block77;
                                        Tr.debug((TraceComponent)tc, (String)"Rolling back on NOT openSuccess", (Object[])new Object[]{exc});
                                    }
                                }
                                try {
                                    if (conn != null) {
                                        this.closeConnectionAfterBatch(conn, initialIsolation);
                                    }
                                }
                                catch (Throwable exc) {
                                    if (!tc.isDebugEnabled()) break block78;
                                    Tr.debug((TraceComponent)tc, (String)"Close Failed on NOT sopenSuccess", (Object[])new Object[]{exc});
                                }
                            }
                            if (this._serverStopping) {
                                InternalLogException ile = this.reportOperationAttemptWhenStopping("open");
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                                }
                                throw ile;
                            }
                            boolean failAndReport = true;
                            nonTransientException = currentSqlEx;
                            OpenLogRetry openLogRetry = new OpenLogRetry();
                            openLogRetry.setNonTransientException(currentSqlEx);
                            if (this._sqlTransientErrorHandlingEnabled && (failAndReport = openLogRetry.retryAfterSQLException(this, currentSqlEx))) {
                                nonTransientException = openLogRetry.getNonTransientException();
                            }
                            if (failAndReport) {
                                Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot recover from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
                                this.markFailed(nonTransientException);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                                }
                                throw new InternalLogException(nonTransientException);
                            }
                            Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName), (Object[])new Object[0]);
                            break block76;
                            catch (SQLException sqlex) {
                                block81: {
                                    block80: {
                                        block79: {
                                            try {
                                                Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName + " SQLException: " + sqlex), (Object[])new Object[0]);
                                                currentSqlEx = sqlex;
                                                if (!openSuccess) break block79;
                                            }
                                            catch (Throwable throwable) {
                                                if (openSuccess) {
                                                    try {
                                                        this.closeConnectionAfterBatch(conn, initialIsolation);
                                                    }
                                                    catch (Throwable exc) {
                                                        if (tc.isDebugEnabled()) {
                                                            Tr.debug((TraceComponent)tc, (String)"Close Failed after initial success", (Object[])new Object[]{exc});
                                                        }
                                                        openSuccess = false;
                                                    }
                                                }
                                                if (!openSuccess) {
                                                    block83: {
                                                        block82: {
                                                            try {
                                                                if (conn != null) {
                                                                    conn.rollback();
                                                                }
                                                            }
                                                            catch (Throwable exc) {
                                                                if (!tc.isDebugEnabled()) break block82;
                                                                Tr.debug((TraceComponent)tc, (String)"Rolling back on NOT openSuccess", (Object[])new Object[]{exc});
                                                            }
                                                        }
                                                        try {
                                                            if (conn != null) {
                                                                this.closeConnectionAfterBatch(conn, initialIsolation);
                                                            }
                                                        }
                                                        catch (Throwable exc) {
                                                            if (!tc.isDebugEnabled()) break block83;
                                                            Tr.debug((TraceComponent)tc, (String)"Close Failed on NOT sopenSuccess", (Object[])new Object[]{exc});
                                                        }
                                                    }
                                                    if (this._serverStopping) {
                                                        InternalLogException ile = this.reportOperationAttemptWhenStopping("open");
                                                        if (tc.isEntryEnabled()) {
                                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                                                        }
                                                        throw ile;
                                                    }
                                                    boolean failAndReport2 = true;
                                                    nonTransientException = currentSqlEx;
                                                    OpenLogRetry openLogRetry2 = new OpenLogRetry();
                                                    openLogRetry2.setNonTransientException(currentSqlEx);
                                                    if (this._sqlTransientErrorHandlingEnabled && (failAndReport2 = openLogRetry2.retryAfterSQLException(this, currentSqlEx))) {
                                                        nonTransientException = openLogRetry2.getNonTransientException();
                                                    }
                                                    if (failAndReport2) {
                                                        Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot recover from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
                                                        this.markFailed(nonTransientException);
                                                        if (tc.isEntryEnabled()) {
                                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                                                        }
                                                        throw new InternalLogException(nonTransientException);
                                                    }
                                                    Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName), (Object[])new Object[0]);
                                                }
                                                throw throwable;
                                            }
                                            try {
                                                this.closeConnectionAfterBatch(conn, initialIsolation);
                                            }
                                            catch (Throwable exc) {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)"Close Failed after initial success", (Object[])new Object[]{exc});
                                                }
                                                openSuccess = false;
                                            }
                                        }
                                        if (openSuccess) break block76;
                                        try {
                                            if (conn != null) {
                                                conn.rollback();
                                            }
                                        }
                                        catch (Throwable exc) {
                                            if (!tc.isDebugEnabled()) break block80;
                                            Tr.debug((TraceComponent)tc, (String)"Rolling back on NOT openSuccess", (Object[])new Object[]{exc});
                                        }
                                    }
                                    try {
                                        if (conn != null) {
                                            this.closeConnectionAfterBatch(conn, initialIsolation);
                                        }
                                    }
                                    catch (Throwable exc) {
                                        if (!tc.isDebugEnabled()) break block81;
                                        Tr.debug((TraceComponent)tc, (String)"Close Failed on NOT sopenSuccess", (Object[])new Object[]{exc});
                                    }
                                }
                                if (this._serverStopping) {
                                    InternalLogException ile = this.reportOperationAttemptWhenStopping("open");
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                                    }
                                    throw ile;
                                }
                                failAndReport = true;
                                nonTransientException = currentSqlEx;
                                openLogRetry = new OpenLogRetry();
                                openLogRetry.setNonTransientException(currentSqlEx);
                                if (this._sqlTransientErrorHandlingEnabled && (failAndReport = openLogRetry.retryAfterSQLException(this, currentSqlEx))) {
                                    nonTransientException = openLogRetry.getNonTransientException();
                                }
                                if (failAndReport) {
                                    Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot recover from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
                                    this.markFailed(nonTransientException);
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                                    }
                                    throw new InternalLogException(nonTransientException);
                                }
                                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName), (Object[])new Object[0]);
                            }
                        }
                        catch (Throwable exc) {
                            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.openLog", (String)"500", (Object)this);
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Unexpected exception caught in openLog", (Object[])new Object[]{exc});
                            }
                            this.markFailed(exc);
                            this._recoverableUnits = null;
                            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)(" " + ste), (Object[])new Object[0]);
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                            }
                            throw new InternalLogException(exc);
                        }
                    }
                }
                ++this._closesRequired;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired), (Object[])new Object[0]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"openLog");
        }
    }

    private void configureConnectionParameters() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"configureConnectionParameters", (Object[])new Object[0]);
        }
        String fullLogDirectory = this._internalLogProperties.getProperty("LOG_DIRECTORY");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("fullLogDirectory = " + fullLogDirectory), (Object[])new Object[0]);
        }
        if (ConfigurationProviderManager.getConfigurationProvider().enableLogRetries()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set the logRetriesEnabled flag to true", (Object[])new Object[0]);
            }
            SQLRetry.setLogRetriesEnabled(true);
        }
        StringTokenizer st = new StringTokenizer(fullLogDirectory, "?");
        String cname = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cname = " + cname), (Object[])new Object[0]);
        }
        Properties dbStringProps = new Properties();
        String dbPropertiesString = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbPropertiesString = " + dbPropertiesString), (Object[])new Object[0]);
        }
        dbStringProps.load(new StringReader(dbPropertiesString.replace(',', '\n')));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbStringProps = " + dbStringProps), (Object[])new Object[0]);
        }
        this._dsName = dbStringProps.getProperty("datasource");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Extracted Data Source name = " + this._dsName), (Object[])new Object[0]);
        }
        if (this._dsName != null && !this._dsName.trim().isEmpty()) {
            this._dsName = this._dsName.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Trimmed Data Source name to = " + this._dsName), (Object[])new Object[0]);
            }
        }
        String tableSuffix = dbStringProps.getProperty("tablesuffix");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Extracted Table Suffix = " + tableSuffix), (Object[])new Object[0]);
        }
        if (tableSuffix != null && !tableSuffix.equals("")) {
            this._recoveryTableNameSuffix = tableSuffix;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Full RecoveryTableName = WAS_" + this._recoveryTableNameSuffix), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configureConnectionParameters");
        }
    }

    private Connection getFirstConnection() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFirstConnection", (Object[])new Object[0]);
        }
        Connection conn = null;
        SQLNonTransactionalDataSource sqlNonTranDS = new SQLNonTransactionalDataSource(this._dsName, this._customLogProperties);
        this._theDS = sqlNonTranDS.getDataSource();
        if (this._theDS != null) {
            conn = this._theDS.getConnection();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got connection: " + conn), (Object[])new Object[0]);
            }
            DatabaseMetaData mdata = conn.getMetaData();
            String dbName = mdata.getDatabaseProductName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Working with database: " + dbName), (Object[])new Object[0]);
            }
            if (dbName.toLowerCase().contains("oracle")) {
                this._isOracle = true;
            } else if (dbName.toLowerCase().contains("db2")) {
                this._isDB2 = true;
            } else if (dbName.toLowerCase().contains("postgresql")) {
                this._isPostgreSQL = true;
            } else if (dbName.toLowerCase().contains("microsoft sql")) {
                this._isSQLServer = true;
            } else if (dbName.toLowerCase().contains("derby")) {
                this._isDerby = true;
            } else {
                this._isNonStandard = true;
                if (!SQLRetry.isLogRetriesEnabled()) {
                    this._sqlTransientErrorHandlingEnabled = false;
                }
            }
            String dbVersion = mdata.getDatabaseProductVersion();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("You are now connected to " + dbName + ", version " + dbVersion), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFirstConnection", (Object)conn);
        }
        return conn;
    }

    @Override
    public Connection getConnection() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object[])new Object[0]);
        }
        Connection conn = null;
        boolean lookupDS = false;
        if (ConfigurationProviderManager.getConfigurationProvider().enableLogRetries()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set the logRetriesEnabled flag to true", (Object[])new Object[0]);
            }
            SQLRetry.setLogRetriesEnabled(true);
            this._sqlTransientErrorHandlingEnabled = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set the logRetriesEnabled flag to false", (Object[])new Object[0]);
            }
            if (SQLRetry.isLogRetriesEnabled() && this._isNonStandard) {
                this._sqlTransientErrorHandlingEnabled = false;
            }
            SQLRetry.setLogRetriesEnabled(false);
        }
        try {
            if (this._theDS != null) {
                conn = this._theDS.getConnection();
            } else {
                lookupDS = true;
            }
        }
        catch (SQLException sqlex) {
            Throwable cause = sqlex.getCause();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught SQLException with cause: " + cause), (Object[])new Object[0]);
            }
            if (cause instanceof ResourceAllocationException) {
                lookupDS = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)"SQLException");
            }
            throw sqlex;
        }
        if (lookupDS) {
            SQLNonTransactionalDataSource sqlNonTranDS = new SQLNonTransactionalDataSource(this._dsName, this._customLogProperties);
            try {
                this._theDS = sqlNonTranDS.getDataSource();
                conn = this._theDS.getConnection();
                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from ResourceAllocationException in SQL RecoveryLog " + this._logName + " for server " + this._serverName), (Object[])new Object[0]);
            }
            catch (Throwable exc) {
                SQLException newsqlex = exc instanceof SQLException ? (SQLException)exc : new SQLException(exc);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)"new SQLException");
                }
                throw newsqlex;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)conn);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover(Connection conn) throws SQLException, RecoverableUnitSectionExistsException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object[])new Object[]{conn});
        }
        Statement recoveryStmt = null;
        ResultSet recoveryRS = null;
        try {
            recoveryStmt = conn.createStatement();
            String queryString = "SELECT RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE SERVER_NAME='" + this._serverName + "' AND SERVICE_ID=" + this._recoveryAgent.clientIdentifier();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Retrieve all rows from table using - " + queryString), (Object[])new Object[0]);
            }
            recoveryRS = recoveryStmt.executeQuery(queryString);
            while (recoveryRS.next()) {
                long ruId = recoveryRS.getLong(1);
                if (ruId != -1L) {
                    SQLRecoverableUnitSectionImpl sect;
                    SQLRecoverableUnitImpl ru = this._recoverableUnits.get(ruId);
                    if (ru == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Creating ru with id: " + ruId), (Object[])new Object[0]);
                        }
                        ru = new SQLRecoverableUnitImpl(this, ruId, this._failureScope, true);
                    }
                    long sectId = recoveryRS.getLong(2);
                    int index = recoveryRS.getInt(3);
                    byte[] data = recoveryRS.getBytes(4);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read ruId: " + ruId), (Object[])new Object[0]);
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read sectionId: " + sectId), (Object[])new Object[0]);
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read item: " + index), (Object[])new Object[0]);
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read data: " + RLSUtils.toHexString((byte[])data, (int)32)), (Object[])new Object[0]);
                    }
                    if ((sect = (SQLRecoverableUnitSectionImpl)ru.lookupSection((int)sectId)) == null) {
                        sect = (SQLRecoverableUnitSectionImpl)ru.createSection((int)sectId, index == 0);
                    }
                    sect.addData(index, data);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Bypass locking row with id: " + ruId), (Object[])new Object[0]);
            }
        }
        finally {
            if (recoveryRS != null && !recoveryRS.isClosed()) {
                recoveryRS.close();
            }
            if (recoveryStmt != null && !recoveryStmt.isClosed()) {
                recoveryStmt.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover");
        }
    }

    public byte[] serviceData() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serviceData", (Object[])new Object[]{this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serviceData", null);
        }
        return null;
    }

    public synchronized void recoveryComplete() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object[])new Object[]{this});
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"InternalLogException");
            }
            throw this.getFailureException();
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    public synchronized void recoveryComplete(byte[] serviceData) throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object[])new Object[]{RLSUtils.toHexString((byte[])serviceData, (int)32), this});
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"InternalLogException");
            }
            throw this.getFailureException();
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    public void closeLog(byte[] serviceData) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLog", (Object[])new Object[]{RLSUtils.toHexString((byte[])serviceData, (int)32), this});
        }
        this.closeLog();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLog() throws InternalLogException {
        boolean successfulSQL = false;
        boolean successfulConnection = true;
        Object object = _DBAccessIntentLock;
        synchronized (object) {
            SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
            synchronized (sQLMultiScopeRecoveryLog) {
                block42: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"closeLog", (Object[])new Object[]{this._reservedConn, this._closesRequired, this});
                    }
                    try {
                        if (this._closesRequired > 0) {
                            boolean initialReservedConnection = false;
                            try {
                                if (this._reservedConn == null) {
                                    if (this._serverStopping) {
                                        Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Server stopping but no reserved connection when closing SQL RecoveryLog " + this._logName + " for server " + this._serverName), (Object[])new Object[0]);
                                        InternalLogException ile = new InternalLogException();
                                        throw ile;
                                    }
                                } else {
                                    initialReservedConnection = true;
                                    if (this._reservedConn.isClosed()) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Reserved Connection is already closed", (Object[])new Object[0]);
                                        }
                                        InternalLogException ile = new InternalLogException();
                                        this.markFailed(ile);
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)("closeLog called when _closesRequired is " + this._closesRequired), (Object)((Object)ile));
                                        }
                                        throw ile;
                                    }
                                }
                                if (successfulConnection) {
                                    this.forceSections(false);
                                    successfulSQL = true;
                                    --this._closesRequired;
                                }
                            }
                            catch (PeerLostLogOwnershipException ple) {
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)((Object)ple));
                                }
                                throw ple;
                            }
                            catch (InternalLogException exc) {
                                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.closeLog", (String)"948", (Object)this);
                                this.markFailed(exc);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)((Object)exc));
                                }
                                throw exc;
                            }
                            catch (Throwable exc) {
                                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.closeLog", (String)"955", (Object)this);
                                this.markFailed(exc);
                                for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug((TraceComponent)tc, (String)(" " + ste), (Object[])new Object[0]);
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)"InternalLogException");
                                }
                                throw new InternalLogException(exc);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired), (Object[])new Object[0]);
                            }
                            try {
                                if (this._closesRequired <= 0) {
                                    if (initialReservedConnection && !_useNewLockingScheme) {
                                        this.unlatchHADBLock();
                                    }
                                    this._recoverableUnits = null;
                                    this._closesRequired = 0;
                                }
                                break block42;
                            }
                            catch (Throwable exc) {
                                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.closeLog", (String)"550", (Object)this);
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Unexpected exception caught in closeLog while unsetting the latch", (Object[])new Object[]{exc});
                                }
                                break block42;
                            }
                        }
                        InternalLogException ile = new InternalLogException();
                        this.markFailed(ile);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("closeLog called when _closesRequired is " + this._closesRequired), (Object)((Object)ile));
                        }
                        throw ile;
                    }
                    finally {
                        if (!successfulSQL) {
                            if (this._closesRequired > 0) {
                                --this._closesRequired;
                            }
                            if (this._reservedConn != null) {
                                try {
                                    this._reservedConn.close();
                                }
                                catch (Exception exception) {}
                            }
                            this._reservedConn = null;
                            this._recoverableUnits = null;
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired), (Object[])new Object[0]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLogImmediate() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLogImmediate", (Object[])new Object[]{this});
        }
        Object object = _DBAccessIntentLock;
        synchronized (object) {
            SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
            synchronized (sQLMultiScopeRecoveryLog) {
                this._closesRequired = 0;
                if (this._reservedConn != null) {
                    try {
                        this._reservedConn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this._reservedConn = null;
                this._recoverableUnits = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLogImmediate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"delete", (Object[])new Object[]{this._closesRequired, this});
        }
        boolean succeeded = false;
        Object object = _DBAccessIntentLock;
        synchronized (object) {
            SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
            synchronized (sQLMultiScopeRecoveryLog) {
                block13: {
                    if (this.failed() || this._closesRequired > 0) {
                        if (tc.isDebugEnabled()) {
                            Exception e = new Exception();
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.delete", (String)"1277", (Object)this);
                            Tr.debug((TraceComponent)tc, (String)("do not delete logs as failed state is " + this.failed() + " or closesRequired is " + this._closesRequired), (Object[])new Object[0]);
                        }
                    } else {
                        try {
                            Connection conn = this.getConnection();
                            this.dropDBTable(conn);
                            succeeded = true;
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.delete", (String)"1286", (Object)this);
                            if (!tc.isDebugEnabled()) break block13;
                            Tr.debug((TraceComponent)tc, (String)"delete caught exception ", (Object[])new Object[]{e});
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delete", (Object)succeeded);
        }
        return succeeded;
    }

    public synchronized RecoverableUnit createRecoverableUnit(FailureScope failureScope) throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoverableUnit", (Object[])new Object[]{failureScope, this});
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"InternalLogException");
            }
            throw this.getFailureException();
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        SQLRecoverableUnitImpl recoverableUnit = null;
        long identity = this._recUnitIdTable.nextId((Object)this);
        recoverableUnit = new SQLRecoverableUnitImpl(this, identity, failureScope);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("SQLMultiScopeRecoveryLog '" + this._logName + "' created a new RecoverableUnit with id '" + identity + "'"), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)recoverableUnit);
        }
        return recoverableUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecoverableUnit(long identity) throws LogClosedException, InvalidRecoverableUnitException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoverableUnit", (Object[])new Object[]{identity, this});
        }
        this._throttleLock.lock();
        try {
            while (this._throttleEnabled) {
                this._throttleCleared.awaitUninterruptibly();
            }
        }
        finally {
            this._throttleLock.unlock();
        }
        SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
        synchronized (sQLMultiScopeRecoveryLog) {
            if (this.failed()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"InternalLogException");
                }
                throw this.getFailureException();
            }
            if (this._closesRequired == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"LogClosedException");
                }
                throw new LogClosedException(null);
            }
            SQLRecoverableUnitImpl recoverableUnit = null;
            recoverableUnit = this.removeRecoverableUnitMapEntries(identity);
            if (recoverableUnit == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"InvalidRecoverableUnitException");
                }
                throw new InvalidRecoverableUnitException(null);
            }
            try {
                recoverableUnit.remove();
                ruForReplay deleteRU = new ruForReplay(identity, 0L, 0, null);
                if (this._writeToCacheA) {
                    this._cachedRemovesA.add(deleteRU);
                } else {
                    this._cachedRemovesB.add(deleteRU);
                }
            }
            catch (InternalLogException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removeRecoverableUnit", (String)"1182", (Object)this);
                this.markFailed(exc);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)((Object)exc));
                }
                throw exc;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removeRecoverableUnit", (String)"1186", (Object)this);
                this.markFailed(e);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)e);
                }
                throw new InternalLogException((Throwable)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit");
        }
    }

    public synchronized LogCursor recoverableUnits(FailureScope failureScope) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverableUnits", (Object[])new Object[]{failureScope, this});
        }
        if (this._closesRequired <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        ArrayList<SQLRecoverableUnitImpl> recoverableUnits = new ArrayList<SQLRecoverableUnitImpl>();
        for (SQLRecoverableUnitImpl recoverableUnit : this._recoverableUnits.values()) {
            if (!this._bypassContainmentCheck && !recoverableUnit.failureScope().isContainedBy(failureScope)) continue;
            recoverableUnits.add(recoverableUnit);
        }
        LogCursorImpl cursor = new LogCursorImpl((Lock)null, recoverableUnits, true, (LogCursorCallback)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)cursor);
        }
        return cursor;
    }

    public LogCursor recoverableUnits() throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverableUnits", (Object[])new Object[]{this});
        }
        LogCursor cursor = this.recoverableUnits(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)cursor);
        }
        return cursor;
    }

    public synchronized RecoverableUnit lookupRecoverableUnit(long identity) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object[])new Object[]{identity, this});
        }
        SQLRecoverableUnitImpl runit = this.getRecoverableUnit(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object)runit);
        }
        return runit;
    }

    public RecoverableUnit createRecoverableUnit() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoverableUnit", (Object[])new Object[]{this});
        }
        RecoverableUnit runit = this.createRecoverableUnit(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)runit);
        }
        return runit;
    }

    public LogProperties logProperties() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"logProperties", (Object[])new Object[]{this._customLogProperties});
        }
        return this._customLogProperties;
    }

    public void keypoint() throws InternalLogException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"keypoint", (Object[])new Object[]{this});
        }
        this.forceSections(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeSections(Iterator<SQLRecoverableUnitSectionImpl> sections) throws InternalLogException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"writeSections", (Object[])new Object[]{sections});
        }
        if (sections != null) {
            this._throttleLock.lock();
            try {
                while (this._throttleEnabled) {
                    this._throttleCleared.awaitUninterruptibly();
                }
            }
            finally {
                this._throttleLock.unlock();
            }
            SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
            synchronized (sQLMultiScopeRecoveryLog) {
                while (sections.hasNext()) {
                    SQLRecoverableUnitSectionImpl section = sections.next();
                    section.write(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRUSection(long ruId, long sectionId, int index, byte[] data, boolean throttle) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeRUSection ", (Object[])new Object[]{ruId, sectionId, index, data, throttle, this});
        }
        if (throttle) {
            this._throttleLock.lock();
            try {
                while (this._throttleEnabled) {
                    this._throttleCleared.awaitUninterruptibly();
                }
            }
            finally {
                this._throttleLock.unlock();
            }
        }
        SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
        synchronized (sQLMultiScopeRecoveryLog) {
            if (this.failed()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeRUSection", (Object)"InternalLogException");
                }
                throw this.getFailureException();
            }
            if (this._closesRequired <= 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeRUSection", (Object)this);
                }
                throw new InternalLogException((Throwable)new LogClosedException());
            }
            try {
                this.internalWriteRUSection(ruId, sectionId, index, data, false);
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.writeRUSection", (String)"1581", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst writing data", (Object[])new Object[0]);
                }
                this.markFailed(exc);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeRUSection", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeRUSection");
        }
    }

    public void internalWriteRUSection(long ruId, long sectionId, int index, byte[] data, boolean replaying) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalWriteRUSection ", (Object[])new Object[]{ruId, sectionId, index, data, replaying, this});
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing ruId: " + ruId), (Object[])new Object[0]);
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing sectionId: " + sectionId), (Object[])new Object[0]);
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing item: " + index), (Object[])new Object[0]);
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing data: " + RLSUtils.toHexString((byte[])data, (int)32)), (Object[])new Object[0]);
        }
        ruForReplay insertRU = new ruForReplay(ruId, sectionId, index, data);
        if (this._writeToCacheA) {
            this._cachedInsertsA.add(insertRU);
        } else {
            this._cachedInsertsB.add(insertRU);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalWriteRUSection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRUSection(long ruId, long sectionId, byte[] data, boolean throttle) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateRUSection ", (Object[])new Object[]{ruId, sectionId, data, throttle, this});
        }
        if (throttle) {
            this._throttleLock.lock();
            try {
                while (this._throttleEnabled) {
                    this._throttleCleared.awaitUninterruptibly();
                }
            }
            finally {
                this._throttleLock.unlock();
            }
        }
        SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
        synchronized (sQLMultiScopeRecoveryLog) {
            if (this.failed()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"updateRUSection", (Object)"InternalLogException");
                }
                throw this.getFailureException();
            }
            if (this._closesRequired <= 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"updateRUSection", (Object)this);
                }
                throw new InternalLogException((Throwable)new LogClosedException());
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("sql tranlog: writing ruId: " + ruId), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("sql tranlog: writing sectionId: " + sectionId), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("sql tranlog: writing data: " + RLSUtils.toHexString((byte[])data, (int)32)), (Object[])new Object[0]);
            }
            try {
                this.internalUpdateRUSection(ruId, sectionId, data, false);
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.updateRUSection", (String)"1581", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst updating a RecoverableUnit", (Object[])new Object[0]);
                }
                this.markFailed(exc);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"updateRUSection", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateRUSection");
        }
    }

    public void internalUpdateRUSection(long ruId, long sectionId, byte[] data, boolean replaying) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalUpdateRUSection ", (Object[])new Object[]{ruId, sectionId, data, replaying, this});
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("sql tranlog: updating ruId: " + ruId), (Object[])new Object[0]);
            Tr.event((TraceComponent)tc, (String)("sql tranlog: updating sectionId: " + sectionId), (Object[])new Object[0]);
            Tr.event((TraceComponent)tc, (String)("sql tranlog: updating data: " + RLSUtils.toHexString((byte[])data, (int)32)), (Object[])new Object[0]);
        }
        ruForReplay updateRU = new ruForReplay(ruId, sectionId, 0, data);
        if (this._writeToCacheA) {
            this._cachedUpdatesA.add(updateRU);
        } else {
            this._cachedUpdatesB.add(updateRU);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalUpdateRUSection");
        }
    }

    public void forceSections() throws InternalLogException {
        this.forceSections(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceSections(boolean throttle) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forceSections", (Object[])new Object[]{this});
        }
        if (throttle) {
            this._throttleLock.lock();
            ++this._throttleWaiters;
            if (this._throttleWaiters >= _waiterThreshold) {
                this._throttleEnabled = true;
            }
            this._throttleLock.unlock();
            try {
                this.internalForceSections();
            }
            finally {
                this._throttleLock.lock();
                try {
                    --this._throttleWaiters;
                    if (this._throttleWaiters == 0) {
                        this._throttleEnabled = false;
                        this._throttleCleared.signalAll();
                    }
                }
                finally {
                    this._throttleLock.unlock();
                }
            }
        }
        this.internalForceSections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @FFDCIgnore(value={SQLException.class, SQLRecoverableException.class})
    void internalForceSections() throws InternalLogException {
        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections", (Object[])new Object[]{this, this._reservedConn});
        }
        conn = null;
        sqlSuccess = false;
        successfulConnection = true;
        currentSqlEx = null;
        nonTransientException = null;
        initialIsolation = 4;
        var7_7 = SQLMultiScopeRecoveryLog._DBAccessIntentLock;
        synchronized (var7_7) {
            block98: {
                somethingToDo = false;
                var12_9 = this;
                synchronized (var12_9) {
                    if (this.failed()) {
                        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections", (Object)new Object[]{this, "Already Failed"});
                        }
                        throw this.getFailureException();
                    }
                    if (this._closesRequired <= 0) {
                        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections", (Object)new Object[]{this, "Already Closed"});
                        }
                        throw new InternalLogException((Throwable)new LogClosedException());
                    }
                    cachedInserts = this._writeToCacheA != false ? this._cachedInsertsA : this._cachedInsertsB;
                    cachedUpdates = this._writeToCacheA != false ? this._cachedUpdatesA : this._cachedUpdatesB;
                    v0 = cachedRemoves = this._writeToCacheA != false ? this._cachedRemovesA : this._cachedRemovesB;
                    if (cachedRemoves.size() != 0 || cachedInserts.size() != 0 || cachedUpdates.size() != 0) {
                        this._writeToCacheA = this._writeToCacheA == false;
                        somethingToDo = true;
                        if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("SOMETHING to do Remove size: " + cachedRemoves.size() + ", Insert size: " + cachedInserts.size() + ", Updates size: " + cachedUpdates.size()), (Object[])new Object[0]);
                        }
                    } else if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"NOTHING to do", (Object[])new Object[0]);
                    }
                }
                if (!somethingToDo) break block98;
                try {
                    if (this._reservedConn != null) ** GOTO lbl50
                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Reserved Connection is NULL, attempt to get new DataSource connection", (Object[])new Object[0]);
                    }
                    if (!this._serverStopping) {
                        conn = this.getConnection();
                    } else {
                        ile = this.reportOperationAttemptWhenStopping("forcing");
                        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections", (Object)"InternalLogException");
                        }
                        throw ile;
lbl50:
                        // 1 sources

                        if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Drive SQL using reserved connection", (Object[])new Object[0]);
                        }
                        conn = this._reservedConn;
                    }
                    if (!successfulConnection) ** GOTO lbl154
                    initialIsolation = this.prepareConnectionForBatch(conn);
                    lockSuccess = this.takeHADBLock(conn);
                    if (lockSuccess) {
                        this.executeBatchStatements(conn);
                    }
                    conn.commit();
                    sqlSuccess = true;
                }
                catch (SQLException sqlex) {
                    Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0107W: Caught SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " SQLException: " + sqlex), (Object[])new Object[0]);
                    currentSqlEx = sqlex;
                    if (conn != null) ** GOTO lbl154
                    nonTransientException = sqlex;
                }
                catch (PeerLostLogOwnershipException ple) {
                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Caught PeerLostLogOwnershipException: " + (Object)ple), (Object[])new Object[0]);
                    }
                    nonTransientException = ple;
                }
                catch (Throwable exc) {
                    Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0107W: Caught non-SQLException Throwable when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Throwable: " + exc), (Object[])new Object[0]);
                    nonTransientException = exc;
                }
                finally {
                    if (conn != null) {
                        if (sqlSuccess) {
                            if (this._reservedConn == null) {
                                try {
                                    this.closeConnectionAfterBatch(conn, initialIsolation);
                                }
                                catch (Throwable exc) {
                                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections success, got exception: " + exc), (Object[])new Object[0]);
                                    }
                                }
                            }
                        } else {
                            block97: {
                                block96: {
                                    try {
                                        conn.rollback();
                                    }
                                    catch (Throwable exc) {
                                        if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block96;
                                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Rollback Failed, after force sections failure, got exception: " + exc), (Object[])new Object[0]);
                                    }
                                }
                                if (this._reservedConn == null) {
                                    try {
                                        this.closeConnectionAfterBatch(conn, initialIsolation);
                                    }
                                    catch (Throwable exc) {
                                        if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block97;
                                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections failure, got exception: " + exc), (Object[])new Object[0]);
                                    }
                                }
                            }
                            if (this._serverStopping) {
                                ile = this.reportOperationAttemptWhenStopping("forcing");
                                if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections", (Object)"InternalLogException");
                                }
                                throw ile;
                            }
                            failAndReport = true;
                            if (currentSqlEx != null) {
                                nonTransientException = currentSqlEx;
                                forceSectionsRetry = new ForceSectionsRetry();
                                forceSectionsRetry.setNonTransientException(currentSqlEx);
                                if (this._sqlTransientErrorHandlingEnabled && (failAndReport = forceSectionsRetry.retryAfterSQLException(this, currentSqlEx))) {
                                    nonTransientException = forceSectionsRetry.getNonTransientException();
                                }
                            }
                            if (failAndReport) {
                                if (nonTransientException instanceof PeerLostLogOwnershipException) {
                                    if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections", (Object)"PeerLostLogOwnershipException");
                                    }
                                    ple = new PeerLostLogOwnershipException(nonTransientException);
                                    throw ple;
                                }
                                Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
                                this.markFailed(nonTransientException);
                                ile = new InternalLogException(nonTransientException);
                                if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections", (Object)ile);
                                }
                                throw ile;
                            }
                            Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0108I: Have recovered from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName), (Object[])new Object[0]);
                        }
                    } else {
                        if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Connection was NULL", (Object[])new Object[0]);
                        }
                        Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
                        this.markFailed(nonTransientException);
                        ile = new InternalLogException(nonTransientException);
                        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections", (Object)ile);
                        }
                        throw ile;
                    }
                    ile = this;
                    synchronized (ile) {
                        cachedInserts.clear();
                        cachedUpdates.clear();
                        cachedRemoves.clear();
                    }
                }
            }
            if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"No inserts, updates or deletes", (Object[])new Object[0]);
            }
        }
lbl154:
        // 7 sources

        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchStatements(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"executeBatchStatements", (Object[])new Object[]{conn, this});
        }
        Statement insertStatement = null;
        Statement updateStatement = null;
        Statement removeStatement = null;
        boolean _writeFromCacheA = !this._writeToCacheA;
        List<ruForReplay> cachedInserts = _writeFromCacheA ? this._cachedInsertsA : this._cachedInsertsB;
        List<ruForReplay> cachedUpdates = _writeFromCacheA ? this._cachedUpdatesA : this._cachedUpdatesB;
        List<ruForReplay> cachedRemoves = _writeFromCacheA ? this._cachedRemovesA : this._cachedRemovesB;
        int inserts = cachedInserts.size();
        int updates = cachedUpdates.size();
        int removes = cachedRemoves.size();
        try {
            int[] numUpdates;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Prepare the INSERT statement for " + inserts + " inserts"), (Object[])new Object[0]);
            }
            if (inserts > 0) {
                String insertString = "INSERT INTO WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " (SERVER_NAME, SERVICE_ID, RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA) VALUES (?,?,?,?,?,?)";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("INSERT string - " + insertString), (Object[])new Object[0]);
                }
                insertStatement = conn.prepareStatement(insertString);
                insertStatement.setString(1, this._serverName);
                insertStatement.setShort(2, (short)this._recoveryAgent.clientIdentifier());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Prepare the UPDATE statement for " + updates + " updates"), (Object[])new Object[0]);
            }
            if (updates > 0) {
                String updateString = "UPDATE WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " SET DATA = ? WHERE SERVER_NAME = ? AND SERVICE_ID = ? AND RU_ID = ? AND RUSECTION_ID = ? AND RUSECTION_DATA_INDEX = 0";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("UPDATE string - " + updateString), (Object[])new Object[0]);
                }
                updateStatement = conn.prepareStatement(updateString);
                updateStatement.setString(2, this._serverName);
                updateStatement.setShort(3, (short)this._recoveryAgent.clientIdentifier());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Prepare the DELETE statement for " + removes + " removes"), (Object[])new Object[0]);
            }
            if (removes > 0) {
                String removeString = "DELETE FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE SERVER_NAME = ? AND SERVICE_ID = ? AND RU_ID = ? ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DELETE string - " + (String)removeString), (Object[])new Object[0]);
                }
                removeStatement = conn.prepareStatement(removeString);
                removeStatement.setString(1, this._serverName);
                removeStatement.setShort(2, (short)this._recoveryAgent.clientIdentifier());
            }
            if (inserts > 0) {
                for (ruForReplay element : cachedInserts) {
                    insertStatement.setLong(3, element.getRuId());
                    insertStatement.setLong(4, element.getSectionId());
                    insertStatement.setShort(5, (short)element.getIndex());
                    insertStatement.setBytes(6, element.getData());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Insert row, serverName: " + this._serverName + " clientId: " + (short)this._recoveryAgent.clientIdentifier() + "ruId: " + element.getRuId() + " sectionId: " + element.getSectionId() + " item: " + (short)element.getIndex()), (Object[])new Object[0]);
                    }
                    insertStatement.addBatch();
                }
            }
            if (updates > 0) {
                for (ruForReplay element : cachedUpdates) {
                    updateStatement.setLong(4, element.getRuId());
                    updateStatement.setLong(5, element.getSectionId());
                    updateStatement.setBytes(1, element.getData());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Update row, serverName: " + this._serverName + " clientId: " + (short)this._recoveryAgent.clientIdentifier() + "ruId: " + element.getRuId() + " sectionId: " + element.getSectionId()), (Object[])new Object[0]);
                    }
                    updateStatement.addBatch();
                }
            }
            if (removes > 0) {
                for (ruForReplay element : cachedRemoves) {
                    removeStatement.setLong(3, element.getRuId());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Delete row, serverName: " + this._serverName + " clientId: " + (short)this._recoveryAgent.clientIdentifier() + "ruId: " + element.getRuId()), (Object[])new Object[0]);
                    }
                    removeStatement.addBatch();
                }
            }
            if (inserts > 0) {
                numUpdates = insertStatement.executeBatch();
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < numUpdates.length; ++i) {
                        if (numUpdates[i] == -2) {
                            Tr.debug((TraceComponent)tc, (String)("Execution " + i + ": unknown number of rows updated"), (Object[])new Object[0]);
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)("Execution " + i + "successful: " + numUpdates[i] + " rows updated"), (Object[])new Object[0]);
                    }
                }
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("sql tranlog: batch inserts: " + inserts), (Object[])new Object[0]);
            }
            if (updates > 0) {
                numUpdates = updateStatement.executeBatch();
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < numUpdates.length; ++i) {
                        if (numUpdates[i] == -2) {
                            Tr.debug((TraceComponent)tc, (String)("Execution " + i + ": unknown number of rows updated"), (Object[])new Object[0]);
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)("Execution " + i + "successful: " + numUpdates[i] + " rows updated"), (Object[])new Object[0]);
                    }
                }
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("sql tranlog: batch updates: " + updates), (Object[])new Object[0]);
            }
            if (removes > 0) {
                numUpdates = removeStatement.executeBatch();
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < numUpdates.length; ++i) {
                        if (numUpdates[i] == -2) {
                            Tr.debug((TraceComponent)tc, (String)("Execution " + i + ": unknown number of rows updated"), (Object[])new Object[0]);
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)("Execution " + i + "successful: " + numUpdates[i] + " rows updated"), (Object[])new Object[0]);
                    }
                }
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("sql tranlog: batch deletes: " + removes + ", for obj: " + this), (Object[])new Object[0]);
            }
        }
        finally {
            if (insertStatement != null && !insertStatement.isClosed()) {
                insertStatement.close();
            }
            if (updateStatement != null && !updateStatement.isClosed()) {
                updateStatement.close();
            }
            if (removeStatement != null && !removeStatement.isClosed()) {
                removeStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"executeBatchStatements");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean takeHADBLock(Connection conn) throws SQLException, InternalLogException {
        boolean lockSuccess;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"takeHADBLock", (Object[])new Object[]{conn, this});
            }
            Statement lockingStmt = null;
            ResultSet lockingRS = null;
            lockSuccess = false;
            try {
                lockingStmt = conn.createStatement();
                String queryString = "SELECT SERVER_NAME FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + (this._isSQLServer ? " WITH (UPDLOCK)" : "") + " WHERE RU_ID=-1" + (this._isSQLServer ? "" : " FOR UPDATE");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW for UPDATE using - " + queryString), (Object[])new Object[0]);
                }
                if ((lockingRS = lockingStmt.executeQuery(queryString)).next()) {
                    String storedServerName = lockingRS.getString(1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Acquired lock on HA Lock row, stored server value is: " + storedServerName), (Object[])new Object[0]);
                    }
                    if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This server OWNS the HA lock row as expected", (Object[])new Object[0]);
                        }
                        lockSuccess = true;
                        break block19;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ANOTHER server OWNS the lock row - we need to mark the log as failed", (Object[])new Object[0]);
                    }
                    if (_useNewLockingScheme && !this._isHomeServer) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Not the home server, failurescope is " + this._failureScope), (Object[])new Object[0]);
                        }
                        PeerLostLogOwnershipException ple = new PeerLostLogOwnershipException("Another server (" + storedServerName + ") has locked the HA lock row", null);
                        this.markFailed(ple, false, true);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"takeHADBLock", (Object)((Object)ple));
                        }
                        throw ple;
                    }
                    Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Another server (" + storedServerName + ") owns the log cannot force SQL RecoveryLog " + this._logName + " for server " + this._serverName), (Object[])new Object[0]);
                    InternalLogException ile = new InternalLogException("Another server (" + storedServerName + ") has locked the HA lock row", null);
                    this.markFailed(ile);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"takeHADBLock", (Object)((Object)ile));
                    }
                    throw ile;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not find HA Lock row", (Object[])new Object[0]);
                }
                InternalLogException ile = new InternalLogException("Could not find the HA lock row", null);
                Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Could not find HA lock row when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName), (Object[])new Object[0]);
                this.markFailed(ile);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"takeHADBLock", (Object)((Object)ile));
                }
                throw ile;
            }
            finally {
                if (lockingRS != null && !lockingRS.isClosed()) {
                    lockingRS.close();
                }
                if (lockingStmt != null && !lockingStmt.isClosed()) {
                    lockingStmt.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"takeHADBLock", (Object)lockSuccess);
        }
        return lockSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHADBLock(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateHADBLock", (Object[])new Object[]{conn, this});
        }
        Statement readForUpdateStmt = null;
        Statement updateStmt = null;
        Statement specStatement = null;
        ResultSet readForUpdateRS = null;
        boolean lockingRecordExists = false;
        try {
            int latchRetryCount = 0;
            boolean needToRetryLatch = false;
            do {
                needToRetryLatch = false;
                readForUpdateStmt = conn.createStatement();
                readForUpdateRS = this.readHADBLock(readForUpdateStmt);
                if (readForUpdateRS.next()) {
                    Long latch;
                    lockingRecordExists = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Acquired lock on HA Lock row", (Object[])new Object[0]);
                    }
                    String storedServerName = readForUpdateRS.getString(1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Stored server value is: " + storedServerName), (Object[])new Object[0]);
                    }
                    if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This server ALREADY OWNS the HA lock row", (Object[])new Object[0]);
                        }
                        if (_useNewLockingScheme || 255L != (latch = Long.valueOf(readForUpdateRS.getLong(2))) || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"latch is set in HA lock row - it will be unset when we perform the UPDATE", (Object[])new Object[0]);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ANOTHER server OWNS the lock", (Object[])new Object[0]);
                    }
                    if (_useNewLockingScheme || 255L != (latch = Long.valueOf(readForUpdateRS.getLong(2))) || this._isHomeServer) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("latch is set in HA lock row for remote failurescope, latchRetryCount = " + latchRetryCount), (Object[])new Object[0]);
                    }
                    if (++latchRetryCount >= 3) continue;
                    needToRetryLatch = true;
                    if (readForUpdateRS != null) {
                        try {
                            readForUpdateRS.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (readForUpdateStmt != null) {
                        try {
                            readForUpdateStmt.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    conn.rollback();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                lockingRecordExists = false;
            } while (needToRetryLatch);
            if (lockingRecordExists) {
                updateStmt = conn.createStatement();
                String updateString = null;
                updateString = !_useNewLockingScheme ? "UPDATE WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " SET SERVER_NAME = '" + this._currentProcessServerName + "', RUSECTION_ID = " + 1L + " WHERE RU_ID = -1" : "UPDATE WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " SET SERVER_NAME = '" + this._currentProcessServerName + "' WHERE RU_ID = -1";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Updating HA Lock using update string - " + updateString), (Object[])new Object[0]);
                }
                int ret = updateStmt.executeUpdate(updateString);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have updated HA Lock row with return: " + ret), (Object[])new Object[0]);
                }
            } else {
                short serviceId = 1;
                String insertString = "INSERT INTO WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " (SERVER_NAME, SERVICE_ID, RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA) VALUES (?,?,?,?,?,?)";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Need to setup HA Lock row using - " + insertString), (Object[])new Object[0]);
                }
                specStatement = conn.prepareStatement(insertString);
                specStatement.setString(1, this._currentProcessServerName);
                specStatement.setShort(2, serviceId);
                specStatement.setLong(3, -1L);
                specStatement.setLong(4, 1L);
                specStatement.setShort(5, (short)1);
                byte[] buf = new byte[2];
                specStatement.setBytes(6, buf);
                int ret = specStatement.executeUpdate();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have inserted HA Lock row with return: " + ret), (Object[])new Object[0]);
                }
            }
        }
        finally {
            if (readForUpdateRS != null) {
                try {
                    readForUpdateRS.close();
                }
                catch (Exception exception) {}
            }
            if (readForUpdateStmt != null) {
                try {
                    readForUpdateStmt.close();
                }
                catch (Exception exception) {}
            }
            if (updateStmt != null) {
                try {
                    updateStmt.close();
                }
                catch (Exception exception) {}
            }
            if (specStatement != null) {
                try {
                    specStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateHADBLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDBTable(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDBTable", (Object[])new Object[]{conn, this});
        }
        Statement createTableStmt = null;
        Statement specStatement = null;
        boolean success = false;
        try {
            createTableStmt = conn.createStatement();
            String fullTableName = _recoveryTableName + this._logIdentifierString + this._recoveryTableNameSuffix;
            if (this._isOracle) {
                String oracleTableString = genericTableCreatePreString + fullTableName + oracleTablePostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Oracle Table using: " + oracleTableString), (Object[])new Object[0]);
                }
                String oracleIndexString = "CREATE INDEX IXWS" + this._logIdentifierString + this._recoveryTableNameSuffix + " ON " + fullTableName + indexPostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Oracle Index using: " + oracleIndexString), (Object[])new Object[0]);
                }
                createTableStmt.executeUpdate(oracleTableString);
                createTableStmt.executeUpdate(oracleIndexString);
            } else if (this._isDB2) {
                String db2TableString = genericTableCreatePreString + fullTableName + db2TablePostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create DB2 Table using: " + db2TableString), (Object[])new Object[0]);
                }
                String db2IndexString = "CREATE INDEX IXWS" + this._logIdentifierString + this._recoveryTableNameSuffix + " ON " + fullTableName + indexPostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create DB2 Index using: " + db2IndexString), (Object[])new Object[0]);
                }
                createTableStmt.executeUpdate(db2TableString);
                createTableStmt.executeUpdate(db2IndexString);
            } else if (this._isPostgreSQL) {
                String postgreSQLTableString = genericTableCreatePreString + fullTableName + postgreSQLTablePostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create PostgreSQL table using: " + postgreSQLTableString), (Object[])new Object[0]);
                }
                String postgreSQLIndexString = "CREATE INDEX IXWS" + this._logIdentifierString + this._recoveryTableNameSuffix + " ON " + fullTableName + postgreSQLIndexPostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create PostgreSQL index using: " + postgreSQLIndexString), (Object[])new Object[0]);
                }
                conn.rollback();
                createTableStmt.execute(postgreSQLTableString);
                createTableStmt.execute(postgreSQLIndexString);
            } else if (this._isSQLServer) {
                String sqlServerTableString = genericTableCreatePreString + fullTableName + sqlServerTablePostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create SQL Server table using: " + sqlServerTableString), (Object[])new Object[0]);
                }
                String sqlServerIndexString = "CREATE INDEX IXWS" + this._logIdentifierString + this._recoveryTableNameSuffix + " ON " + fullTableName + indexPostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create SQL Server index using: " + sqlServerIndexString), (Object[])new Object[0]);
                }
                conn.rollback();
                createTableStmt.execute(sqlServerTableString);
                createTableStmt.execute(sqlServerIndexString);
            } else {
                String genericTableString = genericTableCreatePreString + fullTableName + genericTablePostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Generic Table using: " + genericTableString), (Object[])new Object[0]);
                }
                String genericIndexString = "CREATE INDEX IXWS" + this._logIdentifierString + this._recoveryTableNameSuffix + " ON " + fullTableName + indexPostString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Generic Index using: " + genericIndexString), (Object[])new Object[0]);
                }
                createTableStmt.executeUpdate(genericTableString);
                createTableStmt.executeUpdate(genericIndexString);
            }
            short serviceId = (short)this._recoveryAgent.clientIdentifier();
            String insertString = "INSERT INTO " + fullTableName + " (SERVER_NAME, SERVICE_ID, RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA) VALUES (?,?,?,?,?,?)";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Have created the table, insert special HA LOCKING row using - " + insertString), (Object[])new Object[0]);
            }
            specStatement = conn.prepareStatement(insertString);
            specStatement.setString(1, this._currentProcessServerName);
            specStatement.setShort(2, serviceId);
            specStatement.setLong(3, -1L);
            specStatement.setLong(4, 1L);
            specStatement.setShort(5, (short)1);
            byte[] buf = new byte[2];
            specStatement.setBytes(6, buf);
            int ret = specStatement.executeUpdate();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Have inserted HA LOCKING ROW with return: " + ret), (Object[])new Object[0]);
            }
            conn.commit();
            success = true;
        }
        finally {
            if (createTableStmt != null && !createTableStmt.isClosed()) {
                createTableStmt.close();
            }
            if (specStatement != null && !specStatement.isClosed()) {
                specStatement.close();
            }
            if (!success) {
                conn.rollback();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDBTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDBTable(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"dropDBTable", (Object[])new Object[]{conn, this});
        }
        Statement dropTableStmt = null;
        boolean success = false;
        try {
            dropTableStmt = conn.createStatement();
            String fullTableName = _recoveryTableName + this._logIdentifierString + this._recoveryTableNameSuffix;
            String dropTableString = genericTableDropPreString + fullTableName;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("drop Table using: " + dropTableString), (Object[])new Object[0]);
            }
            dropTableStmt.executeUpdate(dropTableString);
        }
        finally {
            if (dropTableStmt != null && !dropTableStmt.isClosed()) {
                dropTableStmt.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"dropDBTable");
        }
    }

    public synchronized void removing(Object target) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removing", (Object[])new Object[]{target, this});
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)"InternalLogException");
            }
            throw this.getFailureException();
        }
        if (this._closesRequired <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)this);
            }
            throw new InternalLogException((Throwable)new LogClosedException());
        }
        try {
            this.removeRecoverableUnit(((SQLRecoverableUnitImpl)target).identity());
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removing", (String)"1573", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst removing a RecoverableUnit", (Object[])new Object[0]);
            }
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)((Object)exc));
            }
            throw exc;
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removing", (String)"1581", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst removing a RecoverableUnit", (Object[])new Object[0]);
            }
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removing");
        }
    }

    protected boolean failed() {
        if (tc.isDebugEnabled() && this._failed) {
            Tr.debug((TraceComponent)tc, (String)("failed: RecoveryLog has been marked as failed. [" + this + "]"), (Object[])new Object[0]);
        }
        return this._failed;
    }

    protected void markFailed(Throwable t) {
        this.markFailed(t, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markFailed(Throwable t, boolean report, boolean peerServerLostLogOwnership) {
        boolean newFailure = false;
        SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
        synchronized (sQLMultiScopeRecoveryLog) {
            if (tc.isDebugEnabled() && this._failed) {
                Tr.debug((TraceComponent)tc, (String)("markFailed: RecoveryLog has been marked as failed. [" + this + "]"), (Object[])new Object[0]);
            }
            if (!this._failed) {
                newFailure = true;
                this._failed = true;
            }
            if (peerServerLostLogOwnership) {
                this._peerServerLostLogOwnership = true;
            } else if (this._peerServerLostLogOwnership) {
                newFailure = true;
                this._peerServerLostLogOwnership = false;
            }
            if (newFailure) {
                if (report) {
                    Object[] errorObject = new Object[]{this._logIdentifier, this._clientName};
                    Tr.audit((TraceComponent)tc, (String)"CWRLS0008_RECOVERY_LOG_FAILED", (Object[])errorObject);
                    Tr.info((TraceComponent)tc, (String)"CWRLS0009_RECOVERY_LOG_FAILED_DETAIL", (Object[])new Object[]{t});
                }
                if (Configuration.HAEnabled() && ConfigurationProviderManager.getConfigurationProvider().isShutdownOnLogFailure()) {
                    if (Configuration.localFailureScope().equals(this._failureScope)) {
                        Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{t});
                        if (ConfigurationProviderManager.getConfigurationProvider().isShutdownOnLogFailure()) {
                            this._recoveryAgent.terminateServer();
                        }
                    } else {
                        Configuration.getRecoveryLogComponent().leaveGroup(this._failureScope);
                    }
                }
            }
        }
        if (newFailure && this._associatedLog != null) {
            if (this._failAssociatedLog) {
                if (tc.isDebugEnabled() && this._failed) {
                    Tr.debug((TraceComponent)tc, (String)"associated log will be marked as failed", (Object[])new Object[]{this._associatedLog});
                }
                this._associatedLog.markFailedByAssociation(this._peerServerLostLogOwnership);
            } else if (!this._peerServerLostLogOwnership) {
                this._associatedLog.provideServiceability();
            }
        }
    }

    public synchronized void markFailedByAssociation() {
        this.markFailedByAssociation(false);
    }

    private synchronized void markFailedByAssociation(boolean peerServerLostLogOwnership) {
        if (!this._failed) {
            this._failed = true;
            if (tc.isDebugEnabled() && this._failed) {
                Tr.debug((TraceComponent)tc, (String)("markFailedByAssociation: RecoveryLog has been marked as failed by association. [" + this + "]"), (Object[])new Object[0]);
            }
            if (peerServerLostLogOwnership) {
                this._peerServerLostLogOwnership = true;
            } else {
                this.provideServiceability();
            }
        } else if (tc.isDebugEnabled() && this._failed) {
            Tr.debug((TraceComponent)tc, (String)("markFailedByAssociation: RecoveryLog was already failed when marked as failed by association. [" + this + "]"), (Object[])new Object[0]);
        }
    }

    protected InternalLogException getFailureException() {
        if (this._peerServerLostLogOwnership) {
            return new PeerLostLogOwnershipException(null);
        }
        return new InternalLogException(null);
    }

    protected void addRecoverableUnit(SQLRecoverableUnitImpl recoverableUnit, boolean recovered) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addRecoverableUnit", (Object[])new Object[]{recoverableUnit, recovered, this});
        }
        long identity = recoverableUnit.identity();
        this._recoverableUnits.put(identity, recoverableUnit);
        if (recovered) {
            this._recUnitIdTable.reserveId(identity, (Object)recoverableUnit);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addRecoverableUnit");
        }
    }

    protected SQLRecoverableUnitImpl removeRecoverableUnitMapEntries(long identity) {
        SQLRecoverableUnitImpl recoverableUnit;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoverableUnitMapEntries", (Object[])new Object[]{identity, this});
        }
        if ((recoverableUnit = this._recoverableUnits.remove(identity)) != null && !recoverableUnit._recovered) {
            this._recUnitIdTable.removeId(identity);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnitMapEntries", (Object)recoverableUnit);
        }
        return recoverableUnit;
    }

    private SQLRecoverableUnitImpl getRecoverableUnit(long identity) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRecoverableUnit", (Object[])new Object[]{identity, this});
        }
        SQLRecoverableUnitImpl recoverableUnit = null;
        if (this.failed() || this._closesRequired <= 0) {
            LogClosedException lce = new LogClosedException();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRecoverableUnit", (Object)lce);
            }
            throw lce;
        }
        recoverableUnit = this._recoverableUnits.get(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRecoverableUnit", (Object)recoverableUnit);
        }
        return recoverableUnit;
    }

    String serverName() {
        return this._serverName;
    }

    String clientName() {
        return this._clientName;
    }

    public int clientVersion() {
        return this._clientVersion;
    }

    public String logName() {
        return this._logName;
    }

    public int logIdentifier() {
        return this._logIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStopping() {
        SQLException transientException = null;
        Object object = _DBAccessIntentLock;
        synchronized (object) {
            SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
            synchronized (sQLMultiScopeRecoveryLog) {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"serverStopping ", (Object[])new Object[]{this});
                }
                this._serverStopping = true;
                if (_useNewLockingScheme) {
                    HeartbeatLogManager.stopTimeout();
                }
                if (this.failed() || this._closesRequired <= 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"serverStopping", (Object)this);
                    }
                    return;
                }
                try {
                    transientException = this.reserveConnection();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.serverStopping", (String)"3513", (Object)this);
                }
                if (transientException != null) {
                    Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught SQLException when server stopping for SQL RecoveryLog " + this._logName + " for server " + this._serverName + " SQLException: " + transientException), (Object[])new Object[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Try to reexecute the SQL using connection from DS: " + this._theDS), (Object[])new Object[0]);
                    }
                    try {
                        transientException = this.reserveConnection();
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.serverStopping", (String)"3513", (Object)this);
                    }
                    if (transientException != null) {
                        FFDCFilter.processException((Throwable)transientException, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.serverStopping", (String)"3507", (Object)this);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serverStopping");
        }
    }

    public String toString() {
        return this._traceId;
    }

    private String logTypeFromInteger(int x) {
        switch (x) {
            case 1: {
                return "TRAN_LOG";
            }
            case 2: {
                return "PARTNER_LOG";
            }
            case 3: {
                return "COMP_LOG";
            }
        }
        return "";
    }

    public void associateLog(DistributedRecoveryLog otherLog, boolean failAssociatedLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"associateLog", (Object[])new Object[]{otherLog, failAssociatedLog, this});
        }
        if (otherLog instanceof SQLMultiScopeRecoveryLog) {
            this._associatedLog = (SQLMultiScopeRecoveryLog)otherLog;
            this._failAssociatedLog = failAssociatedLog;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"associateLog");
        }
    }

    public void provideServiceability() {
        Exception e = new Exception();
        try {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.provideServiceability", (String)"3624", (Object)this);
            HashMap<Long, SQLRecoverableUnitImpl> rus = this._recoverableUnits;
            if (rus != null) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.provideServiceability", (String)"3628", rus);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int prepareConnectionForBatch(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
        int initialIsolation = 4;
        if (this._isDB2) {
            try {
                initialIsolation = conn.getTransactionIsolation();
                if (4 != initialIsolation && 8 != initialIsolation) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Transaction isolation level was " + initialIsolation + " , setting to TRANSACTION_REPEATABLE_READ"), (Object[])new Object[0]);
                    }
                    conn.setTransactionIsolation(4);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setTransactionIsolation to RR threw Exception. Transaction isolation level was " + initialIsolation + " "), (Object[])new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.prepareConnectionForBatch", (String)"3668", (Object)this);
                if (!this.isolationFailureReported) {
                    this.isolationFailureReported = true;
                    Tr.warning((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{e});
                }
                initialIsolation = 4;
            }
        }
        return initialIsolation;
    }

    @Override
    public void closeConnectionAfterBatch(Connection conn, int initialIsolation) throws SQLException {
        block4: {
            if (this._isDB2 && 4 != initialIsolation && 8 != initialIsolation) {
                try {
                    conn.setTransactionIsolation(initialIsolation);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setTransactionIsolation threw Exception. Specified transaction isolation level was " + initialIsolation + " "), (Object[])new Object[]{e});
                    }
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.closeConnectionAfterBatch", (String)"3696", (Object)this);
                    if (this.isolationFailureReported) break block4;
                    this.isolationFailureReported = true;
                    Tr.warning((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{e});
                }
            }
        }
        conn.setAutoCommit(true);
        conn.close();
    }

    private ResultSet readHADBLock(Statement lockingStmt) throws SQLException {
        String queryString = "SELECT SERVER_NAME, RUSECTION_ID FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + (this._isSQLServer ? " WITH (UPDLOCK)" : "") + " WHERE RU_ID=-1" + (this._isSQLServer ? "" : " FOR UPDATE");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW for UPDATE - " + queryString), (Object[])new Object[0]);
        }
        return lockingStmt.executeQuery(queryString);
    }

    private int setHADBLockLatch(Statement lockingStmt, boolean setLatch) throws SQLException {
        long latch = setLatch ? 255L : 1L;
        String updateString = "UPDATE WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " SET RUSECTION_ID = " + latch + " WHERE RU_ID = -1";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attempt to UPDATE the HA LOCKING ROW - " + updateString), (Object[])new Object[0]);
        }
        return lockingStmt.executeUpdate(updateString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private SQLException reserveConnection() {
        block180: {
            block176: {
                block175: {
                    if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"reserveConnection", (Object[])new Object[]{this._reservedConn, this});
                    }
                    success = false;
                    lockingStmt = null;
                    lockingRS = null;
                    transientException = null;
                    this._reservedConn = this.getConnection();
                    this.prepareConnectionForBatch(this._reservedConn);
                    lockingStmt = this._reservedConn.createStatement();
                    lockingRS = this.readHADBLock(lockingStmt);
                    if (lockingRS.next()) {
                        if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Acquired lock on HA Lock row", (Object[])new Object[0]);
                        }
                        storedServerName = lockingRS.getString(1);
                        if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Stored server value is: " + storedServerName), (Object[])new Object[0]);
                        }
                        if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                            if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"This server OWNS the HA lock row", (Object[])new Object[0]);
                            }
                            if (this._isHomeServer && !SQLMultiScopeRecoveryLog._useNewLockingScheme) {
                                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"it's the local server's failure scope - set the latch", (Object[])new Object[0]);
                                }
                                ret = this.setHADBLockLatch(lockingStmt, true);
                                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Have updated HA Lock row's latch return value: " + ret), (Object[])new Object[0]);
                                }
                            }
                            success = true;
                        } else if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Too late, another server has already got the lock: ", (Object[])new Object[0]);
                        }
                    } else if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"There's no locking row!!!", (Object[])new Object[0]);
                    }
                    if (lockingRS == null) break block175;
                    try {
                        lockingRS.close();
                    }
                    catch (Exception e) {
                        if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block175;
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Exception closing ResultsSet", (Object[])new Object[]{e});
                    }
                }
                if (lockingStmt != null) {
                    try {
                        lockingStmt.close();
                    }
                    catch (Exception e) {
                        if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block176;
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Exception closing Statement", (Object[])new Object[]{e});
                    }
                }
            }
            try {
                if (success) {
                    this._reservedConn.commit();
                }
                if (this._reservedConn == null) ** GOTO lbl251
                this._reservedConn.rollback();
            }
            catch (SQLException sqlex) {
                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("SQLException ending transaction on connection (commit is " + success + "): "), (Object[])new Object[]{sqlex});
                }
                if (success && transientException == null) {
                    if (this._sqlTransientErrorHandlingEnabled && SQLRetry.isSQLErrorTransient(sqlex)) {
                        transientException = sqlex;
                    } else {
                        FFDCFilter.processException((Throwable)sqlex, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.reserveConnection", (String)"3937", (Object)this);
                    }
                }
                success = false;
            }
            catch (Exception e) {
                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Exception ending transaction on connection (commit is " + success + "): "), (Object[])new Object[]{e});
                }
                success = false;
            }
            finally {
                if (!success && this._reservedConn != null) {
                    try {
                        this._reservedConn.close();
                    }
                    catch (Exception sqlex) {
                    }
                    finally {
                        this._reservedConn = null;
                    }
                }
            }
            catch (SQLException sqlex) {
                block179: {
                    block178: {
                        if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"SQLException creating reservedConnection or reading the lock", (Object[])new Object[]{sqlex});
                        }
                        if (this._sqlTransientErrorHandlingEnabled && SQLRetry.isSQLErrorTransient(sqlex)) {
                            transientException = sqlex;
                        } else {
                            FFDCFilter.processException((Throwable)sqlex, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.reserveConnection", (String)"3901", (Object)this);
                        }
                        if (lockingRS == null) break block178;
                        try {
                            lockingRS.close();
                        }
                        catch (Exception e) {
                            if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block178;
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Exception closing ResultsSet", (Object[])new Object[]{e});
                        }
                    }
                    if (lockingStmt != null) {
                        try {
                            lockingStmt.close();
                        }
                        catch (Exception e) {
                            if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block179;
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Exception closing Statement", (Object[])new Object[]{e});
                        }
                    }
                }
                try {
                    if (success) {
                        this._reservedConn.commit();
                    } else if (this._reservedConn != null) {
                        this._reservedConn.rollback();
                    }
                }
                catch (SQLException sqlex) {
                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("SQLException ending transaction on connection (commit is " + success + "): "), (Object[])new Object[]{sqlex});
                    }
                    if (success && transientException == null) {
                        if (this._sqlTransientErrorHandlingEnabled && SQLRetry.isSQLErrorTransient(sqlex)) {
                            transientException = sqlex;
                        } else {
                            FFDCFilter.processException((Throwable)sqlex, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.reserveConnection", (String)"3937", (Object)this);
                        }
                    }
                    success = false;
                    break block180;
                }
                catch (Exception e) {
                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Exception ending transaction on connection (commit is " + success + "): "), (Object[])new Object[]{e});
                    }
                    success = false;
                    break block180;
                }
                finally {
                    if (!success && this._reservedConn != null) {
                        try {
                            this._reservedConn.close();
                        }
                        catch (Exception sqlex) {
                        }
                        finally {
                            this._reservedConn = null;
                        }
                    }
                }
            }
            catch (Exception e) {
                block183: {
                    block182: {
                        if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Exception selecting/updating the HADBLock row ", (Object[])new Object[]{e});
                        }
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.reserveConnection", (String)"3906", (Object)this);
                        if (lockingRS == null) break block182;
                        {
                            catch (Throwable var25_50) {
                                block186: {
                                    block185: {
                                        if (lockingRS != null) {
                                            try {
                                                lockingRS.close();
                                            }
                                            catch (Exception e) {
                                                if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block185;
                                                Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Exception closing ResultsSet", (Object[])new Object[]{e});
                                            }
                                        }
                                    }
                                    if (lockingStmt != null) {
                                        try {
                                            lockingStmt.close();
                                        }
                                        catch (Exception e) {
                                            if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block186;
                                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Exception closing Statement", (Object[])new Object[]{e});
                                        }
                                    }
                                }
                                try {
                                    if (success) {
                                        this._reservedConn.commit();
                                    } else if (this._reservedConn != null) {
                                        this._reservedConn.rollback();
                                    }
                                }
                                catch (SQLException sqlex) {
                                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("SQLException ending transaction on connection (commit is " + success + "): "), (Object[])new Object[]{sqlex});
                                    }
                                    if (success && transientException == null) {
                                        if (this._sqlTransientErrorHandlingEnabled && SQLRetry.isSQLErrorTransient(sqlex)) {
                                            transientException = sqlex;
                                        } else {
                                            FFDCFilter.processException((Throwable)sqlex, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.reserveConnection", (String)"3937", (Object)this);
                                        }
                                    }
                                    success = false;
                                }
                                catch (Exception e) {
                                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Exception ending transaction on connection (commit is " + success + "): "), (Object[])new Object[]{e});
                                    }
                                    success = false;
                                }
                                finally {
                                    if (!success && this._reservedConn != null) {
                                        try {
                                            this._reservedConn.close();
                                        }
                                        catch (Exception sqlex) {
                                        }
                                        finally {
                                            this._reservedConn = null;
                                        }
                                    }
                                }
                                throw var25_50;
                            }
                        }
                        try {
                            lockingRS.close();
                        }
                        catch (Exception e) {
                            if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block182;
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Exception closing ResultsSet", (Object[])new Object[]{e});
                        }
                    }
                    if (lockingStmt != null) {
                        try {
                            lockingStmt.close();
                        }
                        catch (Exception e) {
                            if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block183;
                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Exception closing Statement", (Object[])new Object[]{e});
                        }
                    }
                }
                try {
                    if (success) {
                        this._reservedConn.commit();
                    } else if (this._reservedConn != null) {
                        this._reservedConn.rollback();
                    }
                }
                catch (SQLException sqlex) {
                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("SQLException ending transaction on connection (commit is " + success + "): "), (Object[])new Object[]{sqlex});
                    }
                    if (success && transientException == null) {
                        if (this._sqlTransientErrorHandlingEnabled && SQLRetry.isSQLErrorTransient(sqlex)) {
                            transientException = sqlex;
                        } else {
                            FFDCFilter.processException((Throwable)sqlex, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.reserveConnection", (String)"3937", (Object)this);
                        }
                    }
                    success = false;
                }
                catch (Exception e) {
                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Exception ending transaction on connection (commit is " + success + "): "), (Object[])new Object[]{e});
                    }
                    success = false;
                }
                finally {
                    if (!success && this._reservedConn != null) {
                        try {
                            this._reservedConn.close();
                        }
                        catch (Exception sqlex) {
                        }
                        finally {
                            this._reservedConn = null;
                        }
                    }
                }
            }
        }
        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"reserveConnection", (Object)transientException);
        }
        return transientException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean unlatchHADBLock() {
        boolean success;
        block74: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"unlatchHADBLock", (Object[])new Object[]{this._reservedConn, this});
            }
            success = false;
            Statement lockingStmt = null;
            ResultSet lockingRS = null;
            if (this._isHomeServer && this._reservedConn != null) {
                block73: {
                    block72: {
                        lockingStmt = this._reservedConn.createStatement();
                        lockingRS = this.readHADBLock(lockingStmt);
                        if (lockingRS.next()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Acquired lock on HA Lock row", (Object[])new Object[0]);
                            }
                            String storedServerName = lockingRS.getString(1);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Stored server value is: " + storedServerName), (Object[])new Object[0]);
                            }
                            if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"This server OWNS the HA lock row", (Object[])new Object[0]);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"it's the local server's failure scope - unset the latch", (Object[])new Object[0]);
                                }
                                int ret = this.setHADBLockLatch(lockingStmt, false);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Have updated HA Lock row's latch return value: " + ret), (Object[])new Object[0]);
                                }
                                success = true;
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Too late, another server has already got the lock", (Object[])new Object[0]);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"There's no locking row!!!", (Object[])new Object[0]);
                        }
                        if (lockingRS == null) break block72;
                        try {
                            lockingRS.close();
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block72;
                            Tr.debug((TraceComponent)tc, (String)"Exception closing ResultsSet", (Object[])new Object[]{e});
                        }
                    }
                    if (lockingStmt != null) {
                        try {
                            lockingStmt.close();
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block73;
                            Tr.debug((TraceComponent)tc, (String)"Exception closing Statement", (Object[])new Object[]{e});
                        }
                    }
                }
                if (success) {
                    try {
                        this._reservedConn.commit();
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception committing connection: ", (Object[])new Object[]{e});
                        }
                        success = false;
                    }
                } else {
                    try {
                        this._reservedConn.rollback();
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception rolling back connection: ", (Object[])new Object[]{e});
                        }
                        break block74;
                    }
                    catch (SQLException sqlex) {
                        block76: {
                            block75: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"SQLException selecting/updating the HADBLock row", (Object[])new Object[]{sqlex});
                                }
                                if (lockingRS == null) break block75;
                                try {
                                    lockingRS.close();
                                }
                                catch (Exception e) {
                                    if (!tc.isDebugEnabled()) break block75;
                                    Tr.debug((TraceComponent)tc, (String)"Exception closing ResultsSet", (Object[])new Object[]{e});
                                }
                            }
                            if (lockingStmt != null) {
                                try {
                                    lockingStmt.close();
                                }
                                catch (Exception e) {
                                    if (!tc.isDebugEnabled()) break block76;
                                    Tr.debug((TraceComponent)tc, (String)"Exception closing Statement", (Object[])new Object[]{e});
                                }
                            }
                        }
                        if (success) {
                            try {
                                this._reservedConn.commit();
                            }
                            catch (Exception e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Exception committing connection: ", (Object[])new Object[]{e});
                                }
                                success = false;
                            }
                        }
                        try {
                            this._reservedConn.rollback();
                        }
                        catch (Exception e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Exception rolling back connection: ", (Object[])new Object[]{e});
                            }
                            break block74;
                        }
                    }
                    catch (Exception e) {
                        block78: {
                            block77: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Exception selecting/updating the HADBLock row ", (Object[])new Object[]{e});
                                }
                                if (lockingRS == null) break block77;
                                {
                                    catch (Throwable throwable) {
                                        block81: {
                                            block80: {
                                                block79: {
                                                    if (lockingRS != null) {
                                                        try {
                                                            lockingRS.close();
                                                        }
                                                        catch (Exception e2) {
                                                            if (!tc.isDebugEnabled()) break block79;
                                                            Tr.debug((TraceComponent)tc, (String)"Exception closing ResultsSet", (Object[])new Object[]{e2});
                                                        }
                                                    }
                                                }
                                                if (lockingStmt != null) {
                                                    try {
                                                        lockingStmt.close();
                                                    }
                                                    catch (Exception e3) {
                                                        if (!tc.isDebugEnabled()) break block80;
                                                        Tr.debug((TraceComponent)tc, (String)"Exception closing Statement", (Object[])new Object[]{e3});
                                                    }
                                                }
                                            }
                                            if (success) {
                                                try {
                                                    this._reservedConn.commit();
                                                }
                                                catch (Exception e4) {
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug((TraceComponent)tc, (String)"Exception committing connection: ", (Object[])new Object[]{e4});
                                                    }
                                                    success = false;
                                                }
                                            } else {
                                                try {
                                                    this._reservedConn.rollback();
                                                }
                                                catch (Exception e5) {
                                                    if (!tc.isDebugEnabled()) break block81;
                                                    Tr.debug((TraceComponent)tc, (String)"Exception rolling back connection: ", (Object[])new Object[]{e5});
                                                }
                                            }
                                        }
                                        throw throwable;
                                    }
                                }
                                try {
                                    lockingRS.close();
                                }
                                catch (Exception e6) {
                                    if (!tc.isDebugEnabled()) break block77;
                                    Tr.debug((TraceComponent)tc, (String)"Exception closing ResultsSet", (Object[])new Object[]{e6});
                                }
                            }
                            if (lockingStmt != null) {
                                try {
                                    lockingStmt.close();
                                }
                                catch (Exception e7) {
                                    if (!tc.isDebugEnabled()) break block78;
                                    Tr.debug((TraceComponent)tc, (String)"Exception closing Statement", (Object[])new Object[]{e7});
                                }
                            }
                        }
                        if (success) {
                            try {
                                this._reservedConn.commit();
                            }
                            catch (Exception e8) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Exception committing connection: ", (Object[])new Object[]{e8});
                                }
                                success = false;
                            }
                        }
                        try {
                            this._reservedConn.rollback();
                        }
                        catch (Exception e9) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Exception rolling back connection: ", (Object[])new Object[]{e9});
                            }
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unlatchHADBLock", (Object)success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertDBTableExists(Connection conn, int initialIsolation) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"assertDBTableExists", (Object[])new Object[]{conn, initialIsolation});
        }
        ResultSet touchRS = null;
        Statement touchStmt = null;
        Object object = _CreateTableLock;
        synchronized (object) {
            try {
                touchStmt = conn.createStatement();
                touchRS = this.readHADBLock(touchStmt);
                if (touchRS != null) {
                    try {
                        touchRS.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (touchStmt != null) {
                    try {
                        touchStmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    conn.rollback();
                }
                catch (Exception exception) {}
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Query failed with exception: " + ex), (Object[])new Object[0]);
                }
                if (touchRS != null) {
                    try {
                        touchRS.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (touchStmt != null) {
                    try {
                        touchStmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    if (conn == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Table Creation failed, null connection", (Object[])new Object[0]);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"assertDBTableExists", (Object)ex);
                        }
                        throw ex;
                    }
                    this.createDBTable(conn);
                }
                catch (Exception createException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Table Creation failed with exception: " + createException), (Object[])new Object[0]);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"assertDBTableExists", (Object)createException);
                    }
                    throw createException;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"assertDBTableExists");
        }
    }

    @FFDCIgnore(value={LogClosedException.class})
    public void heartBeat() throws LogClosedException {
        Throwable nonTransientException;
        boolean sqlSuccess;
        block31: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"heartBeat", (Object[])new Object[]{this._closesRequired, this});
            }
            sqlSuccess = false;
            nonTransientException = null;
            int initialIsolation = 4;
            if (this._closesRequired > 0 && !this._serverStopping && !this.failed()) {
                SQLException currentSqlEx;
                block33: {
                    Connection conn;
                    block32: {
                        currentSqlEx = null;
                        conn = null;
                        try {
                            if (this._dsName == null) {
                                this.configureConnectionParameters();
                                conn = this.getFirstConnection();
                            } else {
                                conn = this.getConnection();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Acquired connection for heartbeat - " + conn), (Object[])new Object[0]);
                            }
                            initialIsolation = this.prepareConnectionForBatch(conn);
                            this.internalHeartBeat(conn);
                            conn.commit();
                            sqlSuccess = true;
                        }
                        catch (SQLException sqlex) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("heartbeat failed with SQL exception: " + sqlex), (Object[])new Object[0]);
                            }
                            currentSqlEx = sqlex;
                            if (conn == null) {
                                nonTransientException = sqlex;
                            }
                        }
                        catch (Exception ex) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("heartbeat failed with general Exception: " + ex), (Object[])new Object[0]);
                            }
                            nonTransientException = ex;
                        }
                        if (sqlSuccess) {
                            try {
                                this.closeConnectionAfterBatch(conn, initialIsolation);
                            }
                            catch (Throwable exc) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Close Failed, after heartbeat success, got exception: " + exc), (Object[])new Object[0]);
                                }
                                break block31;
                            }
                        }
                        try {
                            conn.rollback();
                        }
                        catch (Throwable exc) {
                            if (!tc.isDebugEnabled()) break block32;
                            Tr.debug((TraceComponent)tc, (String)("Rollback Failed, after heartbeat failure, got exception: " + exc), (Object[])new Object[0]);
                        }
                    }
                    try {
                        this.closeConnectionAfterBatch(conn, initialIsolation);
                    }
                    catch (Throwable exc) {
                        if (!tc.isDebugEnabled()) break block33;
                        Tr.debug((TraceComponent)tc, (String)("Close Failed, after heartbeat failure, got exception: " + exc), (Object[])new Object[0]);
                    }
                }
                if (this._sqlTransientErrorHandlingEnabled) {
                    if (nonTransientException == null) {
                        if (this._serverStopping) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"heartbeat", (Object)"Log is not in a fit state for a heartbeat");
                            }
                            throw new LogClosedException();
                        }
                        HeartbeatRetry heartbeatRetry = new HeartbeatRetry();
                        sqlSuccess = heartbeatRetry.retryAndReport(this, this._serverName, currentSqlEx, SQLRetry.getLightweightRetryAttempts(), SQLRetry.getLightweightRetrySleepTime());
                        if (!sqlSuccess) {
                            nonTransientException = heartbeatRetry.getNonTransientException();
                        }
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("Cannot recover from Exception when heartbeating for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
                    }
                } else {
                    if (nonTransientException == null) {
                        nonTransientException = currentSqlEx;
                    }
                    Tr.debug((TraceComponent)tc, (String)("Encountered Exception when heartbeating for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
                }
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"heartbeat", (Object)"Log is not in a fit state for a heartbeat");
                }
                throw new LogClosedException();
            }
        }
        if (!sqlSuccess) {
            Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught Exception when heartbeating SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"heartBeat");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalHeartBeat(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalHeartBeat", (Object[])new Object[]{conn});
        }
        Statement lockingStmt = null;
        ResultSet lockingRS = null;
        try {
            lockingStmt = conn.createStatement();
            String queryString = "SELECT RUSECTION_ID FROM WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + (this._isSQLServer ? " WITH (UPDLOCK)" : "") + " WHERE RU_ID=-1" + (this._isSQLServer ? "" : " FOR UPDATE");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW for UPDATE using - " + queryString), (Object[])new Object[0]);
            }
            if ((lockingRS = lockingStmt.executeQuery(queryString)).next()) {
                long storedTimestamp = lockingRS.getLong(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Acquired lock on HA Lock row, stored timestamp is: " + storedTimestamp), (Object[])new Object[0]);
                }
                long fir1 = System.currentTimeMillis();
                String updateString = "UPDATE WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + " SET RUSECTION_ID = " + fir1 + " WHERE RU_ID = -1";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Update timestamp using using - " + updateString), (Object[])new Object[0]);
                }
                int ret = lockingStmt.executeUpdate(updateString);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have updated HA Lock row with return: " + ret), (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not find HA Lock row, unable to update timestamp", (Object[])new Object[0]);
            }
        }
        finally {
            if (lockingRS != null && !lockingRS.isClosed()) {
                lockingRS.close();
            }
            if (lockingStmt != null && !lockingStmt.isClosed()) {
                lockingStmt.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalHeartBeat");
        }
    }

    public boolean claimLocalRecoveryLogs() {
        boolean isClaimed;
        block31: {
            SQLException currentSqlEx;
            Exception nonTransientException;
            boolean sqlSuccess;
            block33: {
                Connection conn;
                int initialIsolation;
                block32: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"claimLocalRecoveryLogs", (Object[])new Object[]{this});
                    }
                    isClaimed = false;
                    sqlSuccess = false;
                    boolean tableExists = false;
                    nonTransientException = null;
                    initialIsolation = 4;
                    _useNewLockingScheme = true;
                    conn = null;
                    currentSqlEx = null;
                    if (this._serverStopping) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Server is stopping will not claim logs", (Object[])new Object[0]);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"claimLocalRecoveryLogs", (Object)"server stopping");
                        }
                        return isClaimed;
                    }
                    try {
                        if (this._dsName == null) {
                            this.configureConnectionParameters();
                            conn = this.getFirstConnection();
                        } else {
                            conn = this.getConnection();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Acquired connection for attempt to claim local server logs - " + conn), (Object[])new Object[0]);
                        }
                        initialIsolation = this.prepareConnectionForBatch(conn);
                        this.assertDBTableExists(conn, initialIsolation);
                        isClaimed = this.internalClaimRecoveryLogs(conn, true);
                        conn.commit();
                        sqlSuccess = true;
                    }
                    catch (SQLException sqlex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("claimLocalRecoveryLogs failed with SQLException: " + sqlex), (Object[])new Object[0]);
                        }
                        currentSqlEx = sqlex;
                        if (conn == null) {
                            nonTransientException = sqlex;
                        }
                    }
                    catch (Exception exc) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("claimLocalRecoveryLogs failed with Exception: " + exc), (Object[])new Object[0]);
                        }
                        nonTransientException = exc;
                    }
                    if (sqlSuccess) {
                        try {
                            this.closeConnectionAfterBatch(conn, initialIsolation);
                        }
                        catch (Throwable exc) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Close Failed, after claimLocalRecoveryLogs success, got exception: " + exc), (Object[])new Object[0]);
                            }
                            break block31;
                        }
                    }
                    isClaimed = false;
                    try {
                        conn.rollback();
                    }
                    catch (Throwable exc) {
                        if (!tc.isDebugEnabled()) break block32;
                        Tr.debug((TraceComponent)tc, (String)("Rollback Failed, after claimLocalRecoveryLogs failure, got exception: " + exc), (Object[])new Object[0]);
                    }
                }
                try {
                    this.closeConnectionAfterBatch(conn, initialIsolation);
                }
                catch (Throwable exc) {
                    if (!tc.isDebugEnabled()) break block33;
                    Tr.debug((TraceComponent)tc, (String)("Close Failed, after claimLocalRecoveryLogs failure, got exception: " + exc), (Object[])new Object[0]);
                }
            }
            if (this._sqlTransientErrorHandlingEnabled) {
                if (nonTransientException == null) {
                    if (this._serverStopping) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"claimLocalRecoveryLogs", (Object)"server stopping");
                        }
                        return false;
                    }
                    ClaimLocalRetry claimLocalRetry = new ClaimLocalRetry();
                    sqlSuccess = claimLocalRetry.retryAndReport(this, this._serverName, currentSqlEx);
                    if (sqlSuccess) {
                        isClaimed = claimLocalRetry.isClaimed();
                    }
                } else {
                    Tr.debug((TraceComponent)tc, (String)("Cannot recover from Exception when claiming local recovery logs for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
                }
            } else {
                if (nonTransientException == null) {
                    nonTransientException = currentSqlEx;
                }
                Tr.debug((TraceComponent)tc, (String)("Encountered Exception when claiming local recovery logs for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
            }
        }
        if (isClaimed) {
            HeartbeatLogManager.setTimeout((HeartbeatLog)this, (int)this._peerLockTimeBetweenHeartbeats);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimLocalRecoveryLogs", (Object)isClaimed);
        }
        return isClaimed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean internalClaimRecoveryLogs(Connection conn, boolean isHomeServer) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalClaimRecoveryLogs", (Object[])new Object[]{conn, isHomeServer});
        }
        boolean isClaimed = false;
        boolean doUpdate = true;
        String updateString = "";
        String reportString = "";
        Statement lockingStmt = null;
        ResultSet lockingRS = null;
        try {
            long curTimestamp = System.currentTimeMillis();
            lockingStmt = conn.createStatement();
            String queryString = "SELECT SERVER_NAME, RUSECTION_ID FROM WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + (this._isSQLServer ? " WITH (UPDLOCK)" : "") + " WHERE RU_ID=-1" + (this._isSQLServer ? "" : " FOR UPDATE");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW for UPDATE using - " + queryString), (Object[])new Object[0]);
            }
            if ((lockingRS = lockingStmt.executeQuery(queryString)).next()) {
                long fir1;
                String storedServerName = lockingRS.getString(1);
                long storedTimestamp = lockingRS.getLong(2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Acquired lock on HA Lock row, stored server value is: " + storedServerName + ", timestamp is: " + storedTimestamp + ", stale time is: " + _logGoneStaleTime), (Object[])new Object[0]);
                }
                if (isHomeServer) {
                    doUpdate = true;
                    if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This server ALREADY OWNS the HA lock row", (Object[])new Object[0]);
                        }
                        fir1 = System.currentTimeMillis();
                        updateString = "UPDATE WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + " SET RUSECTION_ID = " + fir1 + " WHERE RU_ID = -1";
                        reportString = "Claim the logs for the local server using - ";
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Another server owns the HA lock row, we will aggressively claim it,  WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + ", currenttime: " + curTimestamp + ", storedTime: " + storedTimestamp), (Object[])new Object[0]);
                        }
                        fir1 = System.currentTimeMillis();
                        updateString = "UPDATE WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + " SET SERVER_NAME = '" + this._currentProcessServerName + "', RUSECTION_ID = " + fir1 + " WHERE RU_ID = -1";
                        reportString = "Claim the logs for the local server from a peer using - ";
                    }
                } else if (curTimestamp - storedTimestamp > (long)(_logGoneStaleTime * 1000)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Timestamp is STALE for WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + ", currenttime: " + curTimestamp + ", storedTime: " + storedTimestamp), (Object[])new Object[0]);
                    }
                    fir1 = System.currentTimeMillis();
                    updateString = "UPDATE WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + " SET SERVER_NAME = '" + this._currentProcessServerName + "', RUSECTION_ID = " + fir1 + " WHERE RU_ID = -1";
                    reportString = "Claim peer logs from a peer server using - ";
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Timestamp is NOT STALE for WAS_PARTNER_LOG" + this._recoveryTableNameSuffix + ", currenttime: " + curTimestamp + ", storedTime: " + storedTimestamp), (Object[])new Object[0]);
                    }
                    doUpdate = false;
                }
                if (doUpdate) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(reportString + updateString), (Object[])new Object[0]);
                    }
                    int ret = lockingStmt.executeUpdate(updateString);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Have updated HA Lock row with return: " + ret), (Object[])new Object[0]);
                    }
                    isClaimed = true;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not find HA Lock row, unable to retrieve timestamp", (Object[])new Object[0]);
            }
        }
        finally {
            if (lockingRS != null && !lockingRS.isClosed()) {
                lockingRS.close();
            }
            if (lockingStmt != null && !lockingStmt.isClosed()) {
                lockingStmt.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalClaimRecoveryLogs", (Object)isClaimed);
        }
        return isClaimed;
    }

    public boolean claimPeerRecoveryLogs() {
        boolean isClaimed;
        block30: {
            SQLException currentSqlEx;
            Exception nonTransientException;
            boolean sqlSuccess;
            block32: {
                Connection conn;
                int initialIsolation;
                block31: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"claimPeerRecoveryLogs", (Object[])new Object[]{this});
                    }
                    sqlSuccess = false;
                    isClaimed = false;
                    nonTransientException = null;
                    initialIsolation = 4;
                    _useNewLockingScheme = true;
                    if (this._serverStopping) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Server is stopping will not claim logs", (Object[])new Object[0]);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"claimPeerRecoveryLogs", (Object)"server stopping");
                        }
                        return isClaimed;
                    }
                    conn = null;
                    currentSqlEx = null;
                    try {
                        if (this._dsName == null) {
                            this.configureConnectionParameters();
                            conn = this.getFirstConnection();
                        } else {
                            conn = this.getConnection();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Acquired connection for staleness test - " + conn), (Object[])new Object[0]);
                        }
                        initialIsolation = this.prepareConnectionForBatch(conn);
                        isClaimed = this.internalClaimRecoveryLogs(conn, false);
                        conn.commit();
                        sqlSuccess = true;
                    }
                    catch (SQLException sqlex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("claimPeerRecoveryLogs failed with SQLException: " + sqlex), (Object[])new Object[0]);
                        }
                        currentSqlEx = sqlex;
                        if (conn == null) {
                            nonTransientException = sqlex;
                        }
                    }
                    catch (Exception exc) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("claimPeerRecoveryLogs failed with Exception: " + exc), (Object[])new Object[0]);
                        }
                        nonTransientException = exc;
                    }
                    if (sqlSuccess) {
                        try {
                            this.closeConnectionAfterBatch(conn, initialIsolation);
                        }
                        catch (Throwable exc) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Close Failed, after claimPeerRecoveryLogs success, got exception: " + exc), (Object[])new Object[0]);
                            }
                            break block30;
                        }
                    }
                    isClaimed = false;
                    try {
                        conn.rollback();
                    }
                    catch (Throwable exc) {
                        if (!tc.isDebugEnabled()) break block31;
                        Tr.debug((TraceComponent)tc, (String)("Rollback Failed, after claimPeerRecoveryLogs failure, got exception: " + exc), (Object[])new Object[0]);
                    }
                }
                try {
                    this.closeConnectionAfterBatch(conn, initialIsolation);
                }
                catch (Throwable exc) {
                    if (!tc.isDebugEnabled()) break block32;
                    Tr.debug((TraceComponent)tc, (String)("Close Failed, after claimPeerRecoveryLogs failure, got exception: " + exc), (Object[])new Object[0]);
                }
            }
            if (this._sqlTransientErrorHandlingEnabled) {
                if (nonTransientException == null) {
                    if (this._serverStopping) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"claimPeerRecoveryLogs", (Object)"server stopping");
                        }
                        return false;
                    }
                    ClaimPeerRetry claimPeerRetry = new ClaimPeerRetry();
                    sqlSuccess = claimPeerRetry.retryAndReport(this, this._serverName, currentSqlEx, SQLRetry.getLightweightRetryAttempts(), SQLRetry.getLightweightRetrySleepTime());
                    if (sqlSuccess) {
                        isClaimed = claimPeerRetry.isClaimed();
                    }
                } else {
                    Tr.debug((TraceComponent)tc, (String)("Cannot recover from Exception when claiming peer recovery logs for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
                }
            } else {
                if (nonTransientException == null) {
                    nonTransientException = currentSqlEx;
                }
                Tr.debug((TraceComponent)tc, (String)("Encountered Exception when claiming peer recovery logs for server " + this._serverName + " Exception: " + nonTransientException), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerRecoveryLogs", (Object)isClaimed);
        }
        return isClaimed;
    }

    public void setTimeBeforeLogStale(int timeBeforeStale) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setTimeBeforeLogStale", (Object[])new Object[]{timeBeforeStale});
        }
        _logGoneStaleTime = timeBeforeStale;
    }

    public void setTimeBetweenHeartbeats(int timeBetweenHeartbeats) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setTimeBetweenHeartbeats", (Object[])new Object[]{timeBetweenHeartbeats});
        }
        this._peerLockTimeBetweenHeartbeats = timeBetweenHeartbeats;
    }

    public void setLogRetryInterval(int logRetryInterval) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setLogRetryInterval", (Object[])new Object[]{logRetryInterval});
        }
        SQLRetry.setTransientRetrySleepTime(logRetryInterval * 1000);
    }

    public void setLogRetryLimit(int logRetryLimit) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setLogRetryLimit", (Object[])new Object[]{logRetryLimit});
        }
        SQLRetry.setTransientRetryAttempts(logRetryLimit);
    }

    public void setLightweightLogRetryInterval(int lightweightLogRetryInterval) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setLightweightLogRetryInterval", (Object[])new Object[]{lightweightLogRetryInterval});
        }
        SQLRetry.setLightweightRetrySleepTime(lightweightLogRetryInterval * 1000);
    }

    public void setLightweightLogRetryLimit(int lightweightLogRetryLimit) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setLightweightLogRetryLimit", (Object[])new Object[]{lightweightLogRetryLimit});
        }
        SQLRetry.setLightweightRetryAttempts(lightweightLogRetryLimit);
    }

    public void retainLogsInPeerRecoveryEnv(boolean retainLogs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retainLogsInPeerRecoveryEnv", (Object[])new Object[]{retainLogs, this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retainLogsInPeerRecoveryEnv", (Object)this);
        }
    }

    private InternalLogException reportOperationAttemptWhenStopping(String operation) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reportOperationAttemptWhenStopping", (Object[])new Object[]{operation});
        }
        InternalLogException ile = new InternalLogException("Cannot " + operation + " the log as the server is stopping", null);
        if (!this._isHomeServer) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not the home server, failurescope is " + this._failureScope), (Object[])new Object[0]);
            }
            this.markFailed(ile, false, false);
        } else {
            Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot " + operation + " SQL RecoveryLog " + this._logName + " for server " + this._serverName + " as the server is stopping"), (Object[])new Object[0]);
            this.markFailed(ile);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reportOperationAttemptWhenStopping");
        }
        return ile;
    }

    static {
        int waiterThreshold = 6;
        try {
            waiterThreshold = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() {
                    return Integer.getInteger("com.ibm.ws.recoverylog.custom.jdbc.ThrottleThreshold", 6);
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SqlMultiScopeRecoveryLog", (String)"345");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception setting throttle waiter threshold", (Object[])new Object[]{e});
            }
            waiterThreshold = 6;
        }
        _waiterThreshold = waiterThreshold;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Throttle waiter threshold set to ", (Object[])new Object[]{_waiterThreshold});
        }
        _logGoneStaleTime = 10;
    }

    class OpenLogRetry
    extends SQLRetry {
        OpenLogRetry() {
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"OpenLogRetry.retryCode", (Object[])new Object[]{conn});
            }
            if (SQLMultiScopeRecoveryLog.this._serverStopping) {
                InternalLogException ile = SQLMultiScopeRecoveryLog.this.reportOperationAttemptWhenStopping("open");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"OpenLogRetry.retryCode", (Object)"InternalLogException");
                }
                throw ile;
            }
            int initialIsolation = SQLMultiScopeRecoveryLog.this.prepareConnectionForBatch(conn);
            SQLMultiScopeRecoveryLog.this.assertDBTableExists(conn, initialIsolation);
            SQLMultiScopeRecoveryLog.this.updateHADBLock(conn);
            SQLMultiScopeRecoveryLog.this._recoverableUnits.clear();
            SQLMultiScopeRecoveryLog.this._recUnitIdTable = new RecoverableUnitIdTable();
            SQLMultiScopeRecoveryLog.this.recover(conn);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"OpenLogRetry.retryCode");
            }
        }

        @Override
        public String getOperationDescription() {
            return "opening recovery log";
        }
    }

    class ForceSectionsRetry
    extends SQLRetry {
        ForceSectionsRetry() {
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"ForceSectionsRetry.retryCode", (Object[])new Object[]{conn});
            }
            if (SQLMultiScopeRecoveryLog.this._serverStopping) {
                InternalLogException ile = SQLMultiScopeRecoveryLog.this.reportOperationAttemptWhenStopping("forcing");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"ForceSectionsRetry.retryCode", (Object)"InternalLogException");
                }
                throw ile;
            }
            boolean lockSuccess = SQLMultiScopeRecoveryLog.this.takeHADBLock(conn);
            if (lockSuccess) {
                SQLMultiScopeRecoveryLog.this.executeBatchStatements(conn);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ForceSectionsRetry.retryCode");
            }
        }

        @Override
        public String getOperationDescription() {
            return "forcing sections";
        }
    }

    class HeartbeatRetry
    extends SQLRetry {
        HeartbeatRetry() {
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"HeartbeatRetry.retryCode", (Object[])new Object[]{conn});
            }
            if (SQLMultiScopeRecoveryLog.this._serverStopping) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"HeartbeatRetry.retryCode", (Object)"Log is not in a fit state for a heartbeat");
                }
                throw new LogClosedException();
            }
            SQLMultiScopeRecoveryLog.this.internalHeartBeat(conn);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"HeartbeatRetry.retryCode");
            }
        }

        @Override
        public String getOperationDescription() {
            return "heartbeating";
        }
    }

    class ClaimPeerRetry
    extends SQLRetry {
        boolean _isClaimed = false;

        ClaimPeerRetry() {
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"ClaimPeerRetry.retryCode", (Object[])new Object[]{conn});
            }
            if (SQLMultiScopeRecoveryLog.this._serverStopping) {
                Tr.debug((TraceComponent)tc, (String)"Server is stopping will not claim logs", (Object[])new Object[0]);
            } else {
                this._isClaimed = SQLMultiScopeRecoveryLog.this.internalClaimRecoveryLogs(conn, false);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ClaimPeerRetry.retryCode", (Object)this._isClaimed);
            }
        }

        @Override
        public String getOperationDescription() {
            return "claiming peer recovery logs";
        }

        public boolean isClaimed() {
            return this._isClaimed;
        }
    }

    class ClaimLocalRetry
    extends SQLRetry {
        boolean _isClaimed = false;

        ClaimLocalRetry() {
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"ClaimLocalRetry.retryCode", (Object[])new Object[]{conn});
            }
            if (SQLMultiScopeRecoveryLog.this._serverStopping) {
                Tr.debug((TraceComponent)tc, (String)"Server is stopping will not claim logs", (Object[])new Object[0]);
            } else {
                int initialIsolation = SQLMultiScopeRecoveryLog.this.prepareConnectionForBatch(conn);
                SQLMultiScopeRecoveryLog.this.assertDBTableExists(conn, initialIsolation);
                this._isClaimed = SQLMultiScopeRecoveryLog.this.internalClaimRecoveryLogs(conn, true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ClaimLocalRetry.retryCode", (Object)this._isClaimed);
            }
        }

        public boolean isClaimed() {
            return this._isClaimed;
        }

        @Override
        public String getOperationDescription() {
            return "claiming local recovery logs";
        }
    }

    private class ruForReplay {
        private final long _ruId;
        private final long _sectionId;
        private final int _index;
        private byte[] _data = null;

        public ruForReplay(long ruId, long sectionId, int index, byte[] data) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"ruForReplay", (Object[])new Object[]{ruId, sectionId, index, data});
            }
            this._ruId = ruId;
            this._sectionId = sectionId;
            this._index = index;
            this._data = data;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ruForReplay", (Object)this);
            }
        }

        public long getRuId() {
            return this._ruId;
        }

        public long getSectionId() {
            return this._sectionId;
        }

        public int getIndex() {
            return this._index;
        }

        private byte[] getData() {
            return this._data;
        }
    }
}

