/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.mdb.internal;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BeanOFactory;
import com.ibm.ejs.container.MessageEndpointCollaborator;
import com.ibm.tx.jta.XAResourceNotAvailableException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ejbcontainer.mdb.BMMessageDrivenBeanOFactory;
import com.ibm.ws.ejbcontainer.mdb.CMMessageDrivenBeanOFactory;
import com.ibm.ws.ejbcontainer.mdb.internal.MessageEndpointFactoryImpl;
import com.ibm.ws.ejbcontainer.osgi.EJBContainer;
import com.ibm.ws.ejbcontainer.osgi.EJBRuntimeVersion;
import com.ibm.ws.ejbcontainer.osgi.MDBRuntime;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.injectionengine.osgi.util.JNDIHelper;
import com.ibm.ws.jca.service.AdminObjectService;
import com.ibm.ws.jca.service.EndpointActivationService;
import com.ibm.ws.kernel.feature.ServerStartedPhase2;
import com.ibm.ws.messaging.service.JsMainAdminComponent;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.tx.rrs.RRSXAResourceFactory;
import com.ibm.wsspi.application.lifecycle.ApplicationPrereq;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import jakarta.resource.ResourceException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.ejbcontainer.mdb.internal.MDBRuntimeImpl"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM"})
public class MDBRuntimeImpl
implements MDBRuntime,
ApplicationStateListener,
ApplicationPrereq {
    private static final TraceComponent tc = Tr.register(MDBRuntimeImpl.class, (String)"EJBContainer", (String)"com.ibm.ws.ejbcontainer.mdb.resources.EJBMDBMessages");
    static final String REFERENCE_ENDPOINT_ACTIVATION_SERVICES = "endpointActivationServices";
    static final String REFERENCE_ADMIN_OBJECT_SERVICES = "adminObjectServices";
    private ComponentContext context;
    private final AtomicServiceReference<EJBContainer> ejbContainerSR = new AtomicServiceReference("ejbContainer");
    MetaDataSlot moduleMetaDataSlot;
    private final AtomicServiceReference<RRSXAResourceFactory> rrsXAResFactorySvcRef = new AtomicServiceReference("rRSXAResourceFactory");
    private static final String ACT_SPEC_CFG_ID = "id";
    private final AtomicServiceReference<MessageEndpointCollaborator> messageEndpointCollaboratorRef = new AtomicServiceReference("messageEndpointCollaborator");
    private static final String ACT_SPEC_CFG_MAX_ENDPOINTS = "maxEndpoints";
    private static final String ACT_SPEC_CFG_AUTOSTART = "autoStart";
    private static final String ADMIN_OBJECT_CFG_ID = "id";
    private static final String ADMIN_OBJECT_CFG_JNDI_NAME = "jndiName";
    private static final Version DEFAULT_VERSION = EJBRuntimeVersion.VERSION_3_1;
    private static final String REFERENCE_RUNTIME_VERSION = "ejbRuntimeVersion";
    private Version runtimeVersion = DEFAULT_VERSION;
    private final AtomicServiceReference<EJBRuntimeVersion> runtimeVersionRef = new AtomicServiceReference("ejbRuntimeVersion");
    private final Map<String, NamedAdminObjectServiceInfo> adminObjectServices = new HashMap<String, NamedAdminObjectServiceInfo>();
    private final Map<J2EEName, SchemeJndiNameInfo> schemeJndiNames = new HashMap<J2EEName, SchemeJndiNameInfo>();
    private final Map<String, EndpointActivationServiceInfo> endpointActivationServices = new HashMap<String, EndpointActivationServiceInfo>();
    private volatile boolean isServerStarted;
    private final Set<MessageEndpointFactoryImpl> endpointFactories = new LinkedHashSet<MessageEndpointFactoryImpl>();
    private BeanOFactory ivCMMessageDrivenBeanOFactory;
    private BeanOFactory ivBMMessageDrivenBeanOFactory;
    private static MDBRuntimeImpl instance;
    static final long serialVersionUID = -1765085379359543529L;

    @ManualTrace
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, service=JsMainAdminComponent.class)
    protected void setMessagingRuntimeService(Object jsMainAdminComponent) {
        String methodName = "setMessagingRuntimeService";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMessagingRuntimeService", (Object[])new Object[]{this, jsMainAdminComponent});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setMessagingRuntimeService");
        }
    }

    @Reference(name="ejbRuntimeVersion", service=EJBRuntimeVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void setEJBRuntimeVersion(ServiceReference<EJBRuntimeVersion> ref) {
        this.runtimeVersionRef.setReference(ref);
        this.runtimeVersion = Version.parseVersion((String)((String)ref.getProperty("version")));
    }

    protected synchronized void unsetEJBRuntimeVersion(ServiceReference<EJBRuntimeVersion> ref) {
        this.runtimeVersionRef.unsetReference(ref);
        this.runtimeVersion = DEFAULT_VERSION;
    }

    @Reference(name="ejbContainer", service=EJBContainer.class)
    protected void setEJBContainer(ServiceReference<EJBContainer> reference) {
        this.ejbContainerSR.setReference(reference);
    }

    protected void unsetEJBContainer(ServiceReference<EJBContainer> reference) {
        this.ejbContainerSR.unsetReference(reference);
    }

    @Reference(name="messageEndpointCollaborator", service=MessageEndpointCollaborator.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setMessageEndpointCollaborator(ServiceReference<MessageEndpointCollaborator> reference) {
        this.messageEndpointCollaboratorRef.setReference(reference);
    }

    protected void unsetMessageEndpointCollaborator(ServiceReference<MessageEndpointCollaborator> reference) {
        this.messageEndpointCollaboratorRef.unsetReference(reference);
    }

    @Trivial
    public static MDBRuntimeImpl instance() {
        return instance;
    }

    @Trivial
    private static void setInstance(MDBRuntimeImpl impl) {
        instance = impl;
    }

    @ManualTrace
    public MDBRuntimeImpl() {
        String methodName = "MDBRuntimeImpl";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"MDBRuntimeImpl", (Object[])new Object[]{this});
        }
        MDBRuntimeImpl.setInstance(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"MDBRuntimeImpl");
        }
    }

    @Reference(name="rRSXAResourceFactory", service=RRSXAResourceFactory.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setRRSXAResourceFactory(ServiceReference<RRSXAResourceFactory> ref) {
        this.rrsXAResFactorySvcRef.setReference(ref);
    }

    protected void unsetRRSXAResourceFactory(ServiceReference<RRSXAResourceFactory> ref) {
        this.rrsXAResFactorySvcRef.unsetReference(ref);
    }

    public XAResource getRRSXAResource(String activationSpecId, Xid xid) throws XAResourceNotAvailableException {
        RRSXAResourceFactory factory = (RRSXAResourceFactory)this.rrsXAResFactorySvcRef.getService();
        if (factory == null) {
            return null;
        }
        return factory.getTwoPhaseXAResource(xid);
    }

    @Reference(name="adminObjectServices", service=AdminObjectService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected synchronized void addAdminObjectService(ServiceReference<AdminObjectService> reference) {
        String id = (String)reference.getProperty("id");
        if (id != null) {
            String jndiName = (String)reference.getProperty(ADMIN_OBJECT_CFG_JNDI_NAME);
            this.addAdminObjectService(reference, id, false);
            if (jndiName != null && !jndiName.equals(id)) {
                this.addAdminObjectService(reference, jndiName, true);
            }
        }
    }

    private void addAdminObjectService(ServiceReference<AdminObjectService> reference, String id, boolean jndiName) {
        NamedAdminObjectServiceInfo aosInfo = this.createNamedAdminObjectServiceInfo(id);
        aosInfo.getServices(jndiName).addReference(reference);
        ServiceReference<AdminObjectService> oldServiceRef = aosInfo.serviceRef;
        if (aosInfo.updateServiceRef().equals(reference)) {
            if (oldServiceRef != null) {
                this.deactivateEndpoints(aosInfo.endpointFactories);
            }
            this.activateDeferredEndpoints(aosInfo.endpointFactories);
        }
        this.updateSchemeJndiNames(true);
    }

    private void updateSchemeJndiNames(boolean activating) {
        for (Map.Entry<J2EEName, SchemeJndiNameInfo> entry : this.schemeJndiNames.entrySet()) {
            SchemeJndiNameInfo info = entry.getValue();
            info.updateLookupResult();
            if (activating && info.lookupSucceeded()) {
                this.activateDeferredEndpoints(info.endpointFactories);
                continue;
            }
            if (activating || info.lookupSucceeded()) continue;
            this.deactivateEndpoints(info.endpointFactories);
        }
    }

    protected synchronized void removeAdminObjectService(ServiceReference<AdminObjectService> reference) {
        String id = (String)reference.getProperty("id");
        if (id != null) {
            this.removeAdminObjectService(reference, id, false);
            String jndiName = (String)reference.getProperty(ADMIN_OBJECT_CFG_JNDI_NAME);
            if (jndiName != null && !jndiName.equals(id)) {
                this.removeAdminObjectService(reference, jndiName, true);
            }
        }
    }

    protected void removeAdminObjectService(ServiceReference<AdminObjectService> reference, String id, boolean jndiName) {
        NamedAdminObjectServiceInfo aosInfo = this.adminObjectServices.get(id);
        if (aosInfo != null) {
            aosInfo.getServices(jndiName).removeReference(reference);
            if (reference.equals(aosInfo.serviceRef)) {
                this.deactivateEndpoints(aosInfo.endpointFactories);
                if (aosInfo.updateServiceRef() == null) {
                    this.cleanupAdminObjectServiceInfo(aosInfo);
                } else {
                    this.activateDeferredEndpoints(aosInfo.endpointFactories);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unset reference not the primary reference", (Object[])new Object[0]);
            }
        }
        this.updateSchemeJndiNames(false);
    }

    private NamedAdminObjectServiceInfo createNamedAdminObjectServiceInfo(String id) {
        NamedAdminObjectServiceInfo aosInfo = this.adminObjectServices.get(id);
        if (aosInfo == null) {
            aosInfo = new NamedAdminObjectServiceInfo(id, (ConcurrentServiceReferenceSet<AdminObjectService>)new ConcurrentServiceReferenceSet(REFERENCE_ADMIN_OBJECT_SERVICES), (ConcurrentServiceReferenceSet<AdminObjectService>)new ConcurrentServiceReferenceSet(REFERENCE_ADMIN_OBJECT_SERVICES));
            this.adminObjectServices.put(id, aosInfo);
        }
        return aosInfo;
    }

    private void cleanupAdminObjectServiceInfo(NamedAdminObjectServiceInfo aosInfo) {
        if (aosInfo.serviceRef == null && aosInfo.endpointFactories.isEmpty()) {
            this.endpointActivationServices.remove(aosInfo.id);
        }
    }

    @Reference(name="endpointActivationServices", service=EndpointActivationService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected synchronized void addEndPointActivationService(ServiceReference<EndpointActivationService> reference) {
        EndpointActivationServiceInfo easInfo;
        String activationSvcId = (String)reference.getProperty("id");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activationSvcId : " + activationSvcId), (Object[])new Object[0]);
        }
        if ((easInfo = this.createEndpointActivationServiceInfo(activationSvcId)).service != null) {
            this.deactivateEndpoints(easInfo.endpointFactories);
        }
        easInfo.setReference(reference);
        this.activateDeferredEndpoints(easInfo.endpointFactories);
    }

    protected synchronized void removeEndPointActivationService(ServiceReference<EndpointActivationService> reference) {
        EndpointActivationServiceInfo easInfo;
        String activationSvcId = (String)reference.getProperty("id");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activationSvcId : " + activationSvcId), (Object[])new Object[0]);
        }
        if ((easInfo = this.endpointActivationServices.get(activationSvcId)) != null) {
            if (easInfo.serviceRef.equals(reference)) {
                this.deactivateEndpoints(easInfo.endpointFactories);
                easInfo.setReference(null);
                this.cleanupEndpointActivationServiceInfo(easInfo);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unset reference already removed", (Object[])new Object[0]);
            }
        }
    }

    private EndpointActivationServiceInfo createEndpointActivationServiceInfo(String id) {
        EndpointActivationServiceInfo easInfo = this.endpointActivationServices.get(id);
        if (easInfo == null) {
            easInfo = new EndpointActivationServiceInfo(id);
            this.endpointActivationServices.put(id, easInfo);
        }
        return easInfo;
    }

    private void cleanupEndpointActivationServiceInfo(EndpointActivationServiceInfo easInfo) {
        if (easInfo.serviceRef == null && easInfo.endpointFactories.isEmpty()) {
            this.endpointActivationServices.remove(easInfo.id);
        }
    }

    @ManualTrace
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected synchronized void setServerStartedPhase2(ServerStartedPhase2 serverStartedPhase2) {
        String methodName = "setServerStartedPhase2";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setServerStartedPhase2", (Object[])new Object[]{this, serverStartedPhase2});
        }
        this.isServerStarted = true;
        this.activateDeferredEndpoints(this.endpointFactories);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServerStartedPhase2");
        }
    }

    protected void unsetServerStartedPhase2(ServerStartedPhase2 serverStartedPhase2) {
        this.isServerStarted = false;
    }

    @ManualTrace
    @Activate
    protected void activate(Map<String, Object> props, ComponentContext cc) {
        String methodName = "activate";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"activate", (Object[])new Object[]{this, props, cc});
        }
        this.context = cc;
        this.ejbContainerSR.activate(cc);
        this.rrsXAResFactorySvcRef.activate(cc);
        this.messageEndpointCollaboratorRef.activate(cc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activate");
        }
    }

    protected void deactivate(ComponentContext cc) {
        this.ejbContainerSR.deactivate(cc);
        this.rrsXAResFactorySvcRef.deactivate(cc);
        this.messageEndpointCollaboratorRef.deactivate(cc);
    }

    public BeanOFactory getBeanOFactory(BeanOFactory.BeanOFactoryType type) {
        BeanOFactory factory;
        switch (type) {
            case CM_MESSAGEDRIVEN_BEANO_FACTORY: {
                factory = this.ivCMMessageDrivenBeanOFactory;
                if (factory != null) break;
                this.ivCMMessageDrivenBeanOFactory = factory = new CMMessageDrivenBeanOFactory();
                break;
            }
            case BM_MESSAGEDRIVEN_BEANO_FACTORY: {
                factory = this.ivBMMessageDrivenBeanOFactory;
                if (factory != null) break;
                this.ivBMMessageDrivenBeanOFactory = factory = new BMMessageDrivenBeanOFactory();
                break;
            }
            default: {
                factory = null;
            }
        }
        return factory;
    }

    public Class<?> getMessageEndpointFactoryImplClass(BeanMetaData bmd) throws ClassNotFoundException {
        return MessageEndpointFactoryImpl.class;
    }

    public Class<?> getMessageEndpointImplClass(BeanMetaData bmd) throws ClassNotFoundException {
        return null;
    }

    public MessageEndpointCollaborator getMessageEndpointCollaborator() {
        return (MessageEndpointCollaborator)this.messageEndpointCollaboratorRef.getService();
    }

    @Reference(name="metaDataSlotService", service=MetaDataSlotService.class)
    protected void setMetaDataSlotService(MetaDataSlotService slotService) {
        this.moduleMetaDataSlot = slotService.reserveMetaDataSlot(ModuleMetaData.class);
    }

    protected void unsetMetaDataSlotService(MetaDataSlotService slotService) {
    }

    @ManualTrace
    synchronized void activateEndpoint(MessageEndpointFactoryImpl mef) throws ResourceException {
        String methodName = "activateEndpoint";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"activateEndpoint", (Object[])new Object[]{this, mef});
        }
        mef.endpointActivationServiceInfo = this.createEndpointActivationServiceInfo(mef.getActivationSpecId());
        if (!mef.endpointActivationServiceInfo.getAutoStart() && !mef.shouldActivate) {
            Tr.info((TraceComponent)tc, (String)"MDB_ENDPOINT_NOT_ACTIVATED_AUTOSTART_CNTR4116I", (Object[])new Object[]{mef.getJ2EEName().getComponent(), mef.getJ2EEName().getModule(), mef.getJ2EEName().getApplication(), mef.endpointActivationServiceInfo.id});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"activateEndpoint");
            }
            return;
        }
        mef.endpointActivationServiceInfo.addReferencingEndpoint(mef);
        String destId = mef.getDestinationId();
        if (destId == null) {
            if (this.runtimeVersion.compareTo(DEFAULT_VERSION) == 0) {
                destId = mef.getBeanMetaData().ivActivationConfig.getProperty("destination");
            } else {
                BeanMetaData bmd = mef.getBeanMetaData();
                String destLookup = bmd.ivActivationConfig.getProperty("destinationLookup");
                if (destLookup != null && JNDIHelper.hasJNDIScheme((String)destLookup)) {
                    SchemeJndiNameInfo jndiInfo = new SchemeJndiNameInfo(destLookup, bmd);
                    jndiInfo.updateLookupResult();
                    this.schemeJndiNames.put(bmd.j2eeName, new SchemeJndiNameInfo(destLookup, bmd));
                    mef.schemeJndiNameInfo = this.schemeJndiNames.get(bmd.j2eeName);
                    mef.schemeJndiNameInfo.addReferencingEndpoint(mef);
                } else if (destLookup != null) {
                    destId = destLookup;
                    mef.getBeanMetaData().ivMessageDestinationJndiName = destLookup;
                }
                if (destId == null) {
                    destId = mef.getBeanMetaData().ivActivationConfig.getProperty("destination");
                }
            }
        }
        if (destId != null && !JNDIHelper.hasJNDIScheme((String)destId)) {
            mef.adminObjectServiceInfo = this.createNamedAdminObjectServiceInfo(destId);
            mef.adminObjectServiceInfo.addReferencingEndpoint(mef);
        }
        this.endpointFactories.add(mef);
        this.activateEndpointInternal(mef, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activateEndpoint");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void activateDeferredEndpoints(Set<MessageEndpointFactoryImpl> mefs) {
        for (MessageEndpointFactoryImpl mef : mefs) {
            if (mef.runtimeActivated) continue;
            try {
                if (!mef.endpointActivationServiceInfo.getAutoStart() && !mef.shouldActivate) {
                    Tr.info((TraceComponent)tc, (String)"MDB_ENDPOINT_NOT_ACTIVATED_AUTOSTART_CNTR4116I", (Object[])new Object[]{mef.getJ2EEName().getComponent(), mef.getJ2EEName().getModule(), mef.getJ2EEName().getApplication(), mef.endpointActivationServiceInfo.id});
                    return;
                }
                this.activateEndpointInternal(mef, false);
            }
            catch (Throwable throwable) {
                void ex;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.mdb.internal.MDBRuntimeImpl", (String)"905", (Object)this, (Object[])new Object[]{mefs});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Ignoring unexpected exception : " + ex), (Object[])new Object[0]);
            }
        }
    }

    private void activateEndpointInternal(MessageEndpointFactoryImpl mef, boolean explicit) throws ResourceException {
        EndpointActivationService eas;
        if (mef.adminObjectServiceInfo != null && mef.adminObjectServiceInfo.serviceRef == null) {
            if (explicit) {
                Tr.warning((TraceComponent)tc, (String)"MDB_DESTINATION_NOT_FOUND_CNTR4016W", (Object[])new Object[]{mef.getJ2EEName().getComponent(), mef.adminObjectServiceInfo.id});
            }
            return;
        }
        if (mef.schemeJndiNameInfo != null && !mef.schemeJndiNameInfo.lookupSucceeded() && explicit) {
            Tr.warning((TraceComponent)tc, (String)"MDB_DESTINATION_NOT_FOUND_CNTR4016W", (Object[])new Object[]{mef.getJ2EEName().getComponent(), mef.schemeJndiNameInfo.getJndiName()});
        }
        if ((eas = mef.endpointActivationServiceInfo.getService()) == null) {
            if (explicit) {
                Tr.warning((TraceComponent)tc, (String)"MDB_ACTIVATION_SPEC_NOT_FOUND_CNTR4015W", (Object[])new Object[]{mef.getJ2EEName().getComponent(), mef.endpointActivationServiceInfo.id});
            }
            return;
        }
        if (!this.isServerStarted) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"server is not started", (Object[])new Object[0]);
            }
            return;
        }
        mef.activateEndpointInternal(eas, mef.endpointActivationServiceInfo.getMaxEndpoints(), mef.adminObjectServiceInfo == null ? null : (AdminObjectService)this.context.locateService(REFERENCE_ADMIN_OBJECT_SERVICES, mef.adminObjectServiceInfo.serviceRef));
        mef.runtimeActivated = true;
    }

    synchronized void deactivateEndpoint(MessageEndpointFactoryImpl mef) {
        if (mef.adminObjectServiceInfo != null) {
            mef.adminObjectServiceInfo.removeReferencingEndpoint(mef);
            this.cleanupAdminObjectServiceInfo(mef.adminObjectServiceInfo);
        }
        if (mef.schemeJndiNameInfo != null) {
            mef.schemeJndiNameInfo.removeReferencingEndpoint(mef);
            this.schemeJndiNames.remove(mef.schemeJndiNameInfo.getBMD().j2eeName);
        }
        mef.endpointActivationServiceInfo.removeReferencingEndpoint(mef);
        this.cleanupEndpointActivationServiceInfo(mef.endpointActivationServiceInfo);
        this.endpointFactories.remove(mef);
        if (mef.runtimeActivated) {
            this.deactivateEndpointInternal(mef);
        }
    }

    private void deactivateEndpoints(Set<MessageEndpointFactoryImpl> mefs) {
        for (MessageEndpointFactoryImpl mef : mefs) {
            if (!mef.runtimeActivated) continue;
            this.deactivateEndpointInternal(mef);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deactivateEndpointInternal(MessageEndpointFactoryImpl mef) {
        block2: {
            mef.runtimeActivated = false;
            EndpointActivationService eas = mef.endpointActivationServiceInfo.getService();
            try {
                mef.deactivateEndpointInternal(eas);
            }
            catch (Throwable throwable) {
                void ex;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.mdb.internal.MDBRuntimeImpl", (String)"1020", (Object)this, (Object[])new Object[]{mef});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Ignoring unexpected exception : " + ex), (Object[])new Object[0]);
            }
        }
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
        this.updateSchemeJndiNames(true);
    }

    public void applicationStopping(ApplicationInfo appInfo) {
        this.updateSchemeJndiNames(false);
    }

    public void applicationStopped(ApplicationInfo appInfo) {
    }

    public String getApplicationPrereqID() {
        return "MDBRuntime";
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class EndpointActivationServiceInfo
    extends ReferencingEndpointFactorySet {
        private ServiceReference<EndpointActivationService> serviceRef;
        private EndpointActivationService service;
        private Integer maxEndpoints;
        private Boolean autoStart;
        static final long serialVersionUID = 2586602274838820905L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EndpointActivationServiceInfo(String id) {
            super(id);
        }

        void setReference(ServiceReference<EndpointActivationService> ref) {
            this.serviceRef = ref;
            this.service = null;
            this.maxEndpoints = null;
            this.autoStart = null;
        }

        EndpointActivationService getService() {
            if (this.serviceRef == null) {
                return null;
            }
            if (this.service == null) {
                this.service = (EndpointActivationService)MDBRuntimeImpl.this.context.locateService(MDBRuntimeImpl.REFERENCE_ENDPOINT_ACTIVATION_SERVICES, this.serviceRef);
            }
            return this.service;
        }

        int getMaxEndpoints() {
            if (this.maxEndpoints == null) {
                this.maxEndpoints = (Integer)this.serviceRef.getProperty(MDBRuntimeImpl.ACT_SPEC_CFG_MAX_ENDPOINTS);
            }
            return this.maxEndpoints;
        }

        boolean getAutoStart() {
            if (this.serviceRef == null) {
                return true;
            }
            if (this.autoStart == null) {
                this.autoStart = (Boolean)this.serviceRef.getProperty(MDBRuntimeImpl.ACT_SPEC_CFG_AUTOSTART);
            }
            return this.autoStart;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.ejbcontainer.mdb.internal.MDBRuntimeImpl$EndpointActivationServiceInfo", EndpointActivationServiceInfo.class, (String)"EJBContainer", (String)"com.ibm.ws.ejbcontainer.mdb.resources.EJBMDBMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class SchemeJndiNameInfo
    extends ReferencingEndpointFactorySet {
        private final String jndiName;
        private Object lookupResult;
        private final BeanMetaData bmd;
        static final long serialVersionUID = 7681962962752555217L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SchemeJndiNameInfo(String name, BeanMetaData bmd) {
            super(name);
            this.jndiName = name;
            this.bmd = bmd;
        }

        @FFDCIgnore(value={NamingException.class})
        void updateLookupResult() {
            ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            try {
                cmdai.beginContext((ComponentMetaData)this.bmd);
                this.lookupResult = new InitialContext().lookup(this.jndiName);
            }
            catch (NamingException e) {
                this.lookupResult = null;
            }
            finally {
                cmdai.endContext();
            }
        }

        boolean lookupSucceeded() {
            return this.lookupResult != null;
        }

        String getJndiName() {
            return this.jndiName;
        }

        BeanMetaData getBMD() {
            return this.bmd;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.ejbcontainer.mdb.internal.MDBRuntimeImpl$SchemeJndiNameInfo", SchemeJndiNameInfo.class, (String)"EJBContainer", (String)"com.ibm.ws.ejbcontainer.mdb.resources.EJBMDBMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class NamedAdminObjectServiceInfo
    extends ReferencingEndpointFactorySet {
        private final ConcurrentServiceReferenceSet<AdminObjectService> idServices;
        private final ConcurrentServiceReferenceSet<AdminObjectService> jndiNameServices;
        ServiceReference<AdminObjectService> serviceRef;
        static final long serialVersionUID = 4383797908158168740L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        NamedAdminObjectServiceInfo(String id, ConcurrentServiceReferenceSet<AdminObjectService> idServices, ConcurrentServiceReferenceSet<AdminObjectService> jndiNameServices) {
            super(id);
            this.idServices = idServices;
            this.jndiNameServices = jndiNameServices;
        }

        ConcurrentServiceReferenceSet<AdminObjectService> getServices(boolean jndiName) {
            return jndiName ? this.jndiNameServices : this.idServices;
        }

        ServiceReference<AdminObjectService> updateServiceRef() {
            this.serviceRef = this.idServices.getHighestRankedReference();
            if (this.serviceRef == null) {
                this.serviceRef = this.jndiNameServices.getHighestRankedReference();
            }
            return this.serviceRef;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.ejbcontainer.mdb.internal.MDBRuntimeImpl$NamedAdminObjectServiceInfo", NamedAdminObjectServiceInfo.class, (String)"EJBContainer", (String)"com.ibm.ws.ejbcontainer.mdb.resources.EJBMDBMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ReferencingEndpointFactorySet {
        final String id;
        final Set<MessageEndpointFactoryImpl> endpointFactories = new LinkedHashSet<MessageEndpointFactoryImpl>();
        static final long serialVersionUID = -4476521819764587538L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ReferencingEndpointFactorySet(String id) {
            this.id = id;
        }

        void addReferencingEndpoint(MessageEndpointFactoryImpl mef) {
            this.endpointFactories.add(mef);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.id + " now has " + this.endpointFactories.size() + " endpoints"), (Object[])new Object[0]);
            }
        }

        void removeReferencingEndpoint(MessageEndpointFactoryImpl mef) {
            this.endpointFactories.remove(mef);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.id + " now has " + this.endpointFactories.size() + " endpoints"), (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.ejbcontainer.mdb.internal.MDBRuntimeImpl$ReferencingEndpointFactorySet", ReferencingEndpointFactorySet.class, (String)"EJBContainer", (String)"com.ibm.ws.ejbcontainer.mdb.resources.EJBMDBMessages");
        }
    }
}

