/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.ltc.impl.LocalTranCurrentSet;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.tx.UOWEventListener;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.xa.XAResource;

public class TranManagerImpl {
    private static final TraceComponent tc = Tr.register(TranManagerImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int DEFAULT_TX_TIMEOUT = 0;
    private static Set<UOWEventListener> _UOWEventListeners;
    protected int txTimeout;
    protected TransactionImpl tx;

    public TranManagerImpl() {
        ConfigurationProvider cp;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TranManagerImpl", (Object[])new Object[0]);
        }
        if ((cp = ConfigurationProviderManager.getConfigurationProvider()) == null) {
            throw new IllegalStateException();
        }
        this.txTimeout = cp.getTotalTransactionLifetimeTimeout();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TranManagerImpl", (Object)this);
        }
    }

    public void begin(int timeout) throws NotSupportedException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"begin", (Object[])new Object[]{"(SPI)"});
        }
        if (this.tx != null) {
            Tr.error((TraceComponent)tc, (String)"WTRN0017_UNABLE_TO_BEGIN_NESTED_TRANSACTION", (Object[])new Object[0]);
            NotSupportedException nse = new NotSupportedException("Nested transactions are not supported.");
            FFDCFilter.processException((Throwable)nse, (String)"com.ibm.tx.jta.impl.TranManagerImpl.begin", (String)"135", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"begin", (Object)new Object[]{"(SPI)", nse});
            }
            throw nse;
        }
        this.tx = this.createNewTransaction(timeout);
        this.invokeEventListener(this.tx, 1, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"begin", (Object)"(SPI)");
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(this.txTimeout);
    }

    protected TransactionImpl createNewTransaction(int timeout) throws SystemException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"createNewTransaction", (Object[])new Object[]{timeout});
        }
        TransactionImpl tx = new TransactionImpl(timeout);
        tx.setMostRecentThread(Thread.currentThread());
        return tx;
    }

    public void beginUserTran() throws NotSupportedException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"beginUserTran", (Object[])new Object[]{this});
        }
        if (this.tx != null) {
            Tr.error((TraceComponent)tc, (String)"WTRN0017_UNABLE_TO_BEGIN_NESTED_TRANSACTION", (Object[])new Object[0]);
            NotSupportedException nse = new NotSupportedException("Nested transactions are not supported.");
            FFDCFilter.processException((Throwable)nse, (String)"com.ibm.tx.jta.impl.TranManagerImpl.beginUserTran", (String)"159", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"beginUserTran", (Object)nse);
            }
            throw nse;
        }
        this.tx = this.createNewTransaction(this.txTimeout);
        this.invokeEventListener(this.tx, 1, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beginUserTran", (Object)this.tx);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit", (Object[])new Object[]{"(SPI)"});
        }
        if (this.tx == null) {
            String msg = "No transaction associated with this thread";
            IllegalStateException ise = new IllegalStateException("No transaction associated with this thread");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.impl.TranManagerImpl.commit", (String)"167", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        TransactionImpl completingTx = this.tx;
        try {
            this.tx.commit();
        }
        finally {
            this.invokeEventListener(completingTx, 3, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)"(SPI)");
            }
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollback", (Object[])new Object[]{"(SPI)"});
        }
        if (this.tx == null) {
            String msg = "No transaction associated with this thread";
            IllegalStateException ise = new IllegalStateException("No transaction associated with this thread");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.impl.TranManagerImpl.rollback", (String)"193", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        TransactionImpl completingTx = this.tx;
        try {
            this.tx.rollback();
        }
        finally {
            this.invokeEventListener(completingTx, 3, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"(SPI)");
            }
        }
    }

    public Transaction suspend() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"suspend", (Object[])new Object[]{"(SPI)", this});
        }
        TransactionImpl suspended = null;
        if (this.tx != null) {
            if (this.tx.getTxType() != 2) {
                suspended = this.tx;
                this.tx = null;
                this.invokeEventListener(suspended, 100, null);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"the tx is NONINTEROP_GLOBAL it should not be suspended", (Object[])new Object[0]);
                }
                this.tx = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"suspend", (Object)new Object[]{"(SPI)", suspended});
        }
        return suspended;
    }

    public void resume(Transaction t) throws InvalidTransactionException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resume", (Object[])new Object[]{"(SPI)", t});
        }
        if (this.tx != null) {
            String msg = "Thread is already associated with a transaction";
            IllegalStateException ise = new IllegalStateException("Thread is already associated with a transaction");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.impl.TranManagerImpl.resume", (String)"249", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resume", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        try {
            if (t != null) {
                switch (((TransactionImpl)t).getTransactionState().getState()) {
                    case -1: 
                    case 4: 
                    case 6: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Attempting to resume an inactive transaction", (Object[])new Object[0]);
                        }
                        throw new IllegalStateException();
                    }
                }
                this.tx = (TransactionImpl)t;
                this.tx.setMostRecentThread(Thread.currentThread());
            }
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.TranManagerImpl.resume", (String)"201", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception caught checking transaction state", (Object[])new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resume", (Object)"(SPI)");
            }
            throw new InvalidTransactionException();
        }
        if (this.tx != null && this.tx.getTxType() != 2) {
            this.invokeEventListener(this.tx, 110, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resume", (Object)"(SPI)");
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRollbackOnly", (Object[])new Object[]{"(SPI)"});
        }
        if (this.tx == null) {
            String msg = "No transaction associated with this thread";
            IllegalStateException ise = new IllegalStateException("No transaction associated with this thread");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.impl.TranManagerImpl.setRollbackOnly", (String)"303", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setRollbackOnly", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        try {
            this.tx.setRollbackOnly();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setRollbackOnly", (Object)"(SPI)");
            }
        }
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTransactionTimeout", (Object[])new Object[]{"(SPI)", timeout});
        }
        if (timeout > 0) {
            this.txTimeout = timeout == Integer.MAX_VALUE ? 0 : timeout;
        } else if (timeout == 0) {
            this.txTimeout = ConfigurationProviderManager.getConfigurationProvider().getTotalTransactionLifetimeTimeout();
            if (this.txTimeout == 0) {
                this.txTimeout = 0;
            }
        } else {
            SystemException se = new SystemException("Transaction timeout value must be >= 0");
            FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.impl.TranManagerImpl.setTransactionTimeout", (String)"206", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setTransactionTimeout", (Object)new Object[]{"(SPI)", se});
            }
            throw se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTransactionTimeout", (Object)new Object[]{"(SPI)", this.txTimeout});
        }
    }

    public int getStatus() {
        int status = 6;
        if (this.tx != null) {
            status = this.tx.getStatus();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getStatus (SPI)", (Object[])new Object[]{Util.printStatus(status)});
        }
        return status;
    }

    public Transaction getTransaction() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTransaction (SPI)", (Object[])new Object[]{this, this.tx, new Exception("SPI Stack Trace")});
        }
        return this.tx;
    }

    public TransactionImpl getTransactionImpl() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTransactionImpl", (Object[])new Object[]{this, this.tx});
        }
        return this.tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlist(XAResource xaRes, int recoveryId) throws RollbackException, IllegalStateException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enlist", (Object[])new Object[]{xaRes, recoveryId});
        }
        if (this.tx == null) {
            String msg = "No transaction associated with this thread";
            IllegalStateException ise = new IllegalStateException("No transaction associated with this thread");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.impl.TranManagerImpl.enlist", (String)"470", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlist", (Object)ise);
            }
            throw ise;
        }
        boolean ret = false;
        try {
            ret = this.tx.enlistResource(xaRes, recoveryId);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlist", (Object)ret);
            }
        }
        return ret;
    }

    public boolean delist(XAResource xaRes, int flag) {
        boolean ret;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"delist", (Object[])new Object[]{xaRes, Util.printFlag(flag)});
            }
            if (this.tx == null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"The transaction was not found.", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"delist", (Object)Boolean.FALSE);
                }
                return false;
            }
            ret = false;
            try {
                ret = this.tx.delistResource(xaRes, flag);
            }
            catch (Exception e) {
                if (!tc.isEventEnabled()) break block7;
                Tr.event((TraceComponent)tc, (String)"delist exception absorbed", (Object[])new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delist", (Object)ret);
        }
        return ret;
    }

    public UOWCoordinator getUOWCoord() {
        UOWCoordinator uow;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUOWCoord", (Object[])new Object[]{this});
        }
        if ((uow = this.tx) == null) {
            uow = (UOWCoordinator)((Object)LocalTranCurrentSet.instance().getLocalTranCoord());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUOWCoord", (Object)uow);
        }
        return uow;
    }

    public synchronized void setUOWEventListener(UOWEventListener el) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setUOWEventListener", (Object[])new Object[]{el});
        }
        if (_UOWEventListeners == null) {
            _UOWEventListeners = new HashSet<UOWEventListener>();
        }
        _UOWEventListeners.add(el);
    }

    public synchronized void unsetUOWEventListener(UOWEventListener el) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetUOWEventListener", (Object[])new Object[]{el});
        }
        if (_UOWEventListeners != null) {
            _UOWEventListeners.remove(el);
        }
    }

    public synchronized void invokeEventListener(UOWCoordinator uowc, int event, Object data) {
        if (_UOWEventListeners != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invokeEventListener", (Object[])new Object[]{uowc, event, data});
            }
            for (UOWEventListener el : _UOWEventListeners) {
                el.UOWEvent(uowc, event, data);
            }
        }
    }
}

