/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.ConduitConfigurerService;
import com.ibm.ws.jaxws.JaxwsConduitConfigActivator;
import com.ibm.ws.jaxws.JaxwsHttpConduitConfigApplier;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConduitConfigurer
extends ConduitConfigurerService
implements HTTPConduitConfigurer {
    private static final TraceComponent tc = Tr.register(ConduitConfigurer.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
    public static final String FACTORY_PID = "org.apache.cxf.http.conduits";
    Map<String, PidInfo> props = new ConcurrentHashMap<String, PidInfo>(4, 0.75f, 2);
    CopyOnWriteArrayList<PidInfo> sorted = new CopyOnWriteArrayList();
    static final long serialVersionUID = -5869501206223823483L;

    public ConduitConfigurer(BundleContext context) {
        super(context);
        Bus[] buses = (Bus[])this.getServices();
        if (buses == null) {
            return;
        }
        for (Bus bus : buses) {
            bus.setExtension((Object)this, HTTPConduitConfigurer.class);
        }
    }

    public ConduitConfigurer() {
        super(JaxwsConduitConfigActivator.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(String name, String address, HTTPConduit c) {
        PidInfo byName = null;
        PidInfo byAddress = null;
        if (name != null) {
            byName = this.props.get(name);
        }
        if (address != null && (byAddress = this.props.get(address)) == byName) {
            byAddress = null;
        }
        JaxwsHttpConduitConfigApplier applier = new JaxwsHttpConduitConfigApplier();
        for (PidInfo info : this.sorted) {
            Matcher m;
            if (info.getMatcher() == null || info == byName || info == byAddress) continue;
            Matcher matcher = m = info.getMatcher();
            synchronized (matcher) {
                m.reset(address);
                if (m.matches()) {
                    applier.apply(info.getProps(), c, address);
                }
            }
        }
        if (byAddress != null) {
            applier.apply(byAddress.getProps(), c, address);
        }
        if (byName != null) {
            applier.apply(byName.getProps(), c, address);
        }
    }

    public String getName() {
        return FACTORY_PID;
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        if (pid == null) {
            return;
        }
        this.deleted(pid);
        String url = (String)properties.get("url");
        String name = (String)properties.get("name");
        Matcher matcher = url == null ? null : Pattern.compile(url).matcher("");
        String p = (String)properties.get("order");
        int order = 50;
        if (p != null) {
            order = Integer.parseInt(p);
        }
        PidInfo info = new PidInfo(properties, matcher, order);
        this.props.put(pid, info);
        if (url != null) {
            this.props.put(url, info);
        }
        if (name != null) {
            this.props.put(name, info);
        }
        this.addToSortedInfos(info);
    }

    private synchronized void addToSortedInfos(PidInfo pi) {
        int size = this.sorted.size();
        for (int x = 0; x < size; ++x) {
            PidInfo p = this.sorted.get(x);
            if (pi.compareTo(p) >= 0) continue;
            this.sorted.add(x, pi);
            return;
        }
        this.sorted.add(pi);
    }

    private synchronized void removeFromSortedInfos(PidInfo pi) {
        this.sorted.remove(pi);
    }

    public void deleted(String pid) {
        PidInfo info = this.props.remove(pid);
        if (info == null) {
            return;
        }
        this.removeFromSortedInfos(info);
        Dictionary<String, String> d = info.getProps();
        if (d != null) {
            String url = d.get("url");
            String name = d.get("name");
            if (url != null) {
                this.props.remove(url);
            }
            if (name != null) {
                this.props.remove(name);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class PidInfo
    implements Comparable<PidInfo> {
        final Dictionary<String, String> props;
        final Matcher matcher;
        final int order;
        static final long serialVersionUID = 834472049403328398L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        PidInfo(Dictionary<String, String> p, Matcher m, int o) {
            this.matcher = m;
            this.props = p;
            this.order = o;
        }

        public Dictionary<String, String> getProps() {
            return this.props;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        @Override
        public int compareTo(PidInfo o) {
            if (this.order < o.order) {
                return -1;
            }
            if (this.order > o.order) {
                return 1;
            }
            if (this.matcher != null) {
                if (o.matcher == null) {
                    return -1;
                }
                return this.matcher.pattern().toString().compareTo(o.matcher.pattern().toString());
            }
            return 0;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.ConduitConfigurer$PidInfo", PidInfo.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
        }
    }
}

