/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health30.internal;

import com.ibm.websphere.jsonsupport.JSON;
import com.ibm.websphere.jsonsupport.JSONFactory;
import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.jsonsupport.JSONSettings;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.health.HealthCheckResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheck30HttpResponseBuilder {
    private static final TraceComponent tc = Tr.register(HealthCheck30HttpResponseBuilder.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    protected HealthCheckResponse.Status overallStatus = HealthCheckResponse.Status.UP;
    protected final ArrayList<Map<String, Object>> checks = new ArrayList();
    JSON json = null;
    static final long serialVersionUID = 2647021919642971438L;

    public void addResponses(Set<HealthCheckResponse> hcResponseSet) {
        for (HealthCheckResponse hcResponse : hcResponseSet) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addResponse(): hcResponse = " + hcResponse), (Object[])new Object[0]);
            }
            this.setChecks(hcResponse);
        }
    }

    public void setHttpResponse(HttpServletResponse httpResponse) {
        httpResponse.setHeader("Content-Type", "application/json; charset=UTF-8");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        httpResponse.setStatus(this.overallStatus == HealthCheckResponse.Status.UP ? 200 : 503);
        payload.put("status", this.overallStatus);
        payload.put("checks", this.checks.toArray());
        this.setJSONPayload(payload, httpResponse);
    }

    public void handleUndeterminedResponse(HttpServletResponse httpResponse) {
        httpResponse.setStatus(500);
    }

    protected void setChecks(HealthCheckResponse response) {
        Optional data;
        HashMap<String, String> check = new HashMap<String, String>();
        check.put("name", response.getName());
        HealthCheckResponse.Status checkStatus = response.getStatus();
        check.put("status", (String)checkStatus);
        if (checkStatus != null) {
            if (checkStatus.equals((Object)HealthCheckResponse.Status.DOWN)) {
                this.overallStatus = HealthCheckResponse.Status.DOWN;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setChecks(): checkStatus is null", (Object[])new Object[0]);
            }
            this.overallStatus = HealthCheckResponse.Status.DOWN;
        }
        if ((data = response.getData()) != null && data.isPresent()) {
            check.put("data", (String)data.get());
        }
        this.checks.add(check);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setChecks(): checks = " + this.checks), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setJSONPayload(Map<String, Object> payload, HttpServletResponse httpResponse) {
        try {
            JSON jsonService = this.getJSON();
            httpResponse.getOutputStream().write(jsonService.asBytes(payload));
        }
        catch (IOException jsonService) {
            FFDCFilter.processException((Throwable)jsonService, (String)"io.openliberty.microprofile.health30.internal.HealthCheck30HttpResponseBuilder", (String)"119", (Object)this, (Object[])new Object[]{payload, httpResponse});
            if (tc.isEventEnabled()) {
                void e;
                Tr.event((TraceComponent)tc, (String)"Unexpected IOException while writing out POJO response", (Object[])new Object[]{e});
            }
            httpResponse.setStatus(500);
        }
        catch (JSONMarshallException e) {
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.microprofile.health30.internal.HealthCheck30HttpResponseBuilder", (String)"124", (Object)this, (Object[])new Object[]{payload, httpResponse});
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected JSONMarshallException while getting the JSON service", (Object[])new Object[]{e});
            }
            httpResponse.setStatus(500);
        }
    }

    private JSON getJSON() throws JSONMarshallException {
        if (this.json == null) {
            JSONSettings settings = new JSONSettings(JSONSettings.Include.NON_NULL);
            this.json = JSONFactory.newInstance((JSONSettings)settings);
        }
        return this.json;
    }

    public void setOverallStatus(HealthCheckResponse.Status status) {
        this.overallStatus = status;
    }
}

