/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.processor;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.injectionengine.AbstractInjectionEngine;
import com.ibm.ws.injectionengine.InjectionScopeData;
import com.ibm.ws.injectionengine.annotation.ResourceImpl;
import com.ibm.ws.injectionengine.processor.ResourceInjectionBinding;
import com.ibm.ws.injectionengine.processor.ResourceXMLType;
import com.ibm.ws.javaee.dd.common.Describable;
import com.ibm.ws.javaee.dd.common.Description;
import com.ibm.ws.javaee.dd.common.EnvEntry;
import com.ibm.ws.javaee.dd.common.InjectionTarget;
import com.ibm.ws.javaee.dd.common.MessageDestinationRef;
import com.ibm.ws.javaee.dd.common.ResourceEnvRef;
import com.ibm.ws.javaee.dd.common.ResourceRef;
import com.ibm.ws.resource.ResourceRefConfig;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigConstants;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import com.ibm.wsspi.injectionengine.InjectionScope;
import com.ibm.wsspi.injectionengine.InternalInjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.ObjectFactoryInfo;
import com.ibm.wsspi.injectionengine.factory.IndirectJndiLookupReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.MBLinkReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.ResAutoLinkReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.ResRefReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.ResourceInfo;
import com.ibm.wsspi.injectionengine.factory.ResourceInfoRefAddr;
import jakarta.annotation.ManagedBean;
import jakarta.annotation.Resource;
import jakarta.annotation.Resources;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Reference;

public class ResourceProcessor
extends InjectionProcessor<Resource, Resources> {
    private static final String CLASS_NAME = ResourceProcessor.class.getName();
    private static final TraceComponent tc = Tr.register(ResourceProcessor.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private ResourceRefConfigList ivResRefList;
    private Map<String, String> ivResRefBindings;
    private Map<String, String> ivResEnvRefBindings;
    private Map<String, String> ivMsgDestRefBindings;
    private Map<String, String> ivEnvEntryValues;
    private Map<String, String> ivEnvEntryBindings;
    private IndirectJndiLookupReferenceFactory ivIndirectLookupFactory;
    private ResRefReferenceFactory ivResRefRefFactory;
    private ResAutoLinkReferenceFactory ivResAutoLinkRefFactory;
    private MBLinkReferenceFactory ivManagedBeanRefFactory;

    public ResourceProcessor() {
        super(Resource.class, Resources.class);
    }

    @Override
    public void initProcessor() {
        ComponentNameSpaceConfiguration fCompNSConfig = this.ivNameSpaceConfig;
        this.ivIndirectLookupFactory = fCompNSConfig.getResIndirectJndiLookupReferenceFactory();
        this.ivResRefRefFactory = fCompNSConfig.getResRefReferenceFactory();
        this.ivResAutoLinkRefFactory = fCompNSConfig.getResAutoLinkReferenceFactory();
        this.ivManagedBeanRefFactory = fCompNSConfig.getMBLinkReferenceFactory();
        this.ivResRefBindings = fCompNSConfig.getResourceRefBindings();
        this.ivResEnvRefBindings = fCompNSConfig.getResourceEnvRefBindings();
        this.ivMsgDestRefBindings = fCompNSConfig.getMsgDestRefBindings();
        this.ivEnvEntryValues = fCompNSConfig.getEnvEntryValues();
        this.ivEnvEntryBindings = fCompNSConfig.getEnvEntryBindings();
        this.ivResRefList = fCompNSConfig.getResourceRefConfigList();
        if (this.ivResRefList == null) {
            this.ivResRefList = InternalInjectionEngineAccessor.getInstance().createResourceRefConfigList();
        }
    }

    @Override
    public void processXML() throws InjectionException {
        List<? extends MessageDestinationRef> msgDestRefs;
        List<? extends ResourceEnvRef> resourceEnvRefs;
        List<? extends ResourceRef> resourceRefs;
        List<? extends EnvEntry> envEntries;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processXML", (Object[])new Object[0]);
        }
        if ((envEntries = this.ivNameSpaceConfig.getEnvEntries()) != null) {
            this.processXMLEnvEntries(envEntries);
        }
        if ((resourceRefs = this.ivNameSpaceConfig.getResourceRefs()) != null) {
            this.processXMLResourceRefs(resourceRefs);
        }
        if ((resourceEnvRefs = this.ivNameSpaceConfig.getResourceEnvRefs()) != null) {
            this.processXMLResourceEnvRefs(resourceEnvRefs);
        }
        if ((msgDestRefs = this.ivNameSpaceConfig.getMsgDestRefs()) != null) {
            this.processXMLMsgDestRefs(msgDestRefs);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processXML");
        }
    }

    @Override
    public InjectionBinding<Resource> createInjectionBinding(Resource annotation, Class<?> instanceClass, Member member, String jndiName) throws InjectionException {
        return new ResourceInjectionBinding(annotation, this.ivNameSpaceConfig);
    }

    @Override
    public void resolve(InjectionBinding<Resource> binding) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolve : " + binding), (Object[])new Object[0]);
        }
        ResourceInjectionBinding resourceBinding = (ResourceInjectionBinding)binding;
        String refJndiName = resourceBinding.getJndiName();
        String refFullJndiName = InjectionScope.denormalize(refJndiName);
        Class<?> injectType = resourceBinding.getInjectionClassType();
        String injectTypeName = resourceBinding.getInjectionClassTypeName();
        ResourceXMLType xmlType = resourceBinding.ivXMLType;
        resourceBinding.ivResRefConfig = this.ivResRefList.findByName(refJndiName);
        String lookupName = resourceBinding.ivLookup;
        if (lookupName != null && lookupName.equals("")) {
            lookupName = null;
        }
        if (xmlType == ResourceXMLType.ENV_ENTRY || xmlType == ResourceXMLType.UNKNOWN && ResourceProcessor.isEnvEntryType(injectType)) {
            String boundToJndiName = null;
            if (this.ivEnvEntryBindings != null && (boundToJndiName = this.ivEnvEntryBindings.get(refJndiName)) == null && refJndiName != refFullJndiName) {
                boundToJndiName = this.ivEnvEntryBindings.get(refFullJndiName);
            }
            if (boundToJndiName == null) {
                boundToJndiName = lookupName;
            }
            if (boundToJndiName == null) {
                Object injectionObj;
                String value = null;
                if (this.ivEnvEntryValues != null) {
                    value = this.ivEnvEntryValues.get(refJndiName);
                }
                if (value == null) {
                    value = resourceBinding.ivEnvValue;
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("resolve : env-entry - binding value : " + value), (Object[])new Object[0]);
                }
                if ((injectionObj = resourceBinding.resolveEnvEntryValue(value)) != null) {
                    if (resourceBinding.getInjectionClassType() == String.class) {
                        this.collectEjb10Properties(refJndiName, injectionObj);
                    }
                    binding.setObjects(injectionObj, injectionObj);
                    resourceBinding.ivBindingValue = value;
                }
            }
            if (binding.getBindingObject() == null) {
                if (boundToJndiName == null && this.ivNameSpaceConfig.getOwningFlow() == ComponentNameSpaceConfiguration.ReferenceFlowKind.MANAGED_BEAN && binding.getInjectionScope() == InjectionScope.COMP && !"".equals(binding.getAnnotation().name())) {
                    boundToJndiName = InjectionScope.denormalize(refJndiName);
                }
                if (boundToJndiName != null) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("resolve : env-entry - binding lookup : " + boundToJndiName), (Object[])new Object[0]);
                    }
                    Reference ref = this.createIndirectJndiLookup(resourceBinding, boundToJndiName);
                    binding.setObjects(null, ref);
                }
            }
            if (binding.getBindingObject() == null) {
                InjectionScopeData isd;
                ResourceInjectionBinding injectableEnvEntry;
                if (binding.getInjectionScope() != InjectionScope.COMP && (injectableEnvEntry = (ResourceInjectionBinding)(isd = this.getNonCompInjectionScopeData(resourceBinding)).getInjectableEnvEntry(refJndiName)) != null) {
                    String bindingValue = injectableEnvEntry.ivBindingValue;
                    if (bindingValue != null) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("resolve : env-entry - binding injectable lookup : " + bindingValue), (Object[])new Object[0]);
                        }
                        Object injectionObj = resourceBinding.resolveEnvEntryValue(bindingValue);
                        resourceBinding.setObjects(injectionObj, injectionObj);
                        resourceBinding.ivBindingValue = bindingValue;
                    } else {
                        String bindingName = injectableEnvEntry.ivBindingName;
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("resolve : env-entry - binding injectable lookup : " + bindingName), (Object[])new Object[0]);
                        }
                        Reference ref = this.createIndirectJndiLookup(resourceBinding, bindingName);
                        resourceBinding.setObjects(null, ref);
                    }
                }
                if (!binding.hasAnyInjectionTargets() && binding.getBindingObject() == null && resourceBinding.ivEnvValue == null) {
                    String displayName = this.ivNameSpaceConfig.getDisplayName();
                    Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_RESOLVE_THE_ENV_ENTRY_CWNEN0045W", (Object[])new Object[]{refJndiName, displayName});
                }
            } else {
                InjectionScope scope = binding.getInjectionScope();
                if (scope == InjectionScope.APP && this.ivNameSpaceConfig.getJ2EEName() != null && this.ivNameSpaceConfig.getJ2EEName().getModule() == null) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"resolve : env-entry - adding injectable", (Object[])new Object[0]);
                    }
                    InjectionScopeData isd = this.getNonCompInjectionScopeData(resourceBinding);
                    isd.addInjectableEnvEntry(binding);
                }
            }
            if (resourceBinding.ivResRefConfig == null) {
                resourceBinding.ivResRefConfig = InternalInjectionEngineAccessor.getInstance().getDefaultResourceRefConfig();
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("resolve : " + binding));
            }
            return;
        }
        ObjectFactoryInfo extensionFactory = this.getNoOverrideObjectFactory(injectType, injectTypeName);
        if (extensionFactory != null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("resolve : binding factory : " + extensionFactory), (Object[])new Object[0]);
            }
            Reference ref = null;
            if (extensionFactory.isAttributeAllowed("lookup")) {
                if (lookupName != null) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("resolve : Binding : " + lookupName), (Object[])new Object[0]);
                    }
                    ref = this.createIndirectJndiLookup(resourceBinding, lookupName);
                    binding.setObjects(null, ref);
                }
            } else {
                this.checkObjectFactoryAttribute(resourceBinding, "lookup", resourceBinding.ivLookup, "");
            }
            this.checkObjectFactoryAttributes(resourceBinding, extensionFactory);
            if (ref == null) {
                ref = this.createExtensionFactoryReference(extensionFactory, resourceBinding);
                binding.setReferenceObject(ref, extensionFactory.getObjectFactoryClass());
            }
        } else {
            Reference ref;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"resolve : looking for binding", (Object[])new Object[0]);
            }
            if ((ref = this.resolveFromBinding(resourceBinding, refJndiName)) == null && refJndiName != refFullJndiName) {
                ref = this.resolveFromBinding(resourceBinding, refFullJndiName);
            }
            if (ref == null && lookupName != null) {
                if (xmlType == ResourceXMLType.RESOURCE_REF || xmlType == ResourceXMLType.UNKNOWN) {
                    if (resourceBinding.ivResRefConfig == null && refJndiName != refFullJndiName) {
                        resourceBinding.ivResRefConfig = this.ivResRefList.findByName(refFullJndiName);
                    }
                    ref = this.createResRefJndiLookup(resourceBinding, refJndiName, resourceBinding.ivLookup);
                } else {
                    ref = this.createIndirectJndiLookup(resourceBinding, resourceBinding.ivLookup);
                }
            }
            if (ref == null && (extensionFactory = this.getObjectFactoryInfo(injectType, injectTypeName)) != null) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("resolve : binding factory : " + extensionFactory), (Object[])new Object[0]);
                }
                this.checkObjectFactoryAttributes(resourceBinding, extensionFactory);
                ref = this.createExtensionFactoryReference(extensionFactory, resourceBinding);
            }
            if (ref == null && this.isManagedBeanRef(injectType, injectTypeName)) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"resolve : ManagedBean - using MBLink", (Object[])new Object[0]);
                }
                ref = this.ivManagedBeanRefFactory.createMBLinkReference(refJndiName, resourceBinding.ivApplication, resourceBinding.ivModule, this.ivNameSpaceConfig.getDisplayName(), injectTypeName);
            }
            if (ref == null && this.ivNameSpaceConfig.getOwningFlow() == ComponentNameSpaceConfiguration.ReferenceFlowKind.MANAGED_BEAN && binding.getInjectionScope() == InjectionScope.COMP && !"".equals(binding.getAnnotation().name())) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"resolve : ManagedBean resource - binding to consumer java:comp/env", (Object[])new Object[0]);
                }
                ref = this.createIndirectJndiLookupInConsumerContext(resourceBinding);
            }
            if (ref == null && this.ivResAutoLinkRefFactory != null) {
                if (resourceBinding.ivResRefConfig == null && refJndiName != refFullJndiName) {
                    resourceBinding.ivResRefConfig = this.ivResRefList.findByName(refFullJndiName);
                }
                ref = this.ivResAutoLinkRefFactory.createResAutoLinkReference(this.createResourceInfo(resourceBinding));
            }
            if (ref != null) {
                if (extensionFactory != null) {
                    binding.setReferenceObject(ref, extensionFactory.getObjectFactoryClass());
                } else {
                    binding.setObjects(null, ref);
                }
            } else {
                this.ivMissingBindings.add(refJndiName);
            }
        }
        if (resourceBinding.ivResRefConfig == null) {
            resourceBinding.ivResRefConfig = InternalInjectionEngineAccessor.getInstance().getDefaultResourceRefConfig();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resolve : " + binding));
        }
    }

    private Reference resolveFromBinding(ResourceInjectionBinding resourceBinding, String refJndiName) throws InjectionException {
        String boundToJndiName = null;
        Reference ref = null;
        if (this.ivResRefBindings != null && (boundToJndiName = this.ivResRefBindings.get(refJndiName)) != null) {
            ref = this.createResRefJndiLookup(resourceBinding, refJndiName, boundToJndiName);
        }
        if (ref == null && this.ivResEnvRefBindings != null && (boundToJndiName = this.ivResEnvRefBindings.get(refJndiName)) != null) {
            ref = this.createIndirectJndiLookup(resourceBinding, boundToJndiName);
        }
        if (ref == null && this.ivMsgDestRefBindings != null && (boundToJndiName = this.ivMsgDestRefBindings.get(refJndiName)) != null) {
            ref = this.createIndirectJndiLookup(resourceBinding, boundToJndiName);
        }
        return ref;
    }

    private InjectionScopeData getNonCompInjectionScopeData(ResourceInjectionBinding binding) {
        InjectionScope scope = binding.getInjectionScope();
        ApplicationMetaData md = scope == InjectionScope.APP ? this.ivNameSpaceConfig.getApplicationMetaData() : (scope == InjectionScope.MODULE ? this.ivNameSpaceConfig.getModuleMetaData() : null);
        AbstractInjectionEngine injectionEngine = (AbstractInjectionEngine)InjectionEngineAccessor.getInstance();
        return injectionEngine.getInjectionScopeData((MetaData)md);
    }

    private Reference createResRefJndiLookup(ResourceInjectionBinding binding, String refJndiName, String boundToJndiName) throws InjectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Binding resource ref " + refJndiName + " to resource " + boundToJndiName), (Object[])new Object[0]);
        }
        InjectionScope scope = binding.getInjectionScope();
        ResourceRefConfig resRef = this.getResourceRefConfig(binding, refJndiName, boundToJndiName);
        return this.ivResRefRefFactory.createResRefJndiLookup(this.ivNameSpaceConfig, scope, (ResourceRefInfo)resRef);
    }

    private ResourceRefConfig getResourceRefConfig(ResourceInjectionBinding binding, String refJndiName, String boundToJndiName) {
        Resource resourceAnnotation = (Resource)binding.getAnnotation();
        String description = resourceAnnotation.description();
        String classType = binding.getInjectionClassTypeName();
        int resAuthType = resourceAnnotation.authenticationType() == Resource.AuthenticationType.CONTAINER ? 0 : 1;
        int resSharingScope = resourceAnnotation.shareable() ? 0 : 1;
        binding.ivBindingName = boundToJndiName;
        ResourceRefConfig resRef = binding.ivResRefConfig;
        if (resRef == null) {
            binding.ivResRefConfig = resRef = this.ivResRefList.findOrAddByName(refJndiName);
        }
        resRef.setDescription(description);
        resRef.setJNDIName(boundToJndiName);
        resRef.setType(classType);
        resRef.setResAuthType(resAuthType);
        resRef.setSharingScope(resSharingScope);
        return resRef;
    }

    private Reference createIndirectJndiLookup(ResourceInjectionBinding binding, String boundToJndiName) throws InjectionException {
        String jndiName = binding.getJndiName();
        String classType = binding.getInjectionClassTypeName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Binding " + (Object)((Object)binding.ivXMLType) + " " + jndiName + " (" + classType + ") to resource " + boundToJndiName), (Object[])new Object[0]);
        }
        binding.ivBindingName = boundToJndiName;
        if (binding.ivResRefConfig != null) {
            binding.ivResRefConfig.setJNDIName(boundToJndiName);
        }
        return this.ivIndirectLookupFactory.createIndirectJndiLookup(jndiName, boundToJndiName, classType);
    }

    private Reference createIndirectJndiLookupInConsumerContext(ResourceInjectionBinding binding) throws InjectionException {
        String boundToJndiName;
        String jndiName = binding.getJndiName();
        String classType = binding.getInjectionClassTypeName();
        String string = boundToJndiName = jndiName.startsWith("java:") ? jndiName : "java:comp/env/" + jndiName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Binding " + (Object)((Object)binding.ivXMLType) + " " + jndiName + " (" + classType + ") to resource " + boundToJndiName), (Object[])new Object[0]);
        }
        binding.ivBindingName = boundToJndiName;
        if (binding.ivResRefConfig != null) {
            binding.ivResRefConfig.setJNDIName(boundToJndiName);
        }
        return this.ivIndirectLookupFactory.createIndirectJndiLookupInConsumerContext(jndiName, boundToJndiName, classType);
    }

    private void checkObjectFactoryAttributes(ResourceInjectionBinding resourceBinding, ObjectFactoryInfo extensionFactory) throws InjectionConfigurationException {
        Resource resourceAnnotation = (Resource)resourceBinding.getAnnotation();
        if (!extensionFactory.isAttributeAllowed("authenticationType")) {
            this.checkObjectFactoryAttribute(resourceBinding, "authenticationType", resourceAnnotation.authenticationType(), Resource.AuthenticationType.CONTAINER);
        }
        if (!extensionFactory.isAttributeAllowed("shareable")) {
            this.checkObjectFactoryAttribute(resourceBinding, "shareable", resourceAnnotation.shareable(), true);
        }
    }

    private void checkObjectFactoryAttribute(ResourceInjectionBinding resourceBinding, String attributeName, Object value, Object defaultValue) throws InjectionConfigurationException {
        if (value != null && !value.equals(defaultValue)) {
            String name = resourceBinding.getJndiName();
            String injectTypeName = resourceBinding.getInjectionClassTypeName();
            Tr.error((TraceComponent)tc, (String)"INVALID_OBJECT_FACTORY_ATTRIBUTE_CWNEN0071E", (Object[])new Object[]{name, resourceBinding.ivComponent, resourceBinding.ivModule, resourceBinding.ivApplication, injectTypeName, attributeName, value});
            throw new InjectionConfigurationException("The " + name + " reference for the " + resourceBinding.ivComponent + " component in the " + resourceBinding.ivModule + " module in the " + resourceBinding.ivApplication + " application has the " + injectTypeName + " type and a value for the " + attributeName + " attribute that is not valid: " + value);
        }
    }

    private Reference createExtensionFactoryReference(ObjectFactoryInfo extensionFactory, ResourceInjectionBinding resourceBinding) {
        String className = extensionFactory.getObjectFactoryClass().getName();
        Reference ref = new Reference(resourceBinding.getInjectionClassTypeName(), className, null);
        if (extensionFactory.isRefAddrNeeded()) {
            ref.add(new ResourceInfoRefAddr(this.createResourceInfo(resourceBinding)));
        }
        return ref;
    }

    private ResourceInfo createResourceInfo(ResourceInjectionBinding resourceBinding) {
        J2EEName j2eeName = this.ivNameSpaceConfig.getJ2EEName();
        Resource resourceAnnotation = (Resource)resourceBinding.getAnnotation();
        return new ResourceInfo(j2eeName == null ? null : j2eeName.getApplication(), j2eeName == null ? null : j2eeName.getModule(), this.ivNameSpaceConfig.getDisplayName(), resourceBinding.getJndiName(), resourceBinding.getInjectionClassTypeName(), resourceAnnotation.authenticationType(), resourceAnnotation.shareable(), resourceBinding.ivLink, this.getResourceRefConfig(resourceBinding, resourceBinding.getJndiName(), null));
    }

    private void collectEjb10Properties(String jndiName, Object injectionObject) throws InjectionException {
        Properties envProperties;
        String prefix = "ejb10-properties/";
        if (jndiName.startsWith("ejb10-properties/") && (envProperties = this.ivNameSpaceConfig.getEnvProperties()) != null) {
            envProperties.put(jndiName.substring("ejb10-properties/".length()), injectionObject);
        }
    }

    private boolean isManagedBeanRef(Class<?> injectType, String injectTypeName) {
        boolean result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isManagedBeanRef: " + injectType + ", " + injectTypeName), (Object[])new Object[0]);
        }
        if (injectType != null && injectType != Object.class) {
            result = injectType.isAnnotationPresent(ManagedBean.class);
        } else {
            Set<String> mbClassNames = this.ivNameSpaceConfig.getManagedBeanClassNames();
            boolean bl = result = mbClassNames != null && mbClassNames.contains(injectTypeName);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isManagedBeanRef: " + result));
        }
        return result;
    }

    private static String getDescription(Describable desc) {
        List descs = desc.getDescriptions();
        return descs.isEmpty() ? null : ((Description)descs.get(0)).getValue();
    }

    private void processXMLEnvEntries(List<? extends EnvEntry> envEntries) throws InjectionException {
        for (EnvEntry envEntry : envEntries) {
            String jndiName;
            InjectionBinding injectionBinding;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processing : " + envEntry), (Object[])new Object[0]);
            }
            if ((injectionBinding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName = envEntry.getName())) != null) {
                ((ResourceInjectionBinding)injectionBinding).merge(envEntry);
                continue;
            }
            String mappedName = envEntry.getMappedName();
            String description = ResourceProcessor.getDescription((Describable)envEntry);
            String lookup = envEntry.getLookupName();
            if (lookup != null) {
                lookup = lookup.trim();
            }
            List targets = envEntry.getInjectionTargets();
            ResourceImpl resourceAnnotation = new ResourceImpl(jndiName, null, mappedName, description, lookup);
            injectionBinding = new ResourceInjectionBinding(resourceAnnotation, envEntry, this.ivNameSpaceConfig);
            this.addInjectionBinding(injectionBinding);
            if (targets.isEmpty()) continue;
            Class<?> injectionType = injectionBinding.getInjectionClassType();
            for (InjectionTarget target : targets) {
                String targetClassName = target.getInjectionTargetClassName();
                String targetName = target.getInjectionTargetName();
                injectionBinding.addInjectionTarget(injectionType, targetName, targetClassName);
            }
        }
    }

    private void processXMLResourceRefs(List<? extends ResourceRef> resourceRefs) throws InjectionException {
        for (ResourceRef resourceRef : resourceRefs) {
            String jndiName;
            InjectionBinding injectionBinding;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processing : " + resourceRef), (Object[])new Object[0]);
            }
            if ((injectionBinding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName = resourceRef.getName())) != null) {
                ((ResourceInjectionBinding)injectionBinding).merge(resourceRef);
                continue;
            }
            Class<?> injectionType = null;
            String injectionTypeName = null;
            String targetName = null;
            String targetClassName = null;
            Resource.AuthenticationType authenticationType = ResourceProcessor.convertAuthToEnum(resourceRef.getAuthValue());
            int resSharingScope = resourceRef.getSharingScopeValue();
            Boolean shareable = null;
            if (resSharingScope != -1) {
                shareable = resSharingScope == 0;
            }
            String mappedName = resourceRef.getMappedName();
            String description = ResourceProcessor.getDescription((Describable)resourceRef);
            String lookup = resourceRef.getLookupName();
            if (lookup != null) {
                lookup = lookup.trim();
            }
            List targets = resourceRef.getInjectionTargets();
            try {
                injectionTypeName = resourceRef.getType();
                injectionType = this.loadTypeClass(injectionTypeName, jndiName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("targetType : " + injectionType), (Object[])new Object[0]);
                }
                ResourceImpl resourceAnnotation = new ResourceImpl(jndiName, injectionType == null ? Object.class : injectionType, authenticationType, shareable, mappedName, description, lookup);
                injectionBinding = new ResourceInjectionBinding(resourceAnnotation, injectionTypeName, lookup, ResourceXMLType.RESOURCE_REF, this.ivNameSpaceConfig);
                this.addInjectionBinding(injectionBinding);
                if (targets.isEmpty()) continue;
                for (InjectionTarget target : targets) {
                    targetClassName = target.getInjectionTargetClassName();
                    targetName = target.getInjectionTargetName();
                    injectionBinding.addInjectionTarget(injectionType, targetName, targetClassName);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processXMLResourceRefs"), (String)"898", (Object)this, (Object[])new Object[]{resourceRef, jndiName, injectionBinding, targetName, targetClassName});
                InjectionException icex = new InjectionException("Failed to process the XML for resource-ref " + resourceRef, e);
                Tr.error((TraceComponent)tc, (String)"FAILED_TO_PROCESS_XML_CWNEN0032E", (Object[])new Object[]{"resource-ref", resourceRef});
                throw icex;
            }
        }
    }

    private void processXMLResourceEnvRefs(List<? extends ResourceEnvRef> resourceEnvRefs) throws InjectionException {
        for (ResourceEnvRef resourceEnvRef : resourceEnvRefs) {
            String jndiName;
            InjectionBinding injectionBinding;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processing : " + resourceEnvRef), (Object[])new Object[0]);
            }
            if ((injectionBinding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName = resourceEnvRef.getName())) != null) {
                ((ResourceInjectionBinding)injectionBinding).merge(resourceEnvRef);
                continue;
            }
            Class<?> injectionType = null;
            String injectionTypeName = null;
            String targetName = null;
            String targetClassName = null;
            String mappedName = resourceEnvRef.getMappedName();
            String description = ResourceProcessor.getDescription((Describable)resourceEnvRef);
            String lookup = resourceEnvRef.getLookupName();
            if (lookup != null) {
                lookup = lookup.trim();
            }
            List targets = resourceEnvRef.getInjectionTargets();
            try {
                injectionTypeName = resourceEnvRef.getTypeName();
                injectionType = this.loadTypeClass(injectionTypeName, jndiName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("injectionType : " + injectionType), (Object[])new Object[0]);
                }
                ResourceImpl resourceAnnotation = new ResourceImpl(jndiName, injectionType == null ? Object.class : injectionType, mappedName, description, lookup);
                injectionBinding = new ResourceInjectionBinding(resourceAnnotation, injectionTypeName, lookup, ResourceXMLType.RESOURCE_ENV_REF, this.ivNameSpaceConfig);
                this.addInjectionBinding(injectionBinding);
                if (targets.isEmpty()) continue;
                for (InjectionTarget target : targets) {
                    targetClassName = target.getInjectionTargetClassName();
                    targetName = target.getInjectionTargetName();
                    injectionBinding.addInjectionTarget(injectionType, targetName, targetClassName);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processXMLResourceEnvRefs"), (String)"454", (Object)this, (Object[])new Object[]{resourceEnvRef, jndiName, injectionBinding, targetName, targetClassName});
                InjectionException icex = new InjectionException("Failed to process the XML for resource-env-ref " + resourceEnvRef, e);
                Tr.error((TraceComponent)tc, (String)"FAILED_TO_PROCESS_XML_CWNEN0032E", (Object[])new Object[]{"resource-env-ref", resourceEnvRef});
                throw icex;
            }
        }
    }

    private void processXMLMsgDestRefs(List<? extends MessageDestinationRef> msgDestRefs) throws InjectionException {
        for (MessageDestinationRef messageDestinationRef : msgDestRefs) {
            String jndiName;
            InjectionBinding injectionBinding;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processing : " + messageDestinationRef), (Object[])new Object[0]);
            }
            if ((injectionBinding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName = messageDestinationRef.getName())) != null) {
                ((ResourceInjectionBinding)injectionBinding).merge(messageDestinationRef);
                continue;
            }
            Class<?> injectionType = null;
            String targetName = null;
            String targetClassName = null;
            String msgDestType = messageDestinationRef.getType();
            String description = ResourceProcessor.getDescription((Describable)messageDestinationRef);
            String mappedName = messageDestinationRef.getMappedName();
            String lookup = messageDestinationRef.getLookupName();
            if (lookup != null) {
                lookup = lookup.trim();
            }
            List targets = messageDestinationRef.getInjectionTargets();
            try {
                injectionType = this.loadTypeClass(msgDestType, jndiName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("targetType : " + injectionType), (Object[])new Object[0]);
                }
                ResourceImpl resourceAnnotation = new ResourceImpl(jndiName, injectionType == null ? Object.class : injectionType, mappedName, description, lookup);
                if (messageDestinationRef.getLink() != null) {
                    injectionBinding = new ResourceInjectionBinding(resourceAnnotation, messageDestinationRef, lookup, this.ivNameSpaceConfig);
                    this.addInjectionBinding(injectionBinding);
                } else {
                    injectionBinding = new ResourceInjectionBinding(resourceAnnotation, msgDestType, lookup, ResourceXMLType.MESSAGE_DESTINATION_REF, this.ivNameSpaceConfig);
                    this.addInjectionBinding(injectionBinding);
                }
                if (targets.isEmpty()) continue;
                for (InjectionTarget target : targets) {
                    targetClassName = target.getInjectionTargetClassName();
                    targetName = target.getInjectionTargetName();
                    injectionBinding.addInjectionTarget(injectionType, targetName, targetClassName);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processXMLMsgDestRefs"), (String)"1077", (Object)this, (Object[])new Object[]{messageDestinationRef, jndiName, injectionBinding, targetName, targetClassName});
                InjectionException icex = new InjectionException("Failed to process the XML for message-destination-ref " + messageDestinationRef, e);
                Tr.error((TraceComponent)tc, (String)"FAILED_TO_PROCESS_XML_CWNEN0032E", (Object[])new Object[]{"message-destination-ref", messageDestinationRef});
                throw icex;
            }
        }
    }

    @Override
    public String getJndiName(Resource annotation) {
        return annotation.name();
    }

    public Resource[] getAnnotations(Resources annotation) {
        return annotation.value();
    }

    private static boolean isEnvEntryType(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Boolean.class || clazz == Byte.class || clazz == Character.class || clazz == Float.class || clazz == Double.class || clazz == Short.class) {
            return true;
        }
        return !InjectionConfigConstants.EE5Compatibility && (clazz == Class.class || clazz.isEnum());
    }

    private Class<?> loadTypeClass(String className, String refName) throws InjectionConfigurationException {
        Class<?> loadedClass;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("loadTypeClass : " + className), (Object[])new Object[0]);
        }
        ClassLoader classLoader = this.ivNameSpaceConfig.getClassLoader();
        if (className == null || className.equals("") || classLoader == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"loadTypeClass : null");
            }
            return null;
        }
        try {
            loadedClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".loadTypeClass"), (String)"1142", (Object)this, (Object[])new Object[]{className});
            String module = this.ivNameSpaceConfig.getModuleName();
            Tr.warning((TraceComponent)tc, (String)"RESOURCE_TYPE_NOT_FOUND_CWNEN0046W", (Object[])new Object[]{className, refName, module});
            if (this.isValidationFailable()) {
                throw new InjectionConfigurationException("CWNEN0046W: The " + className + " type specified on the resource-ref, resource-env-ref, or message-destination-ref with the " + refName + " name in the " + module + " module could not be loaded.");
            }
            loadedClass = null;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("loadTypeClass : " + loadedClass));
        }
        return loadedClass;
    }

    static Resource.AuthenticationType convertAuthToEnum(int resAuthType) {
        Resource.AuthenticationType authType = Resource.AuthenticationType.CONTAINER;
        if (resAuthType == 1) {
            authType = Resource.AuthenticationType.APPLICATION;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("convertAuthToEnum : " + resAuthType + " -> " + authType), (Object[])new Object[0]);
        }
        return authType;
    }
}

