/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.osgi.framework.Filter;

@Trivial
public class ConfigurationDictionary
extends Dictionary<String, Object>
implements Serializable {
    private static final long serialVersionUID = 7966152868712543805L;
    private static final List<Class<?>> simpleTypes = Arrays.asList(String.class, Integer.class, Long.class, Float.class, Double.class, Byte.class, Short.class, Character.class, Boolean.class);
    private static final List<Class<?>> primitiveArrayTypes = Arrays.asList(long[].class, int[].class, short[].class, char[].class, byte[].class, double[].class, float[].class, boolean[].class);
    private static final List<Class<?>> simpleArrayTypes = Arrays.asList(String[].class, Integer[].class, Long[].class, Float[].class, Double[].class, Byte[].class, Short[].class, Character[].class, Boolean[].class);
    private static final List<Class<?>> extendedTypes = Arrays.asList(SerializableProtectedString.class, OnErrorUtil.OnError.class);
    static final Comparator<String> CASE_INSENSITIVE = new CaseInsensitive();
    protected final Map<String, Object> properties = Collections.synchronizedMap(new TreeMap(CASE_INSENSITIVE));

    @Override
    public Enumeration<Object> elements() {
        return new ValuesEnumeration();
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.properties.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Enumeration<String> keys() {
        return new KeysEnumeration();
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        ConfigurationDictionary.validateValue(value);
        return this.properties.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.properties.remove(key);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    private static void validateValue(Object value) {
        Class<?> clazz = value.getClass();
        if (simpleTypes.contains(clazz)) {
            return;
        }
        if (simpleArrayTypes.contains(clazz) || primitiveArrayTypes.contains(clazz) || extendedTypes.contains(clazz)) {
            return;
        }
        if (value instanceof Collection) {
            Collection valueCollection = (Collection)value;
            Iterator it = valueCollection.iterator();
            while (it.hasNext()) {
                Class<?> containedClazz = it.next().getClass();
                if (simpleTypes.contains(containedClazz)) continue;
                throw new IllegalArgumentException(containedClazz.getName() + " in " + clazz.getName());
            }
            return;
        }
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            for (Map.Entry entry : valueMap.entrySet()) {
                Class<?> keyClazz = entry.getKey().getClass();
                if (keyClazz != String.class) {
                    throw new IllegalArgumentException(keyClazz.getName() + " in " + clazz.getName());
                }
                Class<?> valueClazz = entry.getValue().getClass();
                if (simpleTypes.contains(valueClazz)) continue;
                throw new IllegalArgumentException(valueClazz.getName() + " in " + clazz.getName());
            }
            return;
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    public ConfigurationDictionary copy() {
        ConfigurationDictionary result = new ConfigurationDictionary();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                Object copyOfArray = Array.newInstance(value.getClass().getComponentType(), arrayLength);
                System.arraycopy(value, 0, copyOfArray, 0, arrayLength);
                result.properties.put(key, copyOfArray);
                continue;
            }
            if (value instanceof Vector) {
                result.properties.put(key, ((Vector)value).clone());
                continue;
            }
            result.properties.put(key, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        Map<String, Object> map = this.properties;
        synchronized (map) {
            Iterator<Map.Entry<String, Object>> it = this.properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                builder.append(entry.getKey());
                builder.append('=');
                Object value = entry.getValue();
                if (value == null || !value.getClass().isArray()) {
                    builder.append(value);
                } else {
                    String name = value.getClass().getComponentType().getName();
                    builder.append(name, name.lastIndexOf(46) + 1, name.length()).append("[]{");
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        if (i != 0) {
                            builder.append(", ");
                        }
                        builder.append(Array.get(value, i));
                    }
                    builder.append('}');
                }
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
        }
        return builder.append('}').toString();
    }

    public boolean matches(Filter filter) {
        return filter.matches(this.properties);
    }

    @Trivial
    private class KeysEnumeration<T>
    implements Enumeration<String> {
        Iterator<String> keysIterator;

        private KeysEnumeration() {
            this.keysIterator = ConfigurationDictionary.this.properties.keySet().iterator();
        }

        @Override
        @Trivial
        public boolean hasMoreElements() {
            return this.keysIterator.hasNext();
        }

        @Override
        @Trivial
        public String nextElement() {
            return this.keysIterator.next();
        }
    }

    @Trivial
    private class ValuesEnumeration<T>
    implements Enumeration<Object> {
        final Iterator<Object> valuesIterator;

        private ValuesEnumeration() {
            this.valuesIterator = ConfigurationDictionary.this.properties.values().iterator();
        }

        @Override
        @Trivial
        public boolean hasMoreElements() {
            return this.valuesIterator.hasNext();
        }

        @Override
        @Trivial
        public Object nextElement() {
            return this.valuesIterator.next();
        }
    }

    @Trivial
    static class CaseInsensitive
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 7962325242424955159L;

        CaseInsensitive() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == s2) {
                return 0;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
        }
    }
}

