/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.internal.InstallLicenseImpl;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.repository.common.enums.LicenseType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.aries.util.manifest.ManifestProcessor;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ZipLicenseProvider;

public final class ArchiveUtils {
    public static final String APPLIES_TO = "Applies-To";
    public static final String ARCHIVE_CONTENT_TYPE = "Archive-Content-Type";
    public static final String ARCHIVE_ROOT = "Archive-Root";
    public static final String REQUIRED_FEATURES = "Require-Feature";
    public static final String LICENSE_AGREEMENT = "License-Agreement";
    public static final String LICENSE_INFORMATION = "License-Information";

    private ArchiveUtils() {
    }

    public static Map<String, String> processArchiveManifest(final JarFile jarFile) throws Throwable {
        Map<String, String> manifestAttrs = null;
        if (jarFile != null) {
            try {
                manifestAttrs = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, String>>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public Map<String, String> run() throws ZipException, IOException {
                        InputStream is = null;
                        Map attrs = null;
                        try {
                            is = jarFile.getInputStream(jarFile.getEntry("META-INF/MANIFEST.MF"));
                            attrs = ManifestProcessor.readManifestIntoMap((Manifest)ManifestProcessor.parseManifest((InputStream)is));
                            if (is == null) return attrs;
                        }
                        catch (Throwable throwable) {
                            if (is == null) throw throwable;
                            InstallUtils.close(is);
                            throw throwable;
                        }
                        InstallUtils.close(is);
                        return attrs;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
        return manifestAttrs;
    }

    public static Map<String, String> processArchiveManifest(File file) throws Throwable {
        Map<String, String> manifestAttrs = null;
        if (file != null && file.isFile() && ArchiveFileType.JAR.isType(file.getPath())) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                manifestAttrs = ArchiveUtils.processArchiveManifest(jarFile);
            }
            finally {
                if (jarFile != null) {
                    InstallUtils.close(jarFile);
                }
            }
        }
        return manifestAttrs;
    }

    public static String getLicenseAgreement(JarFile jar, Map<String, String> manifestAttrs) {
        LicenseProvider licenseProvider;
        String licenseAgreement = null;
        if (manifestAttrs.isEmpty()) {
            return licenseAgreement;
        }
        String licenseAgreementPrefix = manifestAttrs.get(LICENSE_AGREEMENT);
        LicenseProvider licenseProvider2 = licenseProvider = licenseAgreementPrefix != null ? ZipLicenseProvider.createInstance((ZipFile)jar, (String)licenseAgreementPrefix) : null;
        if (licenseProvider != null) {
            licenseAgreement = new InstallLicenseImpl("", LicenseType.UNSPECIFIED, licenseProvider).getAgreement();
        }
        return licenseAgreement;
    }

    public static enum ArchiveContentType {
        ADDON("addon", false),
        INSTALL("install", true),
        SAMPLE("sample", true),
        OPENSOURCE("osi", false);

        private final String name;
        private final boolean serverPackage;

        private ArchiveContentType(String name, boolean serverPackage) {
            this.name = name;
            this.serverPackage = serverPackage;
        }

        public boolean isServerPackage() {
            return this.serverPackage;
        }

        public boolean isContentType(String name) {
            return this.name.equalsIgnoreCase(name);
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum ArchiveFileType {
        JAR(".jar"),
        ZIP(".zip"),
        PAX(".pax"),
        ESA(".esa");

        private final String extension;

        private ArchiveFileType(String extension) {
            this.extension = extension;
        }

        public String getFileExtension() {
            return this.extension;
        }

        public boolean isType(String archiveFile) {
            return null == archiveFile || archiveFile.equals("") ? false : archiveFile.toLowerCase().endsWith(this.extension);
        }
    }
}

