/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class SoapBinding
extends AbstractBasicInterceptorProvider
implements Binding {
    private static final Logger LOG = LogUtils.getL7dLogger(SoapBinding.class);
    private SoapVersion version;
    private BindingInfo bindingInfo;
    static final long serialVersionUID = -9058983117688304006L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SoapBinding(BindingInfo info) {
        this(info, Soap11.getInstance());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapBinding", "<init>", new Object[]{info});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.SoapBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SoapBinding(BindingInfo info, SoapVersion v) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapBinding", "<init>", new Object[]{info, v});
        }
        this.version = v;
        this.bindingInfo = info;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.SoapBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BindingInfo getBindingInfo() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapBinding", "getBindingInfo", new Object[0]);
        }
        BindingInfo bindingInfo = this.bindingInfo;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bindingInfo = bindingInfo;
            LOG.exiting("org.apache.cxf.binding.soap.SoapBinding", "getBindingInfo", bindingInfo);
        }
        return bindingInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSoapVersion(SoapVersion v) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapBinding", "setSoapVersion", new Object[]{v});
        }
        this.version = v;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.SoapBinding", "setSoapVersion");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SoapVersion getSoapVersion() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapBinding", "getSoapVersion", new Object[0]);
        }
        SoapVersion soapVersion = this.version;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            soapVersion = soapVersion;
            LOG.exiting("org.apache.cxf.binding.soap.SoapBinding", "getSoapVersion", soapVersion);
        }
        return soapVersion;
    }

    @Sensitive
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Message createMessage() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapBinding", "createMessage", new Object[0]);
        }
        SoapMessage soapMessage = new SoapMessage(this.version);
        soapMessage.put("Content-Type", soapMessage.getVersion().getContentType());
        SoapMessage soapMessage2 = soapMessage;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            soapMessage2 = soapMessage2;
            LOG.exiting("org.apache.cxf.binding.soap.SoapBinding", "createMessage", "<sensitive org.apache.cxf.message.Message>");
        }
        return soapMessage2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Message createMessage(@Sensitive Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive org.apache.cxf.message.Message>";
            LOG.entering("org.apache.cxf.binding.soap.SoapBinding", "createMessage", objectArray);
        }
        SoapMessage soapMessage = new SoapMessage(m);
        if (m.getExchange() != null) {
            if (m.getExchange().getInMessage() instanceof SoapMessage) {
                soapMessage.setVersion(((SoapMessage)m.getExchange().getInMessage()).getVersion());
            } else {
                soapMessage.setVersion(this.version);
            }
        } else {
            soapMessage.setVersion(this.version);
        }
        if (!m.containsKey((Object)"Content-Type")) {
            m.put((Object)"Content-Type", (Object)soapMessage.getVersion().getContentType());
            SoapMessage newMessage = new SoapMessage(m);
            newMessage.setVersion(soapMessage.getVersion());
        }
        if (!soapMessage.containsKey("Content-Type")) {
            soapMessage.put("Content-Type", soapMessage.getVersion().getContentType());
        }
        SoapMessage soapMessage2 = soapMessage;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            soapMessage2 = soapMessage2;
            LOG.exiting("org.apache.cxf.binding.soap.SoapBinding", "createMessage", (Object)soapMessage2);
        }
        return soapMessage2;
    }
}

