/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.context.service.serializable;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.context.service.serializable.ThreadContextManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextDeserializationInfo;
import com.ibm.wsspi.threadcontext.ThreadContextProvider;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.RejectedExecutionException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ThreadContextDescriptorImpl
implements ThreadContextDescriptor,
ThreadContextDeserializationInfo {
    private static final TraceComponent tc = Tr.register(ThreadContextDescriptorImpl.class, (String)"context", (String)"com.ibm.ws.context.service.resources.CWWKCMessages");
    private static final String MP_CLEARED_CONTEXT = "com.ibm.ws.concurrent.mp.cleared.context.provider";
    private final Map<String, String> execProps;
    private final String metaDataIdentifier;
    private ArrayList<String> providerNames;
    List<String> providerNamesToSkip;
    private ArrayList<ThreadContext> threadContext;
    private ThreadContextManager threadContextMgr;
    static final long serialVersionUID = -6759302645441123215L;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ThreadContextDescriptorImpl(Map<String, String> execProps, @Sensitive byte[] bytes) throws ClassNotFoundException, IOException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        execProps = execProps == null ? new TreeMap<String, String>() : new TreeMap<String, String>(execProps);
        this.execProps = execProps;
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytes));
        short numFields = oin.readShort();
        byte[][] contextBytes = (byte[][])oin.readObject();
        this.metaDataIdentifier = numFields < 2 ? null : (String)oin.readObject();
        int numProviderNames = numFields < 3 ? 0 : oin.readShort();
        this.providerNames = new ArrayList(numProviderNames);
        for (int i = 0; i < numProviderNames; ++i) {
            String name = (String)oin.readObject();
            if (name.charAt(0) == '.' && name.charAt(name.length() - 1) == '.') {
                this.providerNames.add("com.ibm.ws" + name + "context.provider");
                continue;
            }
            this.providerNames.add(name);
        }
        oin.close();
        this.threadContext = new ArrayList(contextBytes.length);
        String skip = execProps.get("com.ibm.ws.concurrent.SKIP_CONTEXT_PROVIDERS");
        this.providerNamesToSkip = skip == null ? Collections.emptyList() : Arrays.asList(skip.split(","));
        ServiceReference threadContextMgrRef = null;
        BundleContext bundleContext = null;
        boolean successful = false;
        try {
            int i;
            ThreadContextProvider[] contextProviders = new ThreadContextProvider[contextBytes.length];
            bundleContext = ThreadContextManager.priv.getBundleContext(FrameworkUtil.getBundle(ThreadContextManager.class));
            threadContextMgrRef = (ServiceReference)ThreadContextManager.priv.getServiceReferences(bundleContext, WSContextService.class, "(component.name=com.ibm.ws.context.manager)").iterator().next();
            this.threadContextMgr = (ThreadContextManager)ThreadContextManager.priv.getService(bundleContext, threadContextMgrRef);
            for (i = 0; i < contextBytes.length; ++i) {
                String providerName = this.providerNames.get(i);
                ThreadContextProvider contextProvider = (ThreadContextProvider)this.threadContextMgr.threadContextProviders.getService((Object)providerName);
                if (contextProvider == null && !MP_CLEARED_CONTEXT.equals(providerName)) {
                    throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1004.context.provider.unavailable", (Object[])new Object[]{providerName}));
                }
                contextProviders[i] = contextProvider;
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)providerName, (Object[])new Object[]{contextProvider});
            }
            for (i = 0; i < contextBytes.length; ++i) {
                if (contextProviders[i] == null) continue;
                ThreadContext context = contextProviders[i].deserializeThreadContext(this, contextBytes[i]);
                this.threadContext.add(context);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)contextProviders[i].toString(), (Object[])new Object[]{ThreadContextDescriptorImpl.toString(context)});
            }
            successful = true;
            if (successful || threadContextMgrRef == null) return;
        }
        catch (InvalidSyntaxException contextProviders) {
            try {
                void x;
                Object[] objectArray = new Object[2];
                objectArray[0] = execProps;
                objectArray[1] = "<sensitive byte[]>";
                FFDCFilter.processException((Throwable)contextProviders, (String)"com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl", (String)"169", (Object)this, (Object[])objectArray);
                throw new IOException(x.getCause());
            }
            catch (Throwable throwable) {
                if (successful || threadContextMgrRef == null) throw throwable;
                bundleContext.ungetService(threadContextMgrRef);
                throw throwable;
            }
        }
        bundleContext.ungetService(threadContextMgrRef);
        return;
    }

    @Trivial
    ThreadContextDescriptorImpl(Map<String, String> execProps, int initialCapacity, ThreadContextManager threadContextMgr) {
        this.execProps = execProps;
        this.providerNames = new ArrayList(initialCapacity);
        this.threadContext = new ArrayList(initialCapacity);
        this.threadContextMgr = threadContextMgr;
        String skip = execProps.get("com.ibm.ws.concurrent.SKIP_CONTEXT_PROVIDERS");
        this.providerNamesToSkip = skip == null ? Collections.emptyList() : Arrays.asList(skip.split(","));
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        this.metaDataIdentifier = cData == null ? null : threadContextMgr.metadataIdentifierService.getMetaDataIdentifier((MetaData)cData);
    }

    @Trivial
    final void add(String providerName, ThreadContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("add " + providerName), (Object[])new Object[]{context});
        }
        this.providerNames.add(providerName);
        this.threadContext.add(context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ThreadContextDescriptor clone() {
        try {
            ThreadContextDescriptorImpl clone = (ThreadContextDescriptorImpl)super.clone();
            clone.providerNames = new ArrayList<String>(clone.providerNames);
            clone.providerNamesToSkip = new ArrayList<String>(clone.providerNamesToSkip);
            clone.threadContext = new ArrayList<ThreadContext>(this.threadContext);
            return clone;
        }
        catch (CloneNotSupportedException clone) {
            void x;
            FFDCFilter.processException((Throwable)clone, (String)"com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl", (String)"221", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)x);
        }
    }

    @Trivial
    private static final boolean containsAll(LinkedHashMap<ThreadContextProvider, ThreadContext> contextProviders, List<ThreadContextProvider> prereqs) {
        for (ThreadContextProvider prereq : prereqs) {
            if (contextProviders.containsKey(prereq)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Trivial
    public final Map<String, String> getExecutionProperties() {
        return this.execProps;
    }

    @Override
    @Trivial
    public final boolean isSerializable() {
        int i = this.providerNames.indexOf("io.openliberty.thirdparty.context.provider");
        return i < 0 || this.threadContext.get(i).isSerializable();
    }

    public static void notAvailable(String jeeName, String taskName) {
        String message;
        int modSepIndex = jeeName.indexOf(35);
        if (modSepIndex == -1) {
            message = Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1011.app.unavailable", (Object[])new Object[]{taskName, jeeName});
        } else {
            String application = jeeName.substring(0, modSepIndex);
            int compSepIndex = jeeName.indexOf(35, modSepIndex + 1);
            if (compSepIndex == -1) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1012.module.unavailable", (Object[])new Object[]{taskName, jeeName.substring(modSepIndex + 1), application});
            } else {
                String module = jeeName.substring(modSepIndex + 1, compSepIndex);
                message = Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1013.component.unavailable", (Object[])new Object[]{taskName, jeeName.substring(compSepIndex + 1), module, application});
            }
        }
        throw new IllegalStateException(message);
    }

    @Override
    @Sensitive
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int size = this.threadContext.size();
        byte[][] contextBytes = new byte[size][];
        for (int i = 0; i < size; ++i) {
            bout.reset();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(this.threadContext.get(i));
            oout.flush();
            contextBytes[i] = bout.toByteArray();
            oout.close();
        }
        bout.reset();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeShort(3);
        oout.writeObject(contextBytes);
        oout.writeObject(this.metaDataIdentifier);
        oout.writeShort(this.providerNames.size());
        for (String providerName : this.providerNames) {
            if (providerName.startsWith("com.ibm.ws.") && providerName.endsWith(".context.provider")) {
                oout.writeObject(providerName.substring(10, providerName.length() - 16));
                continue;
            }
            oout.writeObject(providerName);
        }
        oout.flush();
        oout.close();
        return bout.toByteArray();
    }

    @Override
    public final void set(String providerName, ThreadContext context) {
        int index = this.providerNames.indexOf(providerName);
        if (index >= 0) {
            this.threadContext.set(index, context);
        } else {
            this.providerNames.add(providerName);
            this.threadContext.add(context);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    public ArrayList<ThreadContext> taskStarting() throws RejectedExecutionException {
        String defaultContextTypes;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"contextualize", (Object[])new Object[0]);
        }
        if (!"false".equalsIgnoreCase(this.execProps.get("com.ibm.ws.concurrent.REQUIRE_AVAILABLE_APP")) && this.metaDataIdentifier != null && this.threadContextMgr.metadataIdentifierService.getMetaData(this.metaDataIdentifier) == null) {
            String taskName;
            if (this.threadContextMgr.eeVersion < 9) {
                taskName = this.execProps.get("javax.enterprise.concurrent.IDENTITY_NAME");
                if (taskName == null) {
                    taskName = this.execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                }
            } else {
                taskName = this.execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                if (taskName == null) {
                    taskName = this.execProps.get("javax.enterprise.concurrent.IDENTITY_NAME");
                }
            }
            ThreadContextDescriptorImpl.notAvailable(this.metaDataIdentifier, taskName);
        }
        Set<Object> providerNamesForDefaultContext = "UNCONFIGURED_CONTEXT_TYPES".equals(defaultContextTypes = this.execProps.get("com.ibm.ws.concurrent.DEFAULT_CONTEXT")) || "ALL_CONTEXT_TYPES".equals(defaultContextTypes) ? new HashSet(this.threadContextMgr.threadContextProviders.keySet()) : Collections.emptySet();
        providerNamesForDefaultContext.removeAll(this.providerNamesToSkip);
        LinkedHashMap<ThreadContextProvider, ThreadContext> contextAppliedToThread = new LinkedHashMap<ThreadContextProvider, ThreadContext>();
        try {
            int n;
            LinkedHashMap<ThreadContextProvider, ThreadContext> contextNotApplied = new LinkedHashMap<ThreadContextProvider, ThreadContext>();
            for (int i = 0; i < this.threadContext.size(); ++i) {
                ThreadContextProvider provider;
                String string = this.providerNames.get(i);
                providerNamesForDefaultContext.remove(string);
                ThreadContextProvider threadContextProvider = provider = MP_CLEARED_CONTEXT.equals(string) ? (ThreadContextProvider)this.threadContextMgr.threadContextProviders.getService((Object)string) : (ThreadContextProvider)this.threadContextMgr.threadContextProviders.getServiceWithException((Object)string);
                if (provider == null) continue;
                contextNotApplied.put(provider, this.threadContext.get(i));
            }
            for (String string : providerNamesForDefaultContext) {
                contextNotApplied.put((ThreadContextProvider)this.threadContextMgr.threadContextProviders.getServiceWithException((Object)string), null);
            }
            int count = contextNotApplied.size();
            int n2 = count + 1;
            while (count > 0 && count < n) {
                Iterator it = contextNotApplied.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    ThreadContextProvider provider = (ThreadContextProvider)entry.getKey();
                    List<ThreadContextProvider> prereqs = provider.getPrerequisites();
                    if (prereqs != null && !ThreadContextDescriptorImpl.containsAll(contextAppliedToThread, prereqs)) continue;
                    ThreadContext context = (ThreadContext)entry.getValue();
                    ThreadContext threadContext = context = context == null ? provider.createDefaultThreadContext(this.execProps) : context.clone();
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("begin context " + ThreadContextDescriptorImpl.toString(context)), (Object[])new Object[0]);
                    }
                    context.taskStarting();
                    contextAppliedToThread.put(provider, context);
                    it.remove();
                }
                n = count;
                count = contextNotApplied.size();
            }
            if (!contextNotApplied.isEmpty()) {
                Iterator it = contextNotApplied.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    ThreadContext context = (ThreadContext)entry.getValue();
                    if (context != null) continue;
                    ThreadContextProvider provider = (ThreadContextProvider)entry.getKey();
                    context = provider.createDefaultThreadContext(this.execProps);
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("begin context " + ThreadContextDescriptorImpl.toString(context)), (Object[])new Object[0]);
                    }
                    context.taskStarting();
                    contextAppliedToThread.put(provider, context);
                    it.remove();
                }
                if (!contextNotApplied.isEmpty()) {
                    throw new IllegalStateException(contextNotApplied.keySet().toString());
                }
            }
        }
        catch (Throwable contextNotApplied) {
            void x;
            void var7_19;
            FFDCFilter.processException((Throwable)contextNotApplied, (String)"com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl", (String)"440", (Object)this, (Object[])new Object[0]);
            ArrayList contextToRemove = new ArrayList(contextAppliedToThread.values());
            int n = contextToRemove.size() - 1;
            while (var7_19 >= 0) {
                try {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("end context " + ThreadContextDescriptorImpl.toString((ThreadContext)contextToRemove.get((int)var7_19))), (Object[])new Object[0]);
                    }
                    ((ThreadContext)contextToRemove.get((int)var7_19)).taskStopping();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl", (String)"448", (Object)this, (Object[])new Object[0]);
                }
                --var7_19;
            }
            if (x instanceof RejectedExecutionException) {
                throw (RejectedExecutionException)x;
            }
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            if (x instanceof Error) {
                throw (Error)x;
            }
            throw new RejectedExecutionException((Throwable)x);
        }
        return new ArrayList<ThreadContext>(contextAppliedToThread.values());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    public void taskStopping(ArrayList<ThreadContext> threadContext) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"restore context", (Object[])new Object[0]);
        }
        Throwable failure = null;
        for (int c = threadContext.size() - 1; c >= 0; --c) {
            try {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("end context " + ThreadContextDescriptorImpl.toString(threadContext.get(c))), (Object[])new Object[0]);
                }
                threadContext.get(c).taskStopping();
                continue;
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl", (String)"481", (Object)this, (Object[])new Object[]{threadContext});
                if (failure != null) continue;
                failure = x;
            }
        }
        if (failure != null) {
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            throw new RuntimeException(failure);
        }
    }

    @Trivial
    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + this.providerNames;
    }

    @Trivial
    private static String toString(ThreadContext c) {
        if (c == null) {
            return null;
        }
        String s = c.toString();
        if (s.indexOf(64) < 0) {
            s = c.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(c)) + ':' + s;
        }
        return s;
    }

    @Override
    public String getExecutionProperty(String name) {
        return this.execProps.get(name);
    }

    @Override
    public String getMetadataIdentifier() {
        return this.metaDataIdentifier;
    }
}

