/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.random;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RandomUtils {
    private static final TraceComponent tc = Tr.register(RandomUtils.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    private static final char[] alphaNumChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final String JCEPROVIDER_IBM = "IBMJCE";
    static final String SECRANDOM_IBM = "IBMSecureRandom";
    static final String SECRANDOM_SHA1PRNG = "SHA1PRNG";
    static final long serialVersionUID = 7534085811895604379L;

    public static String getRandomAlphaNumeric(int length) {
        if (length <= 0) {
            return "";
        }
        Random r = RandomUtils.getRandom();
        StringBuffer result = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            int n = r.nextInt(alphaNumChars.length);
            result.append(alphaNumChars[n]);
        }
        return result.toString();
    }

    public static Random getRandom() {
        Random result = null;
        try {
            result = Security.getProvider(JCEPROVIDER_IBM) != null ? SecureRandom.getInstance(SECRANDOM_IBM) : SecureRandom.getInstance(SECRANDOM_SHA1PRNG);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.common.random.RandomUtils", (String)"75", null, (Object[])new Object[0]);
            result = new Random();
        }
        return result;
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static <T> T getRandomSelection(List<T> options) {
        return (T)RandomUtils.getRandomSelection(options.toArray(new Object[options.size()]));
    }

    public static <T> T getRandomSelection(T ... options) {
        if (options == null || options.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No options provided to random selection, returning null", (Object[])new Object[0]);
            }
            return null;
        }
        if (options.length == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Only one option provided to random selection, returning it: [" + options[0] + "]"), (Object[])new Object[0]);
            }
            return options[0];
        }
        Random rand = new Random();
        Integer index = rand.nextInt(options.length);
        T entry = options[index];
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Chose random selection: [" + (entry == null ? null : entry) + "]"), (Object[])new Object[0]);
        }
        return entry;
    }

    public static <T> T[] getRandomSelection(T[] ... options) {
        if (options == null || options.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No options provided to random selection, returning null", (Object[])new Object[0]);
            }
            return null;
        }
        if (options.length == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Only one option provided to random selection, returning it: " + Arrays.toString(options[0])), (Object[])new Object[0]);
            }
            return options[0];
        }
        Random rand = new Random();
        Integer index = rand.nextInt(options.length);
        Object[] entry = options[index];
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Chose random selection: " + (entry == null ? null : Arrays.toString(entry))), (Object[])new Object[0]);
        }
        return entry;
    }
}

