/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.controller.impl;

import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.jbatch.container.artifact.proxy.PartitionMapperProxy;
import com.ibm.jbatch.container.artifact.proxy.PartitionReducerProxy;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.artifact.proxy.StepListenerProxy;
import com.ibm.jbatch.container.controller.impl.BaseStepControllerImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.jsl.CloneUtility;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepInstanceKey;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerStaticAnchor;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.util.BatchPartitionWorkUnit;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.container.ws.BatchDispatcher;
import com.ibm.jbatch.container.ws.JoblogUtil;
import com.ibm.jbatch.container.ws.PartitionPlanConfig;
import com.ibm.jbatch.container.ws.PartitionReplyMsg;
import com.ibm.jbatch.container.ws.impl.PartitionReplyQueueLocal;
import com.ibm.jbatch.container.ws.impl.StringUtils;
import com.ibm.jbatch.container.ws.smf.ZosJBatchSMFLogging;
import com.ibm.jbatch.jsl.model.Analyzer;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.PartitionMapper;
import com.ibm.jbatch.jsl.model.PartitionPlan;
import com.ibm.jbatch.jsl.model.PartitionReducer;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.DeserializationObjectInputStream;
import jakarta.batch.api.partition.PartitionReducer;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.runtime.BatchStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class PartitionedStepControllerImpl
extends BaseStepControllerImpl {
    private static final Logger logger = Logger.getLogger(PartitionedStepControllerImpl.class.getName());
    private ExecutionType executionType;
    private final boolean isMultiJvm;
    private volatile List<BatchPartitionWorkUnit> parallelBatchWorkUnits;
    private PartitionReducerProxy partitionReducerProxy;
    private PartitionAnalyzerProxy analyzerProxy;
    protected List<StepListenerProxy> stepListeners;
    private BatchDispatcher batchJmsDispatcher;
    private PartitionPlanDescriptor currentPlan;
    List<Integer> partitionsToExecute;
    List<Integer> startedPartitions;
    List<FinishedPartition> finishedPartitions;
    Set<Integer> finishedPartitionNumbers;
    List<Throwable> analyzerExceptions;
    private boolean rollbackPartitionedStepInvoked;
    static final long serialVersionUID = 8846026581552446621L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PartitionedStepControllerImpl(RuntimeWorkUnitExecution runtimeWorkUnitExecution, Step step) {
        super(runtimeWorkUnitExecution, step);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "<init>", new Object[]{runtimeWorkUnitExecution, step});
        }
        this.executionType = null;
        this.parallelBatchWorkUnits = new ArrayList<BatchPartitionWorkUnit>();
        this.partitionReducerProxy = null;
        this.analyzerProxy = null;
        this.stepListeners = null;
        this.batchJmsDispatcher = null;
        this.startedPartitions = new ArrayList<Integer>();
        this.finishedPartitions = new ArrayList<FinishedPartition>();
        this.finishedPartitionNumbers = new HashSet<Integer>();
        this.analyzerExceptions = new ArrayList<Throwable>();
        this.rollbackPartitionedStepInvoked = false;
        this.setBatchJmsDispatcher(ServicesManagerStaticAnchor.getServicesManager().getBatchJmsDispatcher());
        this.isMultiJvm = this.isMultiJvm();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setBatchJmsDispatcher(BatchDispatcher batchJmsDispatcher) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "setBatchJmsDispatcher", new Object[]{batchJmsDispatcher});
        }
        this.batchJmsDispatcher = batchJmsDispatcher;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "setBatchJmsDispatcher");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private BatchDispatcher getBatchJmsDispatcher() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getBatchJmsDispatcher", new Object[0]);
        }
        BatchDispatcher batchDispatcher = this.batchJmsDispatcher;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchDispatcher = batchDispatcher;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getBatchJmsDispatcher", batchDispatcher);
        }
        return batchDispatcher;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isMultiJvm() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isMultiJvm", new Object[0]);
        }
        boolean bl = this.getBatchJmsDispatcher() != null && this.isMultiJvmEnabled(this.runtimeWorkUnitExecution.getTopLevelJobProperties());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isMultiJvm", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isMultiJvmEnabled(Properties properties) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isMultiJvmEnabled", new Object[]{properties});
        }
        boolean bl = Boolean.parseBoolean(StringUtils.firstNonEmpty(properties.getProperty("com.ibm.websphere.batch.partition.multiJVM"), "true"));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isMultiJvmEnabled", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ZosJBatchSMFLogging getJBatchSMFLoggingService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getJBatchSMFLoggingService", new Object[0]);
        }
        ZosJBatchSMFLogging zosJBatchSMFLogging = ServicesManagerStaticAnchor.getServicesManager().getJBatchSMFService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            zosJBatchSMFLogging = zosJBatchSMFLogging;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getJBatchSMFLoggingService", zosJBatchSMFLogging);
        }
        return zosJBatchSMFLogging;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionStatus execute() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "execute", new Object[0]);
        }
        ExecutionStatus executionStatus = super.execute();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionStatus = executionStatus;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "execute", executionStatus);
        }
        return executionStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={JobExecutionNotRunningException.class})
    public void stop() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "stop", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            if (this.isStepStartingOrStarted()) {
                this.updateStepBatchStatus(BatchStatus.STOPPING);
                for (BatchPartitionWorkUnit partition : this.parallelBatchWorkUnits) {
                    try {
                        this.getBatchKernelService().stopWorkUnit(partition);
                    }
                    catch (JobExecutionNotRunningException e) {
                        logger.fine("Caught exception trying to stop work unit: " + partition + ", which was not running.");
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"232", (Object)this, (Object[])new Object[0]);
                        throw new IllegalStateException(e);
                    }
                }
            } else {
                logger.fine("Ignoring stop, since step not in a state which has a valid status (might not be far enough along to have a state yet)");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "stop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PartitionPlanDescriptor buildPartitionPlan() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "buildPartitionPlan", new Object[0]);
        }
        PartitionMapper partitionMapperModel = this.getStep().getPartition().getMapper();
        PartitionPlan partitionPlanModel = this.getStep().getPartition().getPlan();
        if (partitionMapperModel != null) {
            PartitionPlanDescriptor partitionPlanDescriptor = this.buildPartitionPlanFromMapper(partitionMapperModel);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                partitionPlanDescriptor = partitionPlanDescriptor;
                logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "buildPartitionPlan", partitionPlanDescriptor);
            }
            return partitionPlanDescriptor;
        }
        if (partitionPlanModel != null) {
            PartitionPlanDescriptor partitionPlanDescriptor = this.buildPartitionPlanFromPlanElement(partitionPlanModel);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                partitionPlanDescriptor = partitionPlanDescriptor;
                logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "buildPartitionPlan", partitionPlanDescriptor);
            }
            return partitionPlanDescriptor;
        }
        throw new IllegalArgumentException("Need plan or mapper but found neither.");
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PartitionPlanDescriptor buildPartitionPlanFromMapper(PartitionMapper partitionMapper) {
        PartitionMapperProxy partitionMapperProxy;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "buildPartitionPlanFromMapper", new Object[]{partitionMapper});
        }
        List<Property> propertyList = partitionMapper.getProperties() == null ? null : partitionMapper.getProperties().getPropertyList();
        InjectionReferences injectionRef = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, propertyList);
        try {
            partitionMapperProxy = ProxyFactory.createPartitionMapperProxy(partitionMapper.getRef(), injectionRef, this.runtimeStepExecution);
        }
        catch (ArtifactValidationException artifactValidationException) {
            void e;
            FFDCFilter.processException((Throwable)artifactValidationException, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"277", (Object)this, (Object[])new Object[]{partitionMapper});
            throw new BatchContainerServiceException("Cannot create the PartitionMapper [" + partitionMapper.getRef() + "]", (Throwable)e);
        }
        jakarta.batch.api.partition.PartitionPlan mapperPlan = partitionMapperProxy.mapPartitions();
        if (this.isRestartExecution()) {
            if (mapperPlan.getPartitionsOverride()) {
                this.setExecutionTypeIfNotSet(ExecutionType.RESTART_OVERRIDE);
            } else {
                this.setExecutionTypeIfNotSet(ExecutionType.RESTART_NORMAL);
            }
        } else {
            this.setExecutionTypeIfNotSet(ExecutionType.START);
        }
        PartitionPlanDescriptor retMe = new PartitionPlanDescriptor();
        retMe.setPartitionsOverride(mapperPlan.getPartitionsOverride());
        if (this.executionType == ExecutionType.RESTART_NORMAL) {
            retMe.setNumPartitionsInPlan(this.getTopLevelStepInstance().getPartitionPlanSize());
        } else {
            retMe.setNumPartitionsInPlan(mapperPlan.getPartitions());
        }
        if (mapperPlan.getThreads() == 0) {
            retMe.setThreads(retMe.getNumPartitionsInPlan());
        } else {
            retMe.setThreads(mapperPlan.getThreads());
        }
        retMe.setPartitionProperties(mapperPlan.getPartitionProperties());
        PartitionPlanDescriptor partitionPlanDescriptor = retMe;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            partitionPlanDescriptor = partitionPlanDescriptor;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "buildPartitionPlanFromMapper", partitionPlanDescriptor);
        }
        return partitionPlanDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PartitionPlanDescriptor buildPartitionPlanFromPlanElement(PartitionPlan partitionPlan) {
        int numThreads;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "buildPartitionPlanFromPlanElement", new Object[]{partitionPlan});
        }
        String partitionsAttr = partitionPlan.getPartitions();
        String threadsAttr = null;
        int numPartitions = Integer.MIN_VALUE;
        Properties[] partitionProps = null;
        if (partitionsAttr != null) {
            try {
                numPartitions = Integer.parseInt(partitionsAttr);
            }
            catch (NumberFormatException numberFormatException) {
                void e;
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"331", (Object)this, (Object[])new Object[]{partitionPlan});
                throw new IllegalArgumentException("Could not parse partition instances value in stepId: " + this.getStepName() + ", with instances=" + partitionsAttr, (Throwable)e);
            }
            partitionProps = new Properties[numPartitions];
            if (numPartitions < 0) {
                throw new IllegalArgumentException("Partition instances value must be 0 or greater in stepId: " + this.getStepName() + ", with instances=" + partitionsAttr);
            }
        }
        if ((threadsAttr = partitionPlan.getThreads()) != null) {
            try {
                numThreads = Integer.parseInt(threadsAttr);
                if (numThreads == 0) {
                    numThreads = numPartitions;
                }
            }
            catch (NumberFormatException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"349", (Object)this, (Object[])new Object[]{partitionPlan});
                throw new IllegalArgumentException("Could not parse partition threads value in stepId: " + this.getStepName() + ", with threads=" + threadsAttr, e);
            }
            if (numThreads < 0) {
                throw new IllegalArgumentException("Threads value must be 0 or greater in stepId: " + this.getStepName() + ", with threads=" + threadsAttr);
            }
        } else {
            numThreads = numPartitions;
        }
        if (partitionPlan.getProperties() != null) {
            List<? extends JSLProperties> jslProperties = partitionPlan.getProperties();
            for (JSLProperties jSLProperties : jslProperties) {
                Integer targetPartition = null;
                try {
                    targetPartition = Integer.parseInt(jSLProperties.getPartition());
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"369", (Object)this, (Object[])new Object[]{partitionPlan});
                    throw new IllegalArgumentException("Partition <properties> element should have an attributed  named 'partition' like <properties partition=\"2\"> , but instead found <null> or non-Integer value of: " + jSLProperties.getPartition());
                }
                try {
                    partitionProps[targetPartition.intValue()] = CloneUtility.jslPropertiesToJavaProperties(jSLProperties);
                }
                catch (ArrayIndexOutOfBoundsException nfe) {
                    void e;
                    FFDCFilter.processException((Throwable)nfe, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"375", (Object)this, (Object[])new Object[]{partitionPlan});
                    throw new BatchContainerRuntimeException("There are only " + numPartitions + " partition instances, but there are " + jslProperties.size() + " partition properties lists defined. Remember that partition indexing is 0 based like Java arrays.", (Throwable)e);
                }
            }
        }
        if (this.isRestartExecution()) {
            this.setExecutionTypeIfNotSet(ExecutionType.RESTART_NORMAL);
        } else {
            this.setExecutionTypeIfNotSet(ExecutionType.START);
        }
        PartitionPlanDescriptor retMe = new PartitionPlanDescriptor();
        retMe.setNumPartitionsInPlan(numPartitions);
        retMe.setThreads(numThreads);
        retMe.setPartitionProperties(partitionProps);
        retMe.setPartitionsOverride(false);
        PartitionPlanDescriptor partitionPlanDescriptor = retMe;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            partitionPlanDescriptor = partitionPlanDescriptor;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "buildPartitionPlanFromPlanElement", partitionPlanDescriptor);
        }
        return partitionPlanDescriptor;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setExecutionTypeIfNotSet(ExecutionType executionType) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "setExecutionTypeIfNotSet", new Object[]{executionType});
        }
        if (this.executionType == null) {
            logger.finer("Setting initial execution type value");
            this.executionType = executionType;
        } else {
            logger.finer("Not setting execution type value since it's already set");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "setExecutionTypeIfNotSet");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void markRestartAfterCompletion() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "markRestartAfterCompletion", new Object[0]);
        }
        this.getPersistenceManagerService().deleteStepThreadInstanceOfRelatedPartitions(this.getTopLevelStepInstanceKey());
        this.executionType = ExecutionType.RESTART_AFTER_COMPLETION;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "markRestartAfterCompletion");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isRestartExecution() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isRestartExecution", new Object[0]);
        }
        boolean bl = this.getTopLevelStepInstance().getStartCount() > 1;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isRestartExecution", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void invokeCoreStep() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "invokeCoreStep", new Object[0]);
        }
        this.currentPlan = this.buildPartitionPlan();
        this.validatePlanNumberOfPartitions();
        if (this.executionType == ExecutionType.RESTART_OVERRIDE) {
            this.rollbackPartitionedStep();
        }
        if (this.executionType == ExecutionType.RESTART_OVERRIDE) {
            this.cleanupPreviousPartitionData();
        }
        this.persistCurrentPlanSize();
        this.setPartitionReplyQueue(this.isMultiJvm ? this.getBatchJmsDispatcher().createPartitionReplyQueue() : new PartitionReplyQueueLocal());
        this.executeAndWaitForCompletion();
        this.getPartitionReplyQueue().close();
        this.checkFinishedPartitionsForFailures();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "invokeCoreStep");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void validatePlanNumberOfPartitions() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "validatePlanNumberOfPartitions", new Object[0]);
        }
        int numPreviousPartitions = this.getTopLevelStepInstance().getPartitionPlanSize();
        int numCurrentPartitions = this.currentPlan.getNumPartitionsInPlan();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("For step: " + this.getStepName() + ", previous num partitions = " + numPreviousPartitions + ", and current num partitions = " + numCurrentPartitions);
        }
        if (this.executionType == ExecutionType.RESTART_NORMAL) {
            if (numPreviousPartitions == -1) {
                logger.fine("For step: " + this.getStepName() + ", previous num partitions has not been initialized, so don't validate the current plan size against it");
            } else if (numCurrentPartitions != numPreviousPartitions) {
                throw new IllegalArgumentException("Partition not configured for override, and previous execution used " + numPreviousPartitions + " number of partitions, while current plan uses a different number: " + numCurrentPartitions);
            }
        }
        if (numCurrentPartitions < 0) {
            throw new IllegalArgumentException("Partition plan size is calculated as " + numCurrentPartitions + ", must be greater than or equal to 0.");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "validatePlanNumberOfPartitions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void persistCurrentPlanSize() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "persistCurrentPlanSize", new Object[0]);
        }
        this.getPersistenceManagerService().updateStepThreadInstanceWithPartitionPlanSize(this.getTopLevelStepInstanceKey(), this.currentPlan.getNumPartitionsInPlan());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "persistCurrentPlanSize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private TopLevelStepInstanceKey getTopLevelStepInstanceKey() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getTopLevelStepInstanceKey", new Object[0]);
        }
        TopLevelStepInstanceKey topLevelStepInstanceKey = (TopLevelStepInstanceKey)this.getStepThreadInstanceKey();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            topLevelStepInstanceKey = topLevelStepInstanceKey;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getTopLevelStepInstanceKey", topLevelStepInstanceKey);
        }
        return topLevelStepInstanceKey;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PartitionPlanConfig buildPartitionPlanConfig(int partitionNum) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "buildPartitionPlanConfig", new Object[]{partitionNum});
        }
        PartitionPlanConfig retMe = new PartitionPlanConfig(partitionNum, this.currentPlan.getPartitionProperties(partitionNum));
        retMe.setStepName(this.getStepName());
        retMe.setTopLevelNameInstanceExecutionInfo(this.runtimeWorkUnitExecution.getTopLevelNameInstanceExecutionInfo());
        retMe.setTopLevelStepExecutionId(this.runtimeStepExecution.getTopLevelStepExecutionId());
        retMe.setJobProperties(this.runtimeWorkUnitExecution.getWorkUnitJobContext().getProperties());
        retMe.setCorrelationId(this.runtimeWorkUnitExecution.getCorrelationId());
        retMe.setCreateTime(new Date());
        PartitionPlanConfig partitionPlanConfig = retMe;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            partitionPlanConfig = partitionPlanConfig;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "buildPartitionPlanConfig", partitionPlanConfig);
        }
        return partitionPlanConfig;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List<Integer> getPartitionNumbersToExecute() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getPartitionNumbersToExecute", new Object[0]);
        }
        ArrayList<Integer> partitionsToExecute = new ArrayList<Integer>();
        List<Object> completedPartitions = new ArrayList();
        for (int i = 0; i < this.currentPlan.getNumPartitionsInPlan(); ++i) {
            partitionsToExecute.add(i);
        }
        if (this.executionType == ExecutionType.RESTART_NORMAL && !(completedPartitions = this.getPersistenceManagerService().getStepThreadInstancePartitionNumbersOfRelatedCompletedPartitions(this.getTopLevelStepInstanceKey())).isEmpty()) {
            partitionsToExecute.removeAll(completedPartitions);
        }
        ArrayList<Integer> arrayList = partitionsToExecute;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getPartitionNumbersToExecute", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isStoppingStoppedOrFailed() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isStoppingStoppedOrFailed", new Object[0]);
        }
        BatchStatus jobBatchStatus = this.runtimeWorkUnitExecution.getBatchStatus();
        if (jobBatchStatus.equals((Object)BatchStatus.STOPPING) || jobBatchStatus.equals((Object)BatchStatus.STOPPED) || jobBatchStatus.equals((Object)BatchStatus.FAILED)) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isStoppingStoppedOrFailed", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isStoppingStoppedOrFailed", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void startPartitions() throws JobStoppingException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "startPartitions", new Object[0]);
        }
        logger.fine("startedPartitions = " + this.startedPartitions + ", numThreads = " + this.currentPlan.getThreads());
        while (this.startedPartitions.size() < this.partitionsToExecute.size() && this.startedPartitions.size() - this.finishedPartitions.size() < this.currentPlan.getThreads()) {
            RuntimeWorkUnitExecution.StopLock stopLock;
            int nextPartitionNumber = this.partitionsToExecute.get(this.startedPartitions.size());
            logger.finer("nextPartitionNumber = " + nextPartitionNumber);
            PartitionPlanConfig config = this.buildPartitionPlanConfig(nextPartitionNumber);
            RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
            synchronized (stopLock2) {
                this.startPartition(config);
            }
            this.startedPartitions.add(nextPartitionNumber);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "startPartitions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void startPartitionRemote(PartitionPlanConfig config) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "startPartitionRemote", new Object[]{config});
        }
        this.getBatchJmsDispatcher().startPartition(config, this.getStep(), this.getPartitionReplyQueue());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "startPartitionRemote");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void startPartitionLocal(PartitionPlanConfig config) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "startPartitionLocal", new Object[]{config});
        }
        Map.Entry<BatchPartitionWorkUnit, Future<?>> workUnitFutureEntry = this.getBatchKernelService().startPartition(config, this.getStep(), this.getPartitionReplyQueue(), false);
        this.parallelBatchWorkUnits.add(workUnitFutureEntry.getKey());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "startPartitionLocal");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean startPartition(PartitionPlanConfig config) throws JobStoppingException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "startPartition", new Object[]{config});
        }
        if (this.isStoppingStoppedOrFailed()) {
            throw new JobStoppingException();
        }
        if (this.isMultiJvm) {
            this.startPartitionRemote(config);
        } else {
            this.startPartitionLocal(config);
        }
        JoblogUtil.logToJobLogAndTraceOnly(Level.FINER, "partition.started", new Object[]{config.getPartitionNumber(), this.getStepName(), config.getTopLevelInstanceId(), config.getTopLevelExecutionId()}, logger);
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "startPartition", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void partitionFinishedReplyMessageReceived(PartitionReplyMsg msg) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "partitionFinishedReplyMessageReceived", new Object[]{msg});
        }
        JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "partition.ended", new Object[]{msg.getPartitionPlanConfig().getPartitionNumber(), msg.getBatchStatus(), msg.getExitStatus(), msg.getPartitionPlanConfig().getStepName(), msg.getPartitionPlanConfig().getTopLevelNameInstanceExecutionInfo().getInstanceId(), msg.getPartitionPlanConfig().getTopLevelNameInstanceExecutionInfo().getExecutionId()}, logger);
        this.addToFinishedPartitions(msg.getPartitionPlanConfig().getPartitionNumber(), msg.getBatchStatus());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "partitionFinishedReplyMessageReceived");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addToFinishedPartitions(Integer partitionNumber, BatchStatus batchStatus) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "addToFinishedPartitions", new Object[]{partitionNumber, batchStatus});
        }
        this.finishedPartitions.add(new FinishedPartition(partitionNumber, batchStatus));
        this.finishedPartitionNumbers.add(partitionNumber);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "addToFinishedPartitions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void analyzePartitionReplyMsg(PartitionReplyMsg msg) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "analyzePartitionReplyMsg", new Object[]{msg});
        }
        if (this.analyzerProxy == null) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "analyzePartitionReplyMsg");
            }
            return;
        }
        switch (msg.getMsgType()) {
            case PARTITION_COLLECTOR_DATA: {
                Serializable collectorData = this.deserializeCollectorData(msg.getCollectorData());
                logger.finer("Analyze collector data: " + collectorData);
                this.analyzerProxy.analyzeCollectorData(collectorData);
                break;
            }
            case PARTITION_FINAL_STATUS: {
                logger.fine("Calling analyzeStatus(): " + msg);
                this.analyzerProxy.analyzeStatus(msg.getBatchStatus(), msg.getExitStatus());
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "analyzePartitionReplyMsg");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Serializable deserializeCollectorData(byte[] bytes) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "deserializeCollectorData", new Object[]{bytes});
        }
        Serializable retVal = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try (DeserializationObjectInputStream ois = null;){
                ois = new DeserializationObjectInputStream((InputStream)bais, Thread.currentThread().getContextClassLoader());
                retVal = (Serializable)ois.readObject();
            }
        }
        catch (ClassNotFoundException bais) {
            FFDCFilter.processException((Throwable)bais, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"731", (Object)this, (Object[])new Object[]{bytes});
            throw new IllegalStateException("Problem while trying to deserialize the collector data");
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"733", (Object)this, (Object[])new Object[]{bytes});
            throw new IllegalStateException("Problem while trying to deserialize the collector data");
        }
        Serializable serializable = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            serializable = serializable;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "deserializeCollectorData", serializable);
        }
        return serializable;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PartitionReplyMsg waitForPartitionReplyMsg() {
        PartitionReplyMsg partitionReplyMsg;
        block3: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "waitForPartitionReplyMsg", new Object[0]);
            }
            try {
                partitionReplyMsg = this.getPartitionReplyQueue().take();
                if (logger == null || !logger.isLoggable(Level.FINER)) break block3;
            }
            catch (InterruptedException interruptedException) {
                void ie;
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"747", (Object)this, (Object[])new Object[0]);
                throw new BatchContainerRuntimeException((Throwable)ie);
            }
            partitionReplyMsg = partitionReplyMsg;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "waitForPartitionReplyMsg", partitionReplyMsg);
        }
        return partitionReplyMsg;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PartitionReplyMsg getPartitionReplyMsgNoWait() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getPartitionReplyMsgNoWait", new Object[0]);
        }
        PartitionReplyMsg partitionReplyMsg = this.getPartitionReplyQueue().takeWithoutWaiting();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            partitionReplyMsg = partitionReplyMsg;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getPartitionReplyMsgNoWait", partitionReplyMsg);
        }
        return partitionReplyMsg;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void waitForNextPartitionToFinish() throws JobStoppingException {
        block13: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "waitForNextPartitionToFinish", new Object[0]);
            }
            boolean isStoppingStoppedOrFailed = false;
            PartitionReplyMsg msg = null;
            while (true) {
                if (this.isMultiJvm && this.isStoppingStoppedOrFailed()) {
                    isStoppingStoppedOrFailed = true;
                }
                if (isStoppingStoppedOrFailed) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"793", (Object)this, (Object[])new Object[0]);
                    }
                    while ((msg = this.getPartitionReplyMsgNoWait()) != null) {
                        try {
                            this.analyzePartitionReplyMsg(msg);
                        }
                        catch (Throwable throwable) {
                            void t;
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"804", (Object)this, (Object[])new Object[0]);
                            this.analyzerExceptions.add((Throwable)t);
                        }
                        if (!this.isFinalMessageForPartition(msg)) continue;
                        this.partitionFinishedReplyMessageReceived(msg);
                    }
                    throw new JobStoppingException();
                }
                msg = this.waitForPartitionReplyMsg();
                if (msg == null) {
                    if (!this.isMultiJvm || !this.checkForRecoveredRemotePartitions()) continue;
                    break block13;
                }
                try {
                    this.analyzePartitionReplyMsg(msg);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"844", (Object)this, (Object[])new Object[0]);
                    this.analyzerExceptions.add(t);
                }
                if (this.isFinalMessageForPartition(msg)) break;
            }
            this.partitionFinishedReplyMessageReceived(msg);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "waitForNextPartitionToFinish");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean checkForRecoveredRemotePartitions() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "checkForRecoveredRemotePartitions", new Object[0]);
        }
        boolean retVal = false;
        long stepExecId = this.runtimeStepExecution.getTopLevelStepExecutionId();
        List<Integer> recoveredPartitions = this.getPersistenceManagerService().getRemotablePartitionsRecoveredForStepExecution(stepExecId);
        if (recoveredPartitions.size() > 0) {
            logger.finer("Found list: " + recoveredPartitions + " of new recovered remote partitions for stepExecId = " + stepExecId);
        } else {
            logger.finer("Did not find any recovered partitions for stepExecId = " + stepExecId);
        }
        for (Integer recoveredPartitionNum : recoveredPartitions) {
            if (this.finishedPartitionNumbers.contains(recoveredPartitionNum)) {
                logger.finer("Recovered remote partition # " + recoveredPartitionNum + " is already marked as finished.");
                continue;
            }
            retVal = true;
            logger.finer("Found new recovered remote partition # " + recoveredPartitionNum);
            this.handleRecoveredRemotePartition(recoveredPartitionNum);
        }
        boolean bl = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "checkForRecoveredRemotePartitions", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleRecoveredRemotePartition(int recoveredPartitionNum) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "handleRecoveredRemotePartition", new Object[]{recoveredPartitionNum});
        }
        JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "partition.ended", new Object[]{recoveredPartitionNum, BatchStatus.FAILED, "FAILED", this.getStepName(), this.runtimeWorkUnitExecution.getTopLevelNameInstanceExecutionInfo().getInstanceId(), this.runtimeWorkUnitExecution.getTopLevelNameInstanceExecutionInfo().getExecutionId()}, logger);
        this.addToFinishedPartitions(recoveredPartitionNum, BatchStatus.FAILED);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "handleRecoveredRemotePartition");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isFinalMessageForPartition(PartitionReplyMsg msg) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isFinalMessageForPartition", new Object[]{msg});
        }
        switch (msg.getMsgType()) {
            case PARTITION_FINAL_STATUS: {
                if (msg.getPartitionPlanConfig() != null) {
                    boolean bl = true;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        bl = bl;
                        logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isFinalMessageForPartition", bl);
                    }
                    return bl;
                }
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isFinalMessageForPartition", bl);
                }
                return bl;
            }
            case PARTITION_THREAD_COMPLETE: {
                boolean bl = true;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isFinalMessageForPartition", bl);
                }
                return bl;
            }
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isFinalMessageForPartition", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={JobStoppingException.class})
    private void executeAndWaitForCompletion() throws JobRestartException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "executeAndWaitForCompletion", new Object[0]);
        }
        if (this.isStoppingStoppedOrFailed()) {
            logger.fine("Job already in " + this.runtimeWorkUnitExecution.getWorkUnitJobContext().getBatchStatus().toString() + " state, exiting from executeAndWaitForCompletion() before beginning execution");
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "executeAndWaitForCompletion");
            }
            return;
        }
        this.partitionsToExecute = this.getPartitionNumbersToExecute();
        logger.fine("Partitions to execute in this run: " + this.partitionsToExecute + ".  Total number of partitions in step: " + this.currentPlan.getNumPartitionsInPlan());
        while (this.finishedPartitions.size() < this.partitionsToExecute.size()) {
            logger.fine("Iterate through loop with finishedPartitions = " + this.finishedPartitions);
            try {
                this.startPartitions();
            }
            catch (JobStoppingException e) {
                break;
            }
            if (this.finishedPartitions.size() >= this.partitionsToExecute.size()) break;
            try {
                this.waitForNextPartitionToFinish();
            }
            catch (JobStoppingException e) {
                // empty catch block
                break;
            }
        }
        if (!this.analyzerExceptions.isEmpty()) {
            this.rollbackPartitionedStep();
            throw new BatchContainerRuntimeException("Exception previously thrown by Analyzer, rolling back step.", this.analyzerExceptions.get(0));
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "executeAndWaitForCompletion");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void checkFinishedPartitionsForFailures() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "checkFinishedPartitionsForFailures", new Object[0]);
        }
        ArrayList<String> failingPartitionSeen = new ArrayList<String>();
        boolean stoppedPartitionSeen = false;
        for (FinishedPartition p : this.finishedPartitions) {
            int partitionNumber = p.partitionNum;
            BatchStatus batchStatus = p.batchStatus;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("For partitioned step: " + this.getStepName() + ", the partition # " + partitionNumber + " ended with status '" + batchStatus);
            }
            if (batchStatus.equals((Object)BatchStatus.FAILED)) {
                String msg = "For partitioned step: " + this.getStepName() + ", the partition # " + partitionNumber + " ended with status '" + batchStatus;
                failingPartitionSeen.add(msg);
            }
            if (!batchStatus.equals((Object)BatchStatus.STOPPED)) continue;
            stoppedPartitionSeen = true;
        }
        if (!failingPartitionSeen.isEmpty()) {
            this.markStepForFailure();
            this.rollbackPartitionedStep();
            throw new BatchContainerRuntimeException("One or more partitions failed: " + failingPartitionSeen);
        }
        if (this.isStoppingStoppedOrFailed()) {
            this.rollbackPartitionedStep();
        } else if (stoppedPartitionSeen) {
            this.markStepForFailure();
            this.rollbackPartitionedStep();
        } else if (this.partitionReducerProxy != null) {
            this.partitionReducerProxy.beforePartitionedStepCompletion();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "checkFinishedPartitionsForFailures");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void rollbackPartitionedStep() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "rollbackPartitionedStep", new Object[0]);
        }
        this.rollbackPartitionedStepInvoked = true;
        if (this.partitionReducerProxy != null) {
            this.partitionReducerProxy.rollbackPartitionedStep();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "rollbackPartitionedStep");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private TopLevelStepInstanceEntity getTopLevelStepInstance() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getTopLevelStepInstance", new Object[0]);
        }
        TopLevelStepInstanceEntity topLevelStepInstanceEntity = (TopLevelStepInstanceEntity)this.getStepThreadInstance();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            topLevelStepInstanceEntity = topLevelStepInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "getTopLevelStepInstance", topLevelStepInstanceEntity);
        }
        return topLevelStepInstanceEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setupStepArtifacts() {
        PartitionReducer partitionReducer;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "setupStepArtifacts", new Object[0]);
        }
        InjectionReferences injectionRef = null;
        injectionRef = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, null);
        this.stepListeners = this.runtimeWorkUnitExecution.getListenerFactory().getStepListeners(this.getStep(), injectionRef, this.runtimeStepExecution);
        Analyzer analyzer = this.getStep().getPartition().getAnalyzer();
        if (analyzer != null) {
            List<Property> propList = analyzer.getProperties() == null ? null : analyzer.getProperties().getPropertyList();
            injectionRef = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, propList);
            try {
                this.analyzerProxy = ProxyFactory.createPartitionAnalyzerProxy(analyzer.getRef(), injectionRef, this.runtimeStepExecution);
            }
            catch (ArtifactValidationException artifactValidationException) {
                void e;
                FFDCFilter.processException((Throwable)artifactValidationException, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"1077", (Object)this, (Object[])new Object[0]);
                throw new BatchContainerServiceException("Cannot create the analyzer [" + analyzer.getRef() + "]", (Throwable)e);
            }
        }
        if ((partitionReducer = this.getStep().getPartition().getReducer()) != null) {
            List<Property> propList = partitionReducer.getProperties() == null ? null : partitionReducer.getProperties().getPropertyList();
            injectionRef = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, propList);
            try {
                this.partitionReducerProxy = ProxyFactory.createPartitionReducerProxy(partitionReducer.getRef(), injectionRef, this.runtimeStepExecution);
            }
            catch (ArtifactValidationException artifactValidationException) {
                void e;
                FFDCFilter.processException((Throwable)artifactValidationException, (String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", (String)"1093", (Object)this, (Object[])new Object[0]);
                throw new BatchContainerServiceException("Cannot create the reducer [" + partitionReducer.getRef() + "]", (Throwable)e);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "setupStepArtifacts");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void invokePreStepArtifacts() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "invokePreStepArtifacts", new Object[0]);
        }
        if (this.stepListeners != null) {
            for (StepListenerProxy listenerProxy : this.stepListeners) {
                listenerProxy.beforeStep();
            }
        }
        if (this.partitionReducerProxy != null) {
            this.partitionReducerProxy.beginPartitionedStep();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "invokePreStepArtifacts");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void invokePostStepArtifacts() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "invokePostStepArtifacts", new Object[0]);
        }
        if (this.partitionReducerProxy != null) {
            if (this.rollbackPartitionedStepInvoked) {
                this.partitionReducerProxy.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.ROLLBACK);
            } else {
                this.partitionReducerProxy.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.COMMIT);
            }
        }
        if (this.stepListeners != null) {
            for (StepListenerProxy listenerProxy : this.stepListeners) {
                listenerProxy.afterStep();
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "invokePostStepArtifacts");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void updateStepExecution() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "updateStepExecution", new Object[0]);
        }
        TopLevelStepExecutionEntity topLevelStepExecutionEntity = this.getPersistenceManagerService().updateStepExecutionWithPartitionAggregate(this.runtimeStepExecution);
        topLevelStepExecutionEntity.getJobExecution().setLastUpdatedTime(this.runtimeStepExecution.getLastUpdatedTime());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "updateStepExecution");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isTopLevelStepThreadOfPartitionedStep() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isTopLevelStepThreadOfPartitionedStep", new Object[0]);
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "isTopLevelStepThreadOfPartitionedStep", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void cleanupPreviousPartitionData() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "cleanupPreviousPartitionData", new Object[0]);
        }
        this.getPersistenceManagerService().deleteStepThreadInstanceOfRelatedPartitions(this.getTopLevelStepInstanceKey());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl", "cleanupPreviousPartitionData");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobStoppingException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl$JobStoppingException", JobStoppingException.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class PartitionPlanDescriptor {
        private int numPartitionsInPlan;
        private int threadCount;
        private Properties[] partitionProperties;
        private boolean partitionsOverride;
        static final long serialVersionUID = -1557271346801794957L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PartitionPlanDescriptor() {
        }

        public int getNumPartitionsInPlan() {
            return this.numPartitionsInPlan;
        }

        public void setNumPartitionsInPlan(int numPartitionsInPlan) {
            this.numPartitionsInPlan = numPartitionsInPlan;
        }

        public int getThreads() {
            return this.threadCount;
        }

        public void setThreads(int threadCount) {
            this.threadCount = threadCount;
        }

        public Properties getPartitionProperties(int partitionNum) {
            return this.partitionProperties != null && this.partitionProperties.length > partitionNum ? this.partitionProperties[partitionNum] : null;
        }

        public void setPartitionProperties(Properties[] partitionProperties) {
            this.partitionProperties = partitionProperties;
        }

        public void setPartitionsOverride(boolean override) {
            this.partitionsOverride = override;
        }

        public boolean getPartitionsOverride() {
            return this.partitionsOverride;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("partitionCount = " + this.numPartitionsInPlan);
            buf.append(", threadCount = " + this.threadCount);
            buf.append(", partitionsOverride = " + this.partitionsOverride);
            buf.append(", partitionProperties = " + this.partitionProperties);
            return buf.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl$PartitionPlanDescriptor", PartitionPlanDescriptor.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class FinishedPartition {
        Integer partitionNum;
        BatchStatus batchStatus;
        static final long serialVersionUID = -423430849843076825L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        FinishedPartition(Integer partitionNum, BatchStatus batchStatus) {
            this.partitionNum = partitionNum;
            this.batchStatus = batchStatus;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.controller.impl.PartitionedStepControllerImpl$FinishedPartition", FinishedPartition.class, (String)"wsbatch", null);
        }
    }

    private static enum ExecutionType {
        START,
        RESTART_NORMAL,
        RESTART_OVERRIDE,
        RESTART_AFTER_COMPLETION;

    }
}

