/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.concurrent.persistent.AutoPurge;
import com.ibm.websphere.concurrent.persistent.PersistentExecutor;
import com.ibm.websphere.concurrent.persistent.PersistentStoreException;
import com.ibm.websphere.concurrent.persistent.TaskState;
import com.ibm.websphere.concurrent.persistent.TaskStatus;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.classloading.ClassLoaderIdentifierService;
import com.ibm.ws.concurrent.persistent.db.DatabaseTaskStore;
import com.ibm.ws.concurrent.persistent.ejb.TaskLocker;
import com.ibm.ws.concurrent.persistent.ejb.TimerStatus;
import com.ibm.ws.concurrent.persistent.ejb.TimerTrigger;
import com.ibm.ws.concurrent.persistent.ejb.TimersPersistentExecutor;
import com.ibm.ws.concurrent.persistent.internal.ApplicationTracker;
import com.ibm.ws.concurrent.persistent.internal.Config;
import com.ibm.ws.concurrent.persistent.internal.InvokerTask;
import com.ibm.ws.concurrent.persistent.internal.PersistentExecutorMBeanImpl;
import com.ibm.ws.concurrent.persistent.internal.PollingManager;
import com.ibm.ws.concurrent.persistent.internal.TaskInfo;
import com.ibm.ws.concurrent.persistent.internal.TaskStatusImpl;
import com.ibm.ws.concurrent.persistent.internal.Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.concurrent.persistent.PartitionRecord;
import com.ibm.wsspi.concurrent.persistent.TaskRecord;
import com.ibm.wsspi.concurrent.persistent.TaskStore;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import com.ibm.wsspi.persistence.DDLGenerationParticipant;
import com.ibm.wsspi.persistence.DatabaseStore;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import com.ibm.wsspi.threadcontext.WSContextService;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.Trigger;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.management.MalformedObjectNameException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.concurrent.persistent.executor", service={ApplicationRecycleComponent.class, DDLGenerationParticipant.class, ExecutorService.class, ManagedExecutorService.class, ManagedScheduledExecutorService.class, PersistentExecutor.class, ResourceFactory.class, RuntimeUpdateListener.class, ScheduledExecutorService.class, ServerQuiesceListener.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"creates.objectClass=java.util.concurrent.ExecutorService", "creates.objectClass=java.util.concurrent.ScheduledExecutorService", "creates.objectClass=jakarta.enterprise.concurrent.ManagedExecutorService", "creates.objectClass=jakarta.enterprise.concurrent.ManagedScheduledExecutorService", "creates.objectClass=com.ibm.websphere.concurrent.persistent.PersistentExecutor"})
public class PersistentExecutorImpl
implements ApplicationRecycleComponent,
DDLGenerationParticipant,
ResourceFactory,
RuntimeUpdateListener,
PersistentExecutor,
ServerQuiesceListener,
TimersPersistentExecutor {
    private static final TraceComponent tc = Tr.register(PersistentExecutorImpl.class, (String)"persistentExecutor", (String)"com.ibm.ws.concurrent.persistent.resources.CWWKCMessages");
    private static final String APP_RECYCLE_SERVICE = "appRecycleService";
    private static final PrivilegedExceptionAction<String> getHostName = new PrivilegedExceptionAction<String>(){
        static final long serialVersionUID = 821799325032174751L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @Trivial
        public String run() throws UnknownHostException {
            return InetAddress.getLocalHost().getHostName();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl$1", 1.class, (String)"persistentExecutor", (String)"com.ibm.ws.concurrent.persistent.resources.CWWKCMessages");
        }
    };
    private static final String OTHER_SPEC_IDENTITY_NAME;
    private static final String OTHER_SPEC_LONGRUNNING_HINT;
    private static final String OTHER_SPEC_TRANSACTION_CONSTANT;
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    final AtomicServiceReference<ApplicationTracker> appTrackerRef = new AtomicServiceReference("ApplicationTracker");
    ClassLoaderIdentifierService classloaderIdSvc;
    final AtomicReference<Config> configRef = new AtomicReference();
    private final AtomicServiceReference<WSContextService> contextSvcRef = new AtomicServiceReference("ContextService");
    volatile boolean deactivated;
    private final Map<String, String> defaultExecProps = new TreeMap<String, String>();
    ExecutorService executor;
    final ConcurrentHashMap<Long, Boolean> inMemoryTaskIds = new ConcurrentHashMap();
    private final AtomicServiceReference<LocalTransactionCurrent> localTranCurrentRef = new AtomicServiceReference("LocalTransactionCurrent");
    private WsLocationAdmin locationAdmin;
    private PersistentExecutorMBeanImpl mbean = null;
    String name;
    private long partitionId;
    private long partitionIdForPolling;
    private final ReadWriteLock partitionIdLock = new ReentrantReadWriteLock();
    private DatabaseStore persistentStore;
    private String persistentStoreDisplayId;
    private final AtomicReference<ScheduledFuture<?>> pollingFutureRef = new AtomicReference();
    private final AtomicBoolean pollingStartSignalReceived = new AtomicBoolean();
    @Reference(target="(deferrable=false)")
    protected volatile ScheduledExecutorService scheduledExecutor;
    private final AtomicServiceReference<SerializationService> serializationSvcRef = new AtomicServiceReference("SerializationService");
    TaskStore taskStore;
    final AtomicServiceReference<EmbeddableWebSphereTransactionManager> tranMgrRef = new AtomicServiceReference("TransactionManager");
    private VariableRegistry variableRegistry;
    private final PollingManager readyForPollingTask = new PollingManager();
    private final ReadWriteLock configUpdatePendingQueueLock = new ReentrantReadWriteLock();
    private int configUpdatesInProgress = 0;
    private final LinkedList<InvokerTask> configUpdatePendingQueue = new LinkedList();
    private volatile FutureMonitor _futureMonitor;
    private final Runnable processConfigUpdateQueue = new Runnable(){
        static final long serialVersionUID = -5886966384020742052L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @Trivial
        public void run() {
            while (true) {
                InvokerTask r;
                PersistentExecutorImpl.this.configUpdatePendingQueueLock.writeLock().lock();
                try {
                    r = (InvokerTask)PersistentExecutorImpl.this.configUpdatePendingQueue.poll();
                    if (r == null) {
                        return;
                    }
                }
                finally {
                    PersistentExecutorImpl.this.configUpdatePendingQueueLock.writeLock().unlock();
                }
                if (PersistentExecutorImpl.this.deactivated) continue;
                PersistentExecutorImpl.this.executor.submit(r);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl$2", 2.class, (String)"persistentExecutor", (String)"com.ibm.ws.concurrent.persistent.resources.CWWKCMessages");
        }
    };
    static final long serialVersionUID = 6587646024534253923L;

    @Trivial
    @ManualTrace
    protected void activate(ComponentContext context) throws MalformedObjectNameException {
        Dictionary properties = context.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{properties});
        }
        Config config = new Config(properties);
        this.configRef.set(config);
        String displayId = (String)properties.get("config.displayId");
        String string = this.name = displayId.contains("]/persistentExecutor[") ? displayId : (String)properties.get("id");
        if (this.name == null) {
            this.name = config.jndiName;
            if (this.name == null) {
                throw new IllegalArgumentException("id: null, jndiName: null");
            }
        }
        this.defaultExecProps.put("jakarta.enterprise.concurrent.TRANSACTION", "USE_TRANSACTION_OF_EXECUTION_THREAD");
        this.defaultExecProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
        this.defaultExecProps.put("com.ibm.ws.concurrent.TASK_OWNER", this.name);
        this.appTrackerRef.activate(context);
        this.contextSvcRef.activate(context);
        this.localTranCurrentRef.activate(context);
        this.serializationSvcRef.activate(context);
        this.tranMgrRef.activate(context);
        this.taskStore = DatabaseTaskStore.get(this.persistentStore);
        if (config.initialPollDelay < 0L) {
            this.readyForPollingTask.add(16);
        }
        if (config.enableTaskExecution) {
            this.readyForPollingTask.add(2);
        }
        if (this.readyForPollingTask.addAndCheckIfReady(4)) {
            this.startPollingTask(config);
        }
        if (config.missedTaskThreshold == -1L) {
            this.mbean = new PersistentExecutorMBeanImpl(this);
            this.mbean.register(InvokerTask.priv.getBundleContext(context));
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    @Trivial
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new IllegalStateException(new UnsupportedOperationException("awaitTermination"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cancel(String pattern, Character escape, TaskState state, boolean inState) {
        String owner = this.getOwner();
        if (owner == null) {
            return 0;
        }
        pattern = pattern == null ? null : Utils.normalizeString(pattern);
        int updateCount = 0;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            updateCount = this.taskStore.cancel(pattern, escape, state, inState, owner);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"425", (Object)this, (Object[])new Object[]{pattern, escape, state, inState});
            tranController.setFailure(x);
        }
        finally {
            PersistentStoreException x = tranController.postInvoke(PersistentStoreException.class);
            if (x != null) {
                throw x;
            }
        }
        return updateCount;
    }

    @Trivial
    public void close() {
        throw new IllegalStateException(new UnsupportedOperationException("close"));
    }

    public <U> CompletableFuture<U> completedFuture(U value) {
        throw new UnsupportedOperationException();
    }

    public <U> CompletionStage<U> completedStage(U value) {
        throw new UnsupportedOperationException();
    }

    public <T> CompletableFuture<T> copy(CompletableFuture<T> stage) {
        throw new UnsupportedOperationException();
    }

    public <T> CompletionStage<T> copy(CompletionStage<T> stage) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createProperty(String name, String value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name: " + name);
        }
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("value: " + value);
        }
        boolean created = false;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            created = this.taskStore.createProperty(name, value);
            if (!created) {
                tranController.expectRollback();
            }
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"481", (Object)this, (Object[])new Object[]{name, value});
            tranController.setFailure(x);
        }
        finally {
            PersistentStoreException x = tranController.postInvoke(PersistentStoreException.class);
            if (x != null) {
                throw x;
            }
        }
        return created;
    }

    public Object createResource(ResourceInfo ref) throws Exception {
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cData != null) {
            this.applications.add(cData.getJ2EEName().getApplication());
        }
        return this;
    }

    protected void deactivate(ComponentContext context) throws Exception {
        this.deactivated = true;
        if (this.mbean != null) {
            this.mbean.unregister();
            this.mbean = null;
        }
        if (this.taskStore != null) {
            DatabaseTaskStore.unget(this.persistentStore);
        }
        this.appTrackerRef.deactivate(context);
        this.contextSvcRef.deactivate(context);
        this.localTranCurrentRef.deactivate(context);
        this.serializationSvcRef.deactivate(context);
        this.tranMgrRef.deactivate(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object deserialize(byte[] bytes, ClassLoader loader) throws ClassNotFoundException, IOException {
        if (bytes == null) {
            return null;
        }
        InflaterInputStream iin = new InflaterInputStream(new ByteArrayInputStream(bytes));
        SerializationService serializationSvc = (SerializationService)this.serializationSvcRef.getService();
        try (ObjectInputStream oin = loader == null || serializationSvc == null ? new ObjectInputStream(iin) : serializationSvc.createObjectInputStream((InputStream)iin, loader);){
            Object object = oin.readObject();
            return object;
        }
    }

    public void execute(Runnable runnable) {
        TaskInfo taskInfo = new TaskInfo(false);
        taskInfo.initForOneShotTask(0L);
        this.newTask(runnable, taskInfo, null, null);
    }

    public <U> CompletableFuture<U> failedFuture(Throwable ex) {
        throw new UnsupportedOperationException();
    }

    public <U> CompletionStage<U> failedStage(Throwable ex) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[][] findPartitionInfo(String hostName, String userDir, String libertyServerName, String executorIdentifier) throws Exception {
        Config config = this.configRef.get();
        if (config.missedTaskThreshold != -1L) {
            throw new UnsupportedOperationException();
        }
        PartitionRecord criteria = new PartitionRecord(false);
        if (hostName != null) {
            criteria.setHostName(hostName);
        }
        if (userDir != null) {
            criteria.setUserDir(userDir);
        }
        if (libertyServerName != null) {
            criteria.setLibertyServer(libertyServerName);
        }
        if (executorIdentifier != null) {
            criteria.setExecutor(executorIdentifier);
        }
        List<PartitionRecord> records = null;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            records = this.taskStore.find(criteria);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"601", (Object)this, (Object[])new Object[]{hostName, userDir, libertyServerName, executorIdentifier});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        String[][] partitionInfo = new String[records == null ? 0 : records.size()][5];
        if (records != null) {
            for (int i = 0; i < records.size(); ++i) {
                PartitionRecord record = records.get(i);
                partitionInfo[i][0] = Long.toString(record.getId());
                partitionInfo[i][1] = record.getHostName();
                partitionInfo[i][2] = record.getUserDir();
                partitionInfo[i][3] = record.getLibertyServer();
                partitionInfo[i][4] = record.getExecutor();
            }
        }
        return partitionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> findProperties(String pattern, Character escape) throws Exception {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        Map<String, String> map = null;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            map = this.taskStore.getProperties(Utils.normalizeString(pattern), escape);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"633", (Object)this, (Object[])new Object[]{pattern, escape});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long[] findTaskIds(long partition, TaskState state, boolean inState, Long minId, Integer maxResults) throws Exception {
        Config config = this.configRef.get();
        if (config.missedTaskThreshold != -1L) {
            throw new UnsupportedOperationException();
        }
        Long[] results = null;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            List<Long> ids = this.taskStore.findTaskIds(null, null, state, inState, minId, maxResults, null, partition);
            results = ids.toArray(new Long[ids.size()]);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"671", (Object)this, (Object[])new Object[]{partition, state, inState, minId, maxResults});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> findTaskIds(String pattern, Character escape, TaskState state, boolean inState, Long minId, Integer maxResults) {
        String owner = this.getOwner();
        if (owner == null) {
            return Collections.emptyList();
        }
        pattern = pattern == null ? null : Utils.normalizeString(pattern);
        List<Long> results = null;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            results = this.taskStore.findTaskIds(pattern, escape, state, inState, minId, maxResults, owner, null);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"695", (Object)this, (Object[])new Object[]{pattern, escape, state, inState, minId, maxResults});
            tranController.setFailure(x);
        }
        finally {
            PersistentStoreException x = tranController.postInvoke(PersistentStoreException.class);
            if (x != null) {
                throw x;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TimerStatus<?>> findTimerStatus(String appName, String pattern, Character escape, TaskState state, boolean inState, Long minId, Integer maxResults) throws Exception {
        pattern = pattern == null ? null : Utils.normalizeString(pattern);
        List<TaskStatus<?>> results = null;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            results = this.taskStore.findTaskStatus(pattern, escape, state, inState, minId, maxResults, appName, true, this);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"716", (Object)this, (Object[])new Object[]{appName, pattern, escape, state, inState, minId, maxResults});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        List<TaskStatus<?>> timerStatusResults = results;
        return timerStatusResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskStatus<?>> findTaskStatus(String pattern, Character escape, TaskState state, boolean inState, Long minId, Integer maxResults) {
        String owner = this.getOwner();
        if (owner == null) {
            return Collections.emptyList();
        }
        pattern = pattern == null ? null : Utils.normalizeString(pattern);
        List<TaskStatus<?>> results = null;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            results = this.taskStore.findTaskStatus(pattern, escape, state, inState, minId, maxResults, owner, false, this);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"742", (Object)this, (Object[])new Object[]{pattern, escape, state, inState, minId, maxResults});
            tranController.setFailure(x);
        }
        finally {
            PersistentStoreException x = tranController.postInvoke(PersistentStoreException.class);
            if (x != null) {
                throw x;
            }
        }
        return results;
    }

    public void generate(Writer out) throws Exception {
        ((DatabaseTaskStore)this.taskStore).getPersistenceServiceUnit().generateDDL(out);
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    public ContextService getContextService() {
        throw new UnsupportedOperationException();
    }

    public String getDDLFileName() {
        String name = this.persistentStoreDisplayId;
        if (!name.contains("]/")) {
            name = name + "_persistentExecutor";
        }
        return name;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.applications);
        this.applications.removeAll(members);
        return members;
    }

    @Trivial
    Map<String, String> getExecutionProperties(Object task) {
        Map<String, String> execProps;
        Map<String, String> map = execProps = task instanceof ManagedTask ? ((ManagedTask)task).getExecutionProperties() : null;
        if (execProps == null) {
            execProps = this.defaultExecProps;
        } else {
            TreeMap<Object, Object> mergedProps;
            if (execProps.containsKey("jakarta.enterprise.concurrent.TRANSACTION") || execProps.containsKey(OTHER_SPEC_TRANSACTION_CONSTANT)) {
                mergedProps = new TreeMap<String, String>();
                mergedProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
                mergedProps.put("com.ibm.ws.concurrent.TASK_OWNER", this.name);
            } else {
                mergedProps = new TreeMap<String, String>(this.defaultExecProps);
            }
            mergedProps.putAll(execProps);
            execProps = mergedProps;
        }
        return execProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getNextExecutionTime(long taskId) throws Exception {
        TaskRecord taskRecord = null;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            taskRecord = this.taskStore.getNextExecutionTime(taskId, null);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"830", (Object)this, (Object[])new Object[]{taskId});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        return taskRecord == null || (taskRecord.getState() & TaskState.ENDED.bit) != 0 ? null : new Date(taskRecord.getNextExecutionTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Exception.class})
    long getPartitionId() throws Exception {
        this.partitionIdLock.readLock().lock();
        try {
            if (this.partitionId != 0L) {
                long l = this.partitionId;
                return l;
            }
        }
        finally {
            this.partitionIdLock.readLock().unlock();
        }
        PartitionRecord partitionEntry = new PartitionRecord(false);
        partitionEntry.setExecutor(this.name);
        partitionEntry.setLibertyServer(this.locationAdmin.getServerName());
        partitionEntry.setUserDir(this.variableRegistry.resolveString("${wlp.user.dir}"));
        partitionEntry.setHostName(AccessController.doPrivileged(getHostName));
        partitionEntry.setExpiry(Long.MAX_VALUE);
        EmbeddableWebSphereTransactionManager tranMgr = (EmbeddableWebSphereTransactionManager)this.tranMgrRef.getServiceWithException();
        int tranStatus = tranMgr.getStatus();
        LocalTransactionCurrent ltcCurrent = tranStatus == 6 ? (LocalTransactionCurrent)this.localTranCurrentRef.getServiceWithException() : null;
        LocalTransactionCoordinator suspendedLTC = ltcCurrent == null ? null : ltcCurrent.suspend();
        Transaction suspendedTran = tranStatus == 0 ? tranMgr.suspend() : null;
        Exception failure = null;
        try {
            block32: {
                this.partitionIdLock.writeLock().lock();
                if (this.partitionId == 0L) break block32;
                long l = this.partitionId;
                this.partitionIdLock.writeLock().unlock();
                return l;
            }
            try {
                Long newPartitionId = null;
                for (int i = 0; i < 2 && newPartitionId == null && !this.deactivated; ++i) {
                    failure = null;
                    tranMgr.begin();
                    try {
                        newPartitionId = this.taskStore.findOrCreate(partitionEntry);
                        continue;
                    }
                    catch (Exception x) {
                        failure = x;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("deactivated? " + this.deactivated), (Object[])new Object[]{x});
                        continue;
                    }
                    finally {
                        if (failure == null && newPartitionId != null) {
                            tranMgr.commit();
                            this.partitionId = newPartitionId;
                        } else {
                            tranMgr.rollback();
                        }
                    }
                }
                long l = this.partitionId;
                this.partitionIdLock.writeLock().unlock();
                return l;
            }
            catch (Throwable throwable) {
                this.partitionIdLock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            try {
                if (suspendedTran != null) {
                    tranMgr.resume(suspendedTran);
                } else if (suspendedLTC != null) {
                    ltcCurrent.resume(suspendedLTC);
                }
            }
            finally {
                if (failure != null) {
                    throw failure;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Exception.class})
    long getPollPartitionId() throws Exception {
        this.partitionIdLock.readLock().lock();
        try {
            if (this.partitionIdForPolling != 0L) {
                long l = this.partitionIdForPolling;
                return l;
            }
        }
        finally {
            this.partitionIdLock.readLock().unlock();
        }
        EmbeddableWebSphereTransactionManager tranMgr = (EmbeddableWebSphereTransactionManager)this.tranMgrRef.getServiceWithException();
        int tranStatus = tranMgr.getStatus();
        LocalTransactionCurrent ltcCurrent = tranStatus == 6 ? (LocalTransactionCurrent)this.localTranCurrentRef.getServiceWithException() : null;
        LocalTransactionCoordinator suspendedLTC = ltcCurrent == null ? null : ltcCurrent.suspend();
        Transaction suspendedTran = tranStatus == 0 ? tranMgr.suspend() : null;
        Exception failure = null;
        try {
            block32: {
                this.partitionIdLock.writeLock().lock();
                if (this.partitionIdForPolling == 0L) break block32;
                long l = this.partitionIdForPolling;
                this.partitionIdLock.writeLock().unlock();
                return l;
            }
            try {
                Long newPollPartitionId = null;
                for (int i = 0; i < 10 && newPollPartitionId == null && !this.deactivated; ++i) {
                    failure = null;
                    tranMgr.begin();
                    try {
                        newPollPartitionId = this.taskStore.findOrCreatePollPartition();
                        continue;
                    }
                    catch (Exception x) {
                        failure = x;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("deactivated? " + this.deactivated), (Object[])new Object[]{x});
                        continue;
                    }
                    finally {
                        if (failure == null && newPollPartitionId != null) {
                            tranMgr.commit();
                            this.partitionIdForPolling = newPollPartitionId;
                        } else {
                            tranMgr.rollback();
                        }
                    }
                }
                long l = this.partitionIdForPolling;
                this.partitionIdLock.writeLock().unlock();
                return l;
            }
            catch (Throwable throwable) {
                this.partitionIdLock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            try {
                if (suspendedTran != null) {
                    tranMgr.resume(suspendedTran);
                } else if (suspendedLTC != null) {
                    ltcCurrent.resume(suspendedLTC);
                }
            }
            finally {
                if (failure != null) {
                    throw failure;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String name) {
        String value = null;
        if (name != null) {
            TransactionController tranController = new TransactionController();
            try {
                tranController.preInvoke();
                value = this.taskStore.getProperty(name);
            }
            catch (Throwable x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"989", (Object)this, (Object[])new Object[]{name});
                tranController.setFailure(x);
            }
            finally {
                PersistentStoreException x = tranController.postInvoke(PersistentStoreException.class);
                if (x != null) {
                    throw x;
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> TaskStatus<T> getStatus(long taskId) {
        String owner = this.getOwner();
        if (owner == null) {
            return null;
        }
        TransactionController tranController = new TransactionController();
        TaskRecord taskRecord = null;
        try {
            tranController.preInvoke();
            taskRecord = this.taskStore.findById(taskId, owner, false);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1019", (Object)this, (Object[])new Object[]{taskId});
            tranController.setFailure(x);
        }
        finally {
            PersistentStoreException x = tranController.postInvoke(PersistentStoreException.class);
            if (x != null) {
                throw x;
            }
        }
        return taskRecord == null ? null : new TaskStatusImpl(taskRecord, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> TimerStatus<T> getTimerStatus(long taskId) throws Exception {
        TransactionController tranController = new TransactionController();
        TaskRecord taskRecord = null;
        try {
            tranController.preInvoke();
            taskRecord = this.taskStore.findById(taskId, null, true);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1038", (Object)this, (Object[])new Object[]{taskId});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        return taskRecord == null ? null : new TaskStatusImpl(taskRecord, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimerTrigger getTimer(long taskId) throws ClassNotFoundException, Exception, IOException {
        TaskRecord taskRecord = null;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            taskRecord = this.taskStore.getTrigger(taskId);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1057", (Object)this, (Object[])new Object[]{taskId});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        if (taskRecord == null || (taskRecord.getState() & TaskState.ENDED.bit) != 0) {
            return null;
        }
        byte[] triggerBytes = taskRecord.getTrigger();
        TimerTrigger trigger = triggerBytes == null ? null : (TimerTrigger)this.deserialize(triggerBytes, InvokerTask.priv.getSystemClassLoader());
        return trigger;
    }

    @Trivial
    private final String getOwner() {
        int end;
        int start;
        ClassLoader threadContextClassLoader;
        String identifier;
        String name;
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        String string = name = cData == null ? null : cData.getJ2EEName().getApplication();
        if (name == null && (identifier = this.classloaderIdSvc.getClassLoaderIdentifier(threadContextClassLoader = InvokerTask.priv.getContextClassLoader())) != null && (start = identifier.indexOf(58)) > 0 && (end = identifier.indexOf(35, ++start)) > 0) {
            name = identifier.substring(start, end);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void introspect(PrintWriter out) {
        out.println(this.toString() + ' ' + this.name + (this.deactivated ? " is deactivated" : ""));
        out.print("  Partition ");
        if (this.partitionIdLock.readLock().tryLock()) {
            try {
                out.println(this.partitionId);
            }
            finally {
                this.partitionIdLock.readLock().unlock();
            }
        } else {
            out.println("lock temporarily unavailable");
        }
        out.println("  Config " + this.configRef.get());
        out.println("  Accessed from " + this.applications);
        out.println("  Signalled to poll? " + this.pollingStartSignalReceived);
        out.println("  PollingManager state " + this.readyForPollingTask.bits);
        ScheduledFuture<?> pollFuture = this.pollingFutureRef.get();
        if (pollFuture != null) {
            out.println("  Next poll in " + pollFuture.getDelay(TimeUnit.MILLISECONDS) + "ms");
        }
        if (this.configUpdatePendingQueueLock.readLock().tryLock()) {
            try {
                out.print("  Config updates (" + this.configUpdatesInProgress + ") in progress, which block tasks:");
                for (InvokerTask task : this.configUpdatePendingQueue) {
                    out.print(32L + task.taskId);
                }
                out.println();
            }
            finally {
                this.configUpdatePendingQueueLock.readLock().unlock();
            }
        }
        out.println("  In-memory list of known pending (or active) tasks: " + this.inMemoryTaskIds.keySet());
        out.println();
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> callables) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> callables, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFailOverEnabled() {
        return this.configRef.get().missedTaskThreshold > 0L;
    }

    @Trivial
    public boolean isShutdown() {
        throw new IllegalStateException(new UnsupportedOperationException("isShutdown"));
    }

    @Trivial
    public boolean isTerminated() {
        throw new IllegalStateException(new UnsupportedOperationException("isTerminated"));
    }

    @Trivial
    @ManualTrace
    @Modified
    protected void modified(ComponentContext context) throws MalformedObjectNameException {
        boolean mbeanChange;
        Dictionary properties = context.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"modified", (Object[])new Object[]{properties});
        }
        Config newConfig = new Config(properties);
        Config oldConfig = this.configRef.get();
        this.readyForPollingTask.remove(4);
        Future previousFuture = this.pollingFutureRef.getAndSet(null);
        if (previousFuture != null) {
            previousFuture.cancel(false);
        }
        if (oldConfig.enableTaskExecution != newConfig.enableTaskExecution) {
            if (newConfig.enableTaskExecution) {
                this.readyForPollingTask.add(2);
            } else {
                this.readyForPollingTask.remove(2);
                this.inMemoryTaskIds.clear();
            }
        }
        if (oldConfig.initialPollDelay != newConfig.initialPollDelay) {
            if (newConfig.initialPollDelay == -1L) {
                this.readyForPollingTask.add(16);
            } else if (oldConfig.initialPollDelay == -1L) {
                this.readyForPollingTask.remove(16);
            }
        }
        this.configRef.set(newConfig);
        boolean bl = mbeanChange = oldConfig.missedTaskThreshold == -1L && newConfig.missedTaskThreshold != -1L;
        if (newConfig.jndiName == null ? oldConfig.jndiName != null : !newConfig.jndiName.equals(oldConfig.jndiName)) {
            if (!this.applications.isEmpty()) {
                ApplicationRecycleCoordinator appCoord = (ApplicationRecycleCoordinator)context.locateService(APP_RECYCLE_SERVICE);
                HashSet<String> members = new HashSet<String>(this.applications);
                this.applications.removeAll(members);
                appCoord.recycleApplications(members);
            }
            mbeanChange = true;
        }
        if (mbeanChange) {
            if (this.mbean != null) {
                this.mbean.unregister();
                this.mbean = null;
            }
            if (newConfig.missedTaskThreshold == -1L) {
                this.mbean = new PersistentExecutorMBeanImpl(this);
                this.mbean.register(InvokerTask.priv.getBundleContext(context));
            }
        }
        if (this.readyForPollingTask.addAndCheckIfReady(4)) {
            this.startPollingTask(newConfig);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"modified");
        }
    }

    public <U> CompletableFuture<U> newIncompleteFuture() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private <T> TimerStatus<T> newTask(Object task, TaskInfo taskInfo, Trigger trigger, Object result) {
        int txTimeout;
        Map<String, String> execProps;
        String name;
        String owner;
        if (task == null) {
            throw new NullPointerException(taskInfo.isSubmittedAsCallable() ? Callable.class.getName() : Runnable.class.getName());
        }
        TaskRecord record = new TaskRecord(true);
        record.unsetId();
        TimerTrigger timerTrigger = trigger instanceof TimerTrigger ? (TimerTrigger)trigger : null;
        String string = owner = timerTrigger == null ? this.getOwner() : timerTrigger.getAppName();
        if (owner == null) {
            throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1540.thread.cannot.submit.tasks", (Object[])new Object[0]));
        }
        record.setIdentifierOfOwner(owner);
        Config config = this.configRef.get();
        long taskAssignmentInfo = -1L;
        if (config.missedTaskThreshold < 1L) {
            try {
                taskAssignmentInfo = this.getPartitionId();
            }
            catch (RuntimeException runtimeException) {
                void x;
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1301", (Object)this, (Object[])new Object[]{task, taskInfo, trigger, result});
                throw x;
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1303", (Object)this, (Object[])new Object[]{task, taskInfo, trigger, result});
                throw new RejectedExecutionException(x);
            }
        }
        if ((name = (execProps = this.getExecutionProperties(task)).get("jakarta.enterprise.concurrent.IDENTITY_NAME")) == null) {
            name = execProps.get(OTHER_SPEC_IDENTITY_NAME);
        }
        record.setName(Utils.normalizeString(name));
        String key = "jakarta.enterprise.concurrent.LONGRUNNING_HINT";
        String longRunningHint = execProps.get("jakarta.enterprise.concurrent.LONGRUNNING_HINT");
        if (longRunningHint == null) {
            key = OTHER_SPEC_LONGRUNNING_HINT;
            longRunningHint = execProps.get(key);
        }
        if (Boolean.parseBoolean(longRunningHint)) {
            throw new RejectedExecutionException(key + ": " + longRunningHint);
        }
        String txTimeoutString = execProps.get("com.ibm.ws.concurrent.TRANSACTION_TIMEOUT");
        if (txTimeoutString == null) {
            txTimeout = config.missedTaskThreshold > 0L ? (int)config.missedTaskThreshold : 0;
        } else {
            try {
                txTimeout = Integer.parseInt(txTimeoutString);
                if (txTimeout < 0) {
                    throw new IllegalArgumentException("com.ibm.ws.concurrent.TRANSACTION_TIMEOUT: " + txTimeoutString);
                }
            }
            catch (NumberFormatException numberFormatException) {
                void x;
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1333", (Object)this, (Object[])new Object[]{task, taskInfo, trigger, result});
                throw new IllegalArgumentException("com.ibm.ws.concurrent.TRANSACTION_TIMEOUT: " + txTimeoutString, (Throwable)x);
            }
        }
        record.setTransactionTimeout(txTimeout);
        String transaction = execProps.get("jakarta.enterprise.concurrent.TRANSACTION");
        if (transaction == null) {
            transaction = execProps.get(OTHER_SPEC_TRANSACTION_CONSTANT);
        }
        short flags = 0;
        String autoPurge = execProps.get("com.ibm.ws.concurrent.AUTO_PURGE");
        if (autoPurge == null || AutoPurge.ON_SUCCESS.toString().equals(autoPurge)) {
            flags = (short)(flags | TaskRecord.Flags.AUTO_PURGE_ON_SUCCESS.bit);
        } else if (AutoPurge.ALWAYS.toString().equals(autoPurge)) {
            flags = (short)(flags | (TaskRecord.Flags.AUTO_PURGE_ALWAYS.bit | TaskRecord.Flags.AUTO_PURGE_ON_SUCCESS.bit));
        }
        if (trigger instanceof TaskLocker) {
            flags = (short)(flags | TaskRecord.Flags.EJB_SINGLETON.bit);
        }
        if (trigger instanceof TimerTrigger) {
            flags = (short)(flags | TaskRecord.Flags.EJB_TIMER.bit);
        }
        if (taskInfo.getInterval() == -1L && taskInfo.getInitialDelay() != -1L) {
            flags = (short)(flags | TaskRecord.Flags.ONE_SHOT_TASK.bit);
        }
        if (config.missedTaskThreshold > 0L || "SUSPEND".equals(transaction)) {
            flags = (short)(flags | TaskRecord.Flags.SUSPEND_TRAN_OF_EXECUTOR_THREAD.bit);
        }
        record.setMiscBinaryFlags(flags);
        Date now = new Date();
        long originalSubmitTime = now.getTime();
        record.setOriginalSubmitTime(originalSubmitTime);
        record.setState((short)(TaskState.SCHEDULED.bit | TaskState.UNATTEMPTED.bit));
        taskInfo.initThreadContext((WSContextService)this.contextSvcRef.getServiceWithException(), execProps);
        if (task != trigger) {
            if (task instanceof Serializable) {
                try {
                    record.setTask(this.serialize(task));
                }
                catch (IOException iOException) {
                    void x;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1373", (Object)this, (Object[])new Object[]{task, taskInfo, trigger, result});
                    throw new IllegalArgumentException(Utils.toString(task), (Throwable)x);
                }
            } else {
                taskInfo.initForNonSerializableTask(task.getClass().getName());
            }
        }
        ClassLoader loader = timerTrigger == null ? InvokerTask.priv.getContextClassLoader() : timerTrigger.getClassLoader();
        record.setIdentifierOfClassLoader(this.classloaderIdSvc.getClassLoaderIdentifier(loader));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            Tr.debug((Object)this, (TraceComponent)tc, (String)"submitter info", (Object[])new Object[]{cData == null ? null : cData.getJ2EEName(), loader});
        }
        record.setTrigger(null);
        long initialDelay = taskInfo.getInitialDelay();
        if (initialDelay >= 0L) {
            record.setNextExecutionTime(originalSubmitTime + initialDelay);
        } else {
            Date nextExecutionDate;
            if (trigger == null) {
                throw new NullPointerException(Trigger.class.getName());
            }
            try {
                nextExecutionDate = trigger.getNextRunTime(null, now);
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1398", (Object)this, (Object[])new Object[]{task, taskInfo, trigger, result});
                throw new RejectedExecutionException((Throwable)x);
            }
            if (nextExecutionDate == null) {
                throw new RejectedExecutionException("Trigger.getNextRunTime: null");
            }
            record.setNextExecutionTime(nextExecutionDate.getTime());
            if (trigger instanceof Serializable) {
                try {
                    record.setTrigger(this.serialize(trigger));
                }
                catch (IOException x) {
                    FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1409", (Object)this, (Object[])new Object[]{task, taskInfo, trigger, result});
                    throw new IllegalArgumentException(Utils.toString(trigger), x);
                }
            } else {
                taskInfo.initForNonSerializableTrigger(trigger.getClass().getName());
            }
        }
        try {
            record.setTaskInformation(this.serialize(taskInfo));
        }
        catch (IOException nextExecutionDate) {
            void x;
            FFDCFilter.processException((Throwable)nextExecutionDate, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1418", (Object)this, (Object[])new Object[]{task, taskInfo, trigger, result});
            throw new RejectedExecutionException((Throwable)x);
        }
        if (result != null) {
            try {
                record.setResult(this.serialize(result));
            }
            catch (IOException x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1425", (Object)this, (Object[])new Object[]{task, taskInfo, trigger, result});
                throw new IllegalArgumentException(Utils.toString(result), x);
            }
        }
        boolean claimFirstExecution = false;
        long nextExecTime = record.getNextExecutionTime();
        if (config.missedTaskThreshold > 0L && config.enableTaskExecution && (config.pollInterval < 0L || nextExecTime <= System.currentTimeMillis() + config.pollInterval)) {
            taskAssignmentInfo = nextExecTime + config.missedTaskThreshold * 1000L;
            claimFirstExecution = true;
        }
        record.setClaimExpiryOrPartition(taskAssignmentInfo);
        TransactionController tranController = new TransactionController();
        try {
            boolean scheduleToSelf;
            tranController.preInvoke();
            this.taskStore.create(record);
            boolean bl = config.missedTaskThreshold > 0L ? claimFirstExecution : (scheduleToSelf = config.enableTaskExecution && (config.pollInterval < 0L || nextExecTime <= System.currentTimeMillis() + config.pollInterval));
            if (scheduleToSelf) {
                InvokerTask autoSchedule = new InvokerTask(this, record.getId(), nextExecTime, record.getMiscBinaryFlags(), txTimeout);
                UOWCurrent uowCurrent = (UOWCurrent)tranController.tranMgr;
                tranController.tranMgr.registerSynchronization(uowCurrent.getUOWCoord(), (Synchronization)autoSchedule, 0);
            }
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1455", (Object)this, (Object[])new Object[]{task, taskInfo, trigger, result});
            tranController.setFailure(x);
        }
        finally {
            RejectedExecutionException x = tranController.postInvoke(RejectedExecutionException.class);
            if (x != null) {
                throw x;
            }
        }
        return new TaskStatusImpl(record, this);
    }

    public void notifyOfTaskAssignment(long taskId, long nextExecTime, short binaryFlags, int transactionTimeout) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Boolean previous = this.inMemoryTaskIds.put(taskId, Boolean.TRUE);
        if (previous == null) {
            InvokerTask task = new InvokerTask(this, taskId, nextExecTime, binaryFlags, transactionTimeout);
            long delay = nextExecTime - new Date().getTime();
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Found task " + taskId + " for " + delay + "ms from now"), (Object[])new Object[0]);
            }
            this.scheduledExecutor.schedule(task, delay, TimeUnit.MILLISECONDS);
        } else if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Found task " + taskId + " already scheduled"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(long taskId) {
        long[] runningTaskState;
        String owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        TransactionController tranController = new TransactionController();
        boolean removed = false;
        try {
            tranController.preInvoke();
            removed = this.taskStore.remove(taskId, owner, true);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1501", (Object)this, (Object[])new Object[]{taskId});
            tranController.setFailure(x);
        }
        finally {
            PersistentStoreException x = tranController.postInvoke(PersistentStoreException.class);
            if (x != null) {
                throw x;
            }
        }
        if (removed && (runningTaskState = InvokerTask.runningTaskState.get()) != null && runningTaskState[0] == taskId) {
            runningTaskState[1] = 1L;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(String pattern, Character escape, TaskState state, boolean inState) {
        String owner = this.getOwner();
        if (owner == null) {
            return 0;
        }
        pattern = pattern == null ? null : Utils.normalizeString(pattern);
        int updateCount = 0;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            updateCount = this.taskStore.remove(pattern, escape, state, inState, owner);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1530", (Object)this, (Object[])new Object[]{pattern, escape, state, inState});
            tranController.setFailure(x);
        }
        finally {
            PersistentStoreException x = tranController.postInvoke(PersistentStoreException.class);
            if (x != null) {
                throw x;
            }
        }
        return updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removePartitionInfo(String hostName, String userDir, String libertyServerName, String executorIdentifier) throws Exception {
        Config config = this.configRef.get();
        if (config.missedTaskThreshold != -1L) {
            throw new UnsupportedOperationException();
        }
        PartitionRecord criteria = new PartitionRecord(false);
        if (hostName != null) {
            criteria.setHostName(hostName);
        }
        if (userDir != null) {
            criteria.setUserDir(userDir);
        }
        if (libertyServerName != null) {
            criteria.setLibertyServer(libertyServerName);
        }
        if (executorIdentifier != null) {
            criteria.setExecutor(executorIdentifier);
        }
        int numRemoved = 0;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            numRemoved = this.taskStore.remove(criteria);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1574", (Object)this, (Object[])new Object[]{hostName, userDir, libertyServerName, executorIdentifier});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        return numRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeProperties(String pattern, Character escape) throws Exception {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        int count = 0;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            count = this.taskStore.removeProperties(Utils.normalizeString(pattern), escape);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1596", (Object)this, (Object[])new Object[]{pattern, escape});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeProperty(String name) {
        boolean removed = false;
        if (name != null && name.length() > 0) {
            TransactionController tranController = new TransactionController();
            try {
                tranController.preInvoke();
                removed = this.taskStore.removeProperty(name);
            }
            catch (Throwable x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1616", (Object)this, (Object[])new Object[]{name});
                tranController.setFailure(x);
            }
            finally {
                PersistentStoreException x = tranController.postInvoke(PersistentStoreException.class);
                if (x != null) {
                    throw x;
                }
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTimer(long taskId) throws Exception {
        long[] runningTaskState;
        TransactionController tranController = new TransactionController();
        boolean removed = false;
        try {
            tranController.preInvoke();
            removed = this.taskStore.remove(taskId, null, true);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1636", (Object)this, (Object[])new Object[]{taskId});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        if (removed && (runningTaskState = InvokerTask.runningTaskState.get()) != null && runningTaskState[0] == taskId) {
            runningTaskState[1] = 1L;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeTimers(String appName, String pattern, Character escape, TaskState state, boolean inState) throws Exception {
        pattern = pattern == null ? null : Utils.normalizeString(pattern);
        int updateCount = 0;
        TransactionController tranController = new TransactionController();
        try {
            tranController.preInvoke();
            updateCount = this.taskStore.remove(pattern, escape, state, inState, appName);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1661", (Object)this, (Object[])new Object[]{appName, pattern, escape, state, inState});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        return updateCount;
    }

    public CompletableFuture<Void> runAsync(Runnable runnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V> TaskStatus<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        int compare = unit.compareTo(TimeUnit.MILLISECONDS);
        delay = delay <= 0L ? 0L : (compare == 0 ? delay : (compare < 0 ? unit.toMillis(delay - 1L) + 1L : unit.toMillis(delay)));
        TaskInfo taskInfo = new TaskInfo(true);
        taskInfo.initForOneShotTask(delay);
        return this.newTask(callable, taskInfo, null, null);
    }

    @Override
    public <V> TaskStatus<V> schedule(Callable<V> callable, Trigger trigger) {
        TaskInfo taskInfo = new TaskInfo(true);
        return this.newTask(callable, taskInfo, trigger, null);
    }

    @Override
    public <T> TimerStatus<T> schedule(TimerTrigger task) throws Exception {
        TaskInfo taskInfo = new TaskInfo(task instanceof Callable);
        return this.newTask(task, taskInfo, task, null);
    }

    @Override
    public TaskStatus<?> schedule(Runnable runnable, long delay, TimeUnit unit) {
        int compare = unit.compareTo(TimeUnit.MILLISECONDS);
        delay = delay <= 0L ? 0L : (compare == 0 ? delay : (compare < 0 ? unit.toMillis(delay - 1L) + 1L : unit.toMillis(delay)));
        TaskInfo taskInfo = new TaskInfo(false);
        taskInfo.initForOneShotTask(delay);
        return this.newTask(runnable, taskInfo, null, null);
    }

    @Override
    public TaskStatus<?> schedule(Runnable runnable, Trigger trigger) {
        TaskInfo taskInfo = new TaskInfo(false);
        return this.newTask(runnable, taskInfo, trigger, null);
    }

    @Override
    public TaskStatus<?> scheduleAtFixedRate(Runnable runnable, long initialDelay, long period, TimeUnit unit) {
        int compare = unit.compareTo(TimeUnit.MILLISECONDS);
        long l = initialDelay <= 0L ? 0L : (compare == 0 ? initialDelay : (initialDelay = compare < 0 ? unit.toMillis(initialDelay - 1L) + 1L : unit.toMillis(initialDelay)));
        if (period <= 0L) {
            throw new IllegalArgumentException(Long.toString(period));
        }
        period = compare == 0 ? period : (compare < 0 ? unit.toMillis(period - 1L) + 1L : unit.toMillis(period));
        TaskInfo taskInfo = new TaskInfo(false);
        taskInfo.initForRepeatingTask(true, initialDelay, period);
        return this.newTask(runnable, taskInfo, null, null);
    }

    @Override
    public TaskStatus<?> scheduleWithFixedDelay(Runnable runnable, long initialDelay, long delay, TimeUnit unit) {
        int compare = unit.compareTo(TimeUnit.MILLISECONDS);
        long l = initialDelay <= 0L ? 0L : (compare == 0 ? initialDelay : (initialDelay = compare < 0 ? unit.toMillis(initialDelay - 1L) + 1L : unit.toMillis(initialDelay)));
        if (delay <= 0L) {
            throw new IllegalArgumentException(Long.toString(delay));
        }
        delay = compare == 0 ? delay : (compare < 0 ? unit.toMillis(delay - 1L) + 1L : unit.toMillis(delay));
        TaskInfo taskInfo = new TaskInfo(false);
        taskInfo.initForRepeatingTask(false, initialDelay, delay);
        return this.newTask(runnable, taskInfo, null, null);
    }

    public final byte[] serialize(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        SerializationService serializationSvc = (SerializationService)this.serializationSvcRef.getServiceWithException();
        ObjectOutputStream oout = serializationSvc.createObjectOutputStream((OutputStream)new DeflaterOutputStream(bout));
        oout.writeObject(object);
        oout.flush();
        oout.close();
        byte[] bytes = bout.toByteArray();
        return bytes;
    }

    public void serverStopping() {
        this.deactivated = true;
        Future pollingFuture = this.pollingFutureRef.get();
        if (pollingFuture != null) {
            pollingFuture.cancel(false);
        }
    }

    @Reference(service=ApplicationTracker.class)
    protected void setApplicationTracker(ServiceReference<ApplicationTracker> ref) {
        this.appTrackerRef.setReference(ref);
    }

    @Reference(service=ApplicationRecycleCoordinator.class)
    protected void setAppRecycleService(ServiceReference<ApplicationRecycleCoordinator> ref) {
    }

    @Reference
    protected void setClassLoaderIdentifierService(ClassLoaderIdentifierService svc) {
        this.classloaderIdSvc = svc;
    }

    @Reference(service=WSContextService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(id=unbound)")
    protected void setContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.setReference(ref);
    }

    @Reference(target="(component.name=com.ibm.ws.threading)")
    protected void setExecutor(ExecutorService svc) {
        this.executor = svc;
    }

    @Reference(service=LocalTransactionCurrent.class)
    protected void setLocalTransactionCurrent(ServiceReference<LocalTransactionCurrent> ref) {
        this.localTranCurrentRef.setReference(ref);
    }

    @Reference
    protected void setLocationAdmin(WsLocationAdmin svc) {
        this.locationAdmin = svc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setProperty(String name, String value) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("value: " + value);
        }
        boolean exists = false;
        if (name != null && name.length() > 0) {
            TransactionController tranController = new TransactionController();
            try {
                tranController.preInvoke();
                exists = this.taskStore.setProperty(name, value);
            }
            catch (Throwable x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"1884", (Object)this, (Object[])new Object[]{name, value});
                tranController.setFailure(x);
            }
            finally {
                PersistentStoreException x = tranController.postInvoke(PersistentStoreException.class);
                if (x != null) {
                    throw x;
                }
            }
        }
        return exists;
    }

    @Reference(service=SerializationService.class)
    protected void setSerializationService(ServiceReference<SerializationService> ref) {
        this.serializationSvcRef.setReference(ref);
    }

    @Reference(target="(id=unbound)")
    protected void setTaskStore(DatabaseStore svc, Map<String, Object> props) {
        this.persistentStore = svc;
        this.persistentStoreDisplayId = (String)props.get("config.displayId");
    }

    @Reference(service=EmbeddableWebSphereTransactionManager.class)
    protected void setTransactionManager(ServiceReference<EmbeddableWebSphereTransactionManager> ref) {
        this.tranMgrRef.setReference(ref);
    }

    @Reference
    protected void setVariableRegistry(VariableRegistry svc) {
        this.variableRegistry = svc;
    }

    @Reference(service=ServerStarted.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setServerStarted(ServiceReference<ServerStarted> ref) {
        if (this.readyForPollingTask.addAndCheckIfReady(1)) {
            this.startPollingTask(this.configRef.get());
        }
    }

    @Trivial
    public void shutdown() {
        throw new IllegalStateException(new UnsupportedOperationException("shutdown"));
    }

    @Trivial
    public List<Runnable> shutdownNow() {
        throw new IllegalStateException(new UnsupportedOperationException("shutdownNow"));
    }

    @Override
    public void startPolling() {
        Config config = this.configRef.get();
        if (config.initialPollDelay != -1L) {
            throw new IllegalStateException("initialPollDelay: " + config.initialPollDelay);
        }
        if (!this.deactivated && !this.pollingStartSignalReceived.getAndSet(true) && this.readyForPollingTask.addAndCheckIfReady(8)) {
            this.startPollingTask(config);
        }
    }

    @Override
    public <T> TaskStatus<T> submit(Callable<T> callable) {
        TaskInfo taskInfo = new TaskInfo(true);
        taskInfo.initForOneShotTask(0L);
        return this.newTask(callable, taskInfo, null, null);
    }

    @Override
    public <T> TaskStatus<T> submit(Runnable runnable, T result) {
        TaskInfo taskInfo = new TaskInfo(false);
        taskInfo.initForOneShotTask(0L);
        return this.newTask(runnable, taskInfo, null, result);
    }

    @Override
    public TaskStatus<?> submit(Runnable runnable) {
        TaskInfo taskInfo = new TaskInfo(false);
        taskInfo.initForOneShotTask(0L);
        return this.newTask(runnable, taskInfo, null, null);
    }

    public <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int transfer(Long maxTaskId, long oldPartitionId) throws Exception {
        Config config = this.configRef.get();
        if (config.missedTaskThreshold != -1L) {
            throw new UnsupportedOperationException();
        }
        long partitionId = this.getPartitionId();
        TransactionController tranController = new TransactionController();
        int count = 0;
        try {
            tranController.preInvoke();
            count = this.taskStore.transfer(maxTaskId, oldPartitionId, partitionId);
            if (config.enableTaskExecution && count > 0 && config.pollInterval < 0L) {
                PollingTask autoPoll = new PollingTask(config);
                UOWCurrent uowCurrent = (UOWCurrent)tranController.tranMgr;
                tranController.tranMgr.registerSynchronization(uowCurrent.getUOWCoord(), (Synchronization)autoPoll, 0);
            }
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl", (String)"2048", (Object)this, (Object[])new Object[]{maxTaskId, oldPartitionId});
            tranController.setFailure(x);
        }
        finally {
            Exception x = tranController.postInvoke(Exception.class);
            if (x != null) {
                throw x;
            }
        }
        return count;
    }

    protected void unsetApplicationTracker(ServiceReference<ApplicationTracker> ref) {
        this.appTrackerRef.unsetReference(ref);
    }

    protected void unsetAppRecycleService(ServiceReference<ApplicationRecycleCoordinator> ref) {
    }

    protected void unsetClassLoaderIdentifierService(ClassLoaderIdentifierService svc) {
        this.classloaderIdSvc = null;
    }

    protected void unsetContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.unsetReference(ref);
    }

    protected void unsetExecutor(ExecutorService svc) {
        this.executor = null;
    }

    protected void unsetLocalTransactionCurrent(ServiceReference<LocalTransactionCurrent> ref) {
        this.localTranCurrentRef.unsetReference(ref);
    }

    protected void unsetLocationAdmin(WsLocationAdmin svc) {
        this.locationAdmin = null;
    }

    protected void unsetSerializationService(ServiceReference<SerializationService> ref) {
        this.serializationSvcRef.unsetReference(ref);
    }

    protected void unsetTaskStore(DatabaseStore svc) {
    }

    protected void unsetTransactionManager(ServiceReference<EmbeddableWebSphereTransactionManager> ref) {
        this.tranMgrRef.unsetReference(ref);
    }

    protected void unsetVariableRegistry(VariableRegistry svc) {
        this.variableRegistry = null;
    }

    protected synchronized void unsetServerStarted(ServiceReference<ServerStarted> ref) {
        this.deactivated = true;
    }

    private void startPollingTask(Config config) {
        PollingTask pollingTask = new PollingTask(config);
        ScheduledFuture<?> future = this.scheduledExecutor.schedule(pollingTask, config.initialPollDelay, TimeUnit.MILLISECONDS);
        this.pollingFutureRef.getAndSet(future);
    }

    public void notificationCreated(RuntimeUpdateManager updateManager, RuntimeUpdateNotification notification) {
        FutureMonitor futureMonitor;
        if (this.deactivated) {
            return;
        }
        int prevCnt = this.configUpdateInProgress();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Notified of \"" + notification.getName() + "\" previous configUpdatesInProgress: " + prevCnt), (Object[])new Object[0]);
        }
        if ((futureMonitor = this._futureMonitor) != null) {
            @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
            @InjectedFFDC
            @TraceOptions
            class MyCompletionListener
            implements CompletionListener<Boolean> {
                String notificationName;
                static final long serialVersionUID = 1616210238687030377L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public MyCompletionListener(String name) {
                    this.notificationName = name;
                }

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    PersistentExecutorImpl.this.configUpdateCompleted(this.notificationName);
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    PersistentExecutorImpl.this.configUpdateCompleted(this.notificationName);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl$1MyCompletionListener", MyCompletionListener.class, (String)"persistentExecutor", (String)"com.ibm.ws.concurrent.persistent.resources.CWWKCMessages");
                }
            }
            MyCompletionListener newListener = new MyCompletionListener(notification.getName());
            futureMonitor.onCompletion(notification.getFuture(), (CompletionListener)newListener);
        }
    }

    @Reference(service=FutureMonitor.class)
    protected void setFutureMonitor(FutureMonitor futureMonitor) {
        this._futureMonitor = futureMonitor;
    }

    protected void unsetFutureMonitor(FutureMonitor futureMonitor) {
        this._futureMonitor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    boolean deferExecutionForConfigUpdate(InvokerTask targetRunnable) {
        boolean returnValue = false;
        this.configUpdatePendingQueueLock.readLock().lock();
        try {
            if (this.configUpdatesInProgress == 0) {
                boolean bl = returnValue;
                return bl;
            }
        }
        finally {
            this.configUpdatePendingQueueLock.readLock().unlock();
        }
        this.configUpdatePendingQueueLock.writeLock().lock();
        try {
            if (this.configUpdatesInProgress > 0) {
                this.configUpdatePendingQueue.add(targetRunnable);
                returnValue = true;
            }
        }
        finally {
            this.configUpdatePendingQueueLock.writeLock().unlock();
        }
        if (returnValue && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"execution deferred while config update in progress", (Object[])new Object[0]);
        }
        return returnValue;
    }

    private int configUpdateInProgress() {
        int retVal;
        this.configUpdatePendingQueueLock.writeLock().lock();
        try {
            retVal = this.configUpdatesInProgress++;
        }
        finally {
            this.configUpdatePendingQueueLock.writeLock().unlock();
        }
        return retVal;
    }

    int configUpdateCompleted(String notificationName) {
        int retVal;
        this.configUpdatePendingQueueLock.writeLock().lock();
        try {
            retVal = this.configUpdatesInProgress--;
            if (!this.deactivated && this.configUpdatesInProgress == 0) {
                this.executor.submit(this.processConfigUpdateQueue);
            }
        }
        finally {
            this.configUpdatePendingQueueLock.writeLock().unlock();
        }
        return retVal;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        boolean jakarta = "jakarta.enterprise.concurrent.IDENTITY_NAME".charAt(7) == '.';
        OTHER_SPEC_IDENTITY_NAME = new StringBuilder(jakarta ? 41 : 43).append(jakarta ? "javax" : "jakarta").append(".enterprise.concurrent.IDENTITY_NAME").toString();
        OTHER_SPEC_LONGRUNNING_HINT = new StringBuilder(jakarta ? 44 : 46).append(jakarta ? "javax" : "jakarta").append(".enterprise.concurrent.LONGRUNNING_HINT").toString();
        OTHER_SPEC_TRANSACTION_CONSTANT = new StringBuilder(jakarta ? 39 : 41).append(jakarta ? "javax" : "jakarta").append(".enterprise.concurrent.TRANSACTION").toString();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class TransactionController {
        private boolean expectRollback;
        private Throwable failure;
        private LocalTransactionCurrent ltcCurrent;
        private LocalTransactionCoordinator suspendedLTC;
        private final EmbeddableWebSphereTransactionManager tranMgr;
        private boolean tranStarted;
        static final long serialVersionUID = 2611726901043279914L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        TransactionController() {
            this.tranMgr = (EmbeddableWebSphereTransactionManager)PersistentExecutorImpl.this.tranMgrRef.getServiceWithException();
        }

        private void expectRollback() {
            this.expectRollback = true;
        }

        void preInvoke() throws NotSupportedException, SystemException {
            int tranStatus = this.tranMgr.getStatus();
            this.ltcCurrent = tranStatus == 6 ? (LocalTransactionCurrent)PersistentExecutorImpl.this.localTranCurrentRef.getServiceWithException() : null;
            LocalTransactionCoordinator localTransactionCoordinator = this.suspendedLTC = this.ltcCurrent == null ? null : this.ltcCurrent.suspend();
            if (tranStatus == 6) {
                this.tranMgr.begin();
                this.tranStarted = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        <T extends Throwable> T postInvoke(@Sensitive Class<T> exceptionClass) {
            try {
                if (this.tranStarted) {
                    if (this.failure != null || this.expectRollback && this.tranMgr.getStatus() == 1) {
                        try {
                            this.tranMgr.rollback();
                        }
                        catch (Throwable throwable) {
                            Object[] objectArray = new Object[1];
                            objectArray[0] = "<sensitive java.lang.Class>";
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl$TransactionController", (String)"2688", (Object)this, (Object[])objectArray);
                        }
                    } else {
                        this.tranMgr.commit();
                    }
                }
            }
            catch (Throwable throwable) {
                void x;
                Object[] objectArray = new Object[1];
                objectArray[0] = "<sensitive java.lang.Class>";
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl$TransactionController", (String)"2692", (Object)this, (Object[])objectArray);
                this.setFailure((Throwable)x);
            }
            finally {
                if (this.suspendedLTC != null) {
                    this.ltcCurrent.resume(this.suspendedLTC);
                }
            }
            if (this.failure == null) {
                return null;
            }
            if (this.failure instanceof Error) {
                throw (Error)this.failure;
            }
            if (this.failure instanceof RuntimeException) {
                throw (RuntimeException)this.failure;
            }
            try {
                if (exceptionClass.isInstance(this.failure)) {
                    return (T)((Throwable)exceptionClass.cast(this.failure));
                }
                Throwable result = (Throwable)exceptionClass.newInstance();
                result.initCause(this.failure);
                return (T)result;
            }
            catch (Throwable result) {
                Object[] objectArray = new Object[1];
                objectArray[0] = "<sensitive java.lang.Class>";
                FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl$TransactionController", (String)"2713", (Object)this, (Object[])objectArray);
                throw new RuntimeException(this.failure);
            }
        }

        void setFailure(Throwable failure) {
            if (this.failure == null) {
                this.failure = failure;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl$TransactionController", TransactionController.class, (String)"persistentExecutor", (String)"com.ibm.ws.concurrent.persistent.resources.CWWKCMessages");
        }
    }

    @Trivial
    private class PollingTask
    implements Runnable,
    Synchronization {
        private final Config initialConfig;
        private boolean isFirstTimeCoordinating = true;

        private PollingTask(Config config) {
            this.initialConfig = config;
        }

        public void afterCompletion(int status) {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)"afterCompletion", (Object[])new Object[]{status});
            }
            if (status == 3 && PersistentExecutorImpl.this.readyForPollingTask.addAndCheckIfReady(0)) {
                PersistentExecutorImpl.this.executor.submit(this);
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)"afterCompletion");
            }
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long coordinateNextPoll(Config config) {
            long expiry;
            boolean trace = TraceComponent.isAnyTracingEnabled();
            try {
                EmbeddableWebSphereTransactionManager tranMgr = (EmbeddableWebSphereTransactionManager)PersistentExecutorImpl.this.tranMgrRef.getServiceWithException();
                long pollPartitionId = PersistentExecutorImpl.this.getPollPartitionId();
                boolean successful = false;
                tranMgr.begin();
                try {
                    Object[] expiryAndLastUpdated = PersistentExecutorImpl.this.taskStore.findPollInfoForUpdate(pollPartitionId);
                    expiry = (Long)expiryAndLastUpdated[0];
                    long lastUpdated = (Long)expiryAndLastUpdated[1];
                    long now = System.currentTimeMillis();
                    int slot = 0;
                    long delay = -1L;
                    int missedPollsThreshold = 2;
                    if (now - lastUpdated > 3L * config.pollInterval || this.isFirstTimeCoordinating && expiry - now > 5L * config.pollInterval) {
                        expiry = now / 1000L * 1000L + 600L;
                        delay = config.pollInterval - (now - expiry);
                        slot = 1;
                        if (trace && tc.isDebugEnabled()) {
                            if (now - lastUpdated > 2L * config.pollInterval) {
                                Tr.debug((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)"Detected 2 or more poll intervals were missed.  Resetting poll info.", (Object[])new Object[0]);
                            } else {
                                Tr.debug((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)"Detected starting new PollingTask. Resetting poll info.", (Object[])new Object[0]);
                            }
                        }
                    } else {
                        while (delay < 0L) {
                            delay = (long)(++slot) * config.pollInterval - (now - expiry);
                        }
                    }
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)("now = " + now + "; slot = " + slot), (Object[])new Object[0]);
                    }
                    PersistentExecutorImpl.this.taskStore.updatePollInfo(pollPartitionId, expiry += (long)slot * config.pollInterval);
                    successful = true;
                }
                finally {
                    if (successful) {
                        tranMgr.commit();
                    } else {
                        tranMgr.rollback();
                    }
                }
            }
            catch (Throwable x) {
                expiry = System.currentTimeMillis() + config.pollInterval;
            }
            this.isFirstTimeCoordinating = false;
            return expiry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void partitionBasedPoll(Config config) throws Exception {
            List<Object[]> results;
            boolean trace = TraceComponent.isAnyTracingEnabled();
            EmbeddableWebSphereTransactionManager tranMgr = (EmbeddableWebSphereTransactionManager)PersistentExecutorImpl.this.tranMgrRef.getServiceWithException();
            long partitionId = PersistentExecutorImpl.this.getPartitionId();
            long now = System.currentTimeMillis();
            long maxNextExecTime = config.pollInterval >= 0L ? config.pollInterval + now : Long.MAX_VALUE;
            tranMgr.begin();
            try {
                results = PersistentExecutorImpl.this.taskStore.findUpcomingTasks(partitionId, maxNextExecTime, config.pollSize);
            }
            finally {
                tranMgr.commit();
            }
            for (Object[] result : results) {
                long taskId = (Long)result[0];
                Boolean previous = PersistentExecutorImpl.this.inMemoryTaskIds.put(taskId, Boolean.TRUE);
                if (previous == null) {
                    short mbits = (Short)result[1];
                    long nextExecTime = (Long)result[2];
                    int txTimeout = (Integer)result[3];
                    InvokerTask task = new InvokerTask(PersistentExecutorImpl.this, taskId, nextExecTime, mbits, txTimeout);
                    long delay = nextExecTime - new Date().getTime();
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)("Found task " + taskId + " for " + delay + "ms from now"), (Object[])new Object[0]);
                    }
                    PersistentExecutorImpl.this.scheduledExecutor.schedule(task, delay, TimeUnit.MILLISECONDS);
                    continue;
                }
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)("Found task " + taskId + " already scheduled"), (Object[])new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pollForUnclaimedTasks(Config config) throws Exception {
            List<Object[]> results;
            boolean trace = TraceComponent.isAnyTracingEnabled();
            EmbeddableWebSphereTransactionManager tranMgr = (EmbeddableWebSphereTransactionManager)PersistentExecutorImpl.this.tranMgrRef.getServiceWithException();
            long now = System.currentTimeMillis();
            long maxNextExecTime = config.pollInterval >= 0L ? config.pollInterval + now : Long.MAX_VALUE;
            tranMgr.begin();
            try {
                results = PersistentExecutorImpl.this.taskStore.findUnclaimedTasks(maxNextExecTime, config.pollSize);
            }
            finally {
                tranMgr.commit();
            }
            for (Object[] result : results) {
                long taskId = (Long)result[0];
                boolean claimed = false;
                Boolean previous = PersistentExecutorImpl.this.inMemoryTaskIds.put(taskId, Boolean.TRUE);
                if (previous == null) {
                    try {
                        long nextExecTime = (Long)result[2];
                        int version = (Integer)result[4];
                        now = System.currentTimeMillis();
                        long claimUntilTime = (now > nextExecTime ? now : nextExecTime) + config.missedTaskThreshold * 1000L;
                        boolean claimedPendingCommit = false;
                        tranMgr.begin();
                        try {
                            claimedPendingCommit = PersistentExecutorImpl.this.taskStore.claimIfNotLocked(taskId, version, claimUntilTime);
                        }
                        finally {
                            tranMgr.commit();
                        }
                        claimed = claimedPendingCommit;
                        if (!claimed) continue;
                        short mbits = (Short)result[1];
                        int txTimeout = (Integer)result[3];
                        InvokerTask task = new InvokerTask(PersistentExecutorImpl.this, taskId, nextExecTime, mbits, txTimeout);
                        long delay = nextExecTime - new Date().getTime();
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)("Found task " + taskId + " for " + delay + "ms from now"), (Object[])new Object[0]);
                        }
                        PersistentExecutorImpl.this.scheduledExecutor.schedule(task, delay, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    finally {
                        if (claimed) continue;
                        PersistentExecutorImpl.this.inMemoryTaskIds.remove(taskId);
                        continue;
                    }
                }
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)("Found task " + taskId + " already scheduled"), (Object[])new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable failure;
            boolean trace;
            block15: {
                trace = TraceComponent.isAnyTracingEnabled();
                if (trace && tc.isEntryEnabled()) {
                    Tr.entry((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)"run[poll]", (Object[])new Object[0]);
                }
                Config config = PersistentExecutorImpl.this.configRef.get();
                if (PersistentExecutorImpl.this.deactivated || !config.enableTaskExecution || config != this.initialConfig) {
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)"run[poll]", (Object)(PersistentExecutorImpl.this.deactivated ? "deactivated" : config));
                    }
                    return;
                }
                failure = null;
                try {
                    long beginPoll = System.nanoTime();
                    try {
                        if (config.missedTaskThreshold > 0L) {
                            this.pollForUnclaimedTasks(config);
                        } else {
                            this.partitionBasedPoll(config);
                        }
                    }
                    finally {
                        config = PersistentExecutorImpl.this.configRef.get();
                        if (config.enableTaskExecution && config.pollInterval >= 0L && config == this.initialConfig) {
                            ScheduledFuture<?> future;
                            long duration;
                            if (config.pollingCoordination && config.missedTaskThreshold > 0L) {
                                long expiry = this.coordinateNextPoll(config);
                                duration = System.nanoTime() - beginPoll;
                                future = PersistentExecutorImpl.this.scheduledExecutor.schedule(this, expiry - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                            } else {
                                duration = System.nanoTime() - beginPoll;
                                long delay = config.pollInterval - TimeUnit.NANOSECONDS.toMillis(duration);
                                future = PersistentExecutorImpl.this.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
                            }
                            if (trace && tc.isDebugEnabled()) {
                                Tr.debug((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)("Poll completed in " + duration + "ns. Next poll " + future.getDelay(TimeUnit.MILLISECONDS) + "ms from now"), (Object[])new Object[0]);
                            }
                            PersistentExecutorImpl.this.pollingFutureRef.getAndSet(future);
                        }
                    }
                }
                catch (Throwable x) {
                    if (failure != null) break block15;
                    failure = x;
                }
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)PersistentExecutorImpl.this, (TraceComponent)tc, (String)"run[poll]", (Object)failure);
            }
        }
    }
}

