using UnityEngine;
using UnityEngine.Splines.Interpolators;

public class ScenarioBlender : MonoBehaviour
{
    UnityEngine.Rendering.ProbeReferenceVolume probeRefVolume;
    public string scenario01 = "Scenario01";
    public string scenario02 = "Scenario02";
    public Material lightMaterial01;
    [ColorUsage(false, true)] public Color lightMaterial01Color01 = Color.black;
    [ColorUsage(false, true)] public Color lightMaterial01Color02 = Color.white;
    public Material lightMaterial02;
    [ColorUsage(false, true)] public Color lightMaterial02Color01 = Color.black;
    [ColorUsage(false, true)] public Color lightMaterial02Color02 = Color.white;
    [Range(0, 1)] public float blendingFactor = 0.0f;
    [Min(1)] public int numberOfCellsBlendedPerFrame = 10;
    private static readonly int BaseColor = Shader.PropertyToID("_EmissionColor");

    void Start()
    {
        probeRefVolume = UnityEngine.Rendering.ProbeReferenceVolume.instance;
        probeRefVolume.lightingScenario = scenario01;
        probeRefVolume.numberOfCellsBlendedPerFrame = numberOfCellsBlendedPerFrame;
    }

    void Update()
    {
        probeRefVolume.lightingScenario = scenario01;
        probeRefVolume.BlendLightingScenario(scenario02, blendingFactor);
        lightMaterial01.SetColor(BaseColor, Color.Lerp(lightMaterial01Color01, lightMaterial01Color02, blendingFactor));
        lightMaterial02.SetColor(BaseColor, Color.Lerp(lightMaterial02Color01, lightMaterial02Color02, blendingFactor));
    }
}
